/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.Nullable;

public class ShortcutDataProvider {
    private static final List<Pair<Integer, String>> ourModifiers = new ArrayList<Pair<Integer, String>>(6);
    private static final Map<Integer, String> ourKeyCodes;

    @Nullable
    public static String getActionEventText(@Nullable AnActionEvent event) {
        if (event != null) {
            InputEvent inputEvent = event.getInputEvent();
            if (inputEvent instanceof KeyEvent) {
                if ("TouchBarGeneral".equals(event.getPlace())) {
                    return "Touchbar";
                }
                return ShortcutDataProvider.getKeyEventText((KeyEvent)inputEvent);
            }
            if (inputEvent instanceof MouseEvent) {
                return ShortcutDataProvider.getMouseEventText((MouseEvent)inputEvent);
            }
        }
        return null;
    }

    @Nullable
    protected static String getKeyEventText(@Nullable KeyEvent key) {
        if (key == null) {
            return null;
        }
        KeyStroke keystroke = KeyStroke.getKeyStrokeForEvent(key);
        return keystroke != null ? ShortcutDataProvider.getShortcutText(new KeyboardShortcut(keystroke, null)) : "Unknown";
    }

    @Nullable
    protected static String getMouseEventText(@Nullable MouseEvent event) {
        String modifiersText;
        int modifiers;
        if (event == null) {
            return null;
        }
        String res2 = ShortcutDataProvider.getMouseButtonText(event.getButton());
        int clickCount = event.getClickCount();
        if (clickCount > 1) {
            res2 = res2 + "(" + clickCount + "x)";
        }
        if ((modifiers = event.getModifiersEx() & 0xFFFFFBFF & 0xFFFFEFFF & 0xFFFFF7FF) > 0 && !(modifiersText = ShortcutDataProvider.getLocaleUnawareKeyModifiersText(modifiers)).isEmpty()) {
            res2 = modifiersText + "+" + res2;
        }
        return res2;
    }

    private static String getMouseButtonText(int buttonNum) {
        switch (buttonNum) {
            case 1: {
                return "MouseLeft";
            }
            case 2: {
                return "MouseMiddle";
            }
            case 3: {
                return "MouseRight";
            }
        }
        return "NoMouseButton";
    }

    private static String getShortcutText(KeyboardShortcut shortcut) {
        String keyModifiersText;
        String results = "";
        int modifiers = shortcut.getFirstKeyStroke().getModifiers();
        if (modifiers > 0 && !(keyModifiersText = ShortcutDataProvider.getLocaleUnawareKeyModifiersText(modifiers)).isEmpty()) {
            results = keyModifiersText + "+";
        }
        results = results + ShortcutDataProvider.getLocaleUnawareKeyText(shortcut.getFirstKeyStroke().getKeyCode());
        return results;
    }

    private static String getLocaleUnawareKeyText(int keyCode) {
        if (keyCode >= 48 && keyCode <= 57 || keyCode >= 65 && keyCode <= 90) {
            return String.valueOf((char)keyCode);
        }
        String knownKeyCode = ourKeyCodes.get(keyCode);
        if (knownKeyCode != null) {
            return knownKeyCode;
        }
        if (keyCode >= 96 && keyCode <= 105) {
            char c = (char)(keyCode - 96 + 48);
            return "NumPad-" + c;
        }
        if ((keyCode & 0x1000000) != 0) {
            return String.valueOf((char)(keyCode ^ 0x1000000));
        }
        return "Unknown keyCode: 0x" + Integer.toString(keyCode, 16);
    }

    private static String getLocaleUnawareKeyModifiersText(int modifiers) {
        List pressed = ourModifiers.stream().filter(p -> ((Integer)p.first & modifiers) != 0).map(p -> (String)p.second).collect(Collectors.toList());
        return StringUtil.join(pressed, (String)"+");
    }

    static {
        ourModifiers.add((Pair<Integer, String>)Pair.create((Object)1024, (Object)"Button1"));
        ourModifiers.add((Pair<Integer, String>)Pair.create((Object)2048, (Object)"Button2"));
        ourModifiers.add((Pair<Integer, String>)Pair.create((Object)4096, (Object)"Button3"));
        ourModifiers.add((Pair<Integer, String>)Pair.create((Object)256, (Object)"Meta"));
        ourModifiers.add((Pair<Integer, String>)Pair.create((Object)128, (Object)"Ctrl"));
        ourModifiers.add((Pair<Integer, String>)Pair.create((Object)512, (Object)"Alt"));
        ourModifiers.add((Pair<Integer, String>)Pair.create((Object)64, (Object)"Shift"));
        ourModifiers.add((Pair<Integer, String>)Pair.create((Object)8192, (Object)"Alt Graph"));
        ourKeyCodes = new HashMap<Integer, String>();
        ourKeyCodes.put(10, "Enter");
        ourKeyCodes.put(8, "Backspace");
        ourKeyCodes.put(9, "Tab");
        ourKeyCodes.put(3, "Cancel");
        ourKeyCodes.put(12, "Clear");
        ourKeyCodes.put(65312, "Compose");
        ourKeyCodes.put(19, "Pause");
        ourKeyCodes.put(20, "Caps Lock");
        ourKeyCodes.put(27, "Escape");
        ourKeyCodes.put(32, "Space");
        ourKeyCodes.put(33, "Page Up");
        ourKeyCodes.put(34, "Page Down");
        ourKeyCodes.put(35, "End");
        ourKeyCodes.put(36, "Home");
        ourKeyCodes.put(37, "Left");
        ourKeyCodes.put(38, "Up");
        ourKeyCodes.put(39, "Right");
        ourKeyCodes.put(40, "Down");
        ourKeyCodes.put(65368, "Begin");
        ourKeyCodes.put(16, "Shift");
        ourKeyCodes.put(17, "Control");
        ourKeyCodes.put(18, "Alt");
        ourKeyCodes.put(157, "Meta");
        ourKeyCodes.put(65406, "Alt Graph");
        ourKeyCodes.put(44, "Comma");
        ourKeyCodes.put(46, "Period");
        ourKeyCodes.put(47, "Slash");
        ourKeyCodes.put(59, "Semicolon");
        ourKeyCodes.put(61, "Equals");
        ourKeyCodes.put(91, "Open Bracket");
        ourKeyCodes.put(92, "Back Slash");
        ourKeyCodes.put(93, "Close Bracket");
        ourKeyCodes.put(106, "NumPad *");
        ourKeyCodes.put(107, "NumPad +");
        ourKeyCodes.put(108, "NumPad ,");
        ourKeyCodes.put(109, "NumPad -");
        ourKeyCodes.put(110, "NumPad .");
        ourKeyCodes.put(111, "NumPad /");
        ourKeyCodes.put(127, "Delete");
        ourKeyCodes.put(144, "Num Lock");
        ourKeyCodes.put(145, "Scroll Lock");
        ourKeyCodes.put(524, "Windows");
        ourKeyCodes.put(525, "Context Menu");
        ourKeyCodes.put(112, "F1");
        ourKeyCodes.put(113, "F2");
        ourKeyCodes.put(114, "F3");
        ourKeyCodes.put(115, "F4");
        ourKeyCodes.put(116, "F5");
        ourKeyCodes.put(117, "F6");
        ourKeyCodes.put(118, "F7");
        ourKeyCodes.put(119, "F8");
        ourKeyCodes.put(120, "F9");
        ourKeyCodes.put(121, "F10");
        ourKeyCodes.put(122, "F11");
        ourKeyCodes.put(123, "F12");
        ourKeyCodes.put(61440, "F13");
        ourKeyCodes.put(61441, "F14");
        ourKeyCodes.put(61442, "F15");
        ourKeyCodes.put(61443, "F16");
        ourKeyCodes.put(61444, "F17");
        ourKeyCodes.put(61445, "F18");
        ourKeyCodes.put(61446, "F19");
        ourKeyCodes.put(61447, "F20");
        ourKeyCodes.put(61448, "F21");
        ourKeyCodes.put(61449, "F22");
        ourKeyCodes.put(61450, "F23");
        ourKeyCodes.put(61451, "F24");
        ourKeyCodes.put(154, "Print Screen");
        ourKeyCodes.put(155, "Insert");
        ourKeyCodes.put(156, "Help");
        ourKeyCodes.put(192, "Back Quote");
        ourKeyCodes.put(222, "Quote");
        ourKeyCodes.put(224, "Up");
        ourKeyCodes.put(225, "Down");
        ourKeyCodes.put(226, "Left");
        ourKeyCodes.put(227, "Right");
        ourKeyCodes.put(128, "Dead Grave");
        ourKeyCodes.put(129, "Dead Acute");
        ourKeyCodes.put(130, "Dead Circumflex");
        ourKeyCodes.put(131, "Dead Tilde");
        ourKeyCodes.put(132, "Dead Macron");
        ourKeyCodes.put(133, "Dead Breve");
        ourKeyCodes.put(134, "Dead Above Dot");
        ourKeyCodes.put(135, "Dead Diaeresis");
        ourKeyCodes.put(136, "Dead Above Ring");
        ourKeyCodes.put(137, "Dead Double Acute");
        ourKeyCodes.put(138, "Dead Caron");
        ourKeyCodes.put(139, "Dead Cedilla");
        ourKeyCodes.put(140, "Dead Ogonek");
        ourKeyCodes.put(141, "Dead Iota");
        ourKeyCodes.put(142, "Dead Voiced Sound");
        ourKeyCodes.put(143, "Dead Semivoiced Sound");
        ourKeyCodes.put(150, "Ampersand");
        ourKeyCodes.put(151, "Asterisk");
        ourKeyCodes.put(152, "Double Quote");
        ourKeyCodes.put(153, "Less");
        ourKeyCodes.put(160, "Greater");
        ourKeyCodes.put(161, "Left Brace");
        ourKeyCodes.put(162, "Right Brace");
        ourKeyCodes.put(512, "At");
        ourKeyCodes.put(513, "Colon");
        ourKeyCodes.put(514, "Circumflex");
        ourKeyCodes.put(515, "Dollar");
        ourKeyCodes.put(516, "Euro");
        ourKeyCodes.put(517, "Exclamation Mark");
        ourKeyCodes.put(518, "Inverted Exclamation Mark");
        ourKeyCodes.put(519, "Left Parenthesis");
        ourKeyCodes.put(520, "Number Sign");
        ourKeyCodes.put(45, "Minus");
        ourKeyCodes.put(521, "Plus");
        ourKeyCodes.put(522, "Right Parenthesis");
        ourKeyCodes.put(523, "Underscore");
        ourKeyCodes.put(24, "Final");
        ourKeyCodes.put(28, "Convert");
        ourKeyCodes.put(29, "No Convert");
        ourKeyCodes.put(30, "Accept");
        ourKeyCodes.put(31, "Mode Change");
        ourKeyCodes.put(21, "Kana");
        ourKeyCodes.put(25, "Kanji");
        ourKeyCodes.put(240, "Alphanumeric");
        ourKeyCodes.put(241, "Katakana");
        ourKeyCodes.put(242, "Hiragana");
        ourKeyCodes.put(243, "Full-Width");
        ourKeyCodes.put(244, "Half-Width");
        ourKeyCodes.put(245, "Roman Characters");
        ourKeyCodes.put(256, "All Candidates");
        ourKeyCodes.put(257, "Previous Candidate");
        ourKeyCodes.put(258, "Code Input");
        ourKeyCodes.put(259, "Japanese Katakana");
        ourKeyCodes.put(260, "Japanese Hiragana");
        ourKeyCodes.put(261, "Japanese Roman");
        ourKeyCodes.put(262, "Kana Lock");
        ourKeyCodes.put(263, "Input Method On/Off");
        ourKeyCodes.put(65481, "Again");
        ourKeyCodes.put(65483, "Undo");
        ourKeyCodes.put(65485, "Copy");
        ourKeyCodes.put(65487, "Paste");
        ourKeyCodes.put(65489, "Cut");
        ourKeyCodes.put(65488, "Find");
        ourKeyCodes.put(65482, "Props");
        ourKeyCodes.put(65480, "Stop");
        ourKeyCodes.put(0, "Undefined");
    }
}

