/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.fileTypes;

import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class FileTypeUsagesCollector
extends ProjectUsagesCollector {
    private static final String DEFAULT_ID = "third.party";

    @Override
    @NotNull
    public String getGroupId() {
        if ("file.types" == null) {
            FileTypeUsagesCollector.$$$reportNull$$$0(0);
        }
        return "file.types";
    }

    @Override
    @NotNull
    public Set<UsageDescriptor> getUsages(@NotNull Project project) {
        if (project == null) {
            FileTypeUsagesCollector.$$$reportNull$$$0(1);
        }
        Set<UsageDescriptor> set2 = FileTypeUsagesCollector.getDescriptors(project);
        if (set2 == null) {
            FileTypeUsagesCollector.$$$reportNull$$$0(2);
        }
        return set2;
    }

    @NotNull
    public static Set<UsageDescriptor> getDescriptors(@NotNull Project project) {
        FileType[] registeredFileTypes;
        if (project == null) {
            FileTypeUsagesCollector.$$$reportNull$$$0(3);
        }
        HashSet<UsageDescriptor> descriptors = new HashSet<UsageDescriptor>();
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        if (fileTypeManager == null) {
            Set<UsageDescriptor> set2 = Collections.emptySet();
            if (set2 == null) {
                FileTypeUsagesCollector.$$$reportNull$$$0(4);
            }
            return set2;
        }
        for (FileType fileType : registeredFileTypes = fileTypeManager.getRegisteredFileTypes()) {
            if (project.isDisposed()) {
                Set<UsageDescriptor> set3 = Collections.emptySet();
                if (set3 == null) {
                    FileTypeUsagesCollector.$$$reportNull$$$0(5);
                }
                return set3;
            }
            FeatureUsageData data = new FeatureUsageData();
            String id = FileTypeUsagesCollector.toReportedId(fileType, data);
            ApplicationManager.getApplication().runReadAction(() -> FileTypeIndex.processFiles(fileType, (Processor<? super VirtualFile>)((Processor)file2 -> {
                if (!ProjectKt.getStateStore(project).isProjectFile((VirtualFile)file2)) {
                    descriptors.add(new UsageDescriptor(id, 1, data));
                    return false;
                }
                return true;
            }), GlobalSearchScope.projectScope((Project)project)));
        }
        HashSet<UsageDescriptor> hashSet = descriptors;
        if (hashSet == null) {
            FileTypeUsagesCollector.$$$reportNull$$$0(6);
        }
        return hashSet;
    }

    @NotNull
    public static String toReportedId(@NotNull FileType type, @NotNull FeatureUsageData data) {
        if (type == null) {
            FileTypeUsagesCollector.$$$reportNull$$$0(7);
        }
        if (data == null) {
            FileTypeUsagesCollector.$$$reportNull$$$0(8);
        }
        PluginInfo info = PluginInfoDetectorKt.getPluginInfo(type.getClass());
        data.addPluginInfo(info);
        String string = info.isDevelopedByJetBrains() ? type.getName() : DEFAULT_ID;
        if (string == null) {
            FileTypeUsagesCollector.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/collectors/fus/fileTypes/FileTypeUsagesCollector";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupId";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/collectors/fus/fileTypes/FileTypeUsagesCollector";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsages";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptors";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "toReportedId";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getUsages";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptors";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "toReportedId";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

