/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.retype;

import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.internal.retype.RetypeQueue;
import com.intellij.internal.retype.RetypeSession;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u000e\u0010\u0007\u001a\n\u0018\u00010\bj\u0004\u0018\u0001`\t\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0018\u00010\bj\u0004\u0018\u0001`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/internal/retype/RetypeQueue;", "", "project", "Lcom/intellij/openapi/project/Project;", "retypeDelay", "", "threadDumpDelay", "scriptBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "largeIndexFileCount", "restoreText", "", "(Lcom/intellij/openapi/project/Project;IILjava/lang/StringBuilder;IZ)V", "files", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "getFiles", "()Ljava/util/List;", "threadDumps", "", "findRangeOfSuitableElement", "Lcom/intellij/openapi/util/TextRange;", "treeElement", "Lcom/intellij/ide/util/treeView/smartTree/TreeElement;", "processNext", "", "selectFragmentToRetype", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.platform.lang.impl"})
final class RetypeQueue {
    @NotNull
    private final List<VirtualFile> files;
    private final List<String> threadDumps;
    private final Project project;
    private final int retypeDelay;
    private final int threadDumpDelay;
    private final StringBuilder scriptBuilder;
    private final int largeIndexFileCount;
    private final boolean restoreText;

    @NotNull
    public final List<VirtualFile> getFiles() {
        return this.files;
    }

    public final void processNext() {
        if (this.files.isEmpty()) {
            return;
        }
        VirtualFile file2 = this.files.get(0);
        this.files.remove(0);
        Editor editor = FileEditorManager.getInstance((Project)this.project).openTextEditor(new OpenFileDescriptor(this.project, file2, 0), true);
        if (editor == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
        }
        EditorImpl editor2 = (EditorImpl)editor;
        this.selectFragmentToRetype(editor2);
        int n = this.largeIndexFileCount;
        boolean bl = this.restoreText;
        RetypeSession retypeSession = new RetypeSession(this.project, editor2, this.retypeDelay, this.scriptBuilder, this.threadDumpDelay, this.threadDumps, n, bl);
        Collection collection = this.files;
        if (!collection.isEmpty()) {
            retypeSession.setStartNextCallback((Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ RetypeQueue this$0;

                public final void invoke() {
                    ApplicationManager.getApplication().invokeLater(new Runnable(this){
                        final /* synthetic */ processNext.1 this$0;

                        public final void run() {
                            this.this$0.this$0.processNext();
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
                {
                    this.this$0 = retypeQueue;
                    super(0);
                }
            }));
        }
        retypeSession.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void selectFragmentToRetype(Editor editor) {
        Document document = editor.getDocument();
        Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"editor.document");
        if (document.getTextLength() < 2000) {
            return;
        }
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.project);
        Intrinsics.checkExpressionValueIsNotNull((Object)fileEditorManager, (String)"FileEditorManager.getInstance(project)");
        FileEditor fileEditor = fileEditorManager.getSelectedEditor();
        if (fileEditor == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)fileEditor, (String)"FileEditorManager.getIns\u2026.selectedEditor ?: return");
        FileEditor fileEditor2 = fileEditor;
        StructureViewBuilder structureViewBuilder = fileEditor2.getStructureViewBuilder();
        if (structureViewBuilder == null || (structureViewBuilder = structureViewBuilder.createStructureView(fileEditor2, this.project)) == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)structureViewBuilder, (String)"fileEditor.structureView\u2026ditor, project) ?: return");
        StructureViewBuilder structureView = structureViewBuilder;
        try {
            TextRange textRange;
            PsiTreeElementBase psiTreeElementBase;
            StructureViewModel structureViewModel = structureView.getTreeModel();
            Intrinsics.checkExpressionValueIsNotNull((Object)structureViewModel, (String)"structureView.treeModel");
            StructureViewTreeElement structureViewTreeElement = structureViewModel.getRoot();
            if (!(structureViewTreeElement instanceof PsiTreeElementBase)) {
                structureViewTreeElement = null;
            }
            if ((PsiTreeElementBase)structureViewTreeElement == null) {
                return;
            }
            PsiTreeElementBase root = psiTreeElementBase;
            if (this.findRangeOfSuitableElement((TreeElement)root) == null) {
                return;
            }
            TextRange range2 = textRange;
            editor.getSelectionModel().setSelection(range2.getStartOffset(), range2.getEndOffset());
            editor.getCaretModel().moveToOffset(range2.getStartOffset());
        }
        finally {
            Disposer.dispose((Disposable)((Disposable)structureView));
        }
    }

    private final TextRange findRangeOfSuitableElement(TreeElement treeElement) {
        for (TreeElement child2 : treeElement.getChildren()) {
            TextRange grandchildRange;
            TextRange childRange;
            TreeElement treeElement2 = child2;
            if (!(treeElement2 instanceof StructureViewTreeElement)) {
                treeElement2 = null;
            }
            StructureViewTreeElement structureViewTreeElement = (StructureViewTreeElement)treeElement2;
            Object object = structureViewTreeElement != null ? structureViewTreeElement.getValue() : null;
            if (!(object instanceof PsiElement)) {
                object = null;
            }
            PsiElement psiElement = (PsiElement)object;
            Object object2 = childRange = psiElement != null ? psiElement.getTextRange() : null;
            if (childRange == null) continue;
            int n = childRange.getLength();
            if (1000 <= n && 2000 >= n) {
                return childRange;
            }
            if (childRange.getLength() <= 2000 || (grandchildRange = this.findRangeOfSuitableElement(child2)) == null) continue;
            return grandchildRange;
        }
        return null;
    }

    public RetypeQueue(@NotNull Project project, int retypeDelay, int threadDumpDelay, @Nullable StringBuilder scriptBuilder, int largeIndexFileCount, boolean restoreText) {
        List list2;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        this.retypeDelay = retypeDelay;
        this.threadDumpDelay = threadDumpDelay;
        this.scriptBuilder = scriptBuilder;
        this.largeIndexFileCount = largeIndexFileCount;
        this.restoreText = restoreText;
        RetypeQueue retypeQueue = this;
        retypeQueue.files = list2 = (List)new ArrayList();
        retypeQueue = this;
        retypeQueue.threadDumps = list2 = (List)new ArrayList();
    }
}

