/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.intellij;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.ide.ui.laf.darcula.ui.DarculaSpinnerUI;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.LafIconLookup;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.Path2D;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicArrowButton;
import org.jetbrains.annotations.Nullable;

public class MacIntelliJSpinnerUI
extends DarculaSpinnerUI {
    private static final Icon DEFAULT_ICON = EmptyIcon.create((Icon)LafIconLookup.getIcon((String)"spinnerRight"));

    public static ComponentUI createUI(JComponent c) {
        return new MacIntelliJSpinnerUI();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Container parent = c.getParent();
        if (c.isOpaque() && parent != null) {
            g.setColor(parent.getBackground());
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
        Insets i = c.getInsets();
        int x = c.getWidth() - DEFAULT_ICON.getIconWidth() - i.right;
        if (c instanceof JSpinner) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setColor(this.getBackground());
            float arc = JBUI.scale((float)6.0f);
            Path2D.Float rect = new Path2D.Float(0);
            ((Path2D)rect).moveTo(x, i.top);
            ((Path2D)rect).lineTo(x, c.getHeight() - i.bottom);
            ((Path2D)rect).lineTo((float)i.left + arc, c.getHeight() - i.bottom);
            ((Path2D)rect).quadTo(i.left, c.getHeight() - i.bottom, i.left, (float)(c.getHeight() - i.bottom) - arc);
            ((Path2D)rect).lineTo(i.left, (float)i.top + arc);
            ((Path2D)rect).quadTo(i.left, i.top, (float)i.left + arc, i.top);
            rect.closePath();
            g2.fill(rect);
        }
        Icon icon = LafIconLookup.getIcon((String)"spinnerRight", (boolean)false, (boolean)false, (boolean)c.isEnabled());
        icon.paintIcon(c, g, x, i.top);
    }

    @Override
    protected void paintArrowButton(Graphics g, BasicArrowButton button2, int direction) {
    }

    @Override
    protected Dimension getSizeWithButtons(Insets i, Dimension size) {
        int iconWidth = DEFAULT_ICON.getIconWidth() + i.right;
        int iconHeight = DEFAULT_ICON.getIconHeight() + i.top + i.bottom;
        Dimension minSize = new Dimension(i.left + MINIMUM_WIDTH.get() + i.right, iconHeight);
        size = DarculaUIUtil.maximize(size, minSize);
        JBDimension editorSize = this.spinner.getEditor() != null ? this.spinner.getEditor().getPreferredSize() : JBUI.emptySize();
        Insets m = this.editorMargins();
        return new Dimension(Math.max(size.width, i.left + m.left + editorSize.width + m.right + iconWidth), Math.max(size.height, i.top + m.top + editorSize.height + m.bottom + i.bottom));
    }

    @Override
    protected void layout() {
        JComponent editor = this.spinner.getEditor();
        if (editor != null) {
            Insets i = this.spinner.getInsets();
            Insets m = this.editorMargins();
            int editorHeight = editor.getPreferredSize().height;
            int editorOffset = (this.spinner.getHeight() - i.top - i.bottom - m.top - m.bottom - editorHeight) / 2;
            editor.setBounds(i.left + m.left, i.top + m.top + editorOffset, this.spinner.getWidth() - (i.left + i.right + DEFAULT_ICON.getIconWidth() + m.right + m.left), editor.getPreferredSize().height);
        }
    }

    @Nullable
    Rectangle getArrowButtonBounds() {
        Insets i = this.spinner.getInsets();
        return new Rectangle(this.spinner.getWidth() - DEFAULT_ICON.getIconWidth() - i.right, i.top, DEFAULT_ICON.getIconWidth(), DEFAULT_ICON.getIconHeight());
    }
}

