/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo.configurable;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.todo.TodoConfiguration;
import com.intellij.ide.todo.TodoFilter;
import com.intellij.ide.todo.configurable.FilterDialog;
import com.intellij.ide.todo.configurable.FiltersTableModel;
import com.intellij.ide.todo.configurable.PatternDialog;
import com.intellij.ide.todo.configurable.PatternsTableModel;
import com.intellij.ide.todo.configurable.TodoPatternTableCellRenderer;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.psi.search.TodoAttributesUtil;
import com.intellij.psi.search.TodoPattern;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.BooleanTableCellEditor;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.table.IconTableCellRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TodoConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    private JPanel myPanel;
    private JCheckBox myMultiLineCheckBox;
    private JBTable myPatternsTable;
    private JBTable myFiltersTable;
    protected final List<TodoPattern> myPatterns = new ArrayList<TodoPattern>();
    private final PatternsTableModel myPatternsModel;
    protected final List<TodoFilter> myFilters = new ArrayList<TodoFilter>();
    private final FiltersTableModel myFiltersModel = new FiltersTableModel(this.myFilters);

    public TodoConfigurable() {
        this.myPatternsModel = new PatternsTableModel(this.myPatterns);
    }

    protected boolean arePatternsModified() {
        TodoConfiguration todoConfiguration = TodoConfiguration.getInstance();
        TodoPattern[] initialPatterns = this.getTodoPatternsToDisplay(todoConfiguration);
        if (initialPatterns.length != this.myPatterns.size()) {
            return true;
        }
        for (TodoPattern initialPattern : initialPatterns) {
            if (this.myPatterns.contains(initialPattern)) continue;
            return true;
        }
        return false;
    }

    protected boolean areFiltersModified() {
        TodoConfiguration todoConfiguration = TodoConfiguration.getInstance();
        TodoFilter[] initialFilters = todoConfiguration.getTodoFilters();
        if (initialFilters.length != this.myFilters.size()) {
            return true;
        }
        for (TodoFilter initialFilter : initialFilters) {
            if (this.myFilters.contains(initialFilter)) continue;
            return true;
        }
        return false;
    }

    public boolean isModified() {
        this.stopEditing();
        return TodoConfiguration.getInstance().isMultiLine() != this.myMultiLineCheckBox.isSelected() || this.arePatternsModified() || this.areFiltersModified();
    }

    public void apply() throws ConfigurationException {
        this.stopEditing();
        TodoConfiguration.getInstance().setMultiLine(this.myMultiLineCheckBox.isSelected());
        if (this.arePatternsModified()) {
            TodoPattern[] patterns = this.myPatterns.toArray(new TodoPattern[0]);
            TodoConfiguration.getInstance().setTodoPatterns(patterns);
        }
        if (this.areFiltersModified()) {
            TodoFilter[] filters = this.myFilters.toArray(new TodoFilter[0]);
            TodoConfiguration.getInstance().setTodoFilters(filters);
        }
    }

    public void disposeUIResources() {
        this.myPanel = null;
        this.myPatternsModel.removeTableModelListener((TableModelListener)this.myPatternsTable);
        this.myPatternsTable = null;
        this.myFiltersModel.removeTableModelListener((TableModelListener)this.myFiltersTable);
        this.myFiltersTable = null;
    }

    public JComponent createComponent() {
        this.myMultiLineCheckBox = new JCheckBox(IdeBundle.message((String)"label.todo.multiline", (Object[])new Object[0]));
        this.myPatternsTable = new JBTable((TableModel)this.myPatternsModel);
        this.myPatternsTable.getEmptyText().setText(IdeBundle.message((String)"text.todo.no.patterns", (Object[])new Object[0]));
        TableColumn typeColumn = this.myPatternsTable.getColumnModel().getColumn(0);
        int width = this.myPatternsTable.getFontMetrics(this.myPatternsTable.getFont()).stringWidth(this.myPatternsTable.getColumnName(0)) + 10;
        typeColumn.setPreferredWidth(width);
        typeColumn.setMaxWidth(width);
        typeColumn.setMinWidth(width);
        typeColumn.setCellRenderer(new IconTableCellRenderer<Icon>(){

            @Override
            @Nullable
            protected Icon getIcon(@NotNull Icon value, JTable table, int row2) {
                if (value == null) {
                    1.$$$reportNull$$$0(0);
                }
                return value;
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focus, int row2, int column) {
                super.getTableCellRendererComponent(table, value, selected, focus, row2, column);
                this.setText("");
                return this;
            }

            @Override
            protected boolean isCenterAlignment() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/ide/todo/configurable/TodoConfigurable$1", "getIcon"));
            }
        });
        TableColumn todoCaseSensitiveColumn = this.myPatternsTable.getColumnModel().getColumn(1);
        width = this.myPatternsTable.getFontMetrics(this.myPatternsTable.getFont()).stringWidth(this.myPatternsTable.getColumnName(1)) + 10;
        todoCaseSensitiveColumn.setPreferredWidth(width);
        todoCaseSensitiveColumn.setMaxWidth(width);
        todoCaseSensitiveColumn.setMinWidth(width);
        todoCaseSensitiveColumn.setCellRenderer((TableCellRenderer)new BooleanTableCellRenderer());
        todoCaseSensitiveColumn.setCellEditor((TableCellEditor)new BooleanTableCellEditor());
        TodoPatternTableCellRenderer todoPatternRenderer = new TodoPatternTableCellRenderer(this.myPatterns);
        TableColumn patternColumn = this.myPatternsTable.getColumnModel().getColumn(2);
        patternColumn.setCellRenderer(todoPatternRenderer);
        JPanel patternsPanel = new JPanel(new BorderLayout());
        patternsPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)IdeBundle.message((String)"label.todo.patterns", (Object[])new Object[0]), (boolean)false));
        patternsPanel.add((Component)ToolbarDecorator.createDecorator((JTable)this.myPatternsTable).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button2) {
                TodoConfigurable.this.stopEditing();
                TodoPattern pattern = new TodoPattern(TodoAttributesUtil.createDefault());
                PatternDialog dialog2 = new PatternDialog(TodoConfigurable.this.myPanel, pattern, -1, TodoConfigurable.this.myPatterns);
                if (!dialog2.showAndGet()) {
                    return;
                }
                TodoConfigurable.this.myPatterns.add(pattern);
                int index = TodoConfigurable.this.myPatterns.size() - 1;
                TodoConfigurable.this.myPatternsModel.fireTableRowsInserted(index, index);
                TodoConfigurable.this.myPatternsTable.getSelectionModel().setSelectionInterval(index, index);
                TodoConfigurable.this.myPatternsTable.scrollRectToVisible(TodoConfigurable.this.myPatternsTable.getCellRect(index, 0, true));
            }
        }).setEditAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button2) {
                TodoConfigurable.this.editSelectedPattern();
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button2) {
                TodoConfigurable.this.stopEditing();
                int selectedIndex = TodoConfigurable.this.myPatternsTable.getSelectedRow();
                if (selectedIndex < 0 || selectedIndex >= TodoConfigurable.this.myPatternsModel.getRowCount()) {
                    return;
                }
                TodoPattern patternToBeRemoved = TodoConfigurable.this.myPatterns.get(selectedIndex);
                TableUtil.removeSelectedItems((JTable)TodoConfigurable.this.myPatternsTable);
                for (int i = 0; i < TodoConfigurable.this.myFilters.size(); ++i) {
                    TodoFilter filter = TodoConfigurable.this.myFilters.get(i);
                    if (!filter.contains(patternToBeRemoved)) continue;
                    filter.removeTodoPattern(patternToBeRemoved);
                    TodoConfigurable.this.myFiltersModel.fireTableRowsUpdated(i, i);
                }
            }
        }).disableUpDownActions().createPanel(), "Center");
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                TodoConfigurable.this.editSelectedPattern();
                return true;
            }
        }.installOn((Component)this.myPatternsTable);
        this.myFiltersTable = new JBTable((TableModel)this.myFiltersModel);
        this.myFiltersTable.getEmptyText().setText(IdeBundle.message((String)"text.todo.no.filters", (Object[])new Object[0]));
        TableColumn nameColumn = this.myFiltersTable.getColumnModel().getColumn(0);
        width = this.myPatternsTable.getColumnModel().getColumn(0).getPreferredWidth() + this.myPatternsTable.getColumnModel().getColumn(1).getPreferredWidth();
        nameColumn.setPreferredWidth(width);
        nameColumn.setMaxWidth(width);
        nameColumn.setMinWidth(width);
        nameColumn.setCellRenderer(new MyFilterNameTableCellRenderer());
        JPanel filtersPanel = new JPanel(new BorderLayout());
        filtersPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)IdeBundle.message((String)"label.todo.filters", (Object[])new Object[0]), (boolean)false));
        filtersPanel.add(ToolbarDecorator.createDecorator((JTable)this.myFiltersTable).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button2) {
                TodoConfigurable.this.stopEditing();
                TodoFilter filter = new TodoFilter();
                FilterDialog dialog2 = new FilterDialog(TodoConfigurable.this.myPanel, filter, -1, TodoConfigurable.this.myFilters, TodoConfigurable.this.myPatterns);
                if (dialog2.showAndGet()) {
                    TodoConfigurable.this.myFilters.add(filter);
                    int index = TodoConfigurable.this.myFilters.size() - 1;
                    TodoConfigurable.this.myFiltersModel.fireTableRowsInserted(index, index);
                    TodoConfigurable.this.myFiltersTable.getSelectionModel().setSelectionInterval(index, index);
                    TodoConfigurable.this.myFiltersTable.scrollRectToVisible(TodoConfigurable.this.myFiltersTable.getCellRect(index, 0, true));
                }
            }
        }).setEditAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button2) {
                TodoConfigurable.this.editSelectedFilter();
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button2) {
                TodoConfigurable.this.stopEditing();
                TableUtil.removeSelectedItems((JTable)TodoConfigurable.this.myFiltersTable);
            }
        }).disableUpDownActions().createPanel());
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                TodoConfigurable.this.editSelectedFilter();
                return true;
            }
        }.installOn((Component)this.myFiltersTable);
        this.myPanel = FormBuilder.createFormBuilder().addComponent((JComponent)this.myMultiLineCheckBox).addComponentFillVertically((JComponent)patternsPanel, 0).addComponentFillVertically((JComponent)filtersPanel, 0).getPanel();
        return this.myPanel;
    }

    private void editSelectedPattern() {
        this.stopEditing();
        int selectedIndex = this.myPatternsTable.getSelectedRow();
        if (selectedIndex < 0 || selectedIndex >= this.myPatternsModel.getRowCount()) {
            return;
        }
        TodoPattern sourcePattern = this.myPatterns.get(selectedIndex);
        TodoPattern pattern = sourcePattern.clone();
        PatternDialog dialog2 = new PatternDialog(this.myPanel, pattern, selectedIndex, this.myPatterns);
        dialog2.setTitle(IdeBundle.message((String)"title.edit.todo.pattern", (Object[])new Object[0]));
        if (!dialog2.showAndGet()) {
            return;
        }
        this.myPatterns.set(selectedIndex, pattern);
        this.myPatternsModel.fireTableRowsUpdated(selectedIndex, selectedIndex);
        this.myPatternsTable.getSelectionModel().setSelectionInterval(selectedIndex, selectedIndex);
        for (int i = 0; i < this.myFilters.size(); ++i) {
            TodoFilter filter = this.myFilters.get(i);
            if (!filter.contains(sourcePattern)) continue;
            filter.removeTodoPattern(sourcePattern);
            filter.addTodoPattern(pattern);
            this.myFiltersModel.fireTableRowsUpdated(i, i);
        }
    }

    private void editSelectedFilter() {
        this.stopEditing();
        int selectedIndex = this.myFiltersTable.getSelectedRow();
        if (selectedIndex < 0 || selectedIndex >= this.myFiltersModel.getRowCount()) {
            return;
        }
        TodoFilter sourceFilter = this.myFilters.get(selectedIndex);
        TodoFilter filter = sourceFilter.clone();
        FilterDialog dialog2 = new FilterDialog(this.myPanel, filter, selectedIndex, this.myFilters, this.myPatterns);
        dialog2.setTitle(IdeBundle.message((String)"title.edit.todo.filter", (Object[])new Object[0]));
        dialog2.show();
        int exitCode = dialog2.getExitCode();
        if (0 == exitCode) {
            this.myFilters.set(selectedIndex, filter);
            this.myFiltersModel.fireTableRowsUpdated(selectedIndex, selectedIndex);
            this.myFiltersTable.getSelectionModel().setSelectionInterval(selectedIndex, selectedIndex);
        }
    }

    protected void stopEditing() {
        TableCellEditor editor;
        if (this.myPatternsTable.isEditing() && (editor = this.myPatternsTable.getCellEditor()) != null) {
            editor.stopCellEditing();
        }
        if (this.myFiltersTable.isEditing() && (editor = this.myFiltersTable.getCellEditor()) != null) {
            editor.stopCellEditing();
        }
    }

    public String getDisplayName() {
        return IdeBundle.message((String)"title.todo", (Object[])new Object[0]);
    }

    @NotNull
    public String getHelpTopic() {
        if ("preferences.toDoOptions" == null) {
            TodoConfigurable.$$$reportNull$$$0(0);
        }
        return "preferences.toDoOptions";
    }

    public void reset() {
        TodoFilter[] filters;
        TodoPattern[] patterns;
        this.myMultiLineCheckBox.setSelected(TodoConfiguration.getInstance().isMultiLine());
        this.myPatterns.clear();
        TodoConfiguration todoConfiguration = TodoConfiguration.getInstance();
        for (TodoPattern pattern : patterns = this.getTodoPatternsToDisplay(todoConfiguration)) {
            this.myPatterns.add(pattern.clone());
        }
        this.myPatternsModel.fireTableDataChanged();
        this.myFilters.clear();
        for (TodoFilter filter : filters = todoConfiguration.getTodoFilters()) {
            this.myFilters.add(filter.clone());
        }
        this.myFiltersModel.fireTableDataChanged();
    }

    @NotNull
    protected TodoPattern[] getTodoPatternsToDisplay(TodoConfiguration todoConfiguration) {
        TodoPattern[] todoPatternArray = todoConfiguration.getTodoPatterns();
        if (todoPatternArray == null) {
            TodoConfigurable.$$$reportNull$$$0(1);
        }
        return todoPatternArray;
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            TodoConfigurable.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/ide/todo/configurable/TodoConfigurable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpTopic";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTodoPatternsToDisplay";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private final class MyFilterNameTableCellRenderer
    extends DefaultTableCellRenderer {
        private MyFilterNameTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row2, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row2, column);
            TodoFilter filter = TodoConfigurable.this.myFilters.get(row2);
            if (isSelected) {
                this.setForeground(UIUtil.getTableSelectionForeground());
            } else if (filter.isEmpty()) {
                this.setForeground((Color)JBColor.RED);
            } else {
                this.setForeground(UIUtil.getTableForeground());
            }
            return this;
        }
    }
}

