/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginUpdatesService {
    private static final List<PluginUpdatesService> SERVICES = new ArrayList<PluginUpdatesService>();
    private static Collection<PluginDownloader> myCache;
    private static boolean myPrepared;
    private static boolean myPreparing;
    private Consumer<Integer> myTreeCallback;
    private Consumer<Integer> myTabCallback;
    private Consumer<Collection<PluginDownloader>> myInstalledPanelCallback;
    private Consumer<Collection<PluginDownloader>> myUpdatePanelCallback;

    @NotNull
    public static PluginUpdatesService connectTreeRenderer(@NotNull Consumer<Integer> callback2) {
        if (callback2 == null) {
            PluginUpdatesService.$$$reportNull$$$0(0);
        }
        PluginUpdatesService.checkAccess();
        PluginUpdatesService service2 = new PluginUpdatesService();
        SERVICES.add(service2);
        service2.myTreeCallback = callback2;
        if (myPrepared) {
            callback2.accept(PluginUpdatesService.getCount());
        } else {
            PluginUpdatesService.calculateUpdates();
        }
        PluginUpdatesService pluginUpdatesService = service2;
        if (pluginUpdatesService == null) {
            PluginUpdatesService.$$$reportNull$$$0(1);
        }
        return pluginUpdatesService;
    }

    @NotNull
    public static PluginUpdatesService connectConfigurable(@NotNull Consumer<Integer> callback2) {
        if (callback2 == null) {
            PluginUpdatesService.$$$reportNull$$$0(2);
        }
        PluginUpdatesService.checkAccess();
        PluginUpdatesService service2 = new PluginUpdatesService();
        SERVICES.add(service2);
        service2.myTabCallback = callback2;
        if (myPrepared) {
            callback2.accept(PluginUpdatesService.getCount());
        } else {
            PluginUpdatesService.calculateUpdates();
        }
        PluginUpdatesService pluginUpdatesService = service2;
        if (pluginUpdatesService == null) {
            PluginUpdatesService.$$$reportNull$$$0(3);
        }
        return pluginUpdatesService;
    }

    public void connectInstalled(@NotNull Consumer<Collection<PluginDownloader>> callback2) {
        if (callback2 == null) {
            PluginUpdatesService.$$$reportNull$$$0(4);
        }
        PluginUpdatesService.checkAccess();
        this.myInstalledPanelCallback = callback2;
        if (myPrepared) {
            callback2.accept(myCache);
        } else {
            PluginUpdatesService.calculateUpdates();
        }
    }

    public void calculateUpdates(@NotNull Consumer<Collection<PluginDownloader>> callback2) {
        if (callback2 == null) {
            PluginUpdatesService.$$$reportNull$$$0(5);
        }
        PluginUpdatesService.checkAccess();
        this.myUpdatePanelCallback = callback2;
        if (myPrepared) {
            callback2.accept(myCache);
        } else {
            PluginUpdatesService.calculateUpdates();
        }
    }

    public void finishUpdate(@NotNull IdeaPluginDescriptor descriptor) {
        if (descriptor == null) {
            PluginUpdatesService.$$$reportNull$$$0(6);
        }
        PluginUpdatesService.checkAccess();
        if (!myPrepared || myCache == null) {
            return;
        }
        Iterator<PluginDownloader> I = myCache.iterator();
        while (I.hasNext()) {
            PluginDownloader downloader = I.next();
            if (downloader.getDescriptor() != descriptor) continue;
            I.remove();
            Integer countValue = PluginUpdatesService.getCount();
            for (PluginUpdatesService service2 : SERVICES) {
                service2.runCountCallbacks(countValue);
            }
            return;
        }
    }

    public void recalculateUpdates() {
        PluginUpdatesService.checkAccess();
        assert (!myPreparing);
        Integer countValue = -1;
        for (PluginUpdatesService service2 : SERVICES) {
            service2.runCountCallbacks(countValue);
            if (service2.myInstalledPanelCallback == null) continue;
            service2.myInstalledPanelCallback.accept(null);
        }
        PluginUpdatesService.calculateUpdates();
    }

    public void dispose() {
        PluginUpdatesService.checkAccess();
        PluginUpdatesService.dispose(this);
    }

    private static void dispose(@NotNull PluginUpdatesService service2) {
        if (service2 == null) {
            PluginUpdatesService.$$$reportNull$$$0(7);
        }
        SERVICES.remove(service2);
        if (SERVICES.isEmpty()) {
            myCache = null;
            myPrepared = false;
            myPreparing = false;
        }
    }

    private static void calculateUpdates() {
        if (myPreparing) {
            return;
        }
        myPreparing = true;
        myCache = null;
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            Collection<PluginDownloader> updates = UpdateChecker.getPluginUpdates();
            ApplicationManager.getApplication().invokeLater(() -> {
                PluginUpdatesService.checkAccess();
                myPreparing = false;
                myPrepared = true;
                myCache = updates;
                Integer countValue = PluginUpdatesService.getCount();
                for (PluginUpdatesService service2 : SERVICES) {
                    service2.runAllCallbacks(countValue);
                }
            }, ModalityState.any());
        });
    }

    private void runAllCallbacks(@Nullable Integer countValue) {
        this.runCountCallbacks(countValue);
        if (this.myInstalledPanelCallback != null) {
            this.myInstalledPanelCallback.accept(myCache);
        }
        if (this.myUpdatePanelCallback != null) {
            this.myUpdatePanelCallback.accept(myCache);
        }
    }

    private void runCountCallbacks(@Nullable Integer countValue) {
        if (this.myTreeCallback != null) {
            this.myTreeCallback.accept(countValue);
        }
        if (this.myTabCallback != null) {
            this.myTabCallback.accept(countValue);
        }
    }

    @Nullable
    private static Integer getCount() {
        return myCache == null ? null : new Integer(myCache.size());
    }

    private static void checkAccess() {
        assert (SwingUtilities.isEventDispatchThread());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/newui/PluginUpdatesService";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/newui/PluginUpdatesService";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "connectTreeRenderer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "connectConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "connectTreeRenderer";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "connectConfigurable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "connectInstalled";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "calculateUpdates";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "finishUpdate";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "dispose";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

