/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navigationToolbar;

import com.intellij.ProjectTopics;
import com.intellij.ide.actions.CopyAction;
import com.intellij.ide.actions.CutAction;
import com.intellij.ide.navigationToolbar.NavBarItem;
import com.intellij.ide.navigationToolbar.NavBarKeyboardCommand;
import com.intellij.ide.navigationToolbar.NavBarModelListener;
import com.intellij.ide.navigationToolbar.NavBarPanel;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PopupAction;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.problems.ProblemListener;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.ui.ScrollingUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Robot;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class NavBarListener
implements ProblemListener,
ActionListener,
FocusListener,
FileStatusListener,
AnActionListener,
FileEditorManagerListener,
PsiTreeChangeListener,
ModuleRootListener,
NavBarModelListener,
PropertyChangeListener,
KeyListener,
WindowFocusListener,
LafManagerListener {
    private static final String LISTENER = "NavBarListener";
    private static final String BUS = "NavBarMessageBus";
    private final NavBarPanel myPanel;
    private boolean shouldFocusEditor;

    static void subscribeTo(NavBarPanel panel2) {
        if (panel2.getClientProperty(LISTENER) != null) {
            NavBarListener.unsubscribeFrom(panel2);
        }
        NavBarListener listener2 = new NavBarListener(panel2);
        Project project = panel2.getProject();
        panel2.putClientProperty(LISTENER, listener2);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener(listener2);
        FileStatusManager.getInstance((Project)project).addFileStatusListener((FileStatusListener)listener2);
        PsiManager.getInstance((Project)project).addPsiTreeChangeListener((PsiTreeChangeListener)listener2);
        MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(AnActionListener.TOPIC, (Object)listener2);
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)listener2);
        connection.subscribe(NavBarModelListener.NAV_BAR, (Object)listener2);
        connection.subscribe(ProblemListener.TOPIC, (Object)listener2);
        connection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)listener2);
        panel2.putClientProperty(BUS, connection);
        panel2.addKeyListener(listener2);
        if (panel2.isInFloatingMode()) {
            Window window = SwingUtilities.windowForComponent(panel2);
            if (window != null) {
                window.addWindowFocusListener(listener2);
            }
        } else {
            LafManager.getInstance().addLafManagerListener((LafManagerListener)listener2);
        }
    }

    static void unsubscribeFrom(NavBarPanel panel2) {
        NavBarListener listener2 = (NavBarListener)panel2.getClientProperty(LISTENER);
        panel2.putClientProperty(LISTENER, null);
        if (listener2 != null) {
            Project project = panel2.getProject();
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener(listener2);
            FileStatusManager.getInstance((Project)project).removeFileStatusListener((FileStatusListener)listener2);
            PsiManager.getInstance((Project)project).removePsiTreeChangeListener((PsiTreeChangeListener)listener2);
            MessageBusConnection connection = (MessageBusConnection)panel2.getClientProperty(BUS);
            panel2.putClientProperty(BUS, null);
            if (connection != null) {
                connection.disconnect();
            }
            LafManager.getInstance().removeLafManagerListener((LafManagerListener)listener2);
        }
    }

    NavBarListener(NavBarPanel panel2) {
        this.myPanel = panel2;
        for (NavBarKeyboardCommand command : NavBarKeyboardCommand.values()) {
            this.registerKey(command);
        }
        this.myPanel.addFocusListener(this);
        if (this.myPanel.allowNavItemsFocus()) {
            this.myPanel.addNavBarItemFocusListener(this);
        }
    }

    private void registerKey(NavBarKeyboardCommand cmd) {
        int whenFocused = this.myPanel.allowNavItemsFocus() ? 1 : 0;
        this.myPanel.registerKeyboardAction(this, cmd.name(), cmd.getKeyStroke(), whenFocused);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        NavBarKeyboardCommand cmd = NavBarKeyboardCommand.fromString(e.getActionCommand());
        if (cmd != null) {
            switch (cmd) {
                case LEFT: {
                    this.myPanel.moveLeft();
                    break;
                }
                case RIGHT: {
                    this.myPanel.moveRight();
                    break;
                }
                case HOME: {
                    this.myPanel.moveHome();
                    break;
                }
                case END: {
                    this.myPanel.moveEnd();
                    break;
                }
                case DOWN: {
                    this.myPanel.moveDown();
                    break;
                }
                case UP: {
                    this.myPanel.moveDown();
                    break;
                }
                case ENTER: {
                    this.myPanel.enter();
                    break;
                }
                case ESCAPE: {
                    this.myPanel.escape();
                    break;
                }
                case NAVIGATE: {
                    this.myPanel.navigate();
                }
            }
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.myPanel.allowNavItemsFocus() && UIUtil.isAncestor((Component)this.myPanel, (Component)e.getOppositeComponent())) {
            return;
        }
        if (e.getOppositeComponent() == null && this.shouldFocusEditor) {
            this.shouldFocusEditor = false;
            ToolWindowManager.getInstance((Project)this.myPanel.getProject()).activateEditorComponent();
            return;
        }
        this.myPanel.updateItems();
        List<NavBarItem> items = this.myPanel.getItems();
        if (!this.myPanel.isInFloatingMode() && items.size() > 0) {
            this.myPanel.setContextComponent((Component)((Object)items.get(items.size() - 1)));
        } else {
            this.myPanel.setContextComponent(null);
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (this.myPanel.allowNavItemsFocus() && UIUtil.isAncestor((Component)this.myPanel, (Component)e.getOppositeComponent())) {
            return;
        }
        if (this.myPanel.getProject().isDisposed()) {
            this.myPanel.setContextComponent(null);
            this.myPanel.hideHint();
            return;
        }
        DialogWrapper dialog2 = DialogWrapper.findInstance((Component)e.getOppositeComponent());
        boolean bl = this.shouldFocusEditor = dialog2 != null;
        if (dialog2 != null) {
            Disposable parent = dialog2.getDisposable();
            Disposable onParentDispose = () -> {
                if (dialog2.getExitCode() == 1) {
                    this.shouldFocusEditor = false;
                }
            };
            if (dialog2.isDisposed()) {
                Disposer.dispose((Disposable)onParentDispose);
            } else {
                Disposer.register((Disposable)parent, (Disposable)onParentDispose);
            }
        }
        SwingUtilities.invokeLater(() -> this.processFocusLost(e));
    }

    private void processFocusLost(FocusEvent e) {
        boolean childPopupInactive;
        Component opposite = e.getOppositeComponent();
        if (this.myPanel.isInFloatingMode() && opposite != null && DialogWrapper.findInstance((Component)opposite) != null) {
            this.myPanel.hideHint();
            return;
        }
        boolean nodePopupInactive = !this.myPanel.isNodePopupActive();
        boolean bl = childPopupInactive = !JBPopupFactory.getInstance().isChildPopupFocused((Component)this.myPanel);
        if (nodePopupInactive && childPopupInactive && opposite != null && opposite != this.myPanel && !this.myPanel.isAncestorOf(opposite) && !e.isTemporary()) {
            this.myPanel.setContextComponent(null);
            this.myPanel.hideHint();
        }
        this.myPanel.updateItems();
    }

    private void rebuildUI() {
        if (this.myPanel.isShowing()) {
            this.myPanel.getUpdateQueue().queueRebuildUi();
        }
    }

    private void updateModel() {
        if (this.myPanel.isShowing()) {
            this.myPanel.getModel().setChanged(true);
            this.myPanel.getUpdateQueue().queueModelUpdateFromFocus();
        }
    }

    public void fileStatusesChanged() {
        this.rebuildUI();
    }

    public void fileStatusChanged(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            NavBarListener.$$$reportNull$$$0(0);
        }
        this.rebuildUI();
    }

    public void childAdded(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            NavBarListener.$$$reportNull$$$0(1);
        }
        this.updateModel();
    }

    public void childReplaced(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            NavBarListener.$$$reportNull$$$0(2);
        }
        this.updateModel();
    }

    public void childMoved(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            NavBarListener.$$$reportNull$$$0(3);
        }
        this.updateModel();
    }

    public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            NavBarListener.$$$reportNull$$$0(4);
        }
        this.updateModel();
    }

    public void propertyChanged(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            NavBarListener.$$$reportNull$$$0(5);
        }
        this.updateModel();
    }

    public void rootsChanged(@NotNull ModuleRootEvent event) {
        if (event == null) {
            NavBarListener.$$$reportNull$$$0(6);
        }
        this.updateModel();
    }

    public void problemsAppeared(@NotNull VirtualFile file2) {
        if (file2 == null) {
            NavBarListener.$$$reportNull$$$0(7);
        }
        this.updateModel();
    }

    public void problemsDisappeared(@NotNull VirtualFile file2) {
        if (file2 == null) {
            NavBarListener.$$$reportNull$$$0(8);
        }
        this.updateModel();
    }

    @Override
    public void modelChanged() {
        this.rebuildUI();
    }

    @Override
    public void selectionChanged() {
        this.myPanel.updateItems();
        this.myPanel.scrollSelectionToVisible();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name;
        if (this.myPanel.isShowing() && ("focusOwner".equals(name = evt.getPropertyName()) || "permanentFocusOwner".equals(name))) {
            this.myPanel.getUpdateQueue().restartRebuild();
        }
    }

    public void afterActionPerformed(@NotNull AnAction action, @NotNull DataContext dataContext, @NotNull AnActionEvent event) {
        if (action == null) {
            NavBarListener.$$$reportNull$$$0(9);
        }
        if (dataContext == null) {
            NavBarListener.$$$reportNull$$$0(10);
        }
        if (event == null) {
            NavBarListener.$$$reportNull$$$0(11);
        }
        if (NavBarListener.shouldSkipAction(action)) {
            return;
        }
        if (this.myPanel.isInFloatingMode()) {
            this.myPanel.hideHint();
        } else {
            this.myPanel.cancelPopup();
        }
    }

    private static boolean shouldSkipAction(AnAction action) {
        return action instanceof PopupAction || action instanceof CopyAction || action instanceof CutAction || action instanceof ScrollingUtil.ScrollingAction;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (!(e.isAltDown() || e.isMetaDown() || e.isControlDown() || this.myPanel.isNodePopupActive())) {
            if (!Character.isLetter(e.getKeyChar())) {
                return;
            }
            IdeFocusManager focusManager = IdeFocusManager.getInstance((Project)this.myPanel.getProject());
            ActionCallback firstCharTyped = new ActionCallback();
            focusManager.typeAheadUntil(firstCharTyped);
            this.myPanel.moveDown();
            SwingUtilities.invokeLater(() -> {
                try {
                    Robot robot = new Robot();
                    boolean shiftOn = e.isShiftDown();
                    int code = e.getKeyCode();
                    if (shiftOn) {
                        robot.keyPress(16);
                    }
                    robot.keyPress(code);
                    robot.keyRelease(code);
                    firstCharTyped.setDone();
                }
                catch (AWTException aWTException) {
                    // empty catch block
                }
            });
        }
    }

    public void fileOpened(@NotNull FileEditorManager manager, @NotNull VirtualFile file2) {
        if (manager == null) {
            NavBarListener.$$$reportNull$$$0(12);
        }
        if (file2 == null) {
            NavBarListener.$$$reportNull$$$0(13);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.myPanel.isFocused()) {
                manager.openFile(file2, true);
            }
        });
    }

    public void lookAndFeelChanged(@NotNull LafManager source) {
        if (source == null) {
            NavBarListener.$$$reportNull$$$0(14);
        }
        this.myPanel.getNavBarUI().clearItems();
        this.myPanel.revalidate();
        this.myPanel.repaint();
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
    }

    @Override
    public void windowGainedFocus(WindowEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    public void beforeChildAddition(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            NavBarListener.$$$reportNull$$$0(15);
        }
    }

    public void beforeChildRemoval(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            NavBarListener.$$$reportNull$$$0(16);
        }
    }

    public void beforeChildReplacement(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            NavBarListener.$$$reportNull$$$0(17);
        }
    }

    public void beforeChildMovement(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            NavBarListener.$$$reportNull$$$0(18);
        }
    }

    public void beforeChildrenChange(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            NavBarListener.$$$reportNull$$$0(19);
        }
    }

    public void beforePropertyChange(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            NavBarListener.$$$reportNull$$$0(20);
        }
    }

    public void childRemoved(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            NavBarListener.$$$reportNull$$$0(21);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 7: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/navigationToolbar/NavBarListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fileStatusChanged";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "childAdded";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "childReplaced";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "childMoved";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "childrenChanged";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "propertyChanged";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "rootsChanged";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "problemsAppeared";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "problemsDisappeared";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "afterActionPerformed";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "fileOpened";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "lookAndFeelChanged";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeChildAddition";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeChildRemoval";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeChildReplacement";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeChildMovement";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeChildrenChange";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "beforePropertyChange";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "childRemoved";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

