/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.configurationStore.StorageUtilKt;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.ProjectGroup;
import com.intellij.ide.ProjectGroupActionGroup;
import com.intellij.ide.RecentProjectIconHelper;
import com.intellij.ide.RecentProjectsManager;
import com.intellij.ide.ReopenProjectAction;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.JetBrainsProtocolHandler;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.impl.SystemDock;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.project.ProjectKt;
import com.intellij.util.Alarm;
import com.intellij.util.PathUtil;
import com.intellij.util.PathUtilRt;
import com.intellij.util.SingleAlarm;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;

@com.intellij.openapi.components.State(name="RecentProjectsManager", storages={@Storage(value="recentProjects.xml", roamingType=RoamingType.DISABLED)})
public class RecentProjectsManagerBase
extends RecentProjectsManager
implements PersistentStateComponent<State>,
ModificationTracker {
    private static final int MAX_PROJECTS_IN_MAIN_MENU = 6;
    private final AtomicLong myModCounter;
    private final RecentProjectIconHelper myProjectIconHelper;
    private final Set<String> myNamesToResolve;
    private final Map<String, String> myNameCache;
    private final SingleAlarm myNamesResolver;
    private final Object myStateLock;
    private State myState;
    private boolean myBatchOpening;

    public static RecentProjectsManagerBase getInstanceEx() {
        return (RecentProjectsManagerBase)RecentProjectsManager.getInstance();
    }

    protected RecentProjectsManagerBase(@NotNull MessageBus messageBus) {
        if (messageBus == null) {
            RecentProjectsManagerBase.$$$reportNull$$$0(0);
        }
        this.myModCounter = new AtomicLong();
        this.myProjectIconHelper = new RecentProjectIconHelper();
        this.myNamesToResolve = new THashSet(6);
        this.myNameCache = Collections.synchronizedMap(new THashMap());
        this.myNamesResolver = new SingleAlarm(() -> {
            THashSet paths;
            Set<String> set2 = this.myNamesToResolve;
            synchronized (set2) {
                paths = new THashSet(this.myNamesToResolve);
                this.myNamesToResolve.clear();
            }
            for (String p : paths) {
                this.myNameCache.put(p, RecentProjectsManagerBase.readProjectName(p));
            }
        }, 50, Alarm.ThreadToUse.POOLED_THREAD, (Disposable)ApplicationManager.getApplication());
        this.myStateLock = new Object();
        this.myState = new State();
        MessageBusConnection connection = messageBus.connect();
        connection.subscribe(AppLifecycleListener.TOPIC, (Object)new MyAppLifecycleListener());
        connection.subscribe(ProjectManager.TOPIC, (Object)new MyProjectListener());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public State getState() {
        Object object = this.myStateLock;
        synchronized (object) {
            if (this.myState.pid == null) {
                this.myState.pid = "";
            }
            return this.myState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    protected final State getStateInner() {
        Object object = this.myStateLock;
        // MONITORENTER : object
        State state = this.myState;
        // MONITOREXIT : object
        if (state != null) return state;
        RecentProjectsManagerBase.$$$reportNull$$$0(1);
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(@NotNull State state) {
        File lastFile;
        if (state == null) {
            RecentProjectsManagerBase.$$$reportNull$$$0(2);
        }
        state.makePathsSystemIndependent();
        RecentProjectsManagerBase.removeDuplicates(state);
        if (state.lastPath != null && (!(lastFile = new File(PathUtil.toSystemDependentName((String)state.lastPath))).exists() || lastFile.isDirectory() && !new File(lastFile, ".idea").exists())) {
            state.lastPath = null;
        }
        Object object = this.myStateLock;
        synchronized (object) {
            this.myState = state;
            this.myState.pid = null;
        }
    }

    private static void removeDuplicates(@NotNull State state) {
        if (state == null) {
            RecentProjectsManagerBase.$$$reportNull$$$0(3);
        }
        for (String path : new ArrayList<String>(state.recentPaths)) {
            if (!path.endsWith("/")) continue;
            state.recentPaths.remove(path);
            state.additionalInfo.remove(path);
            state.openPaths.remove(path);
        }
    }

    private static void removePathFrom(@NotNull List<String> items, @NotNull String path) {
        if (items == null) {
            RecentProjectsManagerBase.$$$reportNull$$$0(4);
        }
        if (path == null) {
            RecentProjectsManagerBase.$$$reportNull$$$0(5);
        }
        Iterator<String> iterator = items.iterator();
        while (iterator.hasNext()) {
            String next = iterator.next();
            if (!(SystemInfo.isFileSystemCaseSensitive ? path.equals(next) : path.equalsIgnoreCase(next))) continue;
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePath(@Nullable @SystemIndependent String path) {
        if (path == null) {
            return;
        }
        Object object = this.myStateLock;
        synchronized (object) {
            RecentProjectsManagerBase.removePathFrom(this.myState.recentPaths, path);
            this.myState.names.remove(path);
            for (ProjectGroup group : this.myState.groups) {
                group.removeProject(path);
            }
        }
        this.myModCounter.incrementAndGet();
    }

    public boolean hasPath(@SystemIndependent String path) {
        State state = this.getState();
        return state != null && state.recentPaths.contains(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public @SystemIndependent String getLastProjectCreationLocation() {
        Object object = this.myStateLock;
        synchronized (object) {
            return this.myState.lastProjectLocation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastProjectCreationLocation(@Nullable @SystemIndependent String lastProjectLocation) {
        String location = StringUtil.nullize((String)lastProjectLocation, (boolean)true);
        String newValue = PathUtil.toSystemIndependentName((String)location);
        Object object = this.myStateLock;
        synchronized (object) {
            if (!Objects.equals(newValue, this.myState.lastProjectLocation)) {
                this.myState.lastProjectLocation = newValue;
                this.myModCounter.incrementAndGet();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @SystemIndependent String getLastProjectPath() {
        Object object = this.myStateLock;
        synchronized (object) {
            return this.myState.lastPath;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateLastProjectPath() {
        Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
        Object object = this.myStateLock;
        synchronized (object) {
            List<String> openPaths = this.myState.openPaths;
            openPaths.clear();
            if (openProjects.length == 0) {
                this.myState.lastPath = null;
            } else {
                this.myState.lastPath = this.getProjectPath(openProjects[openProjects.length - 1]);
                for (Project openProject : openProjects) {
                    String path = this.getProjectPath(openProject);
                    if (path == null) continue;
                    openPaths.add(path);
                    this.myState.names.put(path, this.getProjectDisplayName(openProject));
                }
            }
            this.myState.validateRecentProjects(this.myModCounter);
            this.updateOpenProjectsTimestamps(openProjects);
        }
        this.myModCounter.incrementAndGet();
    }

    private void updateOpenProjectsTimestamps(@NotNull Project[] openProjects) {
        if (openProjects == null) {
            RecentProjectsManagerBase.$$$reportNull$$$0(6);
        }
        Map<String, RecentProjectMetaInfo> additionalInfo = this.myState.additionalInfo;
        for (Project project : openProjects) {
            RecentProjectMetaInfo info;
            String path = this.getProjectPath(project);
            RecentProjectMetaInfo recentProjectMetaInfo = info = path == null ? null : additionalInfo.get(path);
            if (info == null) continue;
            info.projectOpenTimestamp = System.currentTimeMillis();
        }
    }

    @NotNull
    protected String getProjectDisplayName(@NotNull Project project) {
        if (project == null) {
            RecentProjectsManagerBase.$$$reportNull$$$0(7);
        }
        if ("" == null) {
            RecentProjectsManagerBase.$$$reportNull$$$0(8);
        }
        return "";
    }

    @Nullable
    public final Icon getProjectIcon(@NotNull @SystemIndependent String path, boolean isDark) {
        if (path == null) {
            RecentProjectsManagerBase.$$$reportNull$$$0(9);
        }
        return this.myProjectIconHelper.getProjectIcon(path, isDark);
    }

    public final Icon getProjectOrAppIcon(@NotNull @SystemIndependent String path) {
        if (path == null) {
            RecentProjectsManagerBase.$$$reportNull$$$0(10);
        }
        return this.myProjectIconHelper.getProjectOrAppIcon(path);
    }

    @NotNull
    private Set<String> getDuplicateProjectNames(@NotNull Set<String> openedPaths, @NotNull Set<String> recentPaths) {
        if (openedPaths == null) {
            RecentProjectsManagerBase.$$$reportNull$$$0(11);
        }
        if (recentPaths == null) {
            RecentProjectsManagerBase.$$$reportNull$$$0(12);
        }
        THashSet names = new THashSet();
        THashSet duplicates = new THashSet();
        for (String path : ContainerUtil.concat((Iterable[])new Iterable[]{openedPaths, recentPaths})) {
            if (names.add(this.getProjectName(path))) continue;
            duplicates.add(path);
        }
        THashSet tHashSet = duplicates;
        if (tHashSet == null) {
            RecentProjectsManagerBase.$$$reportNull$$$0(13);
        }
        return tHashSet;
    }

    @NotNull
    public AnAction[] getRecentProjectsActions(boolean forMainMenu) {
        AnAction[] anActionArray = this.getRecentProjectsActions(forMainMenu, false);
        if (anActionArray == null) {
            RecentProjectsManagerBase.$$$reportNull$$$0(14);
        }
        return anActionArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public AnAction[] getRecentProjectsActions(boolean forMainMenu, boolean useGroups) {
        LinkedHashSet<String> paths;
        Object object = this.myStateLock;
        synchronized (object) {
            this.myState.validateRecentProjects(this.myModCounter);
            paths = new LinkedHashSet<String>(this.myState.recentPaths);
        }
        THashSet openedPaths = new THashSet();
        for (Object openProject : ProjectManager.getInstance().getOpenProjects()) {
            ContainerUtil.addIfNotNull((Collection)openedPaths, (Object)this.getProjectPath((Project)openProject));
        }
        paths.remove(null);
        SmartList actions = new SmartList();
        Set<String> duplicates = this.getDuplicateProjectNames((Set<String>)openedPaths, paths);
        if (useGroups) {
            ArrayList<ProjectGroup> groups;
            Object openProject;
            openProject = this.myStateLock;
            synchronized (openProject) {
                groups = new ArrayList<ProjectGroup>(this.myState.groups);
            }
            final ArrayList<String> projectPaths = new ArrayList<String>(paths);
            groups.sort(new Comparator<ProjectGroup>(){

                @Override
                public int compare(ProjectGroup o1, ProjectGroup o2) {
                    int ind2;
                    int ind1 = this.getGroupIndex(o1);
                    return ind1 == (ind2 = this.getGroupIndex(o2)) ? StringUtil.naturalCompare((String)o1.getName(), (String)o2.getName()) : ind1 - ind2;
                }

                private int getGroupIndex(ProjectGroup group) {
                    int index = Integer.MAX_VALUE;
                    for (String path : group.getProjects()) {
                        int i = projectPaths.indexOf(path);
                        if (i < 0 || index <= i) continue;
                        index = i;
                    }
                    return index;
                }
            });
            for (ProjectGroup group : groups) {
                paths.removeAll(group.getProjects());
            }
            for (ProjectGroup group : groups) {
                ArrayList<AnAction> children2 = new ArrayList<AnAction>();
                for (String path : group.getProjects()) {
                    children2.add(this.createOpenAction(path, duplicates));
                    if (!forMainMenu || children2.size() < 6) continue;
                    break;
                }
                actions.add(new ProjectGroupActionGroup(group, children2));
                if (!group.isExpanded()) continue;
                actions.addAll(children2);
            }
        }
        for (String path : paths) {
            actions.add(this.createOpenAction(path, duplicates));
        }
        if (actions.isEmpty()) {
            if (AnAction.EMPTY_ARRAY == null) {
                RecentProjectsManagerBase.$$$reportNull$$$0(15);
            }
            return AnAction.EMPTY_ARRAY;
        }
        AnAction[] anActionArray = actions.toArray(AnAction.EMPTY_ARRAY);
        if (anActionArray == null) {
            RecentProjectsManagerBase.$$$reportNull$$$0(16);
        }
        return anActionArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected AnAction createOpenAction(@NotNull @SystemIndependent String path, @NotNull Set<String> duplicates) {
        String displayName;
        if (path == null) {
            RecentProjectsManagerBase.$$$reportNull$$$0(17);
        }
        if (duplicates == null) {
            RecentProjectsManagerBase.$$$reportNull$$$0(18);
        }
        String projectName = this.getProjectName(path);
        Object object = this.myStateLock;
        synchronized (object) {
            displayName = this.myState.names.get(path);
        }
        if (StringUtil.isEmptyOrSpaces((String)displayName)) {
            displayName = duplicates.contains(path) ? path : projectName;
        }
        ReopenProjectAction reopenProjectAction = new ReopenProjectAction(path, projectName, displayName);
        if (reopenProjectAction == null) {
            RecentProjectsManagerBase.$$$reportNull$$$0(19);
        }
        return reopenProjectAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markPathRecent(@NotNull @SystemIndependent String path, @NotNull Project project) {
        if (path == null) {
            RecentProjectsManagerBase.$$$reportNull$$$0(20);
        }
        if (project == null) {
            RecentProjectsManagerBase.$$$reportNull$$$0(21);
        }
        Object object = this.myStateLock;
        synchronized (object) {
            if (path.endsWith(File.separator)) {
                path = path.substring(0, path.length() - File.separator.length());
            }
            this.myState.lastPath = path;
            ProjectGroup group = this.getProjectGroup(path);
            this.removePath(path);
            this.myState.recentPaths.add(0, path);
            if (group != null) {
                List projects = group.getProjects();
                projects.add(0, path);
                group.save(projects);
            }
            this.myState.additionalInfo.remove(path);
            String additionalMetadata = this.getRecentProjectMetadata(path, project);
            this.myState.additionalInfo.put(path, RecentProjectMetaInfo.create(additionalMetadata));
        }
        this.myModCounter.incrementAndGet();
    }

    @Nullable
    protected String getRecentProjectMetadata(@SystemIndependent String path, @NotNull Project project) {
        if (project == null) {
            RecentProjectsManagerBase.$$$reportNull$$$0(22);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private ProjectGroup getProjectGroup(@NotNull @SystemIndependent String path) {
        if (path == null) {
            RecentProjectsManagerBase.$$$reportNull$$$0(23);
        }
        Object object = this.myStateLock;
        synchronized (object) {
            for (ProjectGroup group : this.myState.groups) {
                if (!group.getProjects().contains(path)) continue;
                return group;
            }
        }
        return null;
    }

    @Nullable
    protected @SystemIndependent String getProjectPath(@NotNull Project project) {
        if (project == null) {
            RecentProjectsManagerBase.$$$reportNull$$$0(24);
        }
        return PathUtil.toSystemIndependentName((String)project.getPresentableUrl());
    }

    @Nullable
    public Project doOpenProject(@NotNull @SystemIndependent String projectPath, Project projectToClose, boolean forceOpenInNewFrame) {
        VirtualFile dotIdea;
        if (projectPath == null) {
            RecentProjectsManagerBase.$$$reportNull$$$0(25);
        }
        if ((dotIdea = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(projectPath, ".idea"))) != null) {
            EnumSet<PlatformProjectOpenProcessor.Option> options = EnumSet.of(PlatformProjectOpenProcessor.Option.REOPEN);
            if (forceOpenInNewFrame) {
                options.add(PlatformProjectOpenProcessor.Option.FORCE_NEW_FRAME);
            }
            return PlatformProjectOpenProcessor.doOpenProject(dotIdea.getParent(), projectToClose, -1, null, options);
        }
        return ProjectUtil.openOrImport(projectPath, projectToClose, forceOpenInNewFrame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public String getProjectName(@NotNull @SystemIndependent String path) {
        String cached;
        if (path == null) {
            RecentProjectsManagerBase.$$$reportNull$$$0(26);
        }
        if ((cached = this.myNameCache.get(path)) != null) {
            String string = cached;
            if (string == null) {
                RecentProjectsManagerBase.$$$reportNull$$$0(27);
            }
            return string;
        }
        this.myNamesResolver.cancel();
        Set<String> set2 = this.myNamesToResolve;
        synchronized (set2) {
            this.myNamesToResolve.add(path);
        }
        this.myNamesResolver.request();
        String name = PathUtilRt.getFileName((String)path);
        String string = path.endsWith(".ipr") ? FileUtilRt.getNameWithoutExtension((String)name) : name;
        if (string == null) {
            RecentProjectsManagerBase.$$$reportNull$$$0(28);
        }
        return string;
    }

    private static String readProjectName(@NotNull String path) {
        Path file2;
        if (path == null) {
            RecentProjectsManagerBase.$$$reportNull$$$0(29);
        }
        if (!Files.isDirectory(file2 = Paths.get(path, new String[0]), new LinkOption[0])) {
            return FileUtilRt.getNameWithoutExtension((String)file2.getFileName().toString());
        }
        Path nameFile = file2.resolve(".idea").resolve(".name");
        try {
            String result2 = StorageUtilKt.readProjectNameFile(nameFile);
            if (result2 != null) {
                return result2;
            }
        }
        catch (NoSuchFileException noSuchFileException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return file2.getFileName().toString();
    }

    protected boolean willReopenProjectOnStart() {
        return GeneralSettings.getInstance().isReopenLastProject() && this.getLastProjectPath() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doReopenLastProject() {
        Set openPaths;
        GeneralSettings generalSettings = GeneralSettings.getInstance();
        if (!generalSettings.isReopenLastProject()) {
            return;
        }
        boolean forceNewFrame = true;
        Iterator iterator = this.myStateLock;
        synchronized (iterator) {
            openPaths = ContainerUtil.newLinkedHashSet(this.myState.openPaths);
            if (openPaths.isEmpty()) {
                openPaths = ContainerUtil.createMaybeSingletonSet((Object)this.myState.lastPath);
                forceNewFrame = false;
            }
        }
        try {
            this.myBatchOpening = true;
            for (String openPath : openPaths) {
                if (!ProjectKt.isValidProjectPath(openPath, true)) continue;
                this.doOpenProject(openPath, null, forceNewFrame);
            }
        }
        finally {
            this.myBatchOpening = false;
        }
    }

    public boolean isBatchOpening() {
        return this.myBatchOpening;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public List<ProjectGroup> getGroups() {
        Object object = this.myStateLock;
        // MONITORENTER : object
        List<ProjectGroup> list2 = Collections.unmodifiableList(this.myState.groups);
        // MONITOREXIT : object
        if (list2 != null) return list2;
        RecentProjectsManagerBase.$$$reportNull$$$0(30);
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGroup(@NotNull ProjectGroup group) {
        if (group == null) {
            RecentProjectsManagerBase.$$$reportNull$$$0(31);
        }
        Object object = this.myStateLock;
        synchronized (object) {
            if (!this.myState.groups.contains(group)) {
                this.myState.groups.add(group);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGroup(@NotNull ProjectGroup group) {
        if (group == null) {
            RecentProjectsManagerBase.$$$reportNull$$$0(32);
        }
        Object object = this.myStateLock;
        synchronized (object) {
            this.myState.groups.remove(group);
        }
    }

    public long getModificationCount() {
        return this.myModCounter.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 8: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 27: 
            case 28: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 8: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 27: 
            case 28: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageBus";
                break;
            }
            case 1: 
            case 8: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 27: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/RecentProjectsManagerBase";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 17: 
            case 20: 
            case 23: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "openProjects";
                break;
            }
            case 7: 
            case 21: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "openedPaths";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recentPaths";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "duplicates";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/RecentProjectsManagerBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getStateInner";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectDisplayName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDuplicateProjectNames";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecentProjectsActions";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createOpenAction";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectName";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroups";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 8: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 27: 
            case 28: 
            case 30: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeDuplicates";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removePathFrom";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateOpenProjectsTimestamps";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getProjectDisplayName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getProjectIcon";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getProjectOrAppIcon";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getDuplicateProjectNames";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createOpenAction";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "markPathRecent";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getRecentProjectMetadata";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getProjectGroup";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getProjectPath";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "doOpenProject";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getProjectName";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "readProjectName";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "addGroup";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "removeGroup";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 8: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 27: 
            case 28: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class RecentProjectMetaInfo {
        public String build;
        public String productionCode;
        public boolean eap;
        public String binFolder;
        public long projectOpenTimestamp;
        public long buildTimestamp;
        public String metadata;

        public static RecentProjectMetaInfo create(String metadata) {
            RecentProjectMetaInfo info = new RecentProjectMetaInfo();
            info.build = ApplicationInfoEx.getInstanceEx().getBuild().asString();
            info.productionCode = ApplicationInfoEx.getInstanceEx().getBuild().getProductCode();
            info.eap = ApplicationInfoEx.getInstanceEx().isEAP();
            info.binFolder = PathUtil.toSystemIndependentName((String)PathManager.getBinPath());
            info.projectOpenTimestamp = System.currentTimeMillis();
            info.buildTimestamp = ApplicationInfoEx.getInstanceEx().getBuildDate().getTimeInMillis();
            info.metadata = metadata;
            return info;
        }
    }

    private final class MyAppLifecycleListener
    implements AppLifecycleListener {
        private MyAppLifecycleListener() {
        }

        @Override
        public void appFrameCreated(String[] commandLineArgs, @NotNull Ref<Boolean> willOpenProject) {
            if (willOpenProject == null) {
                MyAppLifecycleListener.$$$reportNull$$$0(0);
            }
            if (RecentProjectsManagerBase.this.willReopenProjectOnStart()) {
                willOpenProject.set((Object)Boolean.TRUE);
            }
        }

        @Override
        public void appStarting(Project projectFromCommandLine) {
            if (projectFromCommandLine != null || JetBrainsProtocolHandler.appStartedWithCommand()) {
                return;
            }
            RecentProjectsManagerBase.this.doReopenLastProject();
        }

        @Override
        public void projectOpenFailed() {
            RecentProjectsManagerBase.this.updateLastProjectPath();
        }

        @Override
        public void projectFrameClosed() {
            RecentProjectsManagerBase.this.updateLastProjectPath();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "willOpenProject", "com/intellij/ide/RecentProjectsManagerBase$MyAppLifecycleListener", "appFrameCreated"));
        }
    }

    private class MyProjectListener
    implements ProjectManagerListener {
        private MyProjectListener() {
        }

        public void projectOpened(@NotNull Project project) {
            String path;
            if (project == null) {
                MyProjectListener.$$$reportNull$$$0(0);
            }
            if ((path = RecentProjectsManagerBase.this.getProjectPath(project)) != null) {
                RecentProjectsManagerBase.this.markPathRecent(path, project);
            }
            RecentProjectsManagerBase.this.updateLastProjectPath();
            this.updateSystemDockMenu();
        }

        private void updateSystemDockMenu() {
            if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
                SystemDock.updateMenu();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void projectClosing(@NotNull Project project) {
            String path;
            if (project == null) {
                MyProjectListener.$$$reportNull$$$0(1);
            }
            if ((path = RecentProjectsManagerBase.this.getProjectPath(project)) == null) {
                return;
            }
            Object object = RecentProjectsManagerBase.this.myStateLock;
            synchronized (object) {
                ((RecentProjectsManagerBase)RecentProjectsManagerBase.this).myState.names.put(path, RecentProjectsManagerBase.this.getProjectDisplayName(project));
                RecentProjectsManagerBase.this.myNameCache.put(path, project.getName());
            }
        }

        public void projectClosed(@NotNull Project project) {
            Project openProject;
            String path;
            Project[] openProjects;
            if (project == null) {
                MyProjectListener.$$$reportNull$$$0(2);
            }
            if ((openProjects = ProjectManager.getInstance().getOpenProjects()).length > 0 && (path = RecentProjectsManagerBase.this.getProjectPath(openProject = openProjects[openProjects.length - 1])) != null) {
                RecentProjectsManagerBase.this.markPathRecent(path, openProject);
            }
            this.updateSystemDockMenu();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "project";
            objectArray2[1] = "com/intellij/ide/RecentProjectsManagerBase$MyProjectListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "projectOpened";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "projectClosing";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "projectClosed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class State {
        public final List<String> recentPaths = new SmartList();
        public final List<String> openPaths = new SmartList();
        public final Map<String, String> names = new LinkedHashMap<String, String>();
        public final List<ProjectGroup> groups = new SmartList();
        public String lastPath;
        public String pid;
        public final Map<String, RecentProjectMetaInfo> additionalInfo = new LinkedHashMap<String, RecentProjectMetaInfo>();
        public String lastProjectLocation;

        private void validateRecentProjects(@NotNull AtomicLong modCounter) {
            if (modCounter == null) {
                State.$$$reportNull$$$0(0);
            }
            while (this.recentPaths.remove(null)) {
                modCounter.incrementAndGet();
            }
            Collection<String> displayNames = this.names.values();
            while (displayNames.remove("")) {
                modCounter.incrementAndGet();
            }
            while (this.recentPaths.size() > Registry.intValue((String)"ide.max.recent.projects")) {
                int index = this.recentPaths.size() - 1;
                this.names.remove(this.recentPaths.get(index));
                this.recentPaths.remove(index);
                modCounter.incrementAndGet();
            }
        }

        private void makePathsSystemIndependent() {
            ApplicationInfo appInfo = ApplicationInfo.getInstance();
            String version2 = appInfo.getMajorVersion() + "." + appInfo.getMinorVersion();
            PathMacroManager pathMacroManager = PathMacroManager.getInstance((ComponentManager)ApplicationManager.getApplication());
            Function<String, String> convert = depPath -> {
                String migrated;
                String result2 = PathUtil.toSystemIndependentName((String)depPath);
                if (!result2.startsWith("$APP") && result2.contains("2017.1") && pathMacroManager.collapsePath(migrated = result2.replace("2017.1", version2)).startsWith("$APP")) {
                    return migrated;
                }
                return result2;
            };
            Consumer<List> convertList = o -> {
                ListIterator it = o.listIterator();
                while (it.hasNext()) {
                    it.set(convert.apply((String)it.next()));
                }
            };
            convertList.accept(this.recentPaths);
            convertList.accept(this.openPaths);
            LinkedHashMap<String, String> namesCopy = new LinkedHashMap<String, String>(this.names);
            this.names.clear();
            for (Map.Entry entry : namesCopy.entrySet()) {
                this.names.put(convert.apply((String)entry.getKey()), (String)entry.getValue());
            }
            for (ProjectGroup group : this.groups) {
                ArrayList paths = new ArrayList(group.getProjects());
                convertList.accept(paths);
                group.save(paths);
            }
            if (this.lastPath != null) {
                this.lastPath = convert.apply(this.lastPath);
            }
            LinkedHashMap<String, RecentProjectMetaInfo> additionalInfoCopy = new LinkedHashMap<String, RecentProjectMetaInfo>(this.additionalInfo);
            this.additionalInfo.clear();
            for (Map.Entry entry : additionalInfoCopy.entrySet()) {
                ((RecentProjectMetaInfo)entry.getValue()).binFolder = convert.apply(((RecentProjectMetaInfo)entry.getValue()).binFolder);
                this.additionalInfo.put(convert.apply((String)entry.getKey()), (RecentProjectMetaInfo)entry.getValue());
            }
            if (this.lastProjectLocation != null) {
                this.lastProjectLocation = convert.apply(this.lastProjectLocation);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modCounter", "com/intellij/ide/RecentProjectsManagerBase$State", "validateRecentProjects"));
        }
    }
}

