/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.apple.eawt.Application;
import com.intellij.ide.DataManager;
import com.intellij.ide.actions.AboutAction;
import com.intellij.ide.actions.OpenFileAction;
import com.intellij.ide.actions.ShowSettingsAction;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.idea.IdeaApplication;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.impl.IdeKeyEventDispatcher;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.platform.CommandLineProjectOpenProcessor;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.ui.mac.touchbar.TouchBarsManager;
import com.sun.jna.Callback;
import com.sun.jna.Pointer;
import java.awt.Component;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MacOSApplicationProvider {
    private static final Logger LOG = Logger.getInstance(MacOSApplicationProvider.class);
    private static final AtomicBoolean ENABLED = new AtomicBoolean(true);
    private static final Callback IMPL = new Callback(){

        public void callback(ID self, String selector) {
            SwingUtilities.invokeLater(() -> {
                ActionManagerEx am = ActionManagerEx.getInstanceEx();
                MouseEvent me = new MouseEvent(JOptionPane.getRootFrame(), 500, System.currentTimeMillis(), 0, 0, 0, 1, false);
                am.tryToExecute(am.getAction("CheckForUpdate"), (InputEvent)me, null, null, false);
            });
        }
    };
    private static final String GENERIC_RGB_PROFILE_PATH = "/System/Library/ColorSync/Profiles/Generic RGB Profile.icc";
    private final ColorSpace genericRgbColorSpace;

    public static MacOSApplicationProvider getInstance() {
        return (MacOSApplicationProvider)ApplicationManager.getApplication().getComponent(MacOSApplicationProvider.class);
    }

    public MacOSApplicationProvider() {
        if (SystemInfo.isMac) {
            try {
                Worker.initMacApplication();
            }
            catch (Throwable t) {
                LOG.warn(t);
            }
            this.genericRgbColorSpace = MacOSApplicationProvider.initializeNativeColorSpace();
        } else {
            this.genericRgbColorSpace = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ColorSpace initializeNativeColorSpace() {
        try (FileInputStream is = new FileInputStream(GENERIC_RGB_PROFILE_PATH);){
            ICC_Profile profile2 = ICC_Profile.getInstance(is);
            ICC_ColorSpace iCC_ColorSpace = new ICC_ColorSpace(profile2);
            return iCC_ColorSpace;
        }
        catch (Throwable e) {
            LOG.warn("Couldn't load generic RGB color profile", e);
            return null;
        }
    }

    @Nullable
    public ColorSpace getGenericRgbColorSpace() {
        return this.genericRgbColorSpace;
    }

    public static boolean tryOpenFileList(Project project, List<? extends File> list2, String location) {
        for (File file2 : list2) {
            if (ProjectUtil.openOrImport(file2.getAbsolutePath(), project, true) == null) continue;
            LOG.debug(location + ": load project from ", new Object[]{file2});
            IdeaApplication.getInstance().disableProjectLoad();
            return true;
        }
        boolean result2 = false;
        for (File file3 : list2) {
            VirtualFile virtualFile;
            if (!file3.exists()) continue;
            LOG.debug(location + ": open file ", new Object[]{file3});
            String path = file3.getAbsolutePath();
            if (project != null) {
                OpenFileAction.openFile(path, project);
                result2 = true;
                continue;
            }
            CommandLineProjectOpenProcessor processor2 = CommandLineProjectOpenProcessor.getInstanceIfExists();
            if (processor2 == null || (virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(path)) == null || !virtualFile.isValid()) continue;
            result2 |= processor2.openProjectAndFile(virtualFile, -1, false) != null;
        }
        return result2;
    }

    private static class Worker {
        private Worker() {
        }

        public static void initMacApplication() {
            Application application = Application.getApplication();
            application.setAboutHandler(event -> AboutAction.perform(Worker.getProject(false)));
            application.setPreferencesHandler(event -> {
                Project project = Worker.getProject(true);
                Worker.submit("Preferences", () -> ShowSettingsAction.perform(project));
            });
            application.setQuitHandler((event, response) -> {
                Worker.submit("Quit", () -> ApplicationManager.getApplication().exit());
                response.cancelQuit();
            });
            application.setOpenFileHandler(event -> {
                Project project = Worker.getProject(false);
                List list2 = event.getFiles();
                if (list2.isEmpty()) {
                    return;
                }
                Worker.submit("OpenFile", () -> MacOSApplicationProvider.tryOpenFileList(project, list2, "MacMenu"));
            });
            Worker.installAutoUpdateMenu();
            TouchBarsManager.onApplicationInitialized();
        }

        private static void installAutoUpdateMenu() {
            ID pool = Foundation.invoke((String)"NSAutoreleasePool", (String)"new", (Object[])new Object[0]);
            ID app = Foundation.invoke((String)"NSApplication", (String)"sharedApplication", (Object[])new Object[0]);
            ID menu = Foundation.invoke((ID)app, (Pointer)Foundation.createSelector((String)"menu"), (Object[])new Object[0]);
            ID item = Foundation.invoke((ID)menu, (Pointer)Foundation.createSelector((String)"itemAtIndex:"), (Object[])new Object[]{0});
            ID appMenu = Foundation.invoke((ID)item, (Pointer)Foundation.createSelector((String)"submenu"), (Object[])new Object[0]);
            ID checkForUpdatesClass = Foundation.allocateObjcClassPair((ID)Foundation.getObjcClass((String)"NSMenuItem"), (String)"NSCheckForUpdates");
            Foundation.addMethod((ID)checkForUpdatesClass, (Pointer)Foundation.createSelector((String)"checkForUpdates"), (Callback)IMPL, (String)"v");
            Foundation.registerObjcClassPair((ID)checkForUpdatesClass);
            ID checkForUpdates2 = Foundation.invoke((String)"NSCheckForUpdates", (String)"alloc", (Object[])new Object[0]);
            Foundation.invoke((ID)checkForUpdates2, (Pointer)Foundation.createSelector((String)"initWithTitle:action:keyEquivalent:"), (Object[])new Object[]{Foundation.nsString((String)"Check for Updates..."), Foundation.createSelector((String)"checkForUpdates"), Foundation.nsString((String)"")});
            Foundation.invoke((ID)checkForUpdates2, (Pointer)Foundation.createSelector((String)"setTarget:"), (Object[])new Object[]{checkForUpdates2});
            Foundation.invoke((ID)appMenu, (Pointer)Foundation.createSelector((String)"insertItem:atIndex:"), (Object[])new Object[]{checkForUpdates2, 1});
            Foundation.invoke((ID)checkForUpdates2, (Pointer)Foundation.createSelector((String)"release"), (Object[])new Object[0]);
            Foundation.invoke((ID)pool, (Pointer)Foundation.createSelector((String)"release"), (Object[])new Object[0]);
        }

        private static Project getProject(boolean useDefault) {
            Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext());
            if (project == null) {
                LOG.debug("MacMenu: no project in data context");
                Project[] projects = ProjectManager.getInstance().getOpenProjects();
                Project project2 = project = projects.length > 0 ? projects[0] : null;
                if (project == null && useDefault) {
                    LOG.debug("MacMenu: use default project instead");
                    project = ProjectManager.getInstance().getDefaultProject();
                }
            }
            LOG.debug("MacMenu: project = ", new Object[]{project});
            return project;
        }

        private static void submit(@NotNull String name, @NotNull Runnable task2) {
            if (name == null) {
                Worker.$$$reportNull$$$0(0);
            }
            if (task2 == null) {
                Worker.$$$reportNull$$$0(1);
            }
            LOG.debug("MacMenu: on EDT = ", new Object[]{SwingUtilities.isEventDispatchThread(), "; ENABLED = ", ENABLED.get()});
            if (!ENABLED.get()) {
                LOG.debug("MacMenu: disabled");
            } else {
                Component component = IdeFocusManager.getGlobalInstance().getFocusOwner();
                if (component != null && IdeKeyEventDispatcher.isModalContext(component)) {
                    LOG.debug("MacMenu: component in modal context");
                } else {
                    ENABLED.set(false);
                    TransactionGuard.submitTransaction((Disposable)ApplicationManager.getApplication(), () -> {
                        try {
                            LOG.debug("MacMenu: init ", new Object[]{name});
                            task2.run();
                        }
                        catch (Throwable throwable) {
                            LOG.debug("MacMenu: done ", new Object[]{name});
                            ENABLED.set(true);
                            throw throwable;
                        }
                        LOG.debug("MacMenu: done ", new Object[]{name});
                        ENABLED.set(true);
                    });
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "task";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ide/MacOSApplicationProvider$Worker";
            objectArray[2] = "submit";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

