/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.history.actions;

import com.intellij.execution.TestStateStorage;
import com.intellij.execution.testframework.sm.TestHistoryConfiguration;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.sm.runner.history.actions.ImportTestsFromFileAction;
import com.intellij.execution.testframework.sm.runner.history.actions.ImportTestsFromHistoryAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportTestsGroup
extends ActionGroup {
    private SMTRunnerConsoleProperties myProperties;

    public ImportTestsGroup() {
        super("Import Test Results", "Import Test Results", AllIcons.Vcs.History);
        this.setPopup(true);
    }

    public ImportTestsGroup(SMTRunnerConsoleProperties properties) {
        this();
        this.myProperties = properties;
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        if (e == null) {
            if (EMPTY_ARRAY == null) {
                ImportTestsGroup.$$$reportNull$$$0(0);
            }
            return EMPTY_ARRAY;
        }
        Project project = e.getProject();
        if (project == null) {
            if (EMPTY_ARRAY == null) {
                ImportTestsGroup.$$$reportNull$$$0(1);
            }
            return EMPTY_ARRAY;
        }
        Collection<String> filePaths = TestHistoryConfiguration.getInstance(project).getFiles();
        File testHistoryRoot = TestStateStorage.getTestHistoryRoot(project);
        List fileNames = filePaths.stream().map(fileName2 -> new File(testHistoryRoot, (String)fileName2)).filter(file2 -> file2.exists()).sorted((f1, f2) -> Long.compare(f2.lastModified(), f1.lastModified())).collect(Collectors.toList());
        int historySize = fileNames.size();
        AnAction[] actions = new AnAction[historySize + 2];
        for (int i = 0; i < historySize; ++i) {
            actions[i] = new ImportTestsFromHistoryAction(this.myProperties, project, ((File)fileNames.get(i)).getName());
        }
        actions[historySize] = Separator.getInstance();
        actions[historySize + 1] = new ImportTestsFromFileAction(this.myProperties);
        if (actions == null) {
            ImportTestsGroup.$$$reportNull$$$0(2);
        }
        return actions;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/sm/runner/history/actions/ImportTestsGroup", "getChildren"));
    }
}

