/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.services;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.dashboard.RunDashboardRunConfigurationStatus;
import com.intellij.execution.dashboard.tree.RunDashboardGrouper;
import com.intellij.execution.dashboard.tree.RunDashboardStatusFilter;
import com.intellij.execution.dashboard.tree.RunDashboardTreeMouseListener;
import com.intellij.execution.services.ServiceViewContributor;
import com.intellij.execution.services.ServiceViewManager;
import com.intellij.execution.services.ServiceViewManagerImpl;
import com.intellij.execution.services.ServiceViewState;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.ide.util.treeView.smartTree.ActionPresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CheckedActionGroup;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.LoadingNode;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.BaseTreeModel;
import com.intellij.ui.tree.Searchable;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.Invoker;
import com.intellij.util.concurrency.InvokerSupplier;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeModelAdapter;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

class ServiceView
extends JPanel
implements Disposable {
    private static final ExtensionPointName<ServiceViewContributor> EP_NAME = ExtensionPointName.create((String)"com.intellij.serviceViewContributor");
    @NonNls
    private static final String SERVICE_VIEW_NODE_TOOLBAR = "ServiceViewNodeToolbar";
    @NonNls
    private static final String SERVICE_VIEW_NODE_POPUP = "ServiceViewNodePopup";
    @NonNls
    private static final String SERVICE_VIEW_TREE_TOOLBAR = "ServiceViewTreeToolbar";
    private final Splitter mySplitter;
    private final JPanel myTreePanel;
    private final Tree myTree;
    private final JPanel myDetailsPanel;
    private final JBPanelWithEmptyText myMessagePanel;
    private final JComponent myToolbar;
    private final Map<Object, ServiceViewContributor.ViewDescriptor> myViewDescriptors;
    private final Map<Object, ServiceViewContributor> myContributors;
    private final Map<ServiceViewContributor, ServiceViewContributor.ViewDescriptorRenderer> myRenderers;
    private final Map<Object, ServiceViewContributor.SubtreeDescriptor> mySubtrees;
    private final Set<JComponent> myDetailsComponents;
    private final MyTreeModel myTreeModel;
    private final AsyncTreeModel myAsyncTreeModel;
    private Object myLastSelection;
    private final RunDashboardStatusFilter myStatusFilter;
    @NotNull
    private final Project myProject;
    @NotNull
    private final ServiceViewState myState;
    private final RecursionGuard myGuard;

    ServiceView(@NotNull Project project, @NotNull ServiceViewState state) {
        if (project == null) {
            ServiceView.$$$reportNull$$$0(0);
        }
        if (state == null) {
            ServiceView.$$$reportNull$$$0(1);
        }
        super(new BorderLayout());
        this.myViewDescriptors = new HashMap<Object, ServiceViewContributor.ViewDescriptor>();
        this.myContributors = new HashMap<Object, ServiceViewContributor>();
        this.myRenderers = new HashMap<ServiceViewContributor, ServiceViewContributor.ViewDescriptorRenderer>();
        this.mySubtrees = new HashMap<Object, ServiceViewContributor.SubtreeDescriptor>();
        this.myDetailsComponents = ContainerUtil.createWeakSet();
        this.myStatusFilter = new RunDashboardStatusFilter();
        this.myGuard = RecursionManager.createGuard((String)"ServiceView.getData");
        this.myProject = project;
        this.myState = state;
        this.myTree = new Tree();
        this.myTreeModel = new MyTreeModel();
        this.myAsyncTreeModel = new AsyncTreeModel((TreeModel)((Object)this.myTreeModel), this);
        this.myTree.setModel((TreeModel)((Object)this.myAsyncTreeModel));
        this.initTree();
        this.mySplitter = new OnePixelSplitter(false, this.myState.contentProportion);
        this.myTreePanel = new JPanel(new BorderLayout());
        this.myTreePanel.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myTree, (int)1), "Center");
        this.mySplitter.setFirstComponent((JComponent)this.myTreePanel);
        this.myDetailsPanel = new JPanel(new BorderLayout());
        this.myMessagePanel = new JBPanelWithEmptyText().withEmptyText("Select service in tree to view details");
        this.myDetailsPanel.add((Component)this.myMessagePanel, "Center");
        this.mySplitter.setSecondComponent((JComponent)this.myDetailsPanel);
        this.add((Component)this.mySplitter, "Center");
        this.myToolbar = this.createToolbar();
        this.add((Component)this.myToolbar, "West");
        JComponent treeToolbar = this.createTreeToolBar();
        this.myTreePanel.add((Component)treeToolbar, "North");
        this.putClientProperty("DataProvider", dataId -> {
            DataProvider dataProvider;
            if (PlatformDataKeys.HELP_ID.is(dataId)) {
                return ServiceViewManagerImpl.getToolWindowContextHelpId();
            }
            if (PlatformDataKeys.SELECTED_ITEMS.is(dataId)) {
                return TreeUtil.collectSelectedUserObjects((JTree)this.myTree).toArray();
            }
            ServiceViewContributor.ViewDescriptor descriptor = this.getSelectedDescriptor();
            DataProvider dataProvider2 = dataProvider = descriptor == null ? null : descriptor.getDataProvider();
            if (dataProvider != null) {
                return this.myGuard.doPreventingRecursion((Object)this, false, () -> dataProvider.getData(dataId));
            }
            return null;
        });
        UIUtil.putClientProperty((JComponent)this, (Key)UIUtil.NOT_IN_HIERARCHY_COMPONENTS, () -> JBIterable.from(this.myDetailsComponents).filter(component -> this.myDetailsPanel != component.getParent()).iterator());
        this.myProject.getMessageBus().connect((Disposable)this).subscribe(ServiceViewContributor.TOPIC, this.myTreeModel::refresh);
    }

    @Nullable
    private ServiceViewContributor.ViewDescriptor getSelectedDescriptor() {
        return this.myViewDescriptors.get(this.getSelectedObject());
    }

    @Nullable
    private Object getSelectedObject() {
        TreePath path = this.myTree.getSelectionPath();
        return TreeUtil.getLastUserObject((TreePath)path);
    }

    private void initTree() {
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        this.myTree.setLineStyleAngled();
        this.myTree.setCellRenderer((TreeCellRenderer)new MyTreeCellRenderer());
        UIUtil.putClientProperty((JComponent)this.myTree, (Key)AnimatedIcon.ANIMATION_IN_RENDERER_ALLOWED, (Object)true);
        UIUtil.putClientProperty((JComponent)this.myTree, (Key)ServiceViewManager.SERVICE_VIEW_MASTER_COMPONENT, (Object)Boolean.TRUE);
        this.myTree.addTreeSelectionListener(e -> this.onSelectionChanged());
        new TreeSpeedSearch(this.myTree, TreeSpeedSearch.NODE_DESCRIPTOR_TOSTRING, true);
        RunDashboardTreeMouseListener mouseListener = new RunDashboardTreeMouseListener(this.myTree);
        mouseListener.installOn((Component)this.myTree);
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent event) {
                if (ServiceView.this.myLastSelection != null && ServiceView.this.myTreeModel.isLeaf(ServiceView.this.myLastSelection)) {
                    return ((ServiceViewContributor.ViewDescriptor)ServiceView.this.myViewDescriptors.get(ServiceView.this.myLastSelection)).handleDoubleClick(event);
                }
                return false;
            }
        }.installOn((Component)this.myTree);
        ActionGroup actions = (ActionGroup)ActionManager.getInstance().getAction(SERVICE_VIEW_NODE_POPUP);
        PopupHandler.installPopupHandler((JComponent)this.myTree, (ActionGroup)actions, (String)"ServicesPopup", (ActionManager)ActionManager.getInstance());
        this.myTreeModel.refreshAll();
        this.myState.treeState.applyTo((JTree)this.myTree, this.myTreeModel.getRoot());
    }

    private void setTreeVisible(boolean visible) {
        this.myTreePanel.setVisible(visible);
        this.myToolbar.setBorder(visible ? null : IdeBorderFactory.createBorder((int)4));
    }

    private void onSelectionChanged() {
        JComponent newDetails;
        ServiceViewContributor.ViewDescriptor newDescriptor;
        ServiceViewContributor.ViewDescriptor oldDescriptor;
        List selected = TreeUtil.collectSelectedUserObjects((JTree)this.myTree);
        Object newSelection = ContainerUtil.getOnlyItem((Collection)selected);
        if (Comparing.equal((Object)newSelection, (Object)this.myLastSelection)) {
            return;
        }
        ServiceViewContributor.ViewDescriptor viewDescriptor = oldDescriptor = this.myLastSelection == null ? null : this.myViewDescriptors.get(this.myLastSelection);
        if (oldDescriptor != null) {
            oldDescriptor.onNodeUnselected();
        }
        this.myLastSelection = newSelection;
        ServiceViewContributor.ViewDescriptor viewDescriptor2 = newDescriptor = newSelection == null ? null : this.myViewDescriptors.get(newSelection);
        if (newDescriptor != null) {
            newDescriptor.onNodeSelected();
        }
        JComponent component = newDescriptor == null ? null : newDescriptor.getContentComponent();
        JComponent jComponent = newDetails = component == null ? this.myMessagePanel : component;
        if (newDetails.getParent() == this.myDetailsPanel) {
            return;
        }
        this.myDetailsComponents.add(newDetails);
        this.myDetailsPanel.removeAll();
        this.myDetailsPanel.add((Component)newDetails, "Center");
        this.myDetailsPanel.revalidate();
        this.myDetailsPanel.repaint();
    }

    private JComponent createToolbar() {
        ActionGroup actions = (ActionGroup)ActionManager.getInstance().getAction(SERVICE_VIEW_NODE_TOOLBAR);
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("ServicesToolbar", actions, false);
        toolbar.setTargetComponent((JComponent)this);
        return toolbar.getComponent();
    }

    private JComponent createTreeToolBar() {
        JPanel toolBarPanel = new JPanel(new BorderLayout());
        toolBarPanel.setBorder(IdeBorderFactory.createBorder((int)9));
        DefaultActionGroup treeGroup = new DefaultActionGroup();
        MyTreeExpander treeExpander = new MyTreeExpander();
        AnAction expandAllAction = CommonActionsManager.getInstance().createExpandAllAction((TreeExpander)treeExpander, (JComponent)this);
        treeGroup.add(expandAllAction);
        AnAction collapseAllAction = CommonActionsManager.getInstance().createCollapseAllAction((TreeExpander)treeExpander, (JComponent)this);
        treeGroup.add(collapseAllAction);
        treeGroup.addSeparator();
        treeGroup.add((AnAction)new StatusActionGroup());
        treeGroup.addSeparator();
        AnAction treeActions = ActionManager.getInstance().getAction(SERVICE_VIEW_TREE_TOOLBAR);
        treeActions.registerCustomShortcutSet((JComponent)this, null);
        treeGroup.add(treeActions);
        ActionToolbar treeActionsToolBar = ActionManager.getInstance().createActionToolbar("ServicesToolbar", (ActionGroup)treeGroup, true);
        toolBarPanel.add((Component)treeActionsToolBar.getComponent(), "Center");
        treeActionsToolBar.setTargetComponent((JComponent)this.myTree);
        return toolBarPanel;
    }

    public void dispose() {
    }

    void updateContent(boolean withStructure) {
        this.myTreeModel.refreshAll();
    }

    void selectNode(Object node) {
        TreeUtil.select((JTree)this.myTree, (TreeVisitor)new NodeSelectionVisitor(node), path -> {});
    }

    ServiceViewState getState() {
        this.myState.contentProportion = this.mySplitter.getProportion();
        this.myState.treeState = TreeState.createOn((JTree)this.myTree);
        return this.myState;
    }

    @NotNull
    private static AnAction[] doGetActions(@Nullable AnActionEvent e, boolean toolbar) {
        if (e == null) {
            if (AnAction.EMPTY_ARRAY == null) {
                ServiceView.$$$reportNull$$$0(2);
            }
            return AnAction.EMPTY_ARRAY;
        }
        Project project = e.getProject();
        if (project == null) {
            if (AnAction.EMPTY_ARRAY == null) {
                ServiceView.$$$reportNull$$$0(3);
            }
            return AnAction.EMPTY_ARRAY;
        }
        ServiceView serviceView = ServiceViewManagerImpl.getServiceView(project);
        if (serviceView == null || serviceView.myLastSelection == null) {
            if (AnAction.EMPTY_ARRAY == null) {
                ServiceView.$$$reportNull$$$0(4);
            }
            return AnAction.EMPTY_ARRAY;
        }
        ServiceViewContributor.ViewDescriptor descriptor = serviceView.myViewDescriptors.get(serviceView.myLastSelection);
        ActionGroup group = toolbar ? descriptor.getToolbarActions() : descriptor.getPopupActions();
        AnAction[] anActionArray = group == null ? AnAction.EMPTY_ARRAY : group.getChildren(e);
        if (anActionArray == null) {
            ServiceView.$$$reportNull$$$0(5);
        }
        return anActionArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/services/ServiceView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/services/ServiceView";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ItemPopupActionGroup
    extends ActionGroup {
        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            AnAction[] anActionArray = ServiceView.doGetActions(e, false);
            if (anActionArray == null) {
                ItemPopupActionGroup.$$$reportNull$$$0(0);
            }
            return anActionArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/services/ServiceView$ItemPopupActionGroup", "getChildren"));
        }
    }

    public static class ItemToolbarActionGroup
    extends ActionGroup {
        private static final AnAction[] FAKE_GROUP = new AnAction[]{new DumbAwareAction(null, null, EmptyIcon.ICON_16){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                e.getPresentation().setEnabled(false);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/execution/services/ServiceView$ItemToolbarActionGroup$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }};

        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            AnAction[] actions = ServiceView.doGetActions(e, true);
            AnAction[] anActionArray = actions.length != 0 ? actions : FAKE_GROUP;
            if (anActionArray == null) {
                ItemToolbarActionGroup.$$$reportNull$$$0(0);
            }
            return anActionArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/services/ServiceView$ItemToolbarActionGroup", "getChildren"));
        }
    }

    private static class NodeSelectionVisitor
    implements TreeVisitor {
        private final Object myNode;

        NodeSelectionVisitor(Object node) {
            this.myNode = node;
        }

        @NotNull
        public TreeVisitor.Action visit(@NotNull TreePath path) {
            if (path == null) {
                NodeSelectionVisitor.$$$reportNull$$$0(0);
            }
            if (path.getLastPathComponent().equals(this.myNode)) {
                TreeVisitor.Action action = TreeVisitor.Action.INTERRUPT;
                if (action == null) {
                    NodeSelectionVisitor.$$$reportNull$$$0(1);
                }
                return action;
            }
            TreeVisitor.Action action = TreeVisitor.Action.CONTINUE;
            if (action == null) {
                NodeSelectionVisitor.$$$reportNull$$$0(2);
            }
            return action;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/services/ServiceView$NodeSelectionVisitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/services/ServiceView$NodeSelectionVisitor";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "visit";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "visit";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class GroupNode {
        final TreePath path;
        final Set<Object> children = new LinkedHashSet<Object>();

        GroupNode(TreePath path) {
            this.path = path;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GroupNode node = (GroupNode)o;
            return Objects.equals(this.path, node.path);
        }

        public int hashCode() {
            return Objects.hash(this.path);
        }
    }

    private class MyTreeCellRenderer
    implements TreeCellRenderer {
        private final ColoredTreeCellRenderer myColoredRender = new NodeRenderer(){

            @Nullable
            protected ItemPresentation getPresentation(Object node) {
                return ((ServiceViewContributor.ViewDescriptor)ServiceView.this.myViewDescriptors.get(node)).getPresentation();
            }
        };
        private final ServiceViewContributor.ViewDescriptorRenderer myNodeRenderer = (parent, value, viewDescriptor, selected, hasFocus) -> this.myColoredRender.getTreeCellRendererComponent((JTree)parent, value, selected, true, true, 0, hasFocus);

        private MyTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
            Component component;
            if (value == ServiceView.this.myTreeModel.getRoot() || value instanceof LoadingNode) {
                return this.myColoredRender;
            }
            ServiceViewContributor.ViewDescriptor nodeDescriptor = (ServiceViewContributor.ViewDescriptor)ServiceView.this.myViewDescriptors.get(value);
            ServiceViewContributor contributor = (ServiceViewContributor)ServiceView.this.myContributors.get(value);
            if (!ServiceView.this.myRenderers.containsKey(contributor)) {
                ServiceView.this.myRenderers.put(contributor, contributor.getViewDescriptorRenderer());
            }
            ServiceViewContributor.ViewDescriptorRenderer renderer2 = (ServiceViewContributor.ViewDescriptorRenderer)ServiceView.this.myRenderers.get(contributor);
            Object renderedValue = value instanceof GroupNode ? ((GroupNode)value).path.getLastPathComponent() : value;
            Component component2 = component = renderer2 == null ? null : renderer2.getRendererComponent((JComponent)ServiceView.this.myTree, renderedValue, nodeDescriptor, selected, hasFocus);
            if (component == null) {
                component = this.myNodeRenderer.getRendererComponent((JComponent)ServiceView.this.myTree, value, nodeDescriptor, selected, hasFocus);
            }
            return component;
        }
    }

    private class MyTreeModel
    extends BaseTreeModel<Object>
    implements InvokerSupplier,
    Searchable {
        final Object myRoot = ObjectUtils.sentinel((String)"services root");
        final Invoker myInvoker = new Invoker.BackgroundThread((Disposable)this);

        private MyTreeModel() {
        }

        @Override
        @NotNull
        public Invoker getInvoker() {
            Invoker invoker = this.myInvoker;
            if (invoker == null) {
                MyTreeModel.$$$reportNull$$$0(0);
            }
            return invoker;
        }

        @Override
        @NotNull
        public Promise<TreePath> getTreePath(Object object) {
            Promise promise = Promises.resolvedPromise((Object)new TreePath(this.myRoot));
            if (promise == null) {
                MyTreeModel.$$$reportNull$$$0(1);
            }
            return promise;
        }

        @Override
        public boolean isLeaf(Object object) {
            return object != this.myRoot && !(object instanceof GroupNode) && ServiceView.this.mySubtrees.get(object) == null;
        }

        @Override
        public List<?> getChildren(Object parent) {
            if (parent == this.myRoot) {
                return this.getRootChildren();
            }
            if (parent instanceof GroupNode) {
                return new ArrayList<Object>(((GroupNode)parent).children);
            }
            ServiceViewContributor.SubtreeDescriptor subtree = (ServiceViewContributor.SubtreeDescriptor)ServiceView.this.mySubtrees.get(parent);
            if (subtree == null) {
                return Collections.emptyList();
            }
            SmartList result2 = new SmartList();
            for (Object item : subtree.getItems()) {
                if (item instanceof NodeDescriptor) {
                    ((NodeDescriptor)item).update();
                }
                ServiceView.this.myViewDescriptors.put(item, subtree.getItemDescriptor(item));
                ServiceView.this.mySubtrees.put(item, subtree.getNodeSubtree(item));
                ServiceView.this.myContributors.put(item, ServiceView.this.myContributors.get(parent));
                result2.add(item);
            }
            return result2;
        }

        @NotNull
        private List<?> getRootChildren() {
            LinkedHashSet rootChildren = new LinkedHashSet();
            Map groupNodes = FactoryMap.create(GroupNode::new);
            for (ServiceViewContributor contributor : (ServiceViewContributor[])EP_NAME.getExtensions()) {
                for (Object node : contributor.getNodes(ServiceView.this.myProject)) {
                    if (node instanceof NodeDescriptor) {
                        ((NodeDescriptor)node).update();
                    }
                    ServiceView.this.myViewDescriptors.put(node, contributor.getNodeDescriptor(node));
                    ServiceView.this.mySubtrees.put(node, contributor.getNodeSubtree(node));
                    ServiceView.this.myContributors.put(node, contributor);
                    List groups = contributor.getGroups(node);
                    Object child2 = node;
                    if (!groups.isEmpty()) {
                        TreePath path = new TreePath(groups.toArray()).pathByAddingChild(node);
                        while (path.getParentPath() != null) {
                            GroupNode groupNode = (GroupNode)groupNodes.get(path.getParentPath());
                            ServiceView.this.myViewDescriptors.put(groupNode, contributor.getGroupDescriptor(groupNode.path.getLastPathComponent()));
                            ServiceView.this.myContributors.put(groupNode, contributor);
                            groupNode.children.add(child2);
                            child2 = groupNode;
                            path = path.getParentPath();
                        }
                    }
                    rootChildren.add(child2);
                }
            }
            ArrayList arrayList = new ArrayList(rootChildren);
            if (arrayList == null) {
                MyTreeModel.$$$reportNull$$$0(2);
            }
            return arrayList;
        }

        public Object getRoot() {
            return this.myRoot;
        }

        void refresh(ServiceViewContributor.ServiceEvent e) {
            this.refreshAll();
        }

        void refreshAll() {
            this.treeStructureChanged(null, null, null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/execution/services/ServiceView$MyTreeModel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInvoker";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTreePath";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRootChildren";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private class StatusActionGroup
    extends DefaultActionGroup
    implements CheckedActionGroup {
        StatusActionGroup() {
            super(ExecutionBundle.message((String)"run.dashboard.filter.by.status.action.name", (Object[])new Object[0]), true);
            this.getTemplatePresentation().setIcon(AllIcons.General.Filter);
            for (final RunDashboardRunConfigurationStatus status : new RunDashboardRunConfigurationStatus[]{RunDashboardRunConfigurationStatus.STARTED, RunDashboardRunConfigurationStatus.FAILED, RunDashboardRunConfigurationStatus.STOPPED, RunDashboardRunConfigurationStatus.CONFIGURED}) {
                this.add((AnAction)new ToggleAction(status.getName()){

                    public boolean isSelected(@NotNull AnActionEvent e) {
                        if (e == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return ServiceView.this.myStatusFilter.isVisible(status);
                    }

                    public void setSelected(@NotNull AnActionEvent e, boolean state) {
                        if (e == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (state) {
                            ServiceView.this.myStatusFilter.show(status);
                        } else {
                            ServiceView.this.myStatusFilter.hide(status);
                        }
                        ServiceView.this.updateContent(true);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        objectArray2[0] = "e";
                        objectArray2[1] = "com/intellij/execution/services/ServiceView$StatusActionGroup$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "isSelected";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "setSelected";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }
        }
    }

    private class GroupAction
    extends ToggleAction
    implements DumbAware {
        private final RunDashboardGrouper myGrouper;

        GroupAction(RunDashboardGrouper grouper) {
            this.myGrouper = grouper;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                GroupAction.$$$reportNull$$$0(0);
            }
            super.update(e);
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(ServiceView.this.myTreePanel.isVisible());
            ActionPresentation actionPresentation = this.myGrouper.getRule().getPresentation();
            presentation.setText(actionPresentation.getText());
            presentation.setDescription(actionPresentation.getDescription());
            if ("ServicesToolbar".equals(e.getPlace())) {
                presentation.setIcon(actionPresentation.getIcon());
            }
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                GroupAction.$$$reportNull$$$0(1);
            }
            return this.myGrouper.isEnabled();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                GroupAction.$$$reportNull$$$0(2);
            }
            this.myGrouper.setEnabled(state);
            ServiceView.this.updateContent(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/execution/services/ServiceView$GroupAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class GroupByActionGroup
    extends DefaultActionGroup
    implements CheckedActionGroup {
        GroupByActionGroup(List<? extends RunDashboardGrouper> groupers) {
            super(ExecutionBundle.message((String)"run.dashboard.group.by.action.name", (Object[])new Object[0]), true);
            this.getTemplatePresentation().setIcon(AllIcons.Actions.GroupBy);
            for (RunDashboardGrouper runDashboardGrouper : groupers) {
                this.add((AnAction)new GroupAction(runDashboardGrouper));
            }
        }
    }

    private class MyTreeExpander
    extends DefaultTreeExpander {
        private volatile boolean myFlat;

        MyTreeExpander() {
            super((JTree)ServiceView.this.myTree);
            ServiceView.this.myTreeModel.addTreeModelListener((TreeModelListener)new TreeModelAdapter(){

                public void treeStructureChanged(TreeModelEvent e) {
                    MyTreeExpander.this.isFlat();
                }
            });
        }

        public boolean canExpand() {
            return super.canExpand() && !this.myFlat;
        }

        public boolean canCollapse() {
            return super.canCollapse() && !this.myFlat;
        }

        private void isFlat() {
            this.myFlat = true;
            ServiceView.this.myAsyncTreeModel.accept(new TreeVisitor(){

                @NotNull
                public TreeVisitor.Action visit(@NotNull TreePath path) {
                    if (path == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (path.getPathCount() == 1) {
                        TreeVisitor.Action action = TreeVisitor.Action.CONTINUE;
                        if (action == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        return action;
                    }
                    if (path.getPathCount() == 2) {
                        if (ServiceView.this.myAsyncTreeModel.getChildCount(path.getLastPathComponent()) > 0) {
                            MyTreeExpander.this.myFlat = false;
                            TreeVisitor.Action action = TreeVisitor.Action.INTERRUPT;
                            if (action == null) {
                                2.$$$reportNull$$$0(2);
                            }
                            return action;
                        }
                        TreeVisitor.Action action = TreeVisitor.Action.SKIP_CHILDREN;
                        if (action == null) {
                            2.$$$reportNull$$$0(3);
                        }
                        return action;
                    }
                    TreeVisitor.Action action = TreeVisitor.Action.INTERRUPT;
                    if (action == null) {
                        2.$$$reportNull$$$0(4);
                    }
                    return action;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "path";
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/execution/services/ServiceView$MyTreeExpander$2";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/execution/services/ServiceView$MyTreeExpander$2";
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: {
                            objectArray = objectArray2;
                            objectArray2[1] = "visit";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "visit";
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            });
        }
    }
}

