/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.dashboard;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.actions.StopAction;
import com.intellij.execution.dashboard.RunDashboardAnimator;
import com.intellij.execution.dashboard.RunDashboardContributor;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.execution.dashboard.RunDashboardManagerImpl;
import com.intellij.execution.dashboard.RunDashboardNode;
import com.intellij.execution.dashboard.RunDashboardRunConfigurationNode;
import com.intellij.execution.dashboard.RunDashboardRunConfigurationStatus;
import com.intellij.execution.dashboard.TreeContent;
import com.intellij.execution.dashboard.tree.RunDashboardAnimatorImpl;
import com.intellij.execution.dashboard.tree.RunDashboardGrouper;
import com.intellij.execution.dashboard.tree.RunDashboardStatusFilter;
import com.intellij.execution.dashboard.tree.RunDashboardTreeCellRenderer;
import com.intellij.execution.dashboard.tree.RunDashboardTreeModel;
import com.intellij.execution.dashboard.tree.RunDashboardTreeMouseListener;
import com.intellij.execution.dashboard.tree.RunDashboardTreeStructure;
import com.intellij.execution.runners.FakeRerunAction;
import com.intellij.execution.services.ServiceViewManager;
import com.intellij.execution.ui.RunContentManagerImpl;
import com.intellij.execution.ui.layout.impl.RunnerLayoutUiImpl;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.impl.DataManagerImpl;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.IndexComparator;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.smartTree.ActionPresentation;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CheckedActionGroup;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.RowsDnDSupport;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EditableModel;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeModelAdapter;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class RunDashboardContent
extends JPanel
implements TreeContent,
Disposable {
    public static final DataKey<RunDashboardContent> KEY = DataKey.create((String)"runDashboardContent");
    @NonNls
    private static final String PLACE_TOOLBAR = "RunDashboardContent#Toolbar";
    @NonNls
    static final String RUN_DASHBOARD_CONTENT_TOOLBAR = "RunDashboardContentToolbar";
    @NonNls
    static final String RUN_DASHBOARD_TREE_TOOLBAR = "RunDashboardTreeToolbar";
    @NonNls
    private static final String RUN_DASHBOARD_POPUP = "RunDashboardPopup";
    @NonNls
    private static final String RUN_DASHBOARD_STOP_ACTION_ID = "RunDashboard.Stop";
    private static final String MESSAGE_CARD = "message";
    private static final String CONTENT_CARD = "content";
    private final Splitter mySplitter;
    private final JPanel myTreePanel;
    private final Tree myTree;
    private final CardLayout myDetailsPanelLayout;
    private final JPanel myDetailsPanel;
    private final JBPanelWithEmptyText myMessagePanel;
    private final JComponent myToolbar;
    private final RunDashboardTreeModel myTreeModel;
    private AbstractTreeBuilder myBuilder;
    private RunDashboardAnimator myAnimator;
    private AbstractTreeNode<?> myLastSelection;
    private final Set<Object> myCollapsedTreeNodeValues;
    private final List<? extends RunDashboardGrouper> myGroupers;
    private final RunDashboardStatusFilter myStatusFilter;
    @NotNull
    private final ContentManager myContentManager;
    @NotNull
    private final ContentManagerListener myContentManagerListener;
    @NotNull
    private final Project myProject;
    private final DefaultActionGroup myContentActionGroup;
    private final DefaultActionGroup myDashboardContentActions;
    private final Map<Content, List<AnAction>> myContentActions;

    public RunDashboardContent(@NotNull Project project, @NotNull ContentManager contentManager, @NotNull List<? extends RunDashboardGrouper> groupers) {
        if (project == null) {
            RunDashboardContent.$$$reportNull$$$0(0);
        }
        if (contentManager == null) {
            RunDashboardContent.$$$reportNull$$$0(1);
        }
        if (groupers == null) {
            RunDashboardContent.$$$reportNull$$$0(2);
        }
        super(new BorderLayout());
        this.myCollapsedTreeNodeValues = new HashSet<Object>();
        this.myStatusFilter = new RunDashboardStatusFilter();
        this.myContentActionGroup = new DefaultActionGroup();
        this.myDashboardContentActions = new DefaultActionGroup();
        this.myContentActions = new WeakHashMap<Content, List<AnAction>>();
        this.myProject = project;
        this.myGroupers = groupers;
        this.myTree = new Tree();
        this.myTreeModel = new RunDashboardTreeModel(new DefaultMutableTreeNode(), this.myProject, this.myTree);
        this.myTree.setModel((TreeModel)this.myTreeModel);
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        this.myTree.setLineStyleAngled();
        this.myTree.setCellRenderer((TreeCellRenderer)new RunDashboardTreeCellRenderer());
        RunDashboardTreeMouseListener mouseListener = new RunDashboardTreeMouseListener(this.myTree);
        mouseListener.installOn((Component)this.myTree);
        RowsDnDSupport.install((JTree)this.myTree, (EditableModel)this.myTreeModel);
        RunDashboardManager dashboardManager = RunDashboardManager.getInstance((Project)this.myProject);
        this.mySplitter = new OnePixelSplitter(false, dashboardManager.getContentProportion());
        this.myTreePanel = new JPanel(new BorderLayout());
        this.myTreePanel.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myTree, (int)1), "Center");
        this.mySplitter.setFirstComponent((JComponent)this.myTreePanel);
        this.myDetailsPanelLayout = new CardLayout();
        this.myDetailsPanel = new JPanel(this.myDetailsPanelLayout);
        this.myMessagePanel = new JBPanelWithEmptyText().withEmptyText(ExecutionBundle.message((String)"run.dashboard.empty.selection.message", (Object[])new Object[0]));
        this.myDetailsPanel.add(MESSAGE_CARD, (Component)this.myMessagePanel);
        this.mySplitter.setSecondComponent((JComponent)this.myDetailsPanel);
        this.add((Component)this.mySplitter, "Center");
        this.myToolbar = this.createToolbar();
        this.add((Component)this.myToolbar, "West");
        JComponent treeToolbar = this.createTreeToolBar();
        this.myTreePanel.add((Component)treeToolbar, "North");
        this.myContentManager = contentManager;
        this.myContentManagerListener = new ContentManagerAdapter(){

            public void contentAdded(@NotNull ContentManagerEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                RunDashboardContent.this.onContentAdded(event.getContent());
            }

            public void contentRemoved(@NotNull ContentManagerEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                Content content = event.getContent();
                RunDashboardContent.this.myContentActions.remove(content);
                RunDashboardContent.this.updateContentToolbar(RunDashboardContent.this.myContentManager.getSelectedContent());
            }

            public void selectionChanged(@NotNull ContentManagerEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (ContentManagerEvent.ContentOperation.add != event.getOperation()) {
                    return;
                }
                Content content = event.getContent();
                RunDashboardContent.this.onContentAdded(content);
                RunDashboardContent.this.onContentSelectionChanged(content);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/execution/dashboard/RunDashboardContent$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "contentAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "contentRemoved";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "selectionChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.myContentManager.addContentManagerListener(this.myContentManagerListener);
        this.myDetailsPanel.add(CONTENT_CARD, this.myContentManager.getComponent());
        this.setupBuilder();
        this.myTree.addTreeSelectionListener(e -> this.onSelectionChanged());
        this.myTree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                Object value = this.getNodeValue(event);
                if (value != null) {
                    RunDashboardContent.this.myCollapsedTreeNodeValues.remove(value);
                }
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                Object value = this.getNodeValue(event);
                if (value != null) {
                    RunDashboardContent.this.myCollapsedTreeNodeValues.add(value);
                }
            }

            private Object getNodeValue(TreeExpansionEvent event) {
                DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)ObjectUtils.tryCast((Object)event.getPath().getLastPathComponent(), DefaultMutableTreeNode.class);
                if (treeNode == null) {
                    return null;
                }
                AbstractTreeNode nodeDescriptor = (AbstractTreeNode)ObjectUtils.tryCast((Object)treeNode.getUserObject(), AbstractTreeNode.class);
                if (nodeDescriptor == null) {
                    return null;
                }
                return nodeDescriptor.getValue();
            }
        });
        this.putClientProperty("DataProvider", dataId -> {
            DataProvider dataProvider;
            if (KEY.getName().equals(dataId)) {
                return this;
            }
            if (PlatformDataKeys.HELP_ID.is(dataId)) {
                return RunDashboardManager.getInstance((Project)this.myProject).getToolWindowContextHelpId();
            }
            if (PlatformDataKeys.SELECTED_ITEMS.is(dataId)) {
                return this.myBuilder.getSelectedElements().toArray();
            }
            Content content = this.myContentManager.getSelectedContent();
            if (content != null && content.getComponent() != null && (dataProvider = DataManagerImpl.getDataProviderEx(content.getComponent())) != null) {
                return dataProvider.getData(dataId);
            }
            return null;
        });
        UIUtil.putClientProperty((JComponent)this.myTree, (Key)ServiceViewManager.SERVICE_VIEW_MASTER_COMPONENT, (Object)Boolean.TRUE);
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent event) {
                RunDashboardRunConfigurationNode node;
                RunDashboardContributor contributor;
                if (RunDashboardContent.this.myLastSelection instanceof RunDashboardRunConfigurationNode && RunDashboardContent.this.myLastSelection.getChildren().isEmpty() && (contributor = (node = (RunDashboardRunConfigurationNode)RunDashboardContent.this.myLastSelection).getContributor()) != null) {
                    return contributor.handleDoubleClick(node.getConfigurationSettings().getConfiguration());
                }
                return false;
            }
        }.installOn((Component)this.myTree);
        DefaultActionGroup popupActionGroup = new DefaultActionGroup();
        popupActionGroup.add(ActionManager.getInstance().getAction(RUN_DASHBOARD_CONTENT_TOOLBAR));
        popupActionGroup.addSeparator();
        popupActionGroup.add(ActionManager.getInstance().getAction(RUN_DASHBOARD_TREE_TOOLBAR));
        popupActionGroup.add(ActionManager.getInstance().getAction(RUN_DASHBOARD_POPUP));
        PopupHandler.installPopupHandler((JComponent)this.myTree, (ActionGroup)popupActionGroup, (String)RUN_DASHBOARD_POPUP, (ActionManager)ActionManager.getInstance());
        new TreeSpeedSearch(this.myTree, TreeSpeedSearch.NODE_DESCRIPTOR_TOSTRING, true);
        this.setTreeVisible(dashboardManager.isShowConfigurations());
        for (Content content : this.myContentManager.getContents()) {
            this.onContentAdded(content);
        }
        Content selectedContent = this.myContentManager.getSelectedContent();
        if (selectedContent != null) {
            this.onContentSelectionChanged(selectedContent);
        }
    }

    private void setTreeVisible(boolean visible) {
        this.myTreePanel.setVisible(visible);
        this.myToolbar.setBorder(visible ? null : IdeBorderFactory.createBorder((int)4));
        if (!visible && this.myContentManager.getContentCount() > 0) {
            this.showContentPanel();
        }
    }

    private void updateContentToolbar(Content content) {
        List<AnAction> actions = this.myContentActions.get(content);
        this.myContentActionGroup.removeAll();
        this.myContentActionGroup.addAll((ActionGroup)this.myDashboardContentActions);
        this.myContentActionGroup.addSeparator();
        if (actions != null) {
            this.myContentActionGroup.addAll((Collection)ContainerUtil.filter(actions, action -> !(action instanceof StopAction) && !(action instanceof FakeRerunAction)));
        }
    }

    private void onSelectionChanged() {
        Set nodes = this.myBuilder.getSelectedElements(AbstractTreeNode.class);
        if (nodes.size() != 1) {
            this.showMessagePanel(ExecutionBundle.message((String)"run.dashboard.empty.selection.message", (Object[])new Object[0]));
            this.myLastSelection = null;
            this.updateContentToolbar(null);
            return;
        }
        AbstractTreeNode node = (AbstractTreeNode)nodes.iterator().next();
        if (Comparing.equal((Object)node, this.myLastSelection)) {
            return;
        }
        this.myLastSelection = node;
        if (node instanceof RunDashboardNode) {
            Content content = ((RunDashboardNode)node).getContent();
            if (content != null && content.getManager() != this.myContentManager) {
                content = null;
            }
            this.updateContentToolbar(content);
            if (content != null) {
                if (content != this.myContentManager.getSelectedContent()) {
                    Content toSelect2 = content;
                    SwingUtilities.invokeLater(() -> {
                        if (this.myContentManager.isDisposed() || this.myContentManager.getIndexOfContent(toSelect2) == -1) {
                            return;
                        }
                        if (this.myLastSelection instanceof RunDashboardNode && toSelect2 != ((RunDashboardNode)this.myLastSelection).getContent()) {
                            return;
                        }
                        this.myContentManager.removeContentManagerListener(this.myContentManagerListener);
                        this.myContentManager.setSelectedContent(toSelect2);
                        this.myContentManager.addContentManagerListener(this.myContentManagerListener);
                    });
                }
                this.showContentPanel();
                return;
            }
            if (node instanceof RunDashboardRunConfigurationNode) {
                this.showMessagePanel(ExecutionBundle.message((String)"run.dashboard.not.started.configuration.message", (Object[])new Object[0]));
                return;
            }
        }
        this.showMessagePanel(ExecutionBundle.message((String)"run.dashboard.empty.selection.message", (Object[])new Object[0]));
    }

    private void onContentAdded(Content content) {
        RunnerLayoutUiImpl ui = RunDashboardManagerImpl.getRunnerLayoutUi(RunContentManagerImpl.getRunContentDescriptorByContent(content));
        if (ui == null) {
            return;
        }
        List<AnAction> leftToolbarActions = ui.getActions();
        this.myContentActions.put(content, leftToolbarActions);
        this.updateContentToolbar(content);
    }

    private void onContentSelectionChanged(Content content) {
        this.myBuilder.queueUpdate().doWhenDone(() -> this.myBuilder.accept(RunDashboardNode.class, node -> {
            if (node.getContent() == content) {
                this.myBuilder.select(node);
            }
            return false;
        }));
        this.showContentPanel();
    }

    private void showMessagePanel(String text) {
        Content selectedContent = this.myContentManager.getSelectedContent();
        if (selectedContent != null) {
            SwingUtilities.invokeLater(() -> {
                if (this.myContentManager.isDisposed() || !this.myContentManager.isSelected(selectedContent)) {
                    return;
                }
                if (this.myLastSelection instanceof RunDashboardNode && selectedContent == ((RunDashboardNode)this.myLastSelection).getContent()) {
                    return;
                }
                this.myContentManager.removeContentManagerListener(this.myContentManagerListener);
                this.myContentManager.removeFromSelection(selectedContent);
                this.myContentManager.addContentManagerListener(this.myContentManagerListener);
            });
        }
        this.myMessagePanel.getEmptyText().setText(text);
        this.myDetailsPanelLayout.show(this.myDetailsPanel, MESSAGE_CARD);
    }

    private void showContentPanel() {
        this.myDetailsPanelLayout.show(this.myDetailsPanel, CONTENT_CARD);
    }

    private void setupBuilder() {
        RunDashboardTreeStructure structure = new RunDashboardTreeStructure(this.myProject, this.myGroupers, ContainerUtil.newSmartList((Object)this.myStatusFilter));
        this.myBuilder = new AbstractTreeBuilder((JTree)this.myTree, this.myTreeModel, structure, (Comparator)IndexComparator.INSTANCE){

            protected boolean isAutoExpandNode(NodeDescriptor nodeDescriptor) {
                return super.isAutoExpandNode(nodeDescriptor) || !RunDashboardContent.this.myCollapsedTreeNodeValues.contains(((AbstractTreeNode)nodeDescriptor).getValue());
            }
        };
        this.myBuilder.initRootNode();
        Disposer.register((Disposable)this, (Disposable)this.myBuilder);
        this.myAnimator = new RunDashboardAnimatorImpl(this.myBuilder);
    }

    private JComponent createToolbar() {
        JPanel toolBarPanel = new JPanel(new BorderLayout());
        ActionManager actionManager = ActionManager.getInstance();
        AnAction registeredActions = actionManager.getAction(RUN_DASHBOARD_CONTENT_TOOLBAR);
        if (registeredActions instanceof DefaultActionGroup) {
            for (AnAction action : ((DefaultActionGroup)registeredActions).getChildren(null)) {
                if (!RUN_DASHBOARD_STOP_ACTION_ID.equals(actionManager.getId(action))) continue;
                action.registerCustomShortcutSet((JComponent)this, null);
                break;
            }
        }
        this.myDashboardContentActions.add(registeredActions);
        this.myContentActionGroup.add((AnAction)this.myDashboardContentActions);
        ActionToolbar contentActionsToolBar = actionManager.createActionToolbar(PLACE_TOOLBAR, (ActionGroup)this.myContentActionGroup, false);
        toolBarPanel.add((Component)contentActionsToolBar.getComponent(), "Center");
        contentActionsToolBar.setTargetComponent((JComponent)this);
        return toolBarPanel;
    }

    private JComponent createTreeToolBar() {
        JPanel toolBarPanel = new JPanel(new BorderLayout());
        toolBarPanel.setBorder(IdeBorderFactory.createBorder((int)9));
        DefaultActionGroup treeGroup = new DefaultActionGroup();
        RunDashboardTreeExpander treeExpander = new RunDashboardTreeExpander();
        AnAction expandAllAction = CommonActionsManager.getInstance().createExpandAllAction((TreeExpander)treeExpander, (JComponent)this);
        treeGroup.add(expandAllAction);
        AnAction collapseAllAction = CommonActionsManager.getInstance().createCollapseAllAction((TreeExpander)treeExpander, (JComponent)this);
        treeGroup.add(collapseAllAction);
        treeGroup.addSeparator();
        List groupers = ContainerUtil.filter(this.myGroupers, grouper -> !grouper.getRule().isAlwaysEnabled());
        if (!groupers.isEmpty()) {
            treeGroup.add((AnAction)new GroupByActionGroup(groupers));
        }
        treeGroup.add((AnAction)new StatusActionGroup());
        treeGroup.addSeparator();
        AnAction treeActions = ActionManager.getInstance().getAction(RUN_DASHBOARD_TREE_TOOLBAR);
        treeActions.registerCustomShortcutSet((JComponent)this, null);
        treeGroup.add(treeActions);
        ActionToolbar treeActionsToolBar = ActionManager.getInstance().createActionToolbar(PLACE_TOOLBAR, (ActionGroup)treeGroup, true);
        toolBarPanel.add((Component)treeActionsToolBar.getComponent(), "Center");
        treeActionsToolBar.setTargetComponent((JComponent)this.myTree);
        return toolBarPanel;
    }

    public void dispose() {
    }

    public void updateContent(boolean withStructure) {
        AppUIUtil.invokeLaterIfProjectAlive(this.myProject, () -> {
            boolean showConfigurations = RunDashboardManager.getInstance((Project)this.myProject).isShowConfigurations();
            if (this.myTreePanel.isVisible() ^ showConfigurations) {
                this.setTreeVisible(showConfigurations);
                this.revalidate();
                this.repaint();
                if (showConfigurations) {
                    IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)this.myTree, true);
                }
            }
            this.myBuilder.queueUpdate(withStructure).doWhenDone(() -> {
                if (!withStructure) {
                    return;
                }
                HashSet nodes = new HashSet();
                this.myBuilder.accept(AbstractTreeNode.class, node -> {
                    nodes.add(node.getValue());
                    return false;
                });
                this.myCollapsedTreeNodeValues.retainAll(nodes);
            });
        });
    }

    @NotNull
    public AbstractTreeBuilder getBuilder() {
        AbstractTreeBuilder abstractTreeBuilder = this.myBuilder;
        if (abstractTreeBuilder == null) {
            RunDashboardContent.$$$reportNull$$$0(3);
        }
        return abstractTreeBuilder;
    }

    @NotNull
    public RunDashboardAnimator getAnimator() {
        RunDashboardAnimator runDashboardAnimator = this.myAnimator;
        if (runDashboardAnimator == null) {
            RunDashboardContent.$$$reportNull$$$0(4);
        }
        return runDashboardAnimator;
    }

    public float getContentProportion() {
        return this.mySplitter.getProportion();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupers";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/dashboard/RunDashboardContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/dashboard/RunDashboardContent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuilder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnimator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class StatusActionGroup
    extends DefaultActionGroup
    implements CheckedActionGroup {
        StatusActionGroup() {
            super(ExecutionBundle.message((String)"run.dashboard.filter.by.status.action.name", (Object[])new Object[0]), true);
            this.getTemplatePresentation().setIcon(AllIcons.General.Filter);
            for (final RunDashboardRunConfigurationStatus status : new RunDashboardRunConfigurationStatus[]{RunDashboardRunConfigurationStatus.STARTED, RunDashboardRunConfigurationStatus.FAILED, RunDashboardRunConfigurationStatus.STOPPED, RunDashboardRunConfigurationStatus.CONFIGURED}) {
                this.add((AnAction)new ToggleAction(status.getName()){

                    public boolean isSelected(@NotNull AnActionEvent e) {
                        if (e == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return RunDashboardContent.this.myStatusFilter.isVisible(status);
                    }

                    public void setSelected(@NotNull AnActionEvent e, boolean state) {
                        if (e == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (state) {
                            RunDashboardContent.this.myStatusFilter.show(status);
                        } else {
                            RunDashboardContent.this.myStatusFilter.hide(status);
                        }
                        RunDashboardContent.this.updateContent(true);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        objectArray2[0] = "e";
                        objectArray2[1] = "com/intellij/execution/dashboard/RunDashboardContent$StatusActionGroup$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "isSelected";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "setSelected";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }
        }
    }

    private class GroupAction
    extends ToggleAction
    implements DumbAware {
        private final RunDashboardGrouper myGrouper;

        GroupAction(RunDashboardGrouper grouper) {
            this.myGrouper = grouper;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                GroupAction.$$$reportNull$$$0(0);
            }
            super.update(e);
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(RunDashboardContent.this.myTreePanel.isVisible());
            ActionPresentation actionPresentation = this.myGrouper.getRule().getPresentation();
            presentation.setText(actionPresentation.getText());
            presentation.setDescription(actionPresentation.getDescription());
            if (RunDashboardContent.PLACE_TOOLBAR.equals(e.getPlace())) {
                presentation.setIcon(actionPresentation.getIcon());
            }
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                GroupAction.$$$reportNull$$$0(1);
            }
            return this.myGrouper.isEnabled();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                GroupAction.$$$reportNull$$$0(2);
            }
            this.myGrouper.setEnabled(state);
            RunDashboardContent.this.updateContent(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/execution/dashboard/RunDashboardContent$GroupAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class GroupByActionGroup
    extends DefaultActionGroup
    implements CheckedActionGroup {
        GroupByActionGroup(List<? extends RunDashboardGrouper> groupers) {
            super(ExecutionBundle.message((String)"run.dashboard.group.by.action.name", (Object[])new Object[0]), true);
            this.getTemplatePresentation().setIcon(AllIcons.Actions.GroupBy);
            for (RunDashboardGrouper runDashboardGrouper : groupers) {
                this.add((AnAction)new GroupAction(runDashboardGrouper));
            }
        }
    }

    private class RunDashboardTreeExpander
    extends DefaultTreeExpander {
        boolean myFlat;

        RunDashboardTreeExpander() {
            super((JTree)RunDashboardContent.this.myTree);
            RunDashboardContent.this.myTreeModel.addTreeModelListener((TreeModelListener)new TreeModelAdapter(){

                public void treeStructureChanged(TreeModelEvent e) {
                    RunDashboardTreeExpander.this.myFlat = RunDashboardTreeExpander.this.isFlat();
                }
            });
        }

        public boolean canExpand() {
            return super.canExpand() && !this.myFlat;
        }

        public boolean canCollapse() {
            return super.canCollapse() && !this.myFlat;
        }

        private boolean isFlat() {
            Object root = RunDashboardContent.this.myTreeModel.getRoot();
            for (int i = 0; i < RunDashboardContent.this.myTreeModel.getChildCount(root); ++i) {
                Object child2 = RunDashboardContent.this.myTreeModel.getChild(root, i);
                if (RunDashboardContent.this.myTreeModel.getChildCount(child2) <= 0) continue;
                return false;
            }
            return true;
        }
    }
}

