/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.KillableProcess;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class ShowRunningListAction
extends AnAction {
    private static final Object KEY = new Object();

    public ShowRunningListAction() {
        super(ExecutionBundle.message((String)"show.running.list.action.name", (Object[])new Object[0]), ExecutionBundle.message((String)"show.running.list.action.description", (Object[])new Object[0]), null);
    }

    public void actionPerformed(final @NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ShowRunningListAction.$$$reportNull$$$0(0);
        }
        if ((project = e.getProject()) == null || project.isDisposed()) {
            return;
        }
        final Ref stateRef = new Ref();
        final Ref balloonRef = new Ref();
        final Timer timer = UIUtil.createNamedTimer((String)"runningLists", (int)250);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Balloon balloon = (Balloon)balloonRef.get();
                if (project.isDisposed() || balloon != null && balloon.isDisposed()) {
                    timer.stop();
                    return;
                }
                ArrayList<Project> projects = new ArrayList<Project>(Arrays.asList(ProjectManager.getInstance().getOpenProjects()));
                projects.remove(project);
                projects.add(0, project);
                Pair state = ShowRunningListAction.getCurrentState(projects);
                Pair prevState = (Pair)stateRef.get();
                if (prevState != null && ((String)prevState.getSecond()).equals(state.getSecond())) {
                    return;
                }
                stateRef.set((Object)state);
                BalloonBuilder builder2 = JBPopupFactory.getInstance().createBalloonBuilder((JComponent)state.getFirst());
                builder2.setShowCallout(false).setTitle(ExecutionBundle.message((String)"show.running.list.balloon.title", (Object[])new Object[0])).setBlockClicksThroughBalloon(true).setDialogMode(true).setHideOnKeyOutside(false);
                IdeFrame frame = (IdeFrame)IdeFrame.KEY.getData(e.getDataContext());
                if (frame == null) {
                    frame = WindowManagerEx.getInstanceEx().getFrame(project);
                }
                if (balloon != null) {
                    balloon.hide();
                }
                builder2.setClickHandler(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (e.getSource() instanceof MouseEvent) {
                            MouseEvent mouseEvent = (MouseEvent)e.getSource();
                            Component component = mouseEvent.getComponent();
                            Object value = ((JComponent)(component = SwingUtilities.getDeepestComponentAt(component, mouseEvent.getX(), mouseEvent.getY()))).getClientProperty(KEY);
                            if (value instanceof Trinity) {
                                Project aProject = (Project)((Trinity)value).first;
                                JFrame aFrame = WindowManager.getInstance().getFrame(aProject);
                                if (aFrame != null && !aFrame.isActive()) {
                                    IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)aFrame, true));
                                }
                                ExecutionManagerImpl.getInstance(aProject).getContentManager().toFrontRunContent((Executor)((Trinity)value).second, (RunContentDescriptor)((Trinity)value).third);
                            }
                        }
                    }
                }, false);
                balloon = builder2.createBalloon();
                balloonRef.set((Object)balloon);
                JComponent component = frame.getComponent();
                RelativePoint point = new RelativePoint((Component)component, new Point(component.getWidth(), 0));
                balloon.show(point, Balloon.Position.below);
            }
        };
        timer.addActionListener(actionListener);
        timer.setInitialDelay(0);
        timer.start();
    }

    private static Pair<? extends JComponent, String> getCurrentState(@NotNull List<Project> projects) {
        if (projects == null) {
            ShowRunningListAction.$$$reportNull$$$0(1);
        }
        NonOpaquePanel panel2 = new NonOpaquePanel((LayoutManager)new GridLayout(0, 1, 10, 10));
        StringBuilder state = new StringBuilder();
        for (int i = 0; i < projects.size(); ++i) {
            Project project = projects.get(i);
            ExecutionManagerImpl executionManager = ExecutionManagerImpl.getInstance(project);
            List<RunContentDescriptor> runningDescriptors2 = executionManager.getRunningDescriptors((Condition<RunnerAndConfigurationSettings>)Condition.TRUE);
            if (!runningDescriptors2.isEmpty() && projects.size() > 1) {
                state.append(project.getName());
                panel2.add((Component)new JLabel("<html><body><b>Project '" + project.getName() + "'</b></body></html>"));
            }
            for (RunContentDescriptor descriptor : runningDescriptors2) {
                Set<Executor> executors = executionManager.getExecutors(descriptor);
                for (Executor executor : executors) {
                    state.append(System.identityHashCode(descriptor.getAttachedContent())).append("@").append(System.identityHashCode(executor.getIcon())).append(";");
                    ProcessHandler processHandler2 = descriptor.getProcessHandler();
                    Icon icon = processHandler2 instanceof KillableProcess && processHandler2.isProcessTerminating() ? AllIcons.Debugger.KillProcess : executor.getIcon();
                    HyperlinkLabel label2 = new HyperlinkLabel(descriptor.getDisplayName());
                    label2.setIcon(icon);
                    label2.setIconTextGap(JBUI.scale((int)2));
                    label2.setCursor(Cursor.getPredefinedCursor(12));
                    label2.putClientProperty(KEY, (Object)Trinity.create((Object)project, (Object)executor, (Object)descriptor));
                    panel2.add((Component)label2);
                }
            }
        }
        if (panel2.getComponentCount() == 0) {
            panel2.setBorder(JBUI.Borders.empty((int)10));
            panel2.add((Component)new JLabel(ExecutionBundle.message((String)"show.running.list.balloon.nothing", (Object[])new Object[0]), 0));
        } else {
            panel2.setBorder((Border)JBUI.Borders.empty((int)10, (int)10, (int)0, (int)10));
            JLabel label3 = new JLabel(ExecutionBundle.message((String)"show.running.list.balloon.hint", (Object[])new Object[0]));
            label3.setFont((Font)JBUI.Fonts.miniFont());
            panel2.add((Component)label3);
        }
        return Pair.create((Object)panel2, (Object)state.toString());
    }

    public void update(@NotNull AnActionEvent e) {
        Project[] projects;
        if (e == null) {
            ShowRunningListAction.$$$reportNull$$$0(2);
        }
        for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
            boolean enabled = project != null && !project.isDisposed() && !ExecutionManagerImpl.getInstance(project).getRunningDescriptors((Condition<RunnerAndConfigurationSettings>)Condition.TRUE).isEmpty();
            e.getPresentation().setEnabled(enabled);
            if (enabled) break;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projects";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/actions/ShowRunningListAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getCurrentState";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

