/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.base;

import com.intellij.diff.DiffContext;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.tools.util.FoldingModelSupport;
import com.intellij.diff.tools.util.base.HighlightPolicy;
import com.intellij.diff.tools.util.base.IgnorePolicy;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.DiffUsageTriggerCollector;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.ContextMenuPopupHandler;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.ui.ToggleActionButton;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class TextDiffViewerUtil {
    private static final Logger LOG = Logger.getInstance(TextDiffViewerUtil.class);

    @NotNull
    public static List<AnAction> createEditorPopupActions() {
        ArrayList<AnAction> result2 = new ArrayList<AnAction>();
        result2.add(ActionManager.getInstance().getAction("CompareClipboardWithSelection"));
        result2.add((AnAction)Separator.getInstance());
        ContainerUtil.addAll(result2, (Object[])((ActionGroup)ActionManager.getInstance().getAction("Diff.EditorPopupMenu")).getChildren(null));
        ArrayList<AnAction> arrayList = result2;
        if (arrayList == null) {
            TextDiffViewerUtil.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    @NotNull
    public static FoldingModelSupport.Settings getFoldingModelSettings(@NotNull DiffContext context) {
        if (context == null) {
            TextDiffViewerUtil.$$$reportNull$$$0(1);
        }
        TextDiffSettingsHolder.TextDiffSettings settings = TextDiffViewerUtil.getTextSettings(context);
        FoldingModelSupport.Settings settings2 = new FoldingModelSupport.Settings(settings.getContextRange(), settings.isExpandByDefault());
        if (settings2 == null) {
            TextDiffViewerUtil.$$$reportNull$$$0(2);
        }
        return settings2;
    }

    @NotNull
    public static TextDiffSettingsHolder.TextDiffSettings getTextSettings(@NotNull DiffContext context) {
        TextDiffSettingsHolder.TextDiffSettings settings;
        if (context == null) {
            TextDiffViewerUtil.$$$reportNull$$$0(3);
        }
        if ((settings = (TextDiffSettingsHolder.TextDiffSettings)context.getUserData(TextDiffSettingsHolder.TextDiffSettings.KEY)) == null) {
            settings = TextDiffSettingsHolder.TextDiffSettings.getSettings((String)context.getUserData(DiffUserDataKeys.PLACE));
            context.putUserData(TextDiffSettingsHolder.TextDiffSettings.KEY, (Object)settings);
            if (DiffUtil.isUserDataFlagSet((Key<Boolean>)DiffUserDataKeys.DO_NOT_IGNORE_WHITESPACES, new UserDataHolder[]{context})) {
                settings.setIgnorePolicy(IgnorePolicy.DEFAULT);
            }
        }
        TextDiffSettingsHolder.TextDiffSettings textDiffSettings = settings;
        if (textDiffSettings == null) {
            TextDiffViewerUtil.$$$reportNull$$$0(4);
        }
        return textDiffSettings;
    }

    @NotNull
    public static boolean[] checkForceReadOnly(@NotNull DiffContext context, @NotNull ContentDiffRequest request) {
        if (context == null) {
            TextDiffViewerUtil.$$$reportNull$$$0(5);
        }
        if (request == null) {
            TextDiffViewerUtil.$$$reportNull$$$0(6);
        }
        List contents = request.getContents();
        int contentCount = contents.size();
        boolean[] result2 = new boolean[contentCount];
        boolean[] data = (boolean[])request.getUserData(DiffUserDataKeys.FORCE_READ_ONLY_CONTENTS);
        if (data != null && data.length != contentCount) {
            LOG.warn("Invalid FORCE_READ_ONLY_CONTENTS key value: " + request);
            data = null;
        }
        for (int i = 0; i < contents.size(); ++i) {
            if (!DiffUtil.isUserDataFlagSet((Key<Boolean>)DiffUserDataKeys.FORCE_READ_ONLY, new UserDataHolder[]{(UserDataHolder)contents.get(i), request, context}) && (data == null || !data[i])) continue;
            result2[i] = true;
        }
        if (result2 == null) {
            TextDiffViewerUtil.$$$reportNull$$$0(7);
        }
        return result2;
    }

    public static void installDocumentListeners(@NotNull DocumentListener listener2, @NotNull List<? extends Document> documents, @NotNull Disposable disposable) {
        if (listener2 == null) {
            TextDiffViewerUtil.$$$reportNull$$$0(8);
        }
        if (documents == null) {
            TextDiffViewerUtil.$$$reportNull$$$0(9);
        }
        if (disposable == null) {
            TextDiffViewerUtil.$$$reportNull$$$0(10);
        }
        for (Document document : ContainerUtil.newHashSet(documents)) {
            document.addDocumentListener(listener2, disposable);
        }
    }

    public static void checkDifferentDocuments(@NotNull ContentDiffRequest request) {
        if (request == null) {
            TextDiffViewerUtil.$$$reportNull$$$0(11);
        }
        List contents = request.getContents();
        boolean sameDocuments = false;
        for (int i = 0; i < contents.size(); ++i) {
            for (int j = i + 1; j < contents.size(); ++j) {
                DiffContent content1 = (DiffContent)contents.get(i);
                DiffContent content2 = (DiffContent)contents.get(j);
                if (!(content1 instanceof DocumentContent) || !(content2 instanceof DocumentContent)) continue;
                sameDocuments |= ((DocumentContent)content1).getDocument() == ((DocumentContent)content2).getDocument();
            }
        }
        if (sameDocuments) {
            StringBuilder message = new StringBuilder();
            message.append("DiffRequest with same documents detected\n");
            message.append(request.toString()).append("\n");
            for (DiffContent content : contents) {
                message.append(content.toString()).append("\n");
            }
            LOG.warn(message.toString());
        }
    }

    public static boolean areEqualLineSeparators(@NotNull List<? extends DiffContent> contents) {
        if (contents == null) {
            TextDiffViewerUtil.$$$reportNull$$$0(12);
        }
        return TextDiffViewerUtil.areEqualDocumentContentProperties(contents, DocumentContent::getLineSeparator);
    }

    public static boolean areEqualCharsets(@NotNull List<? extends DiffContent> contents) {
        if (contents == null) {
            TextDiffViewerUtil.$$$reportNull$$$0(13);
        }
        boolean sameCharset = TextDiffViewerUtil.areEqualDocumentContentProperties(contents, DocumentContent::getCharset);
        boolean sameBOM = TextDiffViewerUtil.areEqualDocumentContentProperties(contents, DocumentContent::hasBom);
        return sameCharset && sameBOM;
    }

    private static <T> boolean areEqualDocumentContentProperties(@NotNull List<? extends DiffContent> contents, @NotNull Function<DocumentContent, T> propertyGetter) {
        List properties;
        if (contents == null) {
            TextDiffViewerUtil.$$$reportNull$$$0(14);
        }
        if (propertyGetter == null) {
            TextDiffViewerUtil.$$$reportNull$$$0(15);
        }
        if ((properties = ContainerUtil.mapNotNull(contents, content -> {
            if (content instanceof EmptyContent) {
                return null;
            }
            return propertyGetter.fun((Object)((DocumentContent)content));
        })).size() < 2) {
            return true;
        }
        return ContainerUtil.newHashSet((Iterable)properties).size() == 1;
    }

    @NotNull
    public static List<? extends EditorEx> getEditableEditors(@NotNull List<? extends EditorEx> editors) {
        if (editors == null) {
            TextDiffViewerUtil.$$$reportNull$$$0(16);
        }
        List list2 = ContainerUtil.filter(editors, editor -> !editor.isViewer());
        if (list2 == null) {
            TextDiffViewerUtil.$$$reportNull$$$0(17);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/util/base/TextDiffViewerUtil";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documents";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contents";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyGetter";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditorPopupActions";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/util/base/TextDiffViewerUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFoldingModelSettings";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextSettings";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "checkForceReadOnly";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditableEditors";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getFoldingModelSettings";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTextSettings";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkForceReadOnly";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "installDocumentListeners";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkDifferentDocuments";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "areEqualLineSeparators";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "areEqualCharsets";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "areEqualDocumentContentProperties";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getEditableEditors";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class EditorActionsPopup {
        @NotNull
        private final List<? extends AnAction> myEditorPopupActions;

        public EditorActionsPopup(@NotNull List<? extends AnAction> editorPopupActions) {
            if (editorPopupActions == null) {
                EditorActionsPopup.$$$reportNull$$$0(0);
            }
            this.myEditorPopupActions = editorPopupActions;
        }

        public void install(@NotNull List<? extends EditorEx> editors) {
            if (editors == null) {
                EditorActionsPopup.$$$reportNull$$$0(1);
            }
            ContextMenuPopupHandler.Simple handler2 = new ContextMenuPopupHandler.Simple((ActionGroup)(this.myEditorPopupActions.isEmpty() ? null : new DefaultActionGroup(this.myEditorPopupActions)));
            for (EditorEx editorEx : editors) {
                editorEx.installPopupHandler(handler2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editorPopupActions";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editors";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/tools/util/base/TextDiffViewerUtil$EditorActionsPopup";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "install";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class EditorFontSizeSynchronizer
    implements PropertyChangeListener {
        @NotNull
        private final List<? extends EditorEx> myEditors;
        private boolean myDuringUpdate;

        public EditorFontSizeSynchronizer(@NotNull List<? extends EditorEx> editors) {
            if (editors == null) {
                EditorFontSizeSynchronizer.$$$reportNull$$$0(0);
            }
            this.myDuringUpdate = false;
            this.myEditors = editors;
        }

        public void install(@NotNull Disposable disposable) {
            if (disposable == null) {
                EditorFontSizeSynchronizer.$$$reportNull$$$0(1);
            }
            if (this.myEditors.size() < 2) {
                return;
            }
            for (EditorEx editorEx : this.myEditors) {
                editorEx.addPropertyChangeListener(this, disposable);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (this.myDuringUpdate) {
                return;
            }
            if (!"fontSize".equals(evt.getPropertyName())) {
                return;
            }
            if (evt.getOldValue().equals(evt.getNewValue())) {
                return;
            }
            int fontSize = (Integer)evt.getNewValue();
            for (EditorEx editorEx : this.myEditors) {
                if (evt.getSource() == editorEx) continue;
                this.updateEditor(editorEx, fontSize);
            }
        }

        public void updateEditor(@NotNull EditorEx editor, int fontSize) {
            if (editor == null) {
                EditorFontSizeSynchronizer.$$$reportNull$$$0(2);
            }
            try {
                this.myDuringUpdate = true;
                editor.setFontSize(fontSize);
            }
            finally {
                this.myDuringUpdate = false;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editors";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "disposable";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/tools/util/base/TextDiffViewerUtil$EditorFontSizeSynchronizer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "install";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateEditor";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class EditorReadOnlyLockAction
    extends ReadOnlyLockAction {
        private final List<? extends EditorEx> myEditableEditors;

        public EditorReadOnlyLockAction(@NotNull DiffContext context, @NotNull List<? extends EditorEx> editableEditors) {
            if (context == null) {
                EditorReadOnlyLockAction.$$$reportNull$$$0(0);
            }
            if (editableEditors == null) {
                EditorReadOnlyLockAction.$$$reportNull$$$0(1);
            }
            super(context);
            this.myEditableEditors = editableEditors;
            this.applyDefaults();
        }

        @Override
        protected void doApply(boolean readOnly) {
            for (EditorEx editorEx : this.myEditableEditors) {
                editorEx.setViewer(readOnly);
            }
        }

        @Override
        protected boolean canEdit() {
            return !this.myEditableEditors.isEmpty();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editableEditors";
                    break;
                }
            }
            objectArray[1] = "com/intellij/diff/tools/util/base/TextDiffViewerUtil$EditorReadOnlyLockAction";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class ReadOnlyLockAction
    extends ToggleAction
    implements DumbAware {
        @NotNull
        protected final DiffContext myContext;
        @NotNull
        protected final TextDiffSettingsHolder.TextDiffSettings mySettings;

        public ReadOnlyLockAction(@NotNull DiffContext context) {
            if (context == null) {
                ReadOnlyLockAction.$$$reportNull$$$0(0);
            }
            super("Disable Editing", null, AllIcons.Diff.Lock);
            this.myContext = context;
            this.mySettings = TextDiffViewerUtil.getTextSettings(context);
        }

        protected void applyDefaults() {
            if (this.isVisible()) {
                this.setSelected(this.isSelected());
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ReadOnlyLockAction.$$$reportNull$$$0(1);
            }
            if (!this.isVisible()) {
                e.getPresentation().setEnabledAndVisible(false);
            } else {
                super.update(e);
            }
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                ReadOnlyLockAction.$$$reportNull$$$0(2);
            }
            return this.isSelected();
        }

        boolean isSelected() {
            return this.mySettings.isReadOnlyLock();
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                ReadOnlyLockAction.$$$reportNull$$$0(3);
            }
            this.setSelected(state);
        }

        void setSelected(boolean state) {
            this.mySettings.setReadOnlyLock(state);
            this.doApply(state);
        }

        private boolean isVisible() {
            return this.myContext.getUserData(DiffUserDataKeysEx.SHOW_READ_ONLY_LOCK) == Boolean.TRUE && this.canEdit();
        }

        protected abstract void doApply(boolean var1);

        protected abstract boolean canEdit();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/diff/tools/util/base/TextDiffViewerUtil$ReadOnlyLockAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class ToggleExpandByDefaultAction
    extends ToggleActionButton
    implements DumbAware {
        @NotNull
        protected final TextDiffSettingsHolder.TextDiffSettings mySettings;

        public ToggleExpandByDefaultAction(@NotNull TextDiffSettingsHolder.TextDiffSettings settings) {
            if (settings == null) {
                ToggleExpandByDefaultAction.$$$reportNull$$$0(0);
            }
            super("Collapse Unchanged Fragments", AllIcons.Actions.Collapseall);
            this.mySettings = settings;
        }

        public boolean isVisible() {
            return this.mySettings.getContextRange() != -1;
        }

        public boolean isSelected(AnActionEvent e) {
            return !this.mySettings.isExpandByDefault();
        }

        public void setSelected(AnActionEvent e, boolean state) {
            boolean expand;
            boolean bl = expand = !state;
            if (this.mySettings.isExpandByDefault() == expand) {
                return;
            }
            this.mySettings.setExpandByDefault(expand);
            this.expandAll(expand);
        }

        protected abstract void expandAll(boolean var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/diff/tools/util/base/TextDiffViewerUtil$ToggleExpandByDefaultAction", "<init>"));
        }
    }

    public static class ToggleAutoScrollAction
    extends ToggleActionButton
    implements DumbAware {
        @NotNull
        protected final TextDiffSettingsHolder.TextDiffSettings mySettings;

        public ToggleAutoScrollAction(@NotNull TextDiffSettingsHolder.TextDiffSettings settings) {
            if (settings == null) {
                ToggleAutoScrollAction.$$$reportNull$$$0(0);
            }
            super("Synchronize Scrolling", AllIcons.Actions.SynchronizeScrolling);
            this.mySettings = settings;
        }

        public boolean isSelected(AnActionEvent e) {
            return this.mySettings.isEnableSyncScroll();
        }

        public void setSelected(AnActionEvent e, boolean state) {
            this.mySettings.setEnableSyncScroll(state);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/diff/tools/util/base/TextDiffViewerUtil$ToggleAutoScrollAction", "<init>"));
        }
    }

    public static class IgnorePolicySettingAction
    extends EnumPolicySettingAction<IgnorePolicy> {
        @NotNull
        protected final TextDiffSettingsHolder.TextDiffSettings mySettings;

        public IgnorePolicySettingAction(@NotNull TextDiffSettingsHolder.TextDiffSettings settings, IgnorePolicy ... policies) {
            if (settings == null) {
                IgnorePolicySettingAction.$$$reportNull$$$0(0);
            }
            if (policies == null) {
                IgnorePolicySettingAction.$$$reportNull$$$0(1);
            }
            super((Enum[])policies);
            this.mySettings = settings;
        }

        @Override
        protected void setValue(@NotNull IgnorePolicy option2) {
            if (option2 == null) {
                IgnorePolicySettingAction.$$$reportNull$$$0(2);
            }
            if (this.getValue() == option2) {
                return;
            }
            DiffUsageTriggerCollector.trigger("toggle.ignore.policy", option2);
            this.mySettings.setIgnorePolicy(option2);
        }

        @Override
        @NotNull
        protected IgnorePolicy getStoredValue() {
            IgnorePolicy ignorePolicy = this.mySettings.getIgnorePolicy();
            if (ignorePolicy == null) {
                IgnorePolicySettingAction.$$$reportNull$$$0(3);
            }
            return ignorePolicy;
        }

        @Override
        @NotNull
        protected List<IgnorePolicy> getValueSubstitutes(@NotNull IgnorePolicy value) {
            if (value == null) {
                IgnorePolicySettingAction.$$$reportNull$$$0(4);
            }
            if (value == IgnorePolicy.IGNORE_WHITESPACES_CHUNKS) {
                List list2 = ContainerUtil.list((Object[])new IgnorePolicy[]{IgnorePolicy.IGNORE_WHITESPACES});
                if (list2 == null) {
                    IgnorePolicySettingAction.$$$reportNull$$$0(5);
                }
                return list2;
            }
            if (value == IgnorePolicy.FORMATTING) {
                List list3 = ContainerUtil.list((Object[])new IgnorePolicy[]{IgnorePolicy.TRIM_WHITESPACES});
                if (list3 == null) {
                    IgnorePolicySettingAction.$$$reportNull$$$0(6);
                }
                return list3;
            }
            List list4 = ContainerUtil.list((Object[])new IgnorePolicy[]{IgnorePolicy.DEFAULT});
            if (list4 == null) {
                IgnorePolicySettingAction.$$$reportNull$$$0(7);
            }
            return list4;
        }

        @Override
        @NotNull
        protected String getText(@NotNull IgnorePolicy option2) {
            if (option2 == null) {
                IgnorePolicySettingAction.$$$reportNull$$$0(8);
            }
            String string = option2.getText();
            if (string == null) {
                IgnorePolicySettingAction.$$$reportNull$$$0(9);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "policies";
                    break;
                }
                case 2: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "option";
                    break;
                }
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/util/base/TextDiffViewerUtil$IgnorePolicySettingAction";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/util/base/TextDiffViewerUtil$IgnorePolicySettingAction";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStoredValue";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValueSubstitutes";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setValue";
                    break;
                }
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 9: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getValueSubstitutes";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getText";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class HighlightPolicySettingAction
    extends EnumPolicySettingAction<HighlightPolicy> {
        @NotNull
        protected final TextDiffSettingsHolder.TextDiffSettings mySettings;

        public HighlightPolicySettingAction(@NotNull TextDiffSettingsHolder.TextDiffSettings settings, HighlightPolicy ... policies) {
            if (settings == null) {
                HighlightPolicySettingAction.$$$reportNull$$$0(0);
            }
            if (policies == null) {
                HighlightPolicySettingAction.$$$reportNull$$$0(1);
            }
            super((Enum[])policies);
            this.mySettings = settings;
        }

        @Override
        protected void setValue(@NotNull HighlightPolicy option2) {
            if (option2 == null) {
                HighlightPolicySettingAction.$$$reportNull$$$0(2);
            }
            if (this.getValue() == option2) {
                return;
            }
            DiffUsageTriggerCollector.trigger("toggle.highlight.policy", option2);
            this.mySettings.setHighlightPolicy(option2);
        }

        @Override
        @NotNull
        protected HighlightPolicy getStoredValue() {
            HighlightPolicy highlightPolicy = this.mySettings.getHighlightPolicy();
            if (highlightPolicy == null) {
                HighlightPolicySettingAction.$$$reportNull$$$0(3);
            }
            return highlightPolicy;
        }

        @Override
        @NotNull
        protected List<HighlightPolicy> getValueSubstitutes(@NotNull HighlightPolicy value) {
            if (value == null) {
                HighlightPolicySettingAction.$$$reportNull$$$0(4);
            }
            if (value == HighlightPolicy.BY_WORD_SPLIT) {
                List list2 = ContainerUtil.list((Object[])new HighlightPolicy[]{HighlightPolicy.BY_WORD});
                if (list2 == null) {
                    HighlightPolicySettingAction.$$$reportNull$$$0(5);
                }
                return list2;
            }
            if (value == HighlightPolicy.DO_NOT_HIGHLIGHT) {
                List list3 = ContainerUtil.list((Object[])new HighlightPolicy[]{HighlightPolicy.BY_LINE});
                if (list3 == null) {
                    HighlightPolicySettingAction.$$$reportNull$$$0(6);
                }
                return list3;
            }
            List list4 = ContainerUtil.list((Object[])new HighlightPolicy[]{HighlightPolicy.BY_WORD});
            if (list4 == null) {
                HighlightPolicySettingAction.$$$reportNull$$$0(7);
            }
            return list4;
        }

        @Override
        @NotNull
        protected String getText(@NotNull HighlightPolicy option2) {
            if (option2 == null) {
                HighlightPolicySettingAction.$$$reportNull$$$0(8);
            }
            String string = option2.getText();
            if (string == null) {
                HighlightPolicySettingAction.$$$reportNull$$$0(9);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "policies";
                    break;
                }
                case 2: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "option";
                    break;
                }
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/util/base/TextDiffViewerUtil$HighlightPolicySettingAction";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/util/base/TextDiffViewerUtil$HighlightPolicySettingAction";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStoredValue";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValueSubstitutes";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setValue";
                    break;
                }
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 9: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getValueSubstitutes";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getText";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static abstract class EnumPolicySettingAction<T extends Enum>
    extends ComboBoxSettingAction<T> {
        @NotNull
        private final T[] myPolicies;

        EnumPolicySettingAction(@NotNull T[] policies) {
            if (policies == null) {
                EnumPolicySettingAction.$$$reportNull$$$0(0);
            }
            assert (policies.length > 0);
            this.myPolicies = policies;
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                EnumPolicySettingAction.$$$reportNull$$$0(1);
            }
            super.update(e);
            e.getPresentation().setEnabledAndVisible(this.myPolicies.length > 1);
        }

        @Override
        @NotNull
        protected List<T> getAvailableOptions() {
            List list2 = ContainerUtil.sorted(Arrays.asList(this.myPolicies));
            if (list2 == null) {
                EnumPolicySettingAction.$$$reportNull$$$0(2);
            }
            return list2;
        }

        @Override
        @NotNull
        public T getValue() {
            T value = this.getStoredValue();
            if (ArrayUtil.contains(value, (Object[])this.myPolicies)) {
                T t = value;
                if (t == null) {
                    EnumPolicySettingAction.$$$reportNull$$$0(3);
                }
                return t;
            }
            List<T> substitutes = this.getValueSubstitutes(value);
            for (Enum substitute : substitutes) {
                if (!ArrayUtil.contains((Object)substitute, (Object[])this.myPolicies)) continue;
                Enum enum_ = substitute;
                if (enum_ == null) {
                    EnumPolicySettingAction.$$$reportNull$$$0(4);
                }
                return (T)enum_;
            }
            T t = this.myPolicies[0];
            if (t == null) {
                EnumPolicySettingAction.$$$reportNull$$$0(5);
            }
            return t;
        }

        @NotNull
        protected abstract T getStoredValue();

        @NotNull
        protected abstract List<T> getValueSubstitutes(@NotNull T var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "policies";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/util/base/TextDiffViewerUtil$EnumPolicySettingAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/util/base/TextDiffViewerUtil$EnumPolicySettingAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAvailableOptions";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static abstract class ComboBoxSettingAction<T>
    extends ComboBoxAction
    implements DumbAware {
        private DefaultActionGroup myActions;

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ComboBoxSettingAction.$$$reportNull$$$0(0);
            }
            Presentation presentation = e.getPresentation();
            presentation.setText(this.getText(this.getValue()));
        }

        @NotNull
        protected DefaultActionGroup createPopupActionGroup(JComponent button2) {
            DefaultActionGroup defaultActionGroup = this.getActions();
            if (defaultActionGroup == null) {
                ComboBoxSettingAction.$$$reportNull$$$0(1);
            }
            return defaultActionGroup;
        }

        @NotNull
        public DefaultActionGroup getActions() {
            if (this.myActions == null) {
                this.myActions = new DefaultActionGroup();
                for (T setting : this.getAvailableOptions()) {
                    this.myActions.add((AnAction)new MyAction(setting));
                }
            }
            DefaultActionGroup defaultActionGroup = this.myActions;
            if (defaultActionGroup == null) {
                ComboBoxSettingAction.$$$reportNull$$$0(2);
            }
            return defaultActionGroup;
        }

        @NotNull
        protected abstract List<T> getAvailableOptions();

        @NotNull
        protected abstract T getValue();

        protected abstract void setValue(@NotNull T var1);

        @NotNull
        protected abstract String getText(@NotNull T var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/util/base/TextDiffViewerUtil$ComboBoxSettingAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/util/base/TextDiffViewerUtil$ComboBoxSettingAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createPopupActionGroup";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private class MyAction
        extends AnAction
        implements DumbAware {
            @NotNull
            private final T myOption;

            MyAction(T option2) {
                if (option2 == null) {
                    MyAction.$$$reportNull$$$0(0);
                }
                super(ComboBoxSettingAction.this.getText(option2));
                this.myOption = option2;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    MyAction.$$$reportNull$$$0(1);
                }
                ComboBoxSettingAction.this.setValue(this.myOption);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "option";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/diff/tools/util/base/TextDiffViewerUtil$ComboBoxSettingAction$MyAction";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }
}

