/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison;

import com.intellij.diff.comparison.ByChar;
import com.intellij.diff.comparison.ByLine;
import com.intellij.diff.comparison.ByWord;
import com.intellij.diff.comparison.ComparisonManager;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.ComparisonUtil;
import com.intellij.diff.comparison.DiffTooBigException;
import com.intellij.diff.comparison.InnerFragmentsPolicy;
import com.intellij.diff.comparison.TrimUtil;
import com.intellij.diff.comparison.iterables.DiffIterable;
import com.intellij.diff.comparison.iterables.DiffIterableUtil;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.fragments.DiffFragmentImpl;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.fragments.LineFragmentImpl;
import com.intellij.diff.fragments.MergeLineFragment;
import com.intellij.diff.fragments.MergeLineFragmentImpl;
import com.intellij.diff.fragments.MergeWordFragment;
import com.intellij.diff.fragments.MergeWordFragmentImpl;
import com.intellij.diff.tools.util.text.LineOffsets;
import com.intellij.diff.tools.util.text.LineOffsetsUtil;
import com.intellij.diff.util.IntPair;
import com.intellij.diff.util.MergeRange;
import com.intellij.diff.util.Range;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharSequenceSubSequence;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComparisonManagerImpl
extends ComparisonManager {
    private static final Logger LOG = Logger.getInstance(ComparisonManagerImpl.class);

    @NotNull
    public static ComparisonManagerImpl getInstanceImpl() {
        ComparisonManagerImpl comparisonManagerImpl = (ComparisonManagerImpl)ComparisonManagerImpl.getInstance();
        if (comparisonManagerImpl == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(0);
        }
        return comparisonManagerImpl;
    }

    @NotNull
    public List<LineFragment> compareLines(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        if (text1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(1);
        }
        if (text2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(2);
        }
        if (policy == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(3);
        }
        if (indicator == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(4);
        }
        LineOffsets lineOffsets1 = LineOffsetsUtil.create(text1);
        LineOffsets lineOffsets2 = LineOffsetsUtil.create(text2);
        List<LineFragment> list2 = this.compareLines(text1, text2, lineOffsets1, lineOffsets2, policy, indicator);
        if (list2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(5);
        }
        return list2;
    }

    @NotNull
    public List<LineFragment> compareLines(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull LineOffsets lineOffsets1, @NotNull LineOffsets lineOffsets2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        if (text1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(6);
        }
        if (text2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(7);
        }
        if (lineOffsets1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(8);
        }
        if (lineOffsets2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(9);
        }
        if (policy == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(10);
        }
        if (indicator == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(11);
        }
        Range range2 = new Range(0, lineOffsets1.getLineCount(), 0, lineOffsets2.getLineCount());
        List<LineFragment> list2 = this.compareLines(range2, text1, text2, lineOffsets1, lineOffsets2, policy, indicator);
        if (list2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(12);
        }
        return list2;
    }

    @NotNull
    public List<LineFragment> compareLines(@NotNull Range range2, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull LineOffsets lineOffsets1, @NotNull LineOffsets lineOffsets2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        if (range2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(13);
        }
        if (text1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(14);
        }
        if (text2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(15);
        }
        if (lineOffsets1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(16);
        }
        if (lineOffsets2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(17);
        }
        if (policy == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(18);
        }
        if (indicator == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(19);
        }
        List<CharSequence> lineTexts1 = ComparisonManagerImpl.getLineContents(range2.start1, range2.end1, text1, lineOffsets1);
        List<CharSequence> lineTexts2 = ComparisonManagerImpl.getLineContents(range2.start2, range2.end2, text2, lineOffsets2);
        FairDiffIterable iterable = ByLine.compare(lineTexts1, lineTexts2, policy, indicator);
        List<LineFragment> list2 = ComparisonManagerImpl.convertIntoLineFragments(range2, lineOffsets1, lineOffsets2, iterable);
        if (list2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(20);
        }
        return list2;
    }

    @NotNull
    public List<MergeLineFragment> compareLines(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull CharSequence text3, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        if (text1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(21);
        }
        if (text2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(22);
        }
        if (text3 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(23);
        }
        if (policy == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(24);
        }
        if (indicator == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(25);
        }
        List<CharSequence> lineTexts1 = ComparisonManagerImpl.getLineContents(text1);
        List<CharSequence> lineTexts2 = ComparisonManagerImpl.getLineContents(text2);
        List<CharSequence> lineTexts3 = ComparisonManagerImpl.getLineContents(text3);
        List<MergeRange> ranges = ByLine.compare(lineTexts1, lineTexts2, lineTexts3, policy, indicator);
        List<MergeLineFragment> list2 = ComparisonManagerImpl.convertIntoMergeLineFragments(ranges);
        if (list2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(26);
        }
        return list2;
    }

    @NotNull
    public List<MergeLineFragment> mergeLines(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull CharSequence text3, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        if (text1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(27);
        }
        if (text2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(28);
        }
        if (text3 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(29);
        }
        if (policy == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(30);
        }
        if (indicator == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(31);
        }
        List<CharSequence> lineTexts1 = ComparisonManagerImpl.getLineContents(text1);
        List<CharSequence> lineTexts2 = ComparisonManagerImpl.getLineContents(text2);
        List<CharSequence> lineTexts3 = ComparisonManagerImpl.getLineContents(text3);
        List<MergeRange> ranges = ByLine.merge(lineTexts1, lineTexts2, lineTexts3, policy, indicator);
        List<MergeLineFragment> list2 = ComparisonManagerImpl.convertIntoMergeLineFragments(ranges);
        if (list2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(32);
        }
        return list2;
    }

    @NotNull
    public List<LineFragment> compareLinesInner(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        if (text1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(33);
        }
        if (text2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(34);
        }
        if (policy == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(35);
        }
        if (indicator == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(36);
        }
        List<LineFragment> lineFragments = this.compareLines(text1, text2, policy, indicator);
        List<LineFragment> list2 = ComparisonManagerImpl.createInnerFragments(lineFragments, text1, text2, policy, InnerFragmentsPolicy.WORDS, indicator);
        if (list2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(37);
        }
        return list2;
    }

    @NotNull
    public List<LineFragment> compareLinesInner(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull LineOffsets lineOffsets1, @NotNull LineOffsets lineOffsets2, @NotNull ComparisonPolicy policy, @NotNull InnerFragmentsPolicy fragmentsPolicy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        if (text1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(38);
        }
        if (text2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(39);
        }
        if (lineOffsets1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(40);
        }
        if (lineOffsets2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(41);
        }
        if (policy == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(42);
        }
        if (fragmentsPolicy == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(43);
        }
        if (indicator == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(44);
        }
        List<LineFragment> lineFragments = this.compareLines(text1, text2, lineOffsets1, lineOffsets2, policy, indicator);
        if (fragmentsPolicy != InnerFragmentsPolicy.NONE) {
            List<LineFragment> list2 = ComparisonManagerImpl.createInnerFragments(lineFragments, text1, text2, policy, fragmentsPolicy, indicator);
            if (list2 == null) {
                ComparisonManagerImpl.$$$reportNull$$$0(45);
            }
            return list2;
        }
        List<LineFragment> list3 = lineFragments;
        if (list3 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(46);
        }
        return list3;
    }

    @NotNull
    public List<LineFragment> compareLinesInner(@NotNull Range range2, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull LineOffsets lineOffsets1, @NotNull LineOffsets lineOffsets2, @NotNull ComparisonPolicy policy, boolean innerFragments, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        if (range2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(47);
        }
        if (text1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(48);
        }
        if (text2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(49);
        }
        if (lineOffsets1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(50);
        }
        if (lineOffsets2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(51);
        }
        if (policy == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(52);
        }
        if (indicator == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(53);
        }
        InnerFragmentsPolicy fragmentsPolicy = innerFragments ? InnerFragmentsPolicy.WORDS : InnerFragmentsPolicy.NONE;
        List<LineFragment> list2 = this.compareLinesInner(range2, text1, text2, lineOffsets1, lineOffsets2, policy, fragmentsPolicy, indicator);
        if (list2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(54);
        }
        return list2;
    }

    @NotNull
    public List<LineFragment> compareLinesInner(@NotNull Range range2, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull LineOffsets lineOffsets1, @NotNull LineOffsets lineOffsets2, @NotNull ComparisonPolicy policy, @NotNull InnerFragmentsPolicy fragmentsPolicy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        if (range2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(55);
        }
        if (text1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(56);
        }
        if (text2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(57);
        }
        if (lineOffsets1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(58);
        }
        if (lineOffsets2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(59);
        }
        if (policy == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(60);
        }
        if (fragmentsPolicy == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(61);
        }
        if (indicator == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(62);
        }
        List<LineFragment> lineFragments = this.compareLines(range2, text1, text2, lineOffsets1, lineOffsets2, policy, indicator);
        if (fragmentsPolicy != InnerFragmentsPolicy.NONE) {
            List<LineFragment> list2 = ComparisonManagerImpl.createInnerFragments(lineFragments, text1, text2, policy, fragmentsPolicy, indicator);
            if (list2 == null) {
                ComparisonManagerImpl.$$$reportNull$$$0(63);
            }
            return list2;
        }
        List<LineFragment> list3 = lineFragments;
        if (list3 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(64);
        }
        return list3;
    }

    private static List<LineFragment> createInnerFragments(@NotNull List<LineFragment> lineFragments, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, @NotNull InnerFragmentsPolicy fragmentsPolicy, @NotNull ProgressIndicator indicator) {
        if (lineFragments == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(65);
        }
        if (text1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(66);
        }
        if (text2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(67);
        }
        if (policy == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(68);
        }
        if (fragmentsPolicy == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(69);
        }
        if (indicator == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(70);
        }
        ArrayList<LineFragment> result2 = new ArrayList<LineFragment>(lineFragments.size());
        int tooBigChunksCount = 0;
        for (LineFragment fragment : lineFragments) {
            assert (fragment.getInnerFragments() == null);
            try {
                boolean tryComputeDifferences = tooBigChunksCount < 3;
                result2.addAll(ComparisonManagerImpl.createInnerFragments(fragment, text1, text2, policy, fragmentsPolicy, indicator, tryComputeDifferences));
            }
            catch (DiffTooBigException e) {
                result2.add(fragment);
                ++tooBigChunksCount;
            }
        }
        return result2;
    }

    @NotNull
    private static List<LineFragment> createInnerFragments(@NotNull LineFragment fragment, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, @NotNull InnerFragmentsPolicy fragmentsPolicy, @NotNull ProgressIndicator indicator, boolean tryComputeDifferences) throws DiffTooBigException {
        if (fragment == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(71);
        }
        if (text1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(72);
        }
        if (text2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(73);
        }
        if (policy == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(74);
        }
        if (fragmentsPolicy == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(75);
        }
        if (indicator == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(76);
        }
        if (fragmentsPolicy == InnerFragmentsPolicy.NONE) {
            List<LineFragment> list2 = Collections.singletonList(fragment);
            if (list2 == null) {
                ComparisonManagerImpl.$$$reportNull$$$0(77);
            }
            return list2;
        }
        CharSequence subSequence1 = text1.subSequence(fragment.getStartOffset1(), fragment.getEndOffset1());
        CharSequence subSequence2 = text2.subSequence(fragment.getStartOffset2(), fragment.getEndOffset2());
        if (fragment.getStartLine1() == fragment.getEndLine1() || fragment.getStartLine2() == fragment.getEndLine2()) {
            if (ComparisonUtil.isEquals(subSequence1, subSequence2, policy)) {
                List<LineFragmentImpl> list3 = Collections.singletonList(new LineFragmentImpl(fragment, Collections.emptyList()));
                if (list3 == null) {
                    ComparisonManagerImpl.$$$reportNull$$$0(78);
                }
                return list3;
            }
            List<LineFragment> list4 = Collections.singletonList(fragment);
            if (list4 == null) {
                ComparisonManagerImpl.$$$reportNull$$$0(79);
            }
            return list4;
        }
        if (!tryComputeDifferences) {
            List<LineFragment> list5 = Collections.singletonList(fragment);
            if (list5 == null) {
                ComparisonManagerImpl.$$$reportNull$$$0(80);
            }
            return list5;
        }
        if (fragmentsPolicy == InnerFragmentsPolicy.WORDS) {
            List<LineFragment> list6 = ComparisonManagerImpl.createInnerWordFragments(fragment, subSequence1, subSequence2, policy, indicator);
            if (list6 == null) {
                ComparisonManagerImpl.$$$reportNull$$$0(81);
            }
            return list6;
        }
        if (fragmentsPolicy == InnerFragmentsPolicy.CHARS) {
            List<LineFragment> list7 = ComparisonManagerImpl.createInnerCharFragments(fragment, subSequence1, subSequence2, policy, indicator);
            if (list7 == null) {
                ComparisonManagerImpl.$$$reportNull$$$0(82);
            }
            return list7;
        }
        throw new IllegalArgumentException(fragmentsPolicy.name());
    }

    @NotNull
    private static List<LineFragment> createInnerWordFragments(@NotNull LineFragment fragment, @NotNull CharSequence subSequence1, @NotNull CharSequence subSequence2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        if (fragment == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(83);
        }
        if (subSequence1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(84);
        }
        if (subSequence2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(85);
        }
        if (policy == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(86);
        }
        if (indicator == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(87);
        }
        List<ByWord.LineBlock> lineBlocks2 = ByWord.compareAndSplit(subSequence1, subSequence2, policy, indicator);
        assert (lineBlocks2.size() != 0);
        int startOffset1 = fragment.getStartOffset1();
        int startOffset2 = fragment.getStartOffset2();
        int currentStartLine1 = fragment.getStartLine1();
        int currentStartLine2 = fragment.getStartLine2();
        ArrayList<LineFragment> chunks = new ArrayList<LineFragment>();
        for (int i = 0; i < lineBlocks2.size(); ++i) {
            ByWord.LineBlock block = lineBlocks2.get(i);
            Range offsets = block.offsets;
            int currentEndLine1 = i != lineBlocks2.size() - 1 ? currentStartLine1 + block.newlines1 : fragment.getEndLine1();
            int currentEndLine2 = i != lineBlocks2.size() - 1 ? currentStartLine2 + block.newlines2 : fragment.getEndLine2();
            chunks.add((LineFragment)new LineFragmentImpl(currentStartLine1, currentEndLine1, currentStartLine2, currentEndLine2, offsets.start1 + startOffset1, offsets.end1 + startOffset1, offsets.start2 + startOffset2, offsets.end2 + startOffset2, block.fragments));
            currentStartLine1 = currentEndLine1;
            currentStartLine2 = currentEndLine2;
        }
        ArrayList<LineFragment> arrayList = chunks;
        if (arrayList == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(88);
        }
        return arrayList;
    }

    @NotNull
    private static List<LineFragment> createInnerCharFragments(@NotNull LineFragment fragment, @NotNull CharSequence subSequence1, @NotNull CharSequence subSequence2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        if (fragment == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(89);
        }
        if (subSequence1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(90);
        }
        if (subSequence2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(91);
        }
        if (policy == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(92);
        }
        if (indicator == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(93);
        }
        List<DiffFragment> innerChanges = ComparisonManagerImpl.doCompareChars(subSequence1, subSequence2, policy, indicator);
        List<LineFragmentImpl> list2 = Collections.singletonList(new LineFragmentImpl(fragment, innerChanges));
        if (list2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(94);
        }
        return list2;
    }

    @NotNull
    private static List<DiffFragment> doCompareChars(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) {
        if (text1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(95);
        }
        if (text2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(96);
        }
        if (policy == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(97);
        }
        if (indicator == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(98);
        }
        DiffIterable iterable = policy == ComparisonPolicy.DEFAULT ? ByChar.compareTwoStep(text1, text2, indicator) : (policy == ComparisonPolicy.TRIM_WHITESPACES ? ByChar.compareTrimWhitespaces(text1, text2, indicator) : ByChar.compareIgnoreWhitespaces(text1, text2, indicator));
        List<DiffFragment> list2 = ComparisonManagerImpl.convertIntoDiffFragments(iterable);
        if (list2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(99);
        }
        return list2;
    }

    @Deprecated
    @NotNull
    public List<LineFragment> compareLinesInner(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull List<LineFragment> lineFragments, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        if (text1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(100);
        }
        if (text2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(101);
        }
        if (lineFragments == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(102);
        }
        if (policy == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(103);
        }
        if (indicator == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(104);
        }
        List<LineFragment> list2 = this.compareLinesInner(text1, text2, policy, indicator);
        if (list2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(105);
        }
        return list2;
    }

    @NotNull
    public List<DiffFragment> compareWords(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        if (text1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(106);
        }
        if (text2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(107);
        }
        if (policy == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(108);
        }
        if (indicator == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(109);
        }
        List<DiffFragment> list2 = ByWord.compare(text1, text2, policy, indicator);
        if (list2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(110);
        }
        return list2;
    }

    @NotNull
    public List<DiffFragment> compareChars(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        if (text1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(111);
        }
        if (text2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(112);
        }
        if (policy == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(113);
        }
        if (indicator == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(114);
        }
        List<DiffFragment> list2 = ComparisonManagerImpl.doCompareChars(text1, text2, policy, indicator);
        if (list2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(115);
        }
        return list2;
    }

    public boolean isEquals(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy) {
        if (text1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(116);
        }
        if (text2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(117);
        }
        if (policy == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(118);
        }
        return ComparisonUtil.isEquals(text1, text2, policy);
    }

    @NotNull
    public static List<DiffFragment> convertIntoDiffFragments(@NotNull DiffIterable changes2) {
        if (changes2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(119);
        }
        ArrayList<DiffFragment> fragments = new ArrayList<DiffFragment>();
        for (Range ch : changes2.iterateChanges()) {
            fragments.add((DiffFragment)new DiffFragmentImpl(ch.start1, ch.end1, ch.start2, ch.end2));
        }
        ArrayList<DiffFragment> arrayList = fragments;
        if (arrayList == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(120);
        }
        return arrayList;
    }

    @NotNull
    public static List<LineFragment> convertIntoLineFragments(@NotNull Range range2, @NotNull LineOffsets lineOffsets1, @NotNull LineOffsets lineOffsets2, @NotNull DiffIterable changes2) {
        if (range2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(121);
        }
        if (lineOffsets1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(122);
        }
        if (lineOffsets2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(123);
        }
        if (changes2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(124);
        }
        ArrayList<LineFragment> fragments = new ArrayList<LineFragment>();
        for (Range ch : changes2.iterateChanges()) {
            int startLine1 = ch.start1 + range2.start1;
            int startLine2 = ch.start2 + range2.start2;
            int endLine1 = ch.end1 + range2.start1;
            int endLine2 = ch.end2 + range2.start2;
            IntPair offsets1 = ComparisonManagerImpl.getOffsets(lineOffsets1, startLine1, endLine1);
            IntPair offsets2 = ComparisonManagerImpl.getOffsets(lineOffsets2, startLine2, endLine2);
            fragments.add((LineFragment)new LineFragmentImpl(startLine1, endLine1, startLine2, endLine2, offsets1.val1, offsets1.val2, offsets2.val1, offsets2.val2));
        }
        ArrayList<LineFragment> arrayList = fragments;
        if (arrayList == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(125);
        }
        return arrayList;
    }

    @NotNull
    private static IntPair getOffsets(@NotNull LineOffsets lineOffsets, int startIndex, int endIndex) {
        if (lineOffsets == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(126);
        }
        if (startIndex == endIndex) {
            int offset = startIndex < lineOffsets.getLineCount() ? lineOffsets.getLineStart(startIndex) : lineOffsets.getLineEnd(lineOffsets.getLineCount() - 1, true);
            IntPair intPair = new IntPair(offset, offset);
            if (intPair == null) {
                ComparisonManagerImpl.$$$reportNull$$$0(127);
            }
            return intPair;
        }
        int offset1 = lineOffsets.getLineStart(startIndex);
        int offset2 = lineOffsets.getLineEnd(endIndex - 1, true);
        IntPair intPair = new IntPair(offset1, offset2);
        if (intPair == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(128);
        }
        return intPair;
    }

    @NotNull
    public static List<MergeLineFragment> convertIntoMergeLineFragments(@NotNull List<? extends MergeRange> conflicts) {
        if (conflicts == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(129);
        }
        List list2 = ContainerUtil.map(conflicts, ch -> new MergeLineFragmentImpl((MergeRange)ch));
        if (list2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(130);
        }
        return list2;
    }

    @NotNull
    public static List<MergeWordFragment> convertIntoMergeWordFragments(@NotNull List<? extends MergeRange> conflicts) {
        if (conflicts == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(131);
        }
        List list2 = ContainerUtil.map(conflicts, ch -> new MergeWordFragmentImpl((MergeRange)ch));
        if (list2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(132);
        }
        return list2;
    }

    @NotNull
    public List<LineFragment> squash(@NotNull List<LineFragment> oldFragments) {
        if (oldFragments == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(133);
        }
        if (oldFragments.isEmpty()) {
            List<LineFragment> list2 = oldFragments;
            if (list2 == null) {
                ComparisonManagerImpl.$$$reportNull$$$0(134);
            }
            return list2;
        }
        ArrayList<LineFragment> newFragments = new ArrayList<LineFragment>();
        ComparisonManagerImpl.processAdjoining(oldFragments, (Consumer<List<LineFragment>>)((Consumer)fragments -> newFragments.add(ComparisonManagerImpl.doSquash(fragments))));
        ArrayList<LineFragment> arrayList = newFragments;
        if (arrayList == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(135);
        }
        return arrayList;
    }

    @NotNull
    public List<LineFragment> processBlocks(@NotNull List<LineFragment> oldFragments, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, boolean squash, boolean trim) {
        if (oldFragments == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(136);
        }
        if (text1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(137);
        }
        if (text2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(138);
        }
        if (policy == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(139);
        }
        if (!squash && !trim) {
            List<LineFragment> list2 = oldFragments;
            if (list2 == null) {
                ComparisonManagerImpl.$$$reportNull$$$0(140);
            }
            return list2;
        }
        if (oldFragments.isEmpty()) {
            List<LineFragment> list3 = oldFragments;
            if (list3 == null) {
                ComparisonManagerImpl.$$$reportNull$$$0(141);
            }
            return list3;
        }
        ArrayList<LineFragment> newFragments = new ArrayList<LineFragment>();
        ComparisonManagerImpl.processAdjoining(oldFragments, (Consumer<List<LineFragment>>)((Consumer)fragments -> newFragments.addAll(ComparisonManagerImpl.processAdjoining(fragments, text1, text2, policy, squash, trim))));
        ArrayList<LineFragment> arrayList = newFragments;
        if (arrayList == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(142);
        }
        return arrayList;
    }

    private static void processAdjoining(@NotNull List<LineFragment> oldFragments, @NotNull Consumer<List<LineFragment>> consumer) {
        if (oldFragments == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(143);
        }
        if (consumer == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(144);
        }
        int startIndex = 0;
        for (int i = 1; i < oldFragments.size(); ++i) {
            if (ComparisonManagerImpl.isAdjoining(oldFragments.get(i - 1), oldFragments.get(i))) continue;
            consumer.consume(oldFragments.subList(startIndex, i));
            startIndex = i;
        }
        if (startIndex < oldFragments.size()) {
            consumer.consume(oldFragments.subList(startIndex, oldFragments.size()));
        }
    }

    @NotNull
    private static List<LineFragment> processAdjoining(@NotNull List<LineFragment> fragments, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, boolean squash, boolean trim) {
        int start2;
        if (fragments == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(145);
        }
        if (text1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(146);
        }
        if (text2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(147);
        }
        if (policy == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(148);
        }
        int end = fragments.size();
        if (trim && policy == ComparisonPolicy.IGNORE_WHITESPACES) {
            CharSequenceSubSequence sequence2;
            CharSequenceSubSequence sequence1;
            LineFragment fragment;
            for (start2 = 0; start2 < end; ++start2) {
                fragment = fragments.get(start2);
                sequence1 = new CharSequenceSubSequence(text1, fragment.getStartOffset1(), fragment.getEndOffset1());
                sequence2 = new CharSequenceSubSequence(text2, fragment.getStartOffset2(), fragment.getEndOffset2());
                if ((fragment.getInnerFragments() == null || !fragment.getInnerFragments().isEmpty()) && !StringUtil.equalsIgnoreWhitespaces((CharSequence)sequence1, (CharSequence)sequence2)) break;
            }
            while (start2 < end) {
                fragment = fragments.get(end - 1);
                sequence1 = new CharSequenceSubSequence(text1, fragment.getStartOffset1(), fragment.getEndOffset1());
                sequence2 = new CharSequenceSubSequence(text2, fragment.getStartOffset2(), fragment.getEndOffset2());
                if ((fragment.getInnerFragments() == null || !fragment.getInnerFragments().isEmpty()) && !StringUtil.equalsIgnoreWhitespaces((CharSequence)sequence1, (CharSequence)sequence2)) break;
                --end;
            }
        }
        if (start2 == end) {
            List<LineFragment> list2 = Collections.emptyList();
            if (list2 == null) {
                ComparisonManagerImpl.$$$reportNull$$$0(149);
            }
            return list2;
        }
        if (squash) {
            List<LineFragment> list3 = Collections.singletonList(ComparisonManagerImpl.doSquash(fragments.subList(start2, end)));
            if (list3 == null) {
                ComparisonManagerImpl.$$$reportNull$$$0(150);
            }
            return list3;
        }
        List<LineFragment> list4 = fragments.subList(start2, end);
        if (list4 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(151);
        }
        return list4;
    }

    @NotNull
    private static LineFragment doSquash(@NotNull List<LineFragment> oldFragments) {
        if (oldFragments == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(152);
        }
        assert (!oldFragments.isEmpty());
        if (oldFragments.size() == 1) {
            LineFragment lineFragment = oldFragments.get(0);
            if (lineFragment == null) {
                ComparisonManagerImpl.$$$reportNull$$$0(153);
            }
            return lineFragment;
        }
        LineFragment firstFragment = oldFragments.get(0);
        LineFragment lastFragment = oldFragments.get(oldFragments.size() - 1);
        ArrayList<DiffFragmentImpl> newInnerFragments = new ArrayList<DiffFragmentImpl>();
        for (LineFragment fragment : oldFragments) {
            for (DiffFragment innerFragment : ComparisonManagerImpl.extractInnerFragments(fragment)) {
                int shift1 = fragment.getStartOffset1() - firstFragment.getStartOffset1();
                int shift2 = fragment.getStartOffset2() - firstFragment.getStartOffset2();
                DiffFragment previousFragment = (DiffFragment)ContainerUtil.getLastItem(newInnerFragments);
                if (previousFragment == null || !ComparisonManagerImpl.isAdjoiningInner(previousFragment, innerFragment, shift1, shift2)) {
                    newInnerFragments.add(new DiffFragmentImpl(innerFragment.getStartOffset1() + shift1, innerFragment.getEndOffset1() + shift1, innerFragment.getStartOffset2() + shift2, innerFragment.getEndOffset2() + shift2));
                    continue;
                }
                newInnerFragments.remove(newInnerFragments.size() - 1);
                newInnerFragments.add(new DiffFragmentImpl(previousFragment.getStartOffset1(), innerFragment.getEndOffset1() + shift1, previousFragment.getStartOffset2(), innerFragment.getEndOffset2() + shift2));
            }
        }
        LineFragmentImpl lineFragmentImpl = new LineFragmentImpl(firstFragment.getStartLine1(), lastFragment.getEndLine1(), firstFragment.getStartLine2(), lastFragment.getEndLine2(), firstFragment.getStartOffset1(), lastFragment.getEndOffset1(), firstFragment.getStartOffset2(), lastFragment.getEndOffset2(), newInnerFragments);
        if (lineFragmentImpl == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(154);
        }
        return lineFragmentImpl;
    }

    private static boolean isAdjoining(@NotNull LineFragment beforeFragment, @NotNull LineFragment afterFragment) {
        if (beforeFragment == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(155);
        }
        if (afterFragment == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(156);
        }
        return beforeFragment.getEndLine1() == afterFragment.getStartLine1() && beforeFragment.getEndLine2() == afterFragment.getStartLine2() && beforeFragment.getEndOffset1() == afterFragment.getStartOffset1() && beforeFragment.getEndOffset2() == afterFragment.getStartOffset2();
    }

    private static boolean isAdjoiningInner(@NotNull DiffFragment beforeFragment, @NotNull DiffFragment afterFragment, int shift1, int shift2) {
        if (beforeFragment == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(157);
        }
        if (afterFragment == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(158);
        }
        return beforeFragment.getEndOffset1() == afterFragment.getStartOffset1() + shift1 && beforeFragment.getEndOffset2() == afterFragment.getStartOffset2() + shift2;
    }

    @NotNull
    private static List<DiffFragment> extractInnerFragments(@NotNull LineFragment lineFragment) {
        if (lineFragment == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(159);
        }
        if (lineFragment.getInnerFragments() != null) {
            List list2 = lineFragment.getInnerFragments();
            if (list2 == null) {
                ComparisonManagerImpl.$$$reportNull$$$0(160);
            }
            return list2;
        }
        int length1 = lineFragment.getEndOffset1() - lineFragment.getStartOffset1();
        int length2 = lineFragment.getEndOffset2() - lineFragment.getStartOffset2();
        List<DiffFragmentImpl> list3 = Collections.singletonList(new DiffFragmentImpl(0, length1, 0, length2));
        if (list3 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(161);
        }
        return list3;
    }

    @NotNull
    private static List<CharSequence> getLineContents(@NotNull CharSequence text) {
        if (text == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(162);
        }
        LineOffsets lineOffsets = LineOffsetsUtil.create(text);
        List<CharSequence> list2 = ComparisonManagerImpl.getLineContents(0, lineOffsets.getLineCount(), text, lineOffsets);
        if (list2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(163);
        }
        return list2;
    }

    @NotNull
    private static List<CharSequence> getLineContents(int start2, int end, @NotNull CharSequence text, @NotNull LineOffsets lineOffsets) {
        if (text == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(164);
        }
        if (lineOffsets == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(165);
        }
        ArrayList<CharSequence> lines2 = new ArrayList<CharSequence>(end - start2);
        for (int line = start2; line < end; ++line) {
            lines2.add((CharSequence)new CharSequenceSubSequence(text, lineOffsets.getLineStart(line), lineOffsets.getLineEnd(line)));
        }
        ArrayList<CharSequence> arrayList = lines2;
        if (arrayList == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(166);
        }
        return arrayList;
    }

    @NotNull
    private static List<CharSequence> getNotIgnoredLineContents(int start2, int end, @NotNull CharSequence text, @NotNull LineOffsets lineOffsets, @NotNull BitSet ignored) {
        if (text == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(167);
        }
        if (lineOffsets == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(168);
        }
        if (ignored == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(169);
        }
        StringBuilder sb = new StringBuilder();
        ArrayList<CharSequence> lines2 = new ArrayList<CharSequence>(end - start2);
        for (int line = start2; line < end; ++line) {
            for (int offset = lineOffsets.getLineStart(line); offset < lineOffsets.getLineEnd(line); ++offset) {
                if (ignored.get(offset)) continue;
                sb.append(text.charAt(offset));
            }
            lines2.add(sb.toString());
            sb.setLength(0);
        }
        ArrayList<CharSequence> arrayList = lines2;
        if (arrayList == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(170);
        }
        return arrayList;
    }

    @NotNull
    public List<LineFragment> compareLinesWithIgnoredRanges(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull LineOffsets lineOffsets1, @NotNull LineOffsets lineOffsets2, @NotNull BitSet ignored1, @NotNull BitSet ignored2, @NotNull InnerFragmentsPolicy fragmentsPolicy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        if (text1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(171);
        }
        if (text2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(172);
        }
        if (lineOffsets1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(173);
        }
        if (lineOffsets2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(174);
        }
        if (ignored1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(175);
        }
        if (ignored2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(176);
        }
        if (fragmentsPolicy == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(177);
        }
        if (indicator == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(178);
        }
        Range range2 = new Range(0, lineOffsets1.getLineCount(), 0, lineOffsets2.getLineCount());
        List<LineFragment> list2 = this.compareLinesWithIgnoredRanges(range2, text1, text2, lineOffsets1, lineOffsets2, ignored1, ignored2, fragmentsPolicy, indicator);
        if (list2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(179);
        }
        return list2;
    }

    @NotNull
    public List<LineFragment> compareLinesWithIgnoredRanges(@NotNull Range range2, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull LineOffsets lineOffsets1, @NotNull LineOffsets lineOffsets2, @NotNull BitSet ignored1, @NotNull BitSet ignored2, @NotNull InnerFragmentsPolicy fragmentsPolicy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        if (range2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(180);
        }
        if (text1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(181);
        }
        if (text2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(182);
        }
        if (lineOffsets1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(183);
        }
        if (lineOffsets2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(184);
        }
        if (ignored1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(185);
        }
        if (ignored2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(186);
        }
        if (fragmentsPolicy == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(187);
        }
        if (indicator == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(188);
        }
        List<CharSequence> lineTexts1 = ComparisonManagerImpl.getNotIgnoredLineContents(range2.start1, range2.end1, text1, lineOffsets1, ignored1);
        List<CharSequence> lineTexts2 = ComparisonManagerImpl.getNotIgnoredLineContents(range2.start2, range2.end2, text2, lineOffsets2, ignored2);
        FairDiffIterable iterable = ByLine.compare(lineTexts1, lineTexts2, ComparisonPolicy.DEFAULT, indicator);
        FairDiffIterable correctedIterable = ComparisonManagerImpl.correctIgnoredRangesSecondStep(range2, iterable, text1, text2, lineOffsets1, lineOffsets2, ignored1, ignored2);
        DiffIterable trimmedIterable = ComparisonManagerImpl.trimIgnoredLines(range2, correctedIterable, text1, text2, lineOffsets1, lineOffsets2, ignored1, ignored2);
        List<LineFragment> lineFragments = ComparisonManagerImpl.convertIntoLineFragments(range2, lineOffsets1, lineOffsets2, trimmedIterable);
        if (fragmentsPolicy != InnerFragmentsPolicy.NONE) {
            lineFragments = ComparisonManagerImpl.createInnerFragments(lineFragments, text1, text2, ComparisonPolicy.DEFAULT, fragmentsPolicy, indicator);
        }
        List list2 = ContainerUtil.mapNotNull(lineFragments, fragment -> ComparisonManagerImpl.trimIgnoredInnerFragments(fragment, ignored1, ignored2));
        if (list2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(189);
        }
        return list2;
    }

    @NotNull
    public static BitSet collectIgnoredRanges(@NotNull List<? extends TextRange> ignoredRanges) {
        if (ignoredRanges == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(190);
        }
        BitSet set2 = new BitSet();
        for (TextRange textRange : ignoredRanges) {
            set2.set(textRange.getStartOffset(), textRange.getEndOffset());
        }
        BitSet bitSet = set2;
        if (bitSet == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(191);
        }
        return bitSet;
    }

    @NotNull
    private static FairDiffIterable correctIgnoredRangesSecondStep(@NotNull Range range2, @NotNull FairDiffIterable iterable, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull LineOffsets lineOffsets1, @NotNull LineOffsets lineOffsets2, @NotNull BitSet ignored1, @NotNull BitSet ignored2) {
        if (range2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(192);
        }
        if (iterable == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(193);
        }
        if (text1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(194);
        }
        if (text2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(195);
        }
        if (lineOffsets1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(196);
        }
        if (lineOffsets2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(197);
        }
        if (ignored1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(198);
        }
        if (ignored2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(199);
        }
        DiffIterableUtil.ChangeBuilder builder2 = new DiffIterableUtil.ChangeBuilder(iterable.getLength1(), iterable.getLength2());
        for (Range ch : iterable.iterateUnchanged()) {
            int count = ch.end1 - ch.start1;
            for (int i = 0; i < count; ++i) {
                int index1 = ch.start1 + i;
                int index2 = ch.start2 + i;
                if (!ComparisonManagerImpl.areIgnoredEqualLines(range2.start1 + index1, range2.start2 + index2, text1, text2, lineOffsets1, lineOffsets2, ignored1, ignored2)) continue;
                builder2.markEqual(index1, index2);
            }
        }
        FairDiffIterable fairDiffIterable = DiffIterableUtil.fair(builder2.finish());
        if (fairDiffIterable == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(200);
        }
        return fairDiffIterable;
    }

    @NotNull
    private static DiffIterable trimIgnoredLines(@NotNull Range range2, @NotNull FairDiffIterable iterable, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull LineOffsets lineOffsets1, @NotNull LineOffsets lineOffsets2, @NotNull BitSet ignored1, @NotNull BitSet ignored2) {
        if (range2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(201);
        }
        if (iterable == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(202);
        }
        if (text1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(203);
        }
        if (text2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(204);
        }
        if (lineOffsets1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(205);
        }
        if (lineOffsets2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(206);
        }
        if (ignored1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(207);
        }
        if (ignored2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(208);
        }
        ArrayList<Range> changedRanges = new ArrayList<Range>();
        for (Range ch : iterable.iterateChanges()) {
            Range trimmedRange = TrimUtil.trimExpandRange(ch.start1, ch.start2, ch.end1, ch.end2, (Function2<? super Integer, ? super Integer, Boolean>)((Function2)(index1, index2) -> ComparisonManagerImpl.areIgnoredEqualLines(range2.start1 + index1, range2.start2 + index2, text1, text2, lineOffsets1, lineOffsets2, ignored1, ignored2)), (Function1<? super Integer, Boolean>)((Function1)index -> ComparisonManagerImpl.isIgnoredLine(range2.start1 + index, lineOffsets1, ignored1)), (Function1<? super Integer, Boolean>)((Function1)index -> ComparisonManagerImpl.isIgnoredLine(range2.start2 + index, lineOffsets2, ignored2)));
            if (trimmedRange.isEmpty()) continue;
            changedRanges.add(trimmedRange);
        }
        DiffIterable diffIterable = DiffIterableUtil.create(changedRanges, iterable.getLength1(), iterable.getLength2());
        if (diffIterable == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(209);
        }
        return diffIterable;
    }

    @Nullable
    private static LineFragment trimIgnoredInnerFragments(@NotNull LineFragment fragment, @NotNull BitSet ignored1, @NotNull BitSet ignored2) {
        if (fragment == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(210);
        }
        if (ignored1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(211);
        }
        if (ignored2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(212);
        }
        if (fragment.getInnerFragments() == null) {
            return fragment;
        }
        int startOffset1 = fragment.getStartOffset1();
        int startOffset2 = fragment.getStartOffset2();
        List newInner = ContainerUtil.mapNotNull((Collection)fragment.getInnerFragments(), it -> {
            TextRange range1 = ComparisonManagerImpl.trimIgnoredRange(it.getStartOffset1(), it.getEndOffset1(), ignored1, startOffset1);
            TextRange range2 = ComparisonManagerImpl.trimIgnoredRange(it.getStartOffset2(), it.getEndOffset2(), ignored2, startOffset2);
            if (range1.isEmpty() && range2.isEmpty()) {
                return null;
            }
            return new DiffFragmentImpl(range1.getStartOffset(), range1.getEndOffset(), range2.getStartOffset(), range2.getEndOffset());
        });
        if (newInner.isEmpty()) {
            return null;
        }
        return new LineFragmentImpl(fragment, newInner);
    }

    private static boolean isIgnoredLine(int index, @NotNull LineOffsets lineOffsets, @NotNull BitSet ignored) {
        if (lineOffsets == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(213);
        }
        if (ignored == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(214);
        }
        return ComparisonManagerImpl.isIgnoredRange(ignored, lineOffsets.getLineStart(index), lineOffsets.getLineEnd(index, true));
    }

    private static boolean areIgnoredEqualLines(int index1, int index2, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull LineOffsets lineOffsets1, @NotNull LineOffsets lineOffsets2, @NotNull BitSet ignored1, @NotNull BitSet ignored2) {
        int end2;
        if (text1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(215);
        }
        if (text2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(216);
        }
        if (lineOffsets1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(217);
        }
        if (lineOffsets2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(218);
        }
        if (ignored1 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(219);
        }
        if (ignored2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(220);
        }
        int start1 = lineOffsets1.getLineStart(index1);
        int end1 = lineOffsets1.getLineEnd(index1, true);
        int start2 = lineOffsets2.getLineStart(index2);
        Range range2 = TrimUtil.trimExpandText(text1, text2, start1, start2, end1, end2 = lineOffsets2.getLineEnd(index2, true), ignored1, ignored2);
        if (!range2.isEmpty()) {
            return false;
        }
        List<ByWord.InlineChunk> words1 = ComparisonManagerImpl.getNonIgnoredWords(index1, text1, lineOffsets1, ignored1);
        List<ByWord.InlineChunk> words2 = ComparisonManagerImpl.getNonIgnoredWords(index2, text2, lineOffsets2, ignored2);
        if (words1.size() != words2.size()) {
            return false;
        }
        for (int i = 0; i < words1.size(); ++i) {
            CharSequence word2;
            CharSequence word1 = ComparisonManagerImpl.getWordContent(index1, text1, lineOffsets1, words1.get(i));
            if (StringUtil.equals((CharSequence)word1, (CharSequence)(word2 = ComparisonManagerImpl.getWordContent(index2, text2, lineOffsets2, words2.get(i))))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static List<ByWord.InlineChunk> getNonIgnoredWords(int index, @NotNull CharSequence text, @NotNull LineOffsets lineOffsets, @NotNull BitSet ignored) {
        if (text == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(221);
        }
        if (lineOffsets == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(222);
        }
        if (ignored == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(223);
        }
        int offset = lineOffsets.getLineStart(index);
        List<ByWord.InlineChunk> innerChunks = ByWord.getInlineChunks(ComparisonManagerImpl.getLineContent(index, text, lineOffsets));
        List list2 = ContainerUtil.filter(innerChunks, it -> it instanceof ByWord.WordChunk && !ComparisonManagerImpl.isIgnoredRange(ignored, offset + it.getOffset1(), offset + it.getOffset2()));
        if (list2 == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(224);
        }
        return list2;
    }

    @NotNull
    private static CharSequence getWordContent(int index, @NotNull CharSequence text, @NotNull LineOffsets lineOffsets, @NotNull ByWord.InlineChunk word) {
        if (text == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(225);
        }
        if (lineOffsets == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(226);
        }
        if (word == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(227);
        }
        CharSequence charSequence = ComparisonManagerImpl.getLineContent(index, text, lineOffsets).subSequence(word.getOffset1(), word.getOffset2());
        if (charSequence == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(228);
        }
        return charSequence;
    }

    @NotNull
    private static TextRange trimIgnoredRange(int start2, int end, @NotNull BitSet ignored, int offset) {
        if (ignored == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(229);
        }
        IntPair intPair = TrimUtil.trim(offset + start2, offset + end, ignored);
        TextRange textRange = new TextRange(intPair.val1 - offset, intPair.val2 - offset);
        if (textRange == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(230);
        }
        return textRange;
    }

    private static boolean isIgnoredRange(@NotNull BitSet ignored, int start2, int end) {
        if (ignored == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(231);
        }
        return ignored.nextClearBit(start2) >= end;
    }

    @NotNull
    private static CharSequence getLineContent(int index, @NotNull CharSequence text, @NotNull LineOffsets lineOffsets) {
        if (text == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(232);
        }
        if (lineOffsets == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(233);
        }
        CharSequence charSequence = text.subSequence(lineOffsets.getLineStart(index), lineOffsets.getLineEnd(index, true));
        if (charSequence == null) {
            ComparisonManagerImpl.$$$reportNull$$$0(234);
        }
        return charSequence;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 126: 
            case 129: 
            case 131: 
            case 133: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 152: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 162: 
            case 164: 
            case 165: 
            case 167: 
            case 168: 
            case 169: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 178: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 190: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 208: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 216: 
            case 217: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 225: 
            case 226: 
            case 227: 
            case 229: 
            case 231: 
            case 232: 
            case 233: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 126: 
            case 129: 
            case 131: 
            case 133: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 152: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 162: 
            case 164: 
            case 165: 
            case 167: 
            case 168: 
            case 169: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 178: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 190: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 208: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 216: 
            case 217: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 225: 
            case 226: 
            case 227: 
            case 229: 
            case 231: 
            case 232: 
            case 233: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/comparison/ComparisonManagerImpl";
                break;
            }
            case 1: 
            case 6: 
            case 14: 
            case 21: 
            case 27: 
            case 33: 
            case 38: 
            case 48: 
            case 56: 
            case 66: 
            case 72: 
            case 95: 
            case 100: 
            case 106: 
            case 111: 
            case 116: 
            case 137: 
            case 146: 
            case 171: 
            case 181: 
            case 194: 
            case 203: 
            case 215: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text1";
                break;
            }
            case 2: 
            case 7: 
            case 15: 
            case 22: 
            case 28: 
            case 34: 
            case 39: 
            case 49: 
            case 57: 
            case 67: 
            case 73: 
            case 96: 
            case 101: 
            case 107: 
            case 112: 
            case 117: 
            case 138: 
            case 147: 
            case 172: 
            case 182: 
            case 195: 
            case 204: 
            case 216: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text2";
                break;
            }
            case 3: 
            case 10: 
            case 18: 
            case 24: 
            case 30: 
            case 35: 
            case 42: 
            case 52: 
            case 60: 
            case 68: 
            case 74: 
            case 86: 
            case 92: 
            case 97: 
            case 103: 
            case 108: 
            case 113: 
            case 118: 
            case 139: 
            case 148: {
                objectArray2 = objectArray3;
                objectArray3[0] = "policy";
                break;
            }
            case 4: 
            case 11: 
            case 19: 
            case 25: 
            case 31: 
            case 36: 
            case 44: 
            case 53: 
            case 62: 
            case 70: 
            case 76: 
            case 87: 
            case 93: 
            case 98: 
            case 104: 
            case 109: 
            case 114: 
            case 178: 
            case 188: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 8: 
            case 16: 
            case 40: 
            case 50: 
            case 58: 
            case 122: 
            case 173: 
            case 183: 
            case 196: 
            case 205: 
            case 217: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineOffsets1";
                break;
            }
            case 9: 
            case 17: 
            case 41: 
            case 51: 
            case 59: 
            case 123: 
            case 174: 
            case 184: 
            case 197: 
            case 206: 
            case 218: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineOffsets2";
                break;
            }
            case 13: 
            case 47: 
            case 55: 
            case 121: 
            case 180: 
            case 192: 
            case 201: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 23: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text3";
                break;
            }
            case 43: 
            case 61: 
            case 69: 
            case 75: 
            case 177: 
            case 187: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragmentsPolicy";
                break;
            }
            case 65: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineFragments";
                break;
            }
            case 71: 
            case 83: 
            case 89: 
            case 210: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
            case 84: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subSequence1";
                break;
            }
            case 85: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subSequence2";
                break;
            }
            case 119: 
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 126: 
            case 165: 
            case 168: 
            case 213: 
            case 222: 
            case 226: 
            case 233: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineOffsets";
                break;
            }
            case 129: 
            case 131: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 133: 
            case 136: 
            case 143: 
            case 152: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldFragments";
                break;
            }
            case 144: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 145: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragments";
                break;
            }
            case 155: 
            case 157: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeFragment";
                break;
            }
            case 156: 
            case 158: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterFragment";
                break;
            }
            case 159: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineFragment";
                break;
            }
            case 162: 
            case 164: 
            case 167: 
            case 221: 
            case 225: 
            case 232: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 169: 
            case 214: 
            case 223: 
            case 229: 
            case 231: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignored";
                break;
            }
            case 175: 
            case 185: 
            case 198: 
            case 207: 
            case 211: 
            case 219: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignored1";
                break;
            }
            case 176: 
            case 186: 
            case 199: 
            case 208: 
            case 212: 
            case 220: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignored2";
                break;
            }
            case 190: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoredRanges";
                break;
            }
            case 193: 
            case 202: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterable";
                break;
            }
            case 227: {
                objectArray2 = objectArray3;
                objectArray3[0] = "word";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstanceImpl";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 126: 
            case 129: 
            case 131: 
            case 133: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 152: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 162: 
            case 164: 
            case 165: 
            case 167: 
            case 168: 
            case 169: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 178: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 190: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 208: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 216: 
            case 217: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 225: 
            case 226: 
            case 227: 
            case 229: 
            case 231: 
            case 232: 
            case 233: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/comparison/ComparisonManagerImpl";
                break;
            }
            case 5: 
            case 12: 
            case 20: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "compareLines";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeLines";
                break;
            }
            case 37: 
            case 45: 
            case 46: 
            case 54: 
            case 63: 
            case 64: 
            case 105: {
                objectArray = objectArray2;
                objectArray2[1] = "compareLinesInner";
                break;
            }
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "createInnerFragments";
                break;
            }
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "createInnerWordFragments";
                break;
            }
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "createInnerCharFragments";
                break;
            }
            case 99: {
                objectArray = objectArray2;
                objectArray2[1] = "doCompareChars";
                break;
            }
            case 110: {
                objectArray = objectArray2;
                objectArray2[1] = "compareWords";
                break;
            }
            case 115: {
                objectArray = objectArray2;
                objectArray2[1] = "compareChars";
                break;
            }
            case 120: {
                objectArray = objectArray2;
                objectArray2[1] = "convertIntoDiffFragments";
                break;
            }
            case 125: {
                objectArray = objectArray2;
                objectArray2[1] = "convertIntoLineFragments";
                break;
            }
            case 127: 
            case 128: {
                objectArray = objectArray2;
                objectArray2[1] = "getOffsets";
                break;
            }
            case 130: {
                objectArray = objectArray2;
                objectArray2[1] = "convertIntoMergeLineFragments";
                break;
            }
            case 132: {
                objectArray = objectArray2;
                objectArray2[1] = "convertIntoMergeWordFragments";
                break;
            }
            case 134: 
            case 135: {
                objectArray = objectArray2;
                objectArray2[1] = "squash";
                break;
            }
            case 140: 
            case 141: 
            case 142: {
                objectArray = objectArray2;
                objectArray2[1] = "processBlocks";
                break;
            }
            case 149: 
            case 150: 
            case 151: {
                objectArray = objectArray2;
                objectArray2[1] = "processAdjoining";
                break;
            }
            case 153: 
            case 154: {
                objectArray = objectArray2;
                objectArray2[1] = "doSquash";
                break;
            }
            case 160: 
            case 161: {
                objectArray = objectArray2;
                objectArray2[1] = "extractInnerFragments";
                break;
            }
            case 163: 
            case 166: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineContents";
                break;
            }
            case 170: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotIgnoredLineContents";
                break;
            }
            case 179: 
            case 189: {
                objectArray = objectArray2;
                objectArray2[1] = "compareLinesWithIgnoredRanges";
                break;
            }
            case 191: {
                objectArray = objectArray2;
                objectArray2[1] = "collectIgnoredRanges";
                break;
            }
            case 200: {
                objectArray = objectArray2;
                objectArray2[1] = "correctIgnoredRangesSecondStep";
                break;
            }
            case 209: {
                objectArray = objectArray2;
                objectArray2[1] = "trimIgnoredLines";
                break;
            }
            case 224: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonIgnoredWords";
                break;
            }
            case 228: {
                objectArray = objectArray2;
                objectArray2[1] = "getWordContent";
                break;
            }
            case 230: {
                objectArray = objectArray2;
                objectArray2[1] = "trimIgnoredRange";
                break;
            }
            case 234: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineContent";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "compareLines";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "mergeLines";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "compareLinesInner";
                break;
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "createInnerFragments";
                break;
            }
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "createInnerWordFragments";
                break;
            }
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "createInnerCharFragments";
                break;
            }
            case 95: 
            case 96: 
            case 97: 
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "doCompareChars";
                break;
            }
            case 106: 
            case 107: 
            case 108: 
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "compareWords";
                break;
            }
            case 111: 
            case 112: 
            case 113: 
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "compareChars";
                break;
            }
            case 116: 
            case 117: 
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "isEquals";
                break;
            }
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "convertIntoDiffFragments";
                break;
            }
            case 121: 
            case 122: 
            case 123: 
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "convertIntoLineFragments";
                break;
            }
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "getOffsets";
                break;
            }
            case 129: {
                objectArray = objectArray;
                objectArray[2] = "convertIntoMergeLineFragments";
                break;
            }
            case 131: {
                objectArray = objectArray;
                objectArray[2] = "convertIntoMergeWordFragments";
                break;
            }
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "squash";
                break;
            }
            case 136: 
            case 137: 
            case 138: 
            case 139: {
                objectArray = objectArray;
                objectArray[2] = "processBlocks";
                break;
            }
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: {
                objectArray = objectArray;
                objectArray[2] = "processAdjoining";
                break;
            }
            case 152: {
                objectArray = objectArray;
                objectArray[2] = "doSquash";
                break;
            }
            case 155: 
            case 156: {
                objectArray = objectArray;
                objectArray[2] = "isAdjoining";
                break;
            }
            case 157: 
            case 158: {
                objectArray = objectArray;
                objectArray[2] = "isAdjoiningInner";
                break;
            }
            case 159: {
                objectArray = objectArray;
                objectArray[2] = "extractInnerFragments";
                break;
            }
            case 162: 
            case 164: 
            case 165: {
                objectArray = objectArray;
                objectArray[2] = "getLineContents";
                break;
            }
            case 167: 
            case 168: 
            case 169: {
                objectArray = objectArray;
                objectArray[2] = "getNotIgnoredLineContents";
                break;
            }
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 178: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: {
                objectArray = objectArray;
                objectArray[2] = "compareLinesWithIgnoredRanges";
                break;
            }
            case 190: {
                objectArray = objectArray;
                objectArray[2] = "collectIgnoredRanges";
                break;
            }
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: {
                objectArray = objectArray;
                objectArray[2] = "correctIgnoredRangesSecondStep";
                break;
            }
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 208: {
                objectArray = objectArray;
                objectArray[2] = "trimIgnoredLines";
                break;
            }
            case 210: 
            case 211: 
            case 212: {
                objectArray = objectArray;
                objectArray[2] = "trimIgnoredInnerFragments";
                break;
            }
            case 213: 
            case 214: {
                objectArray = objectArray;
                objectArray[2] = "isIgnoredLine";
                break;
            }
            case 215: 
            case 216: 
            case 217: 
            case 218: 
            case 219: 
            case 220: {
                objectArray = objectArray;
                objectArray[2] = "areIgnoredEqualLines";
                break;
            }
            case 221: 
            case 222: 
            case 223: {
                objectArray = objectArray;
                objectArray[2] = "getNonIgnoredWords";
                break;
            }
            case 225: 
            case 226: 
            case 227: {
                objectArray = objectArray;
                objectArray[2] = "getWordContent";
                break;
            }
            case 229: {
                objectArray = objectArray;
                objectArray[2] = "trimIgnoredRange";
                break;
            }
            case 231: {
                objectArray = objectArray;
                objectArray[2] = "isIgnoredRange";
                break;
            }
            case 232: 
            case 233: {
                objectArray = objectArray;
                objectArray[2] = "getLineContent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 126: 
            case 129: 
            case 131: 
            case 133: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 152: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 162: 
            case 164: 
            case 165: 
            case 167: 
            case 168: 
            case 169: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 178: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 190: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 208: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 216: 
            case 217: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 225: 
            case 226: 
            case 227: 
            case 229: 
            case 231: 
            case 232: 
            case 233: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

