/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation.actions;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.actions.BaseCodeInsightAction;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.codeInsight.navigation.actions.GotoDeclarationHandler;
import com.intellij.diagnostic.PluginException;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.find.actions.ShowUsagesAction;
import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.ide.util.EditSourceUtil;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorGutter;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.awt.RelativePoint;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoDeclarationAction
extends BaseCodeInsightAction
implements CodeInsightActionHandler,
DumbAware {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.navigation.actions.GotoDeclarationAction");

    @NotNull
    protected CodeInsightActionHandler getHandler() {
        GotoDeclarationAction gotoDeclarationAction = this;
        if (gotoDeclarationAction == null) {
            GotoDeclarationAction.$$$reportNull$$$0(0);
        }
        return gotoDeclarationAction;
    }

    @Override
    protected boolean isValidForLookup() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project == null) {
            GotoDeclarationAction.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            GotoDeclarationAction.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            GotoDeclarationAction.$$$reportNull$$$0(3);
        }
        DumbService.getInstance((Project)project).setAlternativeResolveEnabled(true);
        try {
            int offset = editor.getCaretModel().getOffset();
            PsiElement[] elements = (PsiElement[])GotoDeclarationAction.underModalProgress(project, "Resolving Reference...", () -> GotoDeclarationAction.findAllTargetElements(project, editor, offset));
            FeatureUsageTracker.getInstance().triggerFeatureUsed("navigation.goto.declaration");
            if (elements.length != 1) {
                if (elements.length == 0 && GotoDeclarationAction.suggestCandidates(TargetElementUtil.findReference(editor, offset)).isEmpty()) {
                    PsiElement element = GotoDeclarationAction.findElementToShowUsagesOf(editor, editor.getCaretModel().getOffset());
                    if (GotoDeclarationAction.startFindUsages(editor, project, element)) {
                        return;
                    }
                    if (GotoDeclarationAction.isKeywordUnderCaret(project, file2, offset)) {
                        return;
                    }
                }
                GotoDeclarationAction.chooseAmbiguousTarget(editor, offset, elements, file2);
                return;
            }
            PsiElement element = elements[0];
            if (element == GotoDeclarationAction.findElementToShowUsagesOf(editor, editor.getCaretModel().getOffset()) && GotoDeclarationAction.startFindUsages(editor, project, element)) {
                return;
            }
            PsiElement navElement = element.getNavigationElement();
            navElement = TargetElementUtil.getInstance().getGotoDeclarationTarget(element, navElement);
            if (navElement != null) {
                GotoDeclarationAction.gotoTargetElement(navElement, editor, file2);
            }
        }
        catch (IndexNotReadyException e) {
            DumbService.getInstance((Project)project).showDumbModeNotification("Navigation is not available here during index update");
        }
        finally {
            DumbService.getInstance((Project)project).setAlternativeResolveEnabled(false);
        }
    }

    private static boolean startFindUsages(@NotNull Editor editor, @NotNull Project project, PsiElement element) {
        if (editor == null) {
            GotoDeclarationAction.$$$reportNull$$$0(4);
        }
        if (project == null) {
            GotoDeclarationAction.$$$reportNull$$$0(5);
        }
        if (element == null) {
            return false;
        }
        if (DumbService.getInstance((Project)project).isDumb()) {
            AnAction action = ActionManager.getInstance().getAction("ShowUsages");
            String name = action.getTemplatePresentation().getText();
            DumbService.getInstance((Project)project).showDumbModeNotification(ActionUtil.getUnavailableMessage((String)name, (boolean)false));
        } else {
            RelativePoint popupPosition = JBPopupFactory.getInstance().guessBestPopupLocation(editor);
            new ShowUsagesAction().startFindUsages(element, popupPosition, editor, ShowUsagesAction.getUsagesPageSize());
        }
        return true;
    }

    static <T> T underModalProgress(@NotNull Project project, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String progressTitle, @NotNull Computable<T> computable) throws ProcessCanceledException {
        if (project == null) {
            GotoDeclarationAction.$$$reportNull$$$0(6);
        }
        if (progressTitle == null) {
            GotoDeclarationAction.$$$reportNull$$$0(7);
        }
        if (computable == null) {
            GotoDeclarationAction.$$$reportNull$$$0(8);
        }
        return (T)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            DumbService.getInstance((Project)project).setAlternativeResolveEnabled(true);
            try {
                Object object = ApplicationManager.getApplication().runReadAction(computable);
                return object;
            }
            finally {
                DumbService.getInstance((Project)project).setAlternativeResolveEnabled(false);
            }
        }, progressTitle, true, project);
    }

    public static PsiElement findElementToShowUsagesOf(@NotNull Editor editor, int offset) {
        if (editor == null) {
            GotoDeclarationAction.$$$reportNull$$$0(9);
        }
        return TargetElementUtil.getInstance().findTargetElement(editor, 2, offset);
    }

    private static void chooseAmbiguousTarget(Editor editor, int offset, PsiElement[] elements, PsiFile currentFile) {
        if (!editor.getComponent().isShowing()) {
            return;
        }
        PsiElementProcessor navigateProcessor = element -> {
            GotoDeclarationAction.gotoTargetElement(element, editor, currentFile);
            return true;
        };
        boolean found = GotoDeclarationAction.chooseAmbiguousTarget(editor, offset, (PsiElementProcessor<? super PsiElement>)navigateProcessor, CodeInsightBundle.message((String)"declaration.navigation.title", (Object[])new Object[0]), elements);
        if (!found) {
            HintManager.getInstance().showErrorHint(editor, "Cannot find declaration to go to");
        }
    }

    private static boolean navigateInCurrentEditor(@NotNull PsiElement element, @NotNull PsiFile currentFile, @NotNull Editor currentEditor) {
        int offset;
        PsiElement leaf;
        if (element == null) {
            GotoDeclarationAction.$$$reportNull$$$0(10);
        }
        if (currentFile == null) {
            GotoDeclarationAction.$$$reportNull$$$0(11);
        }
        if (currentEditor == null) {
            GotoDeclarationAction.$$$reportNull$$$0(12);
        }
        if (element.getContainingFile() == currentFile && !currentEditor.isDisposed() && (leaf = currentFile.findElementAt(offset = element.getTextOffset())) != null && PsiTreeUtil.isAncestor((PsiElement)element, (PsiElement)leaf, (boolean)false)) {
            Project project = element.getProject();
            CommandProcessor.getInstance().executeCommand(project, () -> {
                IdeDocumentHistory.getInstance(project).includeCurrentCommandAsNavigation();
                new OpenFileDescriptor(project, currentFile.getViewProvider().getVirtualFile(), offset).navigateIn(currentEditor);
            }, "", null);
            return true;
        }
        return false;
    }

    private static void gotoTargetElement(@NotNull PsiElement element, @NotNull Editor currentEditor, @NotNull PsiFile currentFile) {
        Navigatable navigatable;
        if (element == null) {
            GotoDeclarationAction.$$$reportNull$$$0(13);
        }
        if (currentEditor == null) {
            GotoDeclarationAction.$$$reportNull$$$0(14);
        }
        if (currentFile == null) {
            GotoDeclarationAction.$$$reportNull$$$0(15);
        }
        if (GotoDeclarationAction.navigateInCurrentEditor(element, currentFile, currentEditor)) {
            return;
        }
        Navigatable navigatable2 = navigatable = element instanceof Navigatable ? (Navigatable)element : EditSourceUtil.getDescriptor((PsiElement)element);
        if (navigatable != null && navigatable.canNavigate()) {
            navigatable.navigate(true);
        }
    }

    public static boolean chooseAmbiguousTarget(@NotNull Editor editor, int offset, @NotNull PsiElementProcessor<? super PsiElement> processor2, @NotNull String titlePattern, @Nullable PsiElement[] elements) {
        if (editor == null) {
            GotoDeclarationAction.$$$reportNull$$$0(16);
        }
        if (processor2 == null) {
            GotoDeclarationAction.$$$reportNull$$$0(17);
        }
        if (titlePattern == null) {
            GotoDeclarationAction.$$$reportNull$$$0(18);
        }
        if (TargetElementUtil.inVirtualSpace(editor, offset)) {
            return false;
        }
        PsiReference reference = TargetElementUtil.findReference(editor, offset);
        if (elements == null || elements.length == 0) {
            PsiElement[] psiElementArray = elements = reference == null ? PsiElement.EMPTY_ARRAY : PsiUtilCore.toPsiElementArray((Collection)((Collection)GotoDeclarationAction.underModalProgress(reference.getElement().getProject(), "Resolving Reference...", () -> GotoDeclarationAction.suggestCandidates(reference))));
        }
        if (elements.length == 1) {
            PsiElement element = elements[0];
            LOG.assertTrue(element != null);
            processor2.execute(element);
            return true;
        }
        if (elements.length > 1) {
            String title;
            if (reference == null) {
                title = titlePattern;
            } else {
                TextRange range2 = reference.getRangeInElement();
                String elementText = reference.getElement().getText();
                LOG.assertTrue(range2.getStartOffset() >= 0 && range2.getEndOffset() <= elementText.length(), (Object)(Arrays.toString(elements) + ";" + reference));
                String refText = range2.substring(elementText);
                title = MessageFormat.format(titlePattern, refText);
            }
            NavigationUtil.getPsiElementPopup((PsiElement[])elements, (PsiElementListCellRenderer)new DefaultPsiElementCellRenderer(), (String)title, processor2).showInBestPositionFor(editor);
            return true;
        }
        return false;
    }

    @NotNull
    private static Collection<PsiElement> suggestCandidates(@Nullable PsiReference reference) {
        if (reference == null) {
            List<PsiElement> list2 = Collections.emptyList();
            if (list2 == null) {
                GotoDeclarationAction.$$$reportNull$$$0(19);
            }
            return list2;
        }
        Collection<PsiElement> collection = TargetElementUtil.getInstance().getTargetCandidates(reference);
        if (collection == null) {
            GotoDeclarationAction.$$$reportNull$$$0(20);
        }
        return collection;
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Nullable
    public static PsiElement findTargetElement(Project project, Editor editor, int offset) {
        PsiElement[] targets2 = GotoDeclarationAction.findAllTargetElements(project, editor, offset);
        return targets2.length == 1 ? targets2[0] : null;
    }

    @NotNull
    @VisibleForTesting
    public static PsiElement[] findAllTargetElements(Project project, Editor editor, int offset) {
        if (TargetElementUtil.inVirtualSpace(editor, offset)) {
            if (PsiElement.EMPTY_ARRAY == null) {
                GotoDeclarationAction.$$$reportNull$$$0(21);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement[] targets2 = GotoDeclarationAction.findTargetElementsNoVS(project, editor, offset, true);
        PsiElement[] psiElementArray = targets2 != null ? targets2 : PsiElement.EMPTY_ARRAY;
        if (psiElementArray == null) {
            GotoDeclarationAction.$$$reportNull$$$0(22);
        }
        return psiElementArray;
    }

    @Nullable
    static PsiElement[] findTargetElementsFromProviders(@NotNull Project project, @NotNull Editor editor, int offset) {
        if (project == null) {
            GotoDeclarationAction.$$$reportNull$$$0(23);
        }
        if (editor == null) {
            GotoDeclarationAction.$$$reportNull$$$0(24);
        }
        Document document = editor.getDocument();
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (file2 == null) {
            return null;
        }
        PsiElement elementAt = file2.findElementAt(TargetElementUtil.adjustOffset(file2, document, offset));
        for (GotoDeclarationHandler handler2 : GotoDeclarationHandler.EP_NAME.getExtensionList()) {
            PsiElement[] result2 = handler2.getGotoDeclarationTargets(elementAt, offset, editor);
            if (result2 == null || result2.length <= 0) continue;
            return GotoDeclarationAction.assertNotNullElements(result2, handler2.getClass()) ? result2 : null;
        }
        return PsiElement.EMPTY_ARRAY;
    }

    @Nullable
    public static PsiElement[] findTargetElementsNoVS(Project project, Editor editor, int offset, boolean lookupAccepted) {
        PsiElement element;
        PsiElement[] fromProviders = GotoDeclarationAction.findTargetElementsFromProviders(project, editor, offset);
        if (fromProviders == null || fromProviders.length > 0) {
            return fromProviders;
        }
        int flags = TargetElementUtil.getInstance().getAllAccepted() & 0xFFFFFFFD;
        if (!lookupAccepted) {
            flags &= 0xFFFFFFF7;
        }
        if ((element = TargetElementUtil.getInstance().findTargetElement(editor, flags, offset)) != null) {
            return new PsiElement[]{element};
        }
        if (editor instanceof EditorWindow) {
            EditorWindow window = (EditorWindow)editor;
            return GotoDeclarationAction.findTargetElementsNoVS(project, window.getDelegate(), window.getDocument().injectedToHost(offset), lookupAccepted);
        }
        return null;
    }

    @Override
    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            GotoDeclarationAction.$$$reportNull$$$0(25);
        }
        if (event.getProject() == null || event.getData(EditorGutter.KEY) != null || Boolean.TRUE.equals(event.getData(CommonDataKeys.EDITOR_VIRTUAL_SPACE))) {
            event.getPresentation().setEnabled(false);
            return;
        }
        InputEvent inputEvent = event.getInputEvent();
        Editor editor = (Editor)event.getData(CommonDataKeys.EDITOR);
        if (editor != null && inputEvent instanceof MouseEvent && editor.getInlayModel().getElementAt(new RelativePoint((MouseEvent)inputEvent).getPoint((Component)editor.getContentComponent())) != null) {
            event.getPresentation().setEnabled(false);
            return;
        }
        for (GotoDeclarationHandler handler2 : GotoDeclarationHandler.EP_NAME.getExtensionList()) {
            String text = handler2.getActionText(event.getDataContext());
            if (text == null) continue;
            Presentation presentation = event.getPresentation();
            presentation.setText(text);
            break;
        }
        super.update(event);
    }

    static boolean isKeywordUnderCaret(@NotNull Project project, @NotNull PsiFile file2, int offset) {
        PsiElement elementAtCaret;
        if (project == null) {
            GotoDeclarationAction.$$$reportNull$$$0(26);
        }
        if (file2 == null) {
            GotoDeclarationAction.$$$reportNull$$$0(27);
        }
        if ((elementAtCaret = file2.findElementAt(offset)) == null) {
            return false;
        }
        NamesValidator namesValidator = (NamesValidator)LanguageNamesValidation.INSTANCE.forLanguage(elementAtCaret.getLanguage());
        return namesValidator != null && namesValidator.isKeyword(elementAtCaret.getText(), project);
    }

    private static boolean assertNotNullElements(@NotNull PsiElement[] result2, Class<?> clazz) {
        if (result2 == null) {
            GotoDeclarationAction.$$$reportNull$$$0(28);
        }
        for (PsiElement element : result2) {
            if (element != null) continue;
            PluginException.logPluginError((Logger)LOG, (String)("Null target element is returned by 'getGotoDeclarationTargets' in " + clazz.getName()), null, clazz);
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/navigation/actions/GotoDeclarationAction";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 9: 
            case 16: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressTitle";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentFile";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentEditor";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "titlePattern";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHandler";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/navigation/actions/GotoDeclarationAction";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestCandidates";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllTargetElements";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "startFindUsages";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "underModalProgress";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findElementToShowUsagesOf";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "navigateInCurrentEditor";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "gotoTargetElement";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "chooseAmbiguousTarget";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "findTargetElementsFromProviders";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isKeywordUnderCaret";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "assertNotNullElements";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

