/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.folding.impl.EditorFoldingInfo;
import com.intellij.codeInsight.folding.impl.FoldingUpdate;
import com.intellij.codeInsight.folding.impl.FoldingUtil;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.impl.FoldingModelImpl;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;

class UpdateFoldRegionsOperation
implements Runnable {
    private static final Logger LOG = Logger.getInstance(UpdateFoldRegionsOperation.class);
    private static final Key<Boolean> CAN_BE_REMOVED_WHEN_COLLAPSED = Key.create((String)"canBeRemovedWhenCollapsed");
    static final Key<Boolean> COLLAPSED_BY_DEFAULT = Key.create((String)"collapsedByDefault");
    static final Key<String> SIGNATURE = Key.create((String)"signature");
    static final String NO_SIGNATURE = "no signature";
    private static final Comparator<PsiElement> COMPARE_BY_OFFSET_REVERSED = (element, element1) -> {
        int startOffsetDiff = element1.getTextRange().getStartOffset() - element.getTextRange().getStartOffset();
        return startOffsetDiff == 0 ? element1.getTextRange().getEndOffset() - element.getTextRange().getEndOffset() : startOffsetDiff;
    };
    private final Project myProject;
    private final Editor myEditor;
    private final PsiFile myFile;
    @NotNull
    private final ApplyDefaultStateMode myApplyDefaultState;
    private final FoldingMap myElementsToFoldMap;
    private final Set<FoldingUpdate.RegionInfo> myRegionInfos;
    private final MultiMap<FoldingGroup, FoldingUpdate.RegionInfo> myGroupedRegionInfos;
    private final boolean myKeepCollapsedRegions;
    private final boolean myForInjected;

    UpdateFoldRegionsOperation(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2, @NotNull List<FoldingUpdate.RegionInfo> elementsToFold, @NotNull ApplyDefaultStateMode applyDefaultState, boolean keepCollapsedRegions, boolean forInjected) {
        if (project == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(2);
        }
        if (elementsToFold == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(3);
        }
        if (applyDefaultState == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(4);
        }
        this.myElementsToFoldMap = new FoldingMap();
        this.myRegionInfos = new LinkedHashSet<FoldingUpdate.RegionInfo>();
        this.myGroupedRegionInfos = new MultiMap();
        this.myProject = project;
        this.myEditor = editor;
        this.myFile = file2;
        this.myApplyDefaultState = applyDefaultState;
        this.myKeepCollapsedRegions = keepCollapsedRegions;
        this.myForInjected = forInjected;
        for (FoldingUpdate.RegionInfo regionInfo : elementsToFold) {
            this.myElementsToFoldMap.putValue(regionInfo.element, regionInfo);
            this.myRegionInfos.add(regionInfo);
            FoldingGroup group = regionInfo.descriptor.getGroup();
            if (group == null) continue;
            this.myGroupedRegionInfos.putValue((Object)group, (Object)regionInfo);
        }
    }

    @Override
    public void run() {
        EditorFoldingInfo info = EditorFoldingInfo.get(this.myEditor);
        FoldingModelEx foldingModel = (FoldingModelEx)this.myEditor.getFoldingModel();
        THashMap rangeToExpandStatusMap = new THashMap();
        this.removeInvalidRegions(info, foldingModel, (Map<TextRange, Boolean>)rangeToExpandStatusMap);
        THashMap shouldExpand = new THashMap();
        THashMap groupExpand = new THashMap();
        List<FoldRegion> newRegions = this.addNewRegions(info, foldingModel, (Map<TextRange, Boolean>)rangeToExpandStatusMap, (Map<FoldRegion, Boolean>)shouldExpand, (Map<FoldingGroup, Boolean>)groupExpand);
        UpdateFoldRegionsOperation.applyExpandStatus(newRegions, (Map<FoldRegion, Boolean>)shouldExpand, (Map<FoldingGroup, Boolean>)groupExpand);
        foldingModel.clearDocumentRangesModificationStatus();
    }

    private static void applyExpandStatus(@NotNull List<FoldRegion> newRegions, @NotNull Map<FoldRegion, Boolean> shouldExpand, @NotNull Map<FoldingGroup, Boolean> groupExpand) {
        if (newRegions == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(5);
        }
        if (shouldExpand == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(6);
        }
        if (groupExpand == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(7);
        }
        for (FoldRegion region : newRegions) {
            FoldingGroup group = region.getGroup();
            Boolean expanded = group == null ? shouldExpand.get(region) : groupExpand.get(group);
            if (expanded == null) continue;
            region.setExpanded(expanded.booleanValue());
        }
    }

    private List<FoldRegion> addNewRegions(@NotNull EditorFoldingInfo info, @NotNull FoldingModelEx foldingModel, @NotNull Map<TextRange, Boolean> rangeToExpandStatusMap, @NotNull Map<FoldRegion, Boolean> shouldExpand, @NotNull Map<FoldingGroup, Boolean> groupExpand) {
        if (info == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(8);
        }
        if (foldingModel == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(9);
        }
        if (rangeToExpandStatusMap == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(10);
        }
        if (shouldExpand == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(11);
        }
        if (groupExpand == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(12);
        }
        ArrayList<FoldRegion> newRegions = new ArrayList<FoldRegion>();
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)this.myProject);
        for (FoldingUpdate.RegionInfo regionInfo : this.myRegionInfos) {
            boolean expandStatus;
            PsiElement psi;
            ProgressManager.checkCanceled();
            FoldingDescriptor descriptor = regionInfo.descriptor;
            FoldingGroup group = descriptor.getGroup();
            TextRange range2 = descriptor.getRange();
            String placeholder = null;
            try {
                placeholder = descriptor.getPlaceholderText();
            }
            catch (IndexNotReadyException indexNotReadyException) {
                // empty catch block
            }
            if (range2.getEndOffset() > this.myEditor.getDocument().getTextLength()) {
                LOG.error(String.format("Invalid folding descriptor detected (%s). It ends beyond the document range (%d)", descriptor, this.myEditor.getDocument().getTextLength()));
                continue;
            }
            FoldRegion region = foldingModel.createFoldRegion(range2.getStartOffset(), range2.getEndOffset(), placeholder == null ? "..." : placeholder, group, descriptor.isNonExpandable());
            if (region == null) continue;
            if (descriptor.isNonExpandable()) {
                region.putUserData(FoldingModelImpl.SELECT_REGION_ON_CARET_NEARBY, (Object)Boolean.TRUE);
            }
            if ((psi = descriptor.getElement().getPsi()) == null || !psi.isValid() || !this.myFile.isValid()) {
                region.dispose();
                continue;
            }
            region.setGutterMarkEnabledForSingleLine(descriptor.isGutterMarkEnabledForSingleLine());
            if (descriptor.canBeRemovedWhenCollapsed()) {
                region.putUserData(CAN_BE_REMOVED_WHEN_COLLAPSED, (Object)Boolean.TRUE);
            }
            region.putUserData(COLLAPSED_BY_DEFAULT, (Object)regionInfo.collapsedByDefault);
            region.putUserData(SIGNATURE, ObjectUtils.chooseNotNull((Object)regionInfo.signature, (Object)NO_SIGNATURE));
            info.addRegion(region, smartPointerManager.createSmartPsiElementPointer(psi));
            newRegions.add(region);
            boolean bl = expandStatus = !descriptor.isNonExpandable() && this.shouldExpandNewRegion(range2, rangeToExpandStatusMap, regionInfo.collapsedByDefault);
            if (group == null) {
                shouldExpand.put(region, expandStatus);
                continue;
            }
            Boolean alreadyExpanded = groupExpand.get(group);
            groupExpand.put(group, alreadyExpanded == null ? expandStatus : alreadyExpanded != false || expandStatus);
        }
        return newRegions;
    }

    private boolean shouldExpandNewRegion(TextRange range2, Map<TextRange, Boolean> rangeToExpandStatusMap, boolean collapsedByDefault) {
        if (this.myApplyDefaultState != ApplyDefaultStateMode.NO) {
            TextRange lineRange;
            if (this.myApplyDefaultState == ApplyDefaultStateMode.EXCEPT_CARET_REGION && (lineRange = OpenFileDescriptor.getRangeToUnfoldOnNavigation((Editor)this.myEditor)).intersects(range2)) {
                return true;
            }
            return !collapsedByDefault;
        }
        Boolean oldStatus = rangeToExpandStatusMap.get(range2);
        return oldStatus == null || FoldingUtil.caretInsideRange(this.myEditor, range2) || oldStatus != false;
    }

    private void removeInvalidRegions(@NotNull EditorFoldingInfo info, @NotNull FoldingModelEx foldingModel, @NotNull Map<TextRange, Boolean> rangeToExpandStatusMap) {
        if (info == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(13);
        }
        if (foldingModel == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(14);
        }
        if (rangeToExpandStatusMap == null) {
            UpdateFoldRegionsOperation.$$$reportNull$$$0(15);
        }
        ArrayList<FoldRegion> toRemove2 = new ArrayList<FoldRegion>();
        Ref infoRef = Ref.create();
        HashSet<FoldingGroup> processedGroups = new HashSet<FoldingGroup>();
        ArrayList<FoldingUpdate.RegionInfo> matchedInfos = new ArrayList<FoldingUpdate.RegionInfo>();
        for (FoldRegion region : foldingModel.getAllFoldRegions()) {
            FoldingGroup group = region.getGroup();
            if (group != null && !processedGroups.add(group)) continue;
            List<FoldRegion> regionsToProcess = group == null ? Collections.singletonList(region) : foldingModel.getGroupedRegions(group);
            matchedInfos.clear();
            boolean shouldRemove = false;
            for (FoldRegion foldRegion : regionsToProcess) {
                if (this.shouldRemoveRegion(foldRegion, info, rangeToExpandStatusMap, (Ref<? super FoldingUpdate.RegionInfo>)infoRef)) {
                    shouldRemove = true;
                }
                FoldingUpdate.RegionInfo regionInfo = (FoldingUpdate.RegionInfo)infoRef.get();
                matchedInfos.add(regionInfo);
            }
            if (!shouldRemove && group != null) {
                FoldingGroup requestedGroup = null;
                for (FoldingUpdate.RegionInfo matchedInfo : matchedInfos) {
                    if (matchedInfo == null) {
                        shouldRemove = true;
                        break;
                    }
                    FoldingGroup g = matchedInfo.descriptor.getGroup();
                    if (g == null) {
                        shouldRemove = true;
                        break;
                    }
                    if (requestedGroup == null) {
                        requestedGroup = g;
                        continue;
                    }
                    if (requestedGroup.equals(g)) continue;
                    shouldRemove = true;
                    break;
                }
                if (this.myGroupedRegionInfos.get(requestedGroup).size() != matchedInfos.size()) {
                    shouldRemove = true;
                }
            }
            if (shouldRemove) {
                for (FoldRegion foldRegion : regionsToProcess) {
                    rangeToExpandStatusMap.putIfAbsent(TextRange.create((Segment)foldRegion), foldRegion.isExpanded());
                }
                toRemove2.addAll(regionsToProcess);
                continue;
            }
            for (FoldingUpdate.RegionInfo regionInfo : matchedInfos) {
                if (regionInfo == null) continue;
                this.myElementsToFoldMap.remove(regionInfo.element, regionInfo);
                this.myRegionInfos.remove(regionInfo);
            }
        }
        for (FoldRegion region : toRemove2) {
            foldingModel.removeFoldRegion(region);
            info.removeRegion(region);
        }
    }

    private boolean shouldRemoveRegion(FoldRegion region, EditorFoldingInfo info, Map<TextRange, Boolean> rangeToExpandStatusMap, Ref<? super FoldingUpdate.RegionInfo> matchingInfo) {
        Collection regionInfos;
        matchingInfo.set(null);
        PsiElement element = info.getPsiElement(region);
        if (element != null) {
            PsiFile containingFile = element.getContainingFile();
            boolean isInjected = InjectedLanguageManager.getInstance((Project)this.myProject).isInjectedFragment(containingFile);
            if (isInjected != this.myForInjected) {
                return false;
            }
        }
        boolean forceKeepRegion = this.myKeepCollapsedRegions && region.isValid() && !region.isExpanded() && !this.regionOrGroupCanBeRemovedWhenCollapsed(region);
        Boolean storedCollapsedByDefault = (Boolean)region.getUserData(COLLAPSED_BY_DEFAULT);
        if (element != null && !(regionInfos = this.myElementsToFoldMap.get(element)).isEmpty()) {
            FoldingUpdate.RegionInfo[] array = regionInfos.toArray(new FoldingUpdate.RegionInfo[0]);
            for (FoldingUpdate.RegionInfo regionInfo : array) {
                FoldingDescriptor descriptor = regionInfo.descriptor;
                TextRange range2 = descriptor.getRange();
                if (!TextRange.areSegmentsEqual((Segment)region, (Segment)range2)) continue;
                if (!(forceKeepRegion || region.isValid() && region.getPlaceholderText().equals(descriptor.getPlaceholderText()) && range2.getLength() >= 2)) {
                    return true;
                }
                if (storedCollapsedByDefault != null && storedCollapsedByDefault != regionInfo.collapsedByDefault) {
                    rangeToExpandStatusMap.put(range2, !regionInfo.collapsedByDefault);
                    return true;
                }
                matchingInfo.set((Object)regionInfo);
                return false;
            }
            if (!forceKeepRegion) {
                for (FoldingUpdate.RegionInfo regionInfo : regionInfos) {
                    rangeToExpandStatusMap.put(regionInfo.descriptor.getRange(), region.isExpanded());
                }
                return true;
            }
        } else if (!(forceKeepRegion || region.isValid() && region.getUserData(SIGNATURE) == null)) {
            return true;
        }
        return false;
    }

    private boolean regionOrGroupCanBeRemovedWhenCollapsed(FoldRegion region) {
        FoldingGroup group = region.getGroup();
        List<FoldRegion> affectedRegions = group != null && this.myEditor instanceof EditorEx ? ((EditorEx)this.myEditor).getFoldingModel().getGroupedRegions(group) : Collections.singletonList(region);
        for (FoldRegion affectedRegion : affectedRegions) {
            if (!this.regionCanBeRemovedWhenCollapsed(affectedRegion)) continue;
            return true;
        }
        return false;
    }

    private boolean regionCanBeRemovedWhenCollapsed(FoldRegion region) {
        return Boolean.TRUE.equals(region.getUserData(CAN_BE_REMOVED_WHEN_COLLAPSED)) || ((FoldingModelEx)this.myEditor.getFoldingModel()).hasDocumentRegionChangedFor(region) || !region.isValid() || this.isRegionInCaretLine(region);
    }

    private boolean isRegionInCaretLine(FoldRegion region) {
        int regionStartLine = this.myEditor.getDocument().getLineNumber(region.getStartOffset());
        int regionEndLine = this.myEditor.getDocument().getLineNumber(region.getEndOffset());
        int caretLine = this.myEditor.getCaretModel().getLogicalPosition().line;
        return caretLine >= regionStartLine && caretLine <= regionEndLine;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsToFold";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applyDefaultState";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRegions";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shouldExpand";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupExpand";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foldingModel";
                break;
            }
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeToExpandStatusMap";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/folding/impl/UpdateFoldRegionsOperation";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "applyExpandStatus";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "addNewRegions";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "removeInvalidRegions";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class FoldingMap
    extends MultiMap<PsiElement, FoldingUpdate.RegionInfo> {
        private FoldingMap() {
        }

        @NotNull
        protected Map<PsiElement, Collection<FoldingUpdate.RegionInfo>> createMap() {
            TreeMap<PsiElement, Collection<FoldingUpdate.RegionInfo>> treeMap = new TreeMap<PsiElement, Collection<FoldingUpdate.RegionInfo>>(COMPARE_BY_OFFSET_REVERSED);
            if (treeMap == null) {
                FoldingMap.$$$reportNull$$$0(0);
            }
            return treeMap;
        }

        @NotNull
        protected Collection<FoldingUpdate.RegionInfo> createCollection() {
            ArrayList<FoldingUpdate.RegionInfo> arrayList = new ArrayList<FoldingUpdate.RegionInfo>(1);
            if (arrayList == null) {
                FoldingMap.$$$reportNull$$$0(1);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/codeInsight/folding/impl/UpdateFoldRegionsOperation$FoldingMap";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createMap";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createCollection";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    static enum ApplyDefaultStateMode {
        YES,
        EXCEPT_CARET_REGION,
        NO;

    }
}

