/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.dvcs.ignore.VcsRepositoryIgnoredFilesHolderBase;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.vfs.AsyncVfsEventsListener;
import com.intellij.vfs.AsyncVfsEventsPostProcessor;
import git4idea.GitLocalBranch;
import git4idea.GitUtil;
import git4idea.commands.Git;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryFiles;
import git4idea.repo.GitRepositoryManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitUntrackedFilesHolder
implements Disposable,
AsyncVfsEventsListener {
    private static final Logger LOG = Logger.getInstance(GitUntrackedFilesHolder.class);
    private final Project myProject;
    private final VirtualFile myRoot;
    private final GitRepository myRepository;
    private final ChangeListManager myChangeListManager;
    private final VcsDirtyScopeManager myDirtyScopeManager;
    private final ProjectLevelVcsManager myVcsManager;
    private final GitRepositoryFiles myRepositoryFiles;
    private final Git myGit;
    private final Set<VirtualFile> myDefinitelyUntrackedFiles;
    private final Set<VirtualFile> myPossiblyUntrackedFiles;
    private boolean myReady;
    private final Object LOCK;
    private final GitRepositoryManager myRepositoryManager;

    GitUntrackedFilesHolder(@NotNull GitRepository repository, @NotNull GitRepositoryFiles gitFiles) {
        if (repository == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(0);
        }
        if (gitFiles == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(1);
        }
        this.myDefinitelyUntrackedFiles = new HashSet<VirtualFile>();
        this.myPossiblyUntrackedFiles = new HashSet<VirtualFile>();
        this.LOCK = new Object();
        this.myProject = repository.getProject();
        this.myRepository = repository;
        this.myRoot = repository.getRoot();
        this.myChangeListManager = ChangeListManager.getInstance((Project)this.myProject);
        this.myDirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)this.myProject);
        this.myGit = Git.getInstance();
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        this.myRepositoryManager = GitUtil.getRepositoryManager(this.myProject);
        this.myRepositoryFiles = gitFiles;
    }

    void setupVfsListener(@NotNull Project project) {
        if (project == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            if (!project.isDisposed()) {
                AsyncVfsEventsPostProcessor.getInstance().addListener((AsyncVfsEventsListener)this, (Disposable)this);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.myDefinitelyUntrackedFiles;
        synchronized (object) {
            this.myDefinitelyUntrackedFiles.clear();
        }
        object = this.LOCK;
        synchronized (object) {
            this.myPossiblyUntrackedFiles.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(@NotNull VirtualFile file) {
        if (file == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(3);
        }
        Set<VirtualFile> set = this.myDefinitelyUntrackedFiles;
        synchronized (set) {
            this.myDefinitelyUntrackedFiles.add(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(@NotNull Collection<VirtualFile> files) {
        if (files == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(4);
        }
        Set<VirtualFile> set = this.myDefinitelyUntrackedFiles;
        synchronized (set) {
            this.myDefinitelyUntrackedFiles.addAll(files);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(@NotNull Collection<VirtualFile> files) {
        if (files == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(5);
        }
        Set<VirtualFile> set = this.myDefinitelyUntrackedFiles;
        synchronized (set) {
            this.myDefinitelyUntrackedFiles.removeAll(files);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Collection<VirtualFile> retrieveUntrackedFiles() throws VcsException {
        if (this.isReady()) {
            this.verifyPossiblyUntrackedFiles();
        } else {
            this.rescanAll();
        }
        Set<VirtualFile> set = this.myDefinitelyUntrackedFiles;
        // MONITORENTER : set
        ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>(this.myDefinitelyUntrackedFiles);
        // MONITOREXIT : set
        if (arrayList != null) return arrayList;
        GitUntrackedFilesHolder.$$$reportNull$$$0(6);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate() {
        Object object = this.LOCK;
        synchronized (object) {
            this.myReady = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rescanAll() throws VcsException {
        Set<VirtualFile> untrackedFiles = this.myGit.untrackedFiles(this.myProject, this.myRoot, null);
        Object object = this.myDefinitelyUntrackedFiles;
        synchronized (object) {
            this.myDefinitelyUntrackedFiles.clear();
            this.myDefinitelyUntrackedFiles.addAll(untrackedFiles);
        }
        object = this.LOCK;
        synchronized (object) {
            this.myPossiblyUntrackedFiles.clear();
            this.myReady = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isReady() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.myReady;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyPossiblyUntrackedFiles() throws VcsException {
        HashSet<VirtualFile> suspiciousFiles;
        Set<VirtualFile> set = this.LOCK;
        synchronized (set) {
            suspiciousFiles = new HashSet<VirtualFile>(this.myPossiblyUntrackedFiles);
            this.myPossiblyUntrackedFiles.clear();
        }
        set = this.myDefinitelyUntrackedFiles;
        synchronized (set) {
            Set<VirtualFile> untrackedFiles = this.myGit.untrackedFiles(this.myProject, this.myRoot, suspiciousFiles);
            suspiciousFiles.removeAll(untrackedFiles);
            HashSet<VirtualFile> trackedFiles = suspiciousFiles;
            this.myDefinitelyUntrackedFiles.addAll(untrackedFiles);
            this.myDefinitelyUntrackedFiles.removeAll(trackedFiles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filesChanged(@NotNull List<? extends VFileEvent> events) {
        Object object;
        if (events == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(7);
        }
        boolean allChanged = false;
        HashSet<VirtualFile> filesToRefresh = new HashSet<VirtualFile>();
        for (VFileEvent vFileEvent : events) {
            if (allChanged) break;
            String path = vFileEvent.getPath();
            if (this.totalRefreshNeeded(path)) {
                allChanged = true;
                continue;
            }
            VirtualFile affectedFile = VcsRepositoryIgnoredFilesHolderBase.getAffectedFile((VFileEvent)vFileEvent);
            if (!this.notIgnored(affectedFile)) continue;
            filesToRefresh.add(affectedFile);
        }
        if (allChanged) {
            this.rescanIgnoredFiles(() -> {
                LOG.debug(String.format("GitUntrackedFilesHolder: total refresh is needed, marking %s recursively dirty", this.myRoot));
                this.myDirtyScopeManager.dirDirtyRecursively(this.myRoot);
            });
            object = this.LOCK;
            synchronized (object) {
                this.myReady = false;
            }
        }
        object = this.LOCK;
        synchronized (object) {
            this.myPossiblyUntrackedFiles.addAll(filesToRefresh);
        }
    }

    private boolean totalRefreshNeeded(@NotNull String path) {
        if (path == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(8);
        }
        return this.indexChanged(path) || this.externallyCommitted(path) || this.headMoved(path) || this.headChanged(path) || this.currentBranchChanged(path) || this.gitignoreChanged(path);
    }

    private boolean headChanged(@NotNull String path) {
        if (path == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(9);
        }
        return this.myRepositoryFiles.isHeadFile(path);
    }

    private boolean currentBranchChanged(@NotNull String path) {
        GitLocalBranch currentBranch;
        if (path == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(10);
        }
        return (currentBranch = this.myRepository.getCurrentBranch()) != null && this.myRepositoryFiles.isBranchFile(path, currentBranch.getFullName());
    }

    private boolean headMoved(@NotNull String path) {
        if (path == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(11);
        }
        return this.myRepositoryFiles.isOrigHeadFile(path);
    }

    private boolean indexChanged(@NotNull String path) {
        if (path == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(12);
        }
        return this.myRepositoryFiles.isIndexFile(path);
    }

    private boolean externallyCommitted(@NotNull String path) {
        if (path == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(13);
        }
        return this.myRepositoryFiles.isCommitMessageFile(path);
    }

    private boolean gitignoreChanged(@NotNull String path) {
        if (path == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(14);
        }
        return path.endsWith(".gitignore") || this.myRepositoryFiles.isExclude(path);
    }

    private void rescanIgnoredFiles(@NotNull Runnable doAfterRescan) {
        if (doAfterRescan == null) {
            GitUntrackedFilesHolder.$$$reportNull$$$0(15);
        }
        this.myRepository.getIgnoredFilesHolder().startRescan(doAfterRescan);
    }

    private boolean notIgnored(@Nullable VirtualFile file) {
        return file != null && this.belongsToThisRepository(file) && !this.myChangeListManager.isIgnoredFile(file);
    }

    private boolean belongsToThisRepository(VirtualFile file) {
        GitRepository repository = (GitRepository)this.myRepositoryManager.getRepositoryForRootQuick(this.myVcsManager.getVcsRootFor(file));
        return repository != null && repository.getRoot().equals(this.myRoot);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gitFiles";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/repo/GitUntrackedFilesHolder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doAfterRescan";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/repo/GitUntrackedFilesHolder";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "retrieveUntrackedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setupVfsListener";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "filesChanged";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "totalRefreshNeeded";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "headChanged";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "currentBranchChanged";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "headMoved";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "indexChanged";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "externallyCommitted";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "gitignoreChanged";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "rescanIgnoredFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

