/*
 * Decompiled with CFR 0.152.
 */
package git4idea.log;

import com.intellij.diff.DiffContentFactoryEx;
import com.intellij.diff.DiffManager;
import com.intellij.diff.DiffRequestFactoryImpl;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsDiffUtil;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogDiffHandler;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitContentRevision;
import git4idea.GitRevisionNumber;
import git4idea.changes.GitChangeUtils;
import git4idea.diff.GitSubmoduleContentRevision;
import git4idea.repo.GitSubmodule;
import git4idea.util.GitFileUtils;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitLogDiffHandler
implements VcsLogDiffHandler {
    private static final Logger LOG = Logger.getInstance(GitLogDiffHandler.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final DiffContentFactoryEx myDiffContentFactory;

    public GitLogDiffHandler(@NotNull Project project) {
        if (project == null) {
            GitLogDiffHandler.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myDiffContentFactory = DiffContentFactoryEx.getInstanceEx();
    }

    public void showDiff(final @NotNull VirtualFile root, final @Nullable FilePath leftPath, final @NotNull Hash leftHash, final @Nullable FilePath rightPath, final @NotNull Hash rightHash) {
        if (root == null) {
            GitLogDiffHandler.$$$reportNull$$$0(1);
        }
        if (leftHash == null) {
            GitLogDiffHandler.$$$reportNull$$$0(2);
        }
        if (rightHash == null) {
            GitLogDiffHandler.$$$reportNull$$$0(3);
        }
        if (leftPath == null && rightPath == null) {
            return;
        }
        if (((FilePath)ObjectUtils.chooseNotNull((Object)leftPath, (Object)rightPath)).isDirectory()) {
            this.showDiffForPaths(root, Collections.singleton(ObjectUtils.chooseNotNull((Object)leftPath, (Object)rightPath)), leftHash, rightHash);
        } else {
            this.loadDiffAndShow(new ThrowableComputable<DiffRequest, VcsException>(){

                public DiffRequest compute() throws VcsException {
                    DiffContent leftDiffContent = GitLogDiffHandler.this.createDiffContent(root, leftPath, leftHash);
                    DiffContent rightDiffContent = GitLogDiffHandler.this.createDiffContent(root, rightPath, rightHash);
                    return new SimpleDiffRequest(DiffRequestFactoryImpl.getTitle((FilePath)leftPath, (FilePath)rightPath, (String)" -> "), leftDiffContent, rightDiffContent, leftHash.asString(), rightHash.asString());
                }
            }, request -> DiffManager.getInstance().showDiff(this.myProject, request), "Calculating Diff for " + ((FilePath)ObjectUtils.chooseNotNull((Object)rightPath, (Object)leftPath)).getName());
        }
    }

    public void showDiffWithLocal(final @NotNull VirtualFile root, final @Nullable FilePath revisionPath, final @NotNull Hash revisionHash, final @NotNull FilePath localPath) {
        if (root == null) {
            GitLogDiffHandler.$$$reportNull$$$0(4);
        }
        if (revisionHash == null) {
            GitLogDiffHandler.$$$reportNull$$$0(5);
        }
        if (localPath == null) {
            GitLogDiffHandler.$$$reportNull$$$0(6);
        }
        if (localPath.isDirectory()) {
            this.showDiffForPaths(root, Collections.singleton(localPath), revisionHash, null);
        } else {
            this.loadDiffAndShow(new ThrowableComputable<DiffRequest, VcsException>(){

                public DiffRequest compute() throws VcsException {
                    DiffContent leftDiffContent = GitLogDiffHandler.this.createDiffContent(root, revisionPath, revisionHash);
                    DiffContent rightDiffContent = GitLogDiffHandler.this.createCurrentDiffContent(localPath);
                    return new SimpleDiffRequest(DiffRequestFactoryImpl.getTitle((FilePath)revisionPath, (FilePath)localPath, (String)" -> "), leftDiffContent, rightDiffContent, revisionHash.asString(), "(Local)");
                }
            }, request -> DiffManager.getInstance().showDiff(this.myProject, request), "Calculating Diff for " + localPath.getName());
        }
    }

    public void showDiffForPaths(@NotNull VirtualFile root, @Nullable Collection<FilePath> affectedPaths, @NotNull Hash leftRevision, @Nullable Hash rightRevision) {
        if (root == null) {
            GitLogDiffHandler.$$$reportNull$$$0(7);
        }
        if (leftRevision == null) {
            GitLogDiffHandler.$$$reportNull$$$0(8);
        }
        Collection<FilePath> filePaths = affectedPaths != null ? affectedPaths : Collections.singleton(VcsUtil.getFilePath((VirtualFile)root));
        this.loadDiffAndShow(() -> this.getDiff(root, filePaths, leftRevision, rightRevision), diff -> {
            String dialogTitle = "Changes between " + leftRevision.toShortString() + " and " + (rightRevision == null ? "local version" : rightRevision.toShortString()) + " in " + GitLogDiffHandler.getTitleForPaths(root, affectedPaths);
            VcsDiffUtil.showChangesDialog((Project)this.myProject, (String)dialogTitle, (List)ContainerUtil.newArrayList((Iterable)diff));
        }, "Calculating Diff for " + StringUtil.shortenTextWithEllipsis((String)StringUtil.join(filePaths, FilePath::getName, (String)", "), (int)100, (int)0));
    }

    @NotNull
    private static String getTitleForPaths(@NotNull VirtualFile root, @Nullable Collection<FilePath> filePaths) {
        if (root == null) {
            GitLogDiffHandler.$$$reportNull$$$0(9);
        }
        if (filePaths == null) {
            String string = DiffRequestFactoryImpl.getContentTitle((FilePath)VcsUtil.getFilePath((VirtualFile)root));
            if (string == null) {
                GitLogDiffHandler.$$$reportNull$$$0(10);
            }
            return string;
        }
        String joinedPaths = StringUtil.join(filePaths, path -> VcsFileUtil.relativePath((VirtualFile)root, (FilePath)path), (String)", ");
        String string = StringUtil.shortenTextWithEllipsis((String)joinedPaths, (int)100, (int)0);
        if (string == null) {
            GitLogDiffHandler.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    private DiffContent createCurrentDiffContent(@NotNull FilePath localPath) throws VcsException {
        GitSubmodule submodule;
        if (localPath == null) {
            GitLogDiffHandler.$$$reportNull$$$0(12);
        }
        if ((submodule = GitContentRevision.getRepositoryIfSubmodule(this.myProject, localPath)) != null) {
            ContentRevision revision = GitSubmoduleContentRevision.createCurrentRevision(submodule.getRepository());
            String content = revision.getContent();
            Object object = content != null ? this.myDiffContentFactory.create(this.myProject, content) : this.myDiffContentFactory.createEmpty();
            if (object == null) {
                GitLogDiffHandler.$$$reportNull$$$0(13);
            }
            return object;
        }
        VirtualFile file = localPath.getVirtualFile();
        LOG.assertTrue(file != null);
        DiffContent diffContent = this.myDiffContentFactory.create(this.myProject, file);
        if (diffContent == null) {
            GitLogDiffHandler.$$$reportNull$$$0(14);
        }
        return diffContent;
    }

    @NotNull
    private Collection<Change> getDiff(@NotNull VirtualFile root, @NotNull Collection<FilePath> filePaths, @NotNull Hash leftRevision, @Nullable Hash rightRevision) throws VcsException {
        if (root == null) {
            GitLogDiffHandler.$$$reportNull$$$0(15);
        }
        if (filePaths == null) {
            GitLogDiffHandler.$$$reportNull$$$0(16);
        }
        if (leftRevision == null) {
            GitLogDiffHandler.$$$reportNull$$$0(17);
        }
        if (rightRevision == null) {
            Collection<Change> collection = GitChangeUtils.getDiffWithWorkingDir(this.myProject, root, leftRevision.asString(), filePaths, false);
            if (collection == null) {
                GitLogDiffHandler.$$$reportNull$$$0(18);
            }
            return collection;
        }
        Collection<Change> collection = GitChangeUtils.getDiff(this.myProject, root, leftRevision.asString(), rightRevision.asString(), filePaths);
        if (collection == null) {
            GitLogDiffHandler.$$$reportNull$$$0(19);
        }
        return collection;
    }

    private <T> void loadDiffAndShow(final @NotNull ThrowableComputable<T, VcsException> load, final @NotNull Consumer<T> show, final @NotNull @Nls(capitalization=Nls.Capitalization.Title) String title) {
        if (load == null) {
            GitLogDiffHandler.$$$reportNull$$$0(20);
        }
        if (show == null) {
            GitLogDiffHandler.$$$reportNull$$$0(21);
        }
        if (title == null) {
            GitLogDiffHandler.$$$reportNull$$$0(22);
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, title + "...", false){
                @Nullable
                private T myResult;

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    try {
                        this.myResult = load.compute();
                    }
                    catch (VcsException e) {
                        throw new RuntimeException(e);
                    }
                }

                public void onSuccess() {
                    if (this.myResult != null) {
                        show.consume(this.myResult);
                    }
                }

                public void onThrowable(@NotNull Throwable error) {
                    if (error == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    VcsBalloonProblemNotifier.showOverVersionControlView((Project)this.myProject, (String)(title + " failed\n" + error.getMessage()), (MessageType)MessageType.ERROR);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "indicator";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "error";
                            break;
                        }
                    }
                    objectArray2[1] = "git4idea/log/GitLogDiffHandler$3";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "run";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onThrowable";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        } else {
            try {
                Object result2 = load.compute();
                ApplicationManager.getApplication().invokeLater(() -> show.consume(result2));
            }
            catch (VcsException e) {
                VcsBalloonProblemNotifier.showOverVersionControlView((Project)this.myProject, (String)(title + " failed\n" + e.getMessage()), (MessageType)MessageType.ERROR);
            }
        }
    }

    @NotNull
    private DiffContent createDiffContent(@NotNull VirtualFile root, @Nullable FilePath path, @NotNull Hash hash) throws VcsException {
        EmptyContent diffContent;
        if (root == null) {
            GitLogDiffHandler.$$$reportNull$$$0(23);
        }
        if (hash == null) {
            GitLogDiffHandler.$$$reportNull$$$0(24);
        }
        GitRevisionNumber revisionNumber = new GitRevisionNumber(hash.asString());
        if (path == null) {
            diffContent = new EmptyContent();
        } else {
            GitSubmodule submodule = GitContentRevision.getRepositoryIfSubmodule(this.myProject, path);
            if (submodule != null) {
                ContentRevision revision = GitSubmoduleContentRevision.createRevision(submodule, (VcsRevisionNumber)revisionNumber);
                String content = revision.getContent();
                diffContent = content != null ? this.myDiffContentFactory.create(this.myProject, content) : this.myDiffContentFactory.createEmpty();
            } else {
                try {
                    byte[] content = GitFileUtils.getFileContent(this.myProject, root, hash.asString(), VcsFileUtil.relativePath((VirtualFile)root, (FilePath)path));
                    diffContent = this.myDiffContentFactory.createFromBytes(this.myProject, content, path);
                }
                catch (IOException e) {
                    throw new VcsException((Throwable)e);
                }
            }
        }
        diffContent.putUserData(DiffUserDataKeysEx.REVISION_INFO, (Object)new Pair((Object)path, (Object)revisionNumber));
        EmptyContent emptyContent = diffContent;
        if (emptyContent == null) {
            GitLogDiffHandler.$$$reportNull$$$0(25);
        }
        return emptyContent;
    }

    @NotNull
    public ContentRevision createContentRevision(@NotNull FilePath filePath, @NotNull Hash hash) {
        if (filePath == null) {
            GitLogDiffHandler.$$$reportNull$$$0(26);
        }
        if (hash == null) {
            GitLogDiffHandler.$$$reportNull$$$0(27);
        }
        GitRevisionNumber revisionNumber = new GitRevisionNumber(hash.asString());
        ContentRevision contentRevision = GitContentRevision.createRevision(filePath, (VcsRevisionNumber)revisionNumber, this.myProject, null);
        if (contentRevision == null) {
            GitLogDiffHandler.$$$reportNull$$$0(28);
        }
        return contentRevision;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 25: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 25: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 9: 
            case 15: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftHash";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightHash";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revisionHash";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
            case 8: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftRevision";
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/log/GitLogDiffHandler";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePaths";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "load";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "show";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/log/GitLogDiffHandler";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitleForPaths";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createCurrentDiffContent";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiff";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "createDiffContent";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "createContentRevision";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "showDiff";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "showDiffWithLocal";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "showDiffForPaths";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTitleForPaths";
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 25: 
            case 28: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createCurrentDiffContent";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getDiff";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "loadDiffAndShow";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createDiffContent";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createContentRevision";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 25: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

