/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsFileUtil;
import git4idea.branch.GitRebaseParams;
import git4idea.commands.Git;
import git4idea.commands.GitAuthenticationGate;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitHandlerInputProcessorUtil;
import git4idea.commands.GitImplBase;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitRebaseCommandResult;
import git4idea.config.GitVersionSpecialty;
import git4idea.push.GitPushParams;
import git4idea.rebase.GitInteractiveRebaseEditorHandler;
import git4idea.rebase.GitRebaseEditorHandler;
import git4idea.rebase.GitRebaseEditorService;
import git4idea.rebase.GitRebaseResumeMode;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.reset.GitResetMode;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitImpl
extends GitImplBase {
    private static final Logger LOG = Logger.getInstance(Git.class);
    private static final List<String> REBASE_CONFIG_PARAMS = Collections.singletonList("core.commentChar=\u0001");

    @Override
    @NotNull
    public GitCommandResult init(@NotNull Project project, @NotNull VirtualFile root, GitLineHandlerListener ... listeners) {
        if (project == null) {
            GitImpl.$$$reportNull$$$0(0);
        }
        if (root == null) {
            GitImpl.$$$reportNull$$$0(1);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(2);
        }
        GitLineHandler h = new GitLineHandler(project, root, GitCommand.INIT);
        for (GitLineHandlerListener listener : listeners) {
            h.addLineListener(listener);
        }
        h.setSilent(false);
        h.setStdoutSuppressed(false);
        GitCommandResult gitCommandResult = this.runCommand(h);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(3);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public Set<VirtualFile> ignoredFiles(@NotNull Project project, @NotNull VirtualFile root, @Nullable Collection<FilePath> paths) throws VcsException {
        if (project == null) {
            GitImpl.$$$reportNull$$$0(4);
        }
        if (root == null) {
            GitImpl.$$$reportNull$$$0(5);
        }
        HashSet<VirtualFile> ignoredFiles = new HashSet<VirtualFile>();
        if (paths == null) {
            ignoredFiles.addAll(this.ignoredFilesNoChunk(project, root, null));
        } else {
            for (List relativePaths : VcsFileUtil.chunkPaths((VirtualFile)root, paths)) {
                ignoredFiles.addAll(this.ignoredFilesNoChunk(project, root, relativePaths));
            }
        }
        HashSet<VirtualFile> hashSet = ignoredFiles;
        if (hashSet == null) {
            GitImpl.$$$reportNull$$$0(6);
        }
        return hashSet;
    }

    @Override
    @NotNull
    public Set<VirtualFile> ignoredFilesNoChunk(@NotNull Project project, @NotNull VirtualFile root, @Nullable List<String> paths) throws VcsException {
        if (project == null) {
            GitImpl.$$$reportNull$$$0(7);
        }
        if (root == null) {
            GitImpl.$$$reportNull$$$0(8);
        }
        GitLineHandler h = new GitLineHandler(project, root, GitCommand.STATUS);
        h.setSilent(true);
        h.addParameters("--ignored", "--porcelain", "-z");
        if (paths != null) {
            h.addParameters(paths);
        }
        h.endOptions();
        String output = this.runCommand(h).getOutputOrThrow(new int[0]);
        Set<VirtualFile> set = GitImpl.parseFiles(root, output, "!! ");
        if (set == null) {
            GitImpl.$$$reportNull$$$0(9);
        }
        return set;
    }

    @NotNull
    private static Set<VirtualFile> parseFiles(@NotNull VirtualFile root, @Nullable String output, @NotNull String fileStatusPrefix) {
        if (root == null) {
            GitImpl.$$$reportNull$$$0(10);
        }
        if (fileStatusPrefix == null) {
            GitImpl.$$$reportNull$$$0(11);
        }
        if (StringUtil.isEmptyOrSpaces((String)output)) {
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                GitImpl.$$$reportNull$$$0(12);
            }
            return set;
        }
        HashSet<VirtualFile> files = new HashSet<VirtualFile>();
        for (String relPath : output.split("\u0000")) {
            ProgressManager.checkCanceled();
            if (!fileStatusPrefix.isEmpty() && !relPath.startsWith(fileStatusPrefix)) continue;
            String relativePath = relPath.substring(fileStatusPrefix.length());
            VirtualFile f = VfsUtil.findFileByIoFile((File)new File(root.getPath(), relativePath), (boolean)true);
            if (f == null) {
                LOG.info(String.format("VirtualFile for path [%s] is null", relPath));
                continue;
            }
            files.add(f);
        }
        HashSet<VirtualFile> hashSet = files;
        if (hashSet == null) {
            GitImpl.$$$reportNull$$$0(13);
        }
        return hashSet;
    }

    @Override
    @NotNull
    public Set<VirtualFile> untrackedFiles(@NotNull Project project, @NotNull VirtualFile root, @Nullable Collection<VirtualFile> files) throws VcsException {
        if (project == null) {
            GitImpl.$$$reportNull$$$0(14);
        }
        if (root == null) {
            GitImpl.$$$reportNull$$$0(15);
        }
        HashSet<VirtualFile> untrackedFiles = new HashSet<VirtualFile>();
        if (files == null) {
            untrackedFiles.addAll(this.untrackedFilesNoChunk(project, root, null));
        } else {
            for (List relativePaths : VcsFileUtil.chunkFiles((VirtualFile)root, files)) {
                untrackedFiles.addAll(this.untrackedFilesNoChunk(project, root, relativePaths));
            }
        }
        HashSet<VirtualFile> hashSet = untrackedFiles;
        if (hashSet == null) {
            GitImpl.$$$reportNull$$$0(16);
        }
        return hashSet;
    }

    @Override
    @NotNull
    public Collection<VirtualFile> untrackedFilesNoChunk(@NotNull Project project, @NotNull VirtualFile root, @Nullable List<String> relativePaths) throws VcsException {
        if (project == null) {
            GitImpl.$$$reportNull$$$0(17);
        }
        if (root == null) {
            GitImpl.$$$reportNull$$$0(18);
        }
        GitLineHandler h = new GitLineHandler(project, root, GitCommand.LS_FILES);
        h.setSilent(true);
        h.addParameters("--exclude-standard", "--others", "-z");
        h.endOptions();
        if (relativePaths != null) {
            h.addParameters(relativePaths);
        }
        String output = this.runCommand(h).getOutputOrThrow(new int[0]);
        Set<VirtualFile> set = GitImpl.parseFiles(root, output, "");
        if (set == null) {
            GitImpl.$$$reportNull$$$0(19);
        }
        return set;
    }

    @Override
    @NotNull
    public GitCommandResult clone(@NotNull Project project, @NotNull File parentDirectory, @NotNull String url, @NotNull String clonedDirectoryName, GitLineHandlerListener ... listeners) {
        if (project == null) {
            GitImpl.$$$reportNull$$$0(20);
        }
        if (parentDirectory == null) {
            GitImpl.$$$reportNull$$$0(21);
        }
        if (url == null) {
            GitImpl.$$$reportNull$$$0(22);
        }
        if (clonedDirectoryName == null) {
            GitImpl.$$$reportNull$$$0(23);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(24);
        }
        GitCommandResult gitCommandResult = this.runCommand(() -> {
            GitLineHandler handler = new GitLineHandler(project, parentDirectory, GitCommand.CLONE);
            handler.setSilent(false);
            handler.setStderrSuppressed(false);
            handler.setUrl(url);
            handler.addParameters("--progress");
            if (GitVersionSpecialty.CLONE_RECURSE_SUBMODULES.existsIn(project) && Registry.is((String)"git.clone.recurse.submodules")) {
                handler.addParameters("--recurse-submodules");
            }
            handler.addParameters(url);
            handler.endOptions();
            handler.addParameters(clonedDirectoryName);
            GitImpl.addListeners(handler, listeners);
            return handler;
        });
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(25);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult config(@NotNull GitRepository repository, String ... params) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(26);
        }
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.CONFIG);
        h.addParameters(params);
        GitCommandResult gitCommandResult = this.runCommand(h);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(27);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult diff(@NotNull GitRepository repository, @NotNull List<String> parameters, @NotNull String range) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(28);
        }
        if (parameters == null) {
            GitImpl.$$$reportNull$$$0(29);
        }
        if (range == null) {
            GitImpl.$$$reportNull$$$0(30);
        }
        GitLineHandler diff = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.DIFF);
        diff.addParameters(parameters);
        diff.addParameters(range);
        diff.setStdoutSuppressed(true);
        diff.setStderrSuppressed(true);
        diff.setSilent(true);
        GitCommandResult gitCommandResult = this.runCommand(diff);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(31);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult checkAttr(@NotNull GitRepository repository, @NotNull Collection<String> attributes, @NotNull Collection<VirtualFile> files) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(32);
        }
        if (attributes == null) {
            GitImpl.$$$reportNull$$$0(33);
        }
        if (files == null) {
            GitImpl.$$$reportNull$$$0(34);
        }
        List relativeFilePaths = ContainerUtil.map(files, file -> VcsFileUtil.relativePath((VirtualFile)repository.getRoot(), (VirtualFile)file));
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.CHECK_ATTR);
        h.addParameters("--stdin");
        h.addParameters(new ArrayList<String>(attributes));
        h.endOptions();
        h.setInputProcessor(GitHandlerInputProcessorUtil.writeLines(relativeFilePaths, h.getCharset()));
        GitCommandResult gitCommandResult = this.runCommand(h);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(35);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult stashSave(@NotNull GitRepository repository, @NotNull String message) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(36);
        }
        if (message == null) {
            GitImpl.$$$reportNull$$$0(37);
        }
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.STASH);
        h.addParameters("save");
        h.addParameters(message);
        GitCommandResult gitCommandResult = this.runCommand(h);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(38);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult stashPop(@NotNull GitRepository repository, GitLineHandlerListener ... listeners) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(39);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(40);
        }
        GitLineHandler handler = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.STASH);
        handler.addParameters("pop");
        GitImpl.addListeners(handler, listeners);
        GitCommandResult gitCommandResult = this.runCommand(handler);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(41);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult merge(@NotNull GitRepository repository, @NotNull String branchToMerge, @Nullable List<String> additionalParams, GitLineHandlerListener ... listeners) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(42);
        }
        if (branchToMerge == null) {
            GitImpl.$$$reportNull$$$0(43);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(44);
        }
        GitLineHandler mergeHandler = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.MERGE);
        mergeHandler.setSilent(false);
        mergeHandler.addParameters(branchToMerge);
        if (additionalParams != null) {
            mergeHandler.addParameters(additionalParams);
        }
        for (GitLineHandlerListener listener : listeners) {
            mergeHandler.addLineListener(listener);
        }
        GitCommandResult gitCommandResult = this.runCommand(mergeHandler);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(45);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult checkout(@NotNull GitRepository repository, @NotNull String reference, @Nullable String newBranch, boolean force, boolean detach, GitLineHandlerListener ... listeners) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(46);
        }
        if (reference == null) {
            GitImpl.$$$reportNull$$$0(47);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(48);
        }
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.CHECKOUT);
        h.setSilent(false);
        h.setStdoutSuppressed(false);
        if (force) {
            h.addParameters("--force");
        }
        if (newBranch == null) {
            h.addParameters(detach ? reference + "^0" : reference);
        } else {
            h.addParameters("-b", newBranch, reference);
        }
        h.endOptions();
        for (GitLineHandlerListener listener : listeners) {
            h.addLineListener(listener);
        }
        GitCommandResult gitCommandResult = this.runCommand(h);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(49);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult checkoutNewBranch(@NotNull GitRepository repository, @NotNull String branchName, @Nullable GitLineHandlerListener listener) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(50);
        }
        if (branchName == null) {
            GitImpl.$$$reportNull$$$0(51);
        }
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.CHECKOUT);
        h.setSilent(false);
        h.setStdoutSuppressed(false);
        h.addParameters("-b");
        h.addParameters(branchName);
        if (listener != null) {
            h.addLineListener(listener);
        }
        GitCommandResult gitCommandResult = this.runCommand(h);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(52);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult createNewTag(@NotNull GitRepository repository, @NotNull String tagName, @Nullable GitLineHandlerListener listener, @NotNull String reference) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(53);
        }
        if (tagName == null) {
            GitImpl.$$$reportNull$$$0(54);
        }
        if (reference == null) {
            GitImpl.$$$reportNull$$$0(55);
        }
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.TAG);
        h.setSilent(false);
        h.addParameters(tagName);
        if (!reference.isEmpty()) {
            h.addParameters(reference);
        }
        if (listener != null) {
            h.addLineListener(listener);
        }
        GitCommandResult gitCommandResult = this.runCommand(h);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(56);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult deleteTag(@NotNull GitRepository repository, @NotNull String tagName, GitLineHandlerListener ... listeners) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(57);
        }
        if (tagName == null) {
            GitImpl.$$$reportNull$$$0(58);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(59);
        }
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.TAG);
        h.setSilent(false);
        h.addParameters("-d");
        h.addParameters(tagName);
        for (GitLineHandlerListener listener : listeners) {
            h.addLineListener(listener);
        }
        GitCommandResult gitCommandResult = this.runCommand(h);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(60);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult branchDelete(@NotNull GitRepository repository, @NotNull String branchName, boolean force, GitLineHandlerListener ... listeners) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(61);
        }
        if (branchName == null) {
            GitImpl.$$$reportNull$$$0(62);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(63);
        }
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.BRANCH);
        h.setSilent(false);
        h.setStdoutSuppressed(false);
        h.addParameters(force ? "-D" : "-d");
        h.addParameters(branchName);
        for (GitLineHandlerListener listener : listeners) {
            h.addLineListener(listener);
        }
        GitCommandResult gitCommandResult = this.runCommand(h);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(64);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult branchContains(@NotNull GitRepository repository, @NotNull String commit2) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(65);
        }
        if (commit2 == null) {
            GitImpl.$$$reportNull$$$0(66);
        }
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.BRANCH);
        h.addParameters("--contains", commit2);
        GitCommandResult gitCommandResult = this.runCommand(h);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(67);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult branchCreate(@NotNull GitRepository repository, @NotNull String branchName, @NotNull String startPoint) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(68);
        }
        if (branchName == null) {
            GitImpl.$$$reportNull$$$0(69);
        }
        if (startPoint == null) {
            GitImpl.$$$reportNull$$$0(70);
        }
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.BRANCH);
        h.setStdoutSuppressed(false);
        h.addParameters(branchName);
        h.addParameters(startPoint);
        GitCommandResult gitCommandResult = this.runCommand(h);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(71);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult renameBranch(@NotNull GitRepository repository, @NotNull String currentName, @NotNull String newName, GitLineHandlerListener ... listeners) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(72);
        }
        if (currentName == null) {
            GitImpl.$$$reportNull$$$0(73);
        }
        if (newName == null) {
            GitImpl.$$$reportNull$$$0(74);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(75);
        }
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.BRANCH);
        h.setSilent(false);
        h.setStdoutSuppressed(false);
        h.addParameters("-m", currentName, newName);
        GitCommandResult gitCommandResult = this.runCommand(h);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(76);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult reset(@NotNull GitRepository repository, @NotNull GitResetMode mode, @NotNull String target, GitLineHandlerListener ... listeners) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(77);
        }
        if (mode == null) {
            GitImpl.$$$reportNull$$$0(78);
        }
        if (target == null) {
            GitImpl.$$$reportNull$$$0(79);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(80);
        }
        GitCommandResult gitCommandResult = this.reset(repository, mode.getArgument(), target, listeners);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(81);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult resetMerge(@NotNull GitRepository repository, @Nullable String revision) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(82);
        }
        GitCommandResult gitCommandResult = this.reset(repository, "--merge", revision, new GitLineHandlerListener[0]);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(83);
        }
        return gitCommandResult;
    }

    @NotNull
    private GitCommandResult reset(@NotNull GitRepository repository, @NotNull String argument, @Nullable String target, GitLineHandlerListener ... listeners) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(84);
        }
        if (argument == null) {
            GitImpl.$$$reportNull$$$0(85);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(86);
        }
        GitLineHandler handler = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.RESET);
        handler.addParameters(argument);
        if (target != null) {
            handler.addParameters(target);
        }
        GitImpl.addListeners(handler, listeners);
        GitCommandResult gitCommandResult = this.runCommand(handler);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(87);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult tip(@NotNull GitRepository repository, @NotNull String branchName) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(88);
        }
        if (branchName == null) {
            GitImpl.$$$reportNull$$$0(89);
        }
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.REV_LIST);
        h.addParameters("-1");
        h.addParameters(branchName);
        GitCommandResult gitCommandResult = this.runCommand(h);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(90);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult push(@NotNull GitRepository repository, @NotNull String remote, @Nullable String url, @NotNull String spec, boolean updateTracking, GitLineHandlerListener ... listeners) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(91);
        }
        if (remote == null) {
            GitImpl.$$$reportNull$$$0(92);
        }
        if (spec == null) {
            GitImpl.$$$reportNull$$$0(93);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(94);
        }
        GitCommandResult gitCommandResult = this.doPush(repository, remote, Collections.singleton(url), spec, false, updateTracking, false, Collections.emptyList(), null, listeners);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(95);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult push(@NotNull GitRepository repository, @NotNull GitPushParams pushParams, GitLineHandlerListener ... listeners) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(96);
        }
        if (pushParams == null) {
            GitImpl.$$$reportNull$$$0(97);
        }
        GitCommandResult gitCommandResult = this.doPush(repository, pushParams.getRemote().getName(), pushParams.getRemote().getPushUrls(), pushParams.getSpec(), pushParams.isForce(), pushParams.shouldSetupTracking(), pushParams.shouldSkipHooks(), pushParams.getForceWithLease(), pushParams.getTagMode(), listeners);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(98);
        }
        return gitCommandResult;
    }

    @NotNull
    private GitCommandResult doPush(@NotNull GitRepository repository, @NotNull String remoteName, @NotNull Collection<String> remoteUrls, @NotNull String spec, boolean force, boolean updateTracking, boolean skipHook, List<GitPushParams.ForceWithLease> forceWithLease, @Nullable String tagMode, GitLineHandlerListener ... listeners) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(99);
        }
        if (remoteName == null) {
            GitImpl.$$$reportNull$$$0(100);
        }
        if (remoteUrls == null) {
            GitImpl.$$$reportNull$$$0(101);
        }
        if (spec == null) {
            GitImpl.$$$reportNull$$$0(102);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(103);
        }
        GitCommandResult gitCommandResult = this.runCommand(() -> {
            GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.PUSH);
            h.setUrls(remoteUrls);
            h.setSilent(false);
            h.setStdoutSuppressed(false);
            GitImpl.addListeners(h, listeners);
            if (GitVersionSpecialty.ABLE_TO_USE_PROGRESS_IN_REMOTE_COMMANDS.existsIn(repository)) {
                h.addParameters("--progress");
            }
            h.addParameters("--porcelain");
            h.addParameters(remoteName);
            h.addParameters(spec);
            if (updateTracking) {
                h.addParameters("--set-upstream");
            }
            if (GitVersionSpecialty.SUPPORTS_FORCE_PUSH_WITH_LEASE.existsIn(repository) && !forceWithLease.isEmpty()) {
                for (GitPushParams.ForceWithLease lease : forceWithLease) {
                    String parameter = lease.getParameter();
                    if (parameter != null) {
                        h.addParameters("--force-with-lease=" + parameter);
                        continue;
                    }
                    h.addParameters("--force-with-lease");
                }
            } else if (force) {
                h.addParameters("--force");
            }
            if (tagMode != null) {
                h.addParameters(tagMode);
            }
            if (skipHook) {
                h.addParameters("--no-verify");
            }
            return h;
        });
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(104);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult show(@NotNull GitRepository repository, String ... params) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(105);
        }
        if (params == null) {
            GitImpl.$$$reportNull$$$0(106);
        }
        GitLineHandler handler = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.SHOW);
        handler.addParameters(params);
        GitCommandResult gitCommandResult = this.runCommand(handler);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(107);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult cherryPick(@NotNull GitRepository repository, @NotNull String hash, boolean autoCommit, GitLineHandlerListener ... listeners) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(108);
        }
        if (hash == null) {
            GitImpl.$$$reportNull$$$0(109);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(110);
        }
        GitCommandResult gitCommandResult = this.cherryPick(repository, hash, autoCommit, true, listeners);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(111);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult cherryPick(@NotNull GitRepository repository, @NotNull String hash, boolean autoCommit, boolean addCherryPickedFromSuffix, GitLineHandlerListener ... listeners) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(112);
        }
        if (hash == null) {
            GitImpl.$$$reportNull$$$0(113);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(114);
        }
        GitLineHandler handler = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.CHERRY_PICK);
        if (addCherryPickedFromSuffix) {
            handler.addParameters("-x");
        }
        if (!autoCommit) {
            handler.addParameters("-n");
        }
        handler.addParameters(hash);
        GitImpl.addListeners(handler, listeners);
        handler.setSilent(false);
        handler.setStdoutSuppressed(false);
        GitCommandResult gitCommandResult = this.runCommand(handler);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(115);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult getUnmergedFiles(@NotNull GitRepository repository) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(116);
        }
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.LS_FILES);
        h.addParameters("--unmerged");
        h.setSilent(true);
        GitCommandResult gitCommandResult = this.runCommand(h);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(117);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult fetch(@NotNull GitRepository repository, @NotNull GitRemote remote, @NotNull List<GitLineHandlerListener> listeners, String ... params) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(118);
        }
        if (remote == null) {
            GitImpl.$$$reportNull$$$0(119);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(120);
        }
        GitCommandResult gitCommandResult = this.fetch(repository, remote, listeners, (GitAuthenticationGate)null, params);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(121);
        }
        return gitCommandResult;
    }

    @NotNull
    public GitCommandResult fetch(@NotNull GitRepository repository, @NotNull GitRemote remote, @NotNull List<GitLineHandlerListener> listeners, @Nullable GitAuthenticationGate authenticationGate, String ... params) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(122);
        }
        if (remote == null) {
            GitImpl.$$$reportNull$$$0(123);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(124);
        }
        GitCommandResult gitCommandResult = this.runCommand(() -> {
            GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.FETCH);
            if (authenticationGate != null) {
                h.setAuthenticationGate(authenticationGate);
            }
            h.setSilent(false);
            h.setStdoutSuppressed(false);
            h.setUrls(remote.getUrls());
            h.addParameters(remote.getName());
            h.addParameters(params);
            if (GitVersionSpecialty.ABLE_TO_USE_PROGRESS_IN_REMOTE_COMMANDS.existsIn(repository)) {
                h.addParameters("--progress");
            }
            if (GitVersionSpecialty.SUPPORTS_FETCH_PRUNE.existsIn(repository)) {
                h.addParameters("--prune");
            }
            GitImpl.addListeners(h, listeners);
            return h;
        });
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(125);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult addRemote(@NotNull GitRepository repository, @NotNull String name, @NotNull String url) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(126);
        }
        if (name == null) {
            GitImpl.$$$reportNull$$$0(127);
        }
        if (url == null) {
            GitImpl.$$$reportNull$$$0(128);
        }
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.REMOTE);
        h.addParameters("add", name, url);
        GitCommandResult gitCommandResult = this.runCommand(h);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(129);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult removeRemote(@NotNull GitRepository repository, @NotNull GitRemote remote) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(130);
        }
        if (remote == null) {
            GitImpl.$$$reportNull$$$0(131);
        }
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.REMOTE);
        h.addParameters("remove", remote.getName());
        GitCommandResult gitCommandResult = this.runCommand(h);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(132);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult renameRemote(@NotNull GitRepository repository, @NotNull String oldName, @NotNull String newName) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(133);
        }
        if (oldName == null) {
            GitImpl.$$$reportNull$$$0(134);
        }
        if (newName == null) {
            GitImpl.$$$reportNull$$$0(135);
        }
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.REMOTE);
        h.addParameters("rename", oldName, newName);
        GitCommandResult gitCommandResult = this.runCommand(h);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(136);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult setRemoteUrl(@NotNull GitRepository repository, @NotNull String remoteName, @NotNull String newUrl) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(137);
        }
        if (remoteName == null) {
            GitImpl.$$$reportNull$$$0(138);
        }
        if (newUrl == null) {
            GitImpl.$$$reportNull$$$0(139);
        }
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.REMOTE);
        h.addParameters("set-url", remoteName, newUrl);
        GitCommandResult gitCommandResult = this.runCommand(h);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(140);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult lsRemote(@NotNull Project project, @NotNull File workingDir, @NotNull String url) {
        if (project == null) {
            GitImpl.$$$reportNull$$$0(141);
        }
        if (workingDir == null) {
            GitImpl.$$$reportNull$$$0(142);
        }
        if (url == null) {
            GitImpl.$$$reportNull$$$0(143);
        }
        GitCommandResult gitCommandResult = this.doLsRemote(project, workingDir, url, Collections.singleton(url), Collections.emptyList(), new String[0]);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(144);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult lsRemote(@NotNull Project project, @NotNull VirtualFile workingDir, @NotNull GitRemote remote, String ... additionalParameters) {
        if (project == null) {
            GitImpl.$$$reportNull$$$0(145);
        }
        if (workingDir == null) {
            GitImpl.$$$reportNull$$$0(146);
        }
        if (remote == null) {
            GitImpl.$$$reportNull$$$0(147);
        }
        GitCommandResult gitCommandResult = this.lsRemoteRefs(project, workingDir, remote, Collections.emptyList(), additionalParameters);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(148);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult lsRemoteRefs(@NotNull Project project, @NotNull VirtualFile workingDir, @NotNull GitRemote remote, @NotNull List<String> refs, String ... additionalParameters) {
        if (project == null) {
            GitImpl.$$$reportNull$$$0(149);
        }
        if (workingDir == null) {
            GitImpl.$$$reportNull$$$0(150);
        }
        if (remote == null) {
            GitImpl.$$$reportNull$$$0(151);
        }
        if (refs == null) {
            GitImpl.$$$reportNull$$$0(152);
        }
        GitCommandResult gitCommandResult = this.doLsRemote(project, VfsUtilCore.virtualToIoFile((VirtualFile)workingDir), remote.getName(), remote.getUrls(), refs, additionalParameters);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(153);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult remotePrune(@NotNull GitRepository repository, @NotNull GitRemote remote) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(154);
        }
        if (remote == null) {
            GitImpl.$$$reportNull$$$0(155);
        }
        GitCommandResult gitCommandResult = this.runCommand(() -> {
            GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.REMOTE.writeLockingCommand());
            h.setStdoutSuppressed(false);
            h.addParameters("prune");
            h.addParameters(remote.getName());
            h.setUrls(remote.getUrls());
            return h;
        });
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(156);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitRebaseCommandResult rebase(@NotNull GitRepository repository, @NotNull GitRebaseParams parameters, GitLineHandlerListener ... listeners) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(157);
        }
        if (parameters == null) {
            GitImpl.$$$reportNull$$$0(158);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(159);
        }
        Project project = repository.getProject();
        VirtualFile root = repository.getRoot();
        GitLineHandler handler = new GitLineHandler(project, root, GitCommand.REBASE, REBASE_CONFIG_PARAMS);
        handler.addParameters(parameters.asCommandLineArguments());
        GitImpl.addListeners(handler, listeners);
        if (parameters.isInteractive()) {
            GitRebaseEditorHandler editorHandler = parameters.getEditorHandler();
            if (editorHandler == null) {
                editorHandler = this.createEditor(project, root, handler, true);
            }
            GitRebaseCommandResult gitRebaseCommandResult = this.runWithEditor(handler, editorHandler);
            if (gitRebaseCommandResult == null) {
                GitImpl.$$$reportNull$$$0(160);
            }
            return gitRebaseCommandResult;
        }
        GitRebaseCommandResult gitRebaseCommandResult = GitRebaseCommandResult.normal(this.runCommand(handler));
        if (gitRebaseCommandResult == null) {
            GitImpl.$$$reportNull$$$0(161);
        }
        return gitRebaseCommandResult;
    }

    @Override
    @NotNull
    public GitRebaseCommandResult rebaseAbort(@NotNull GitRepository repository, GitLineHandlerListener ... listeners) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(162);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(163);
        }
        GitLineHandler handler = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.REBASE);
        handler.addParameters("--abort");
        GitImpl.addListeners(handler, listeners);
        GitRebaseCommandResult gitRebaseCommandResult = GitRebaseCommandResult.normal(this.runCommand(handler));
        if (gitRebaseCommandResult == null) {
            GitImpl.$$$reportNull$$$0(164);
        }
        return gitRebaseCommandResult;
    }

    @Override
    @NotNull
    public GitRebaseCommandResult rebaseContinue(@NotNull GitRepository repository, GitLineHandlerListener ... listeners) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(165);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(166);
        }
        GitRebaseCommandResult gitRebaseCommandResult = this.rebaseResume(repository, GitRebaseResumeMode.CONTINUE, listeners);
        if (gitRebaseCommandResult == null) {
            GitImpl.$$$reportNull$$$0(167);
        }
        return gitRebaseCommandResult;
    }

    @Override
    @NotNull
    public GitRebaseCommandResult rebaseSkip(@NotNull GitRepository repository, GitLineHandlerListener ... listeners) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(168);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(169);
        }
        GitRebaseCommandResult gitRebaseCommandResult = this.rebaseResume(repository, GitRebaseResumeMode.SKIP, listeners);
        if (gitRebaseCommandResult == null) {
            GitImpl.$$$reportNull$$$0(170);
        }
        return gitRebaseCommandResult;
    }

    @NotNull
    private GitRebaseCommandResult rebaseResume(@NotNull GitRepository repository, @NotNull GitRebaseResumeMode rebaseMode, @NotNull GitLineHandlerListener[] listeners) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(171);
        }
        if (rebaseMode == null) {
            GitImpl.$$$reportNull$$$0(172);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(173);
        }
        Project project = repository.getProject();
        VirtualFile root = repository.getRoot();
        GitLineHandler handler = new GitLineHandler(project, root, GitCommand.REBASE, REBASE_CONFIG_PARAMS);
        handler.addParameters(rebaseMode.asCommandLineArgument());
        GitImpl.addListeners(handler, listeners);
        GitRebaseCommandResult gitRebaseCommandResult = this.runWithEditor(handler, this.createEditor(project, root, handler, false));
        if (gitRebaseCommandResult == null) {
            GitImpl.$$$reportNull$$$0(174);
        }
        return gitRebaseCommandResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private GitRebaseCommandResult runWithEditor(@NotNull GitLineHandler handler, @NotNull GitRebaseEditorHandler editorHandler) {
        if (handler == null) {
            GitImpl.$$$reportNull$$$0(175);
        }
        if (editorHandler == null) {
            GitImpl.$$$reportNull$$$0(176);
        }
        GitRebaseEditorService service = GitRebaseEditorService.getInstance();
        service.configureHandler(handler, editorHandler.getHandlerNo());
        GitCommandResult result2 = this.runCommand(handler);
        if (editorHandler.wasCommitListEditorCancelled()) {
            GitRebaseCommandResult gitRebaseCommandResult = GitRebaseCommandResult.cancelledInCommitList(result2);
            GitRebaseCommandResult gitRebaseCommandResult2 = gitRebaseCommandResult;
            if (gitRebaseCommandResult2 == null) {
                GitImpl.$$$reportNull$$$0(177);
            }
            return gitRebaseCommandResult2;
        }
        if (editorHandler.wasUnstructuredEditorCancelled()) {
            GitRebaseCommandResult gitRebaseCommandResult = GitRebaseCommandResult.cancelledInCommitMessage(result2);
            GitRebaseCommandResult gitRebaseCommandResult3 = gitRebaseCommandResult;
            if (gitRebaseCommandResult3 == null) {
                GitImpl.$$$reportNull$$$0(178);
            }
            return gitRebaseCommandResult3;
        }
        GitRebaseCommandResult gitRebaseCommandResult = GitRebaseCommandResult.normal(result2);
        GitRebaseCommandResult gitRebaseCommandResult4 = gitRebaseCommandResult;
        if (gitRebaseCommandResult4 == null) {
            GitImpl.$$$reportNull$$$0(179);
        }
        return gitRebaseCommandResult4;
        finally {
            service.unregisterHandler(editorHandler.getHandlerNo());
        }
    }

    @VisibleForTesting
    @NotNull
    protected GitInteractiveRebaseEditorHandler createEditor(@NotNull Project project, @NotNull VirtualFile root, @NotNull GitLineHandler handler, boolean commitListAware) {
        if (project == null) {
            GitImpl.$$$reportNull$$$0(180);
        }
        if (root == null) {
            GitImpl.$$$reportNull$$$0(181);
        }
        if (handler == null) {
            GitImpl.$$$reportNull$$$0(182);
        }
        GitInteractiveRebaseEditorHandler editor = new GitInteractiveRebaseEditorHandler(GitRebaseEditorService.getInstance(), project, root);
        if (!commitListAware) {
            editor.setRebaseEditorShown();
        }
        GitInteractiveRebaseEditorHandler gitInteractiveRebaseEditorHandler = editor;
        if (gitInteractiveRebaseEditorHandler == null) {
            GitImpl.$$$reportNull$$$0(183);
        }
        return gitInteractiveRebaseEditorHandler;
    }

    @Override
    @NotNull
    public GitCommandResult revert(@NotNull GitRepository repository, @NotNull String commit2, boolean autoCommit, GitLineHandlerListener ... listeners) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(184);
        }
        if (commit2 == null) {
            GitImpl.$$$reportNull$$$0(185);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(186);
        }
        GitLineHandler handler = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.REVERT);
        handler.addParameters(commit2);
        if (!autoCommit) {
            handler.addParameters("--no-commit");
        }
        GitImpl.addListeners(handler, listeners);
        GitCommandResult gitCommandResult = this.runCommand(handler);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(187);
        }
        return gitCommandResult;
    }

    @NotNull
    private GitCommandResult doLsRemote(@NotNull Project project, @NotNull File workingDir, @NotNull String remoteId, @NotNull Collection<String> authenticationUrls, @NotNull List<String> refs, String ... additionalParameters) {
        if (project == null) {
            GitImpl.$$$reportNull$$$0(188);
        }
        if (workingDir == null) {
            GitImpl.$$$reportNull$$$0(189);
        }
        if (remoteId == null) {
            GitImpl.$$$reportNull$$$0(190);
        }
        if (authenticationUrls == null) {
            GitImpl.$$$reportNull$$$0(191);
        }
        if (refs == null) {
            GitImpl.$$$reportNull$$$0(192);
        }
        GitCommandResult gitCommandResult = this.runCommand(() -> {
            GitLineHandler h = new GitLineHandler(project, workingDir, GitCommand.LS_REMOTE);
            h.addParameters(additionalParameters);
            h.addParameters(remoteId);
            h.addParameters(refs);
            h.setUrls(authenticationUrls);
            return h;
        });
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(193);
        }
        return gitCommandResult;
    }

    @Override
    @NotNull
    public GitCommandResult getObjectType(@NotNull GitRepository repository, @NotNull String object) {
        if (repository == null) {
            GitImpl.$$$reportNull$$$0(194);
        }
        if (object == null) {
            GitImpl.$$$reportNull$$$0(195);
        }
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.CAT_FILE);
        h.setSilent(true);
        h.addParameters("-t", object);
        GitCommandResult gitCommandResult = this.runCommand(h);
        if (gitCommandResult == null) {
            GitImpl.$$$reportNull$$$0(196);
        }
        return gitCommandResult;
    }

    private static void addListeners(@NotNull GitLineHandler handler, GitLineHandlerListener ... listeners) {
        if (handler == null) {
            GitImpl.$$$reportNull$$$0(197);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(198);
        }
        GitImpl.addListeners(handler, Arrays.asList(listeners));
    }

    private static void addListeners(@NotNull GitLineHandler handler, @NotNull List<GitLineHandlerListener> listeners) {
        if (handler == null) {
            GitImpl.$$$reportNull$$$0(199);
        }
        if (listeners == null) {
            GitImpl.$$$reportNull$$$0(200);
        }
        for (GitLineHandlerListener listener : listeners) {
            handler.addLineListener(listener);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 16: 
            case 19: 
            case 25: 
            case 27: 
            case 31: 
            case 35: 
            case 38: 
            case 41: 
            case 45: 
            case 49: 
            case 52: 
            case 56: 
            case 60: 
            case 64: 
            case 67: 
            case 71: 
            case 76: 
            case 81: 
            case 83: 
            case 87: 
            case 90: 
            case 95: 
            case 98: 
            case 104: 
            case 107: 
            case 111: 
            case 115: 
            case 117: 
            case 121: 
            case 125: 
            case 129: 
            case 132: 
            case 136: 
            case 140: 
            case 144: 
            case 148: 
            case 153: 
            case 156: 
            case 160: 
            case 161: 
            case 164: 
            case 167: 
            case 170: 
            case 174: 
            case 177: 
            case 178: 
            case 179: 
            case 183: 
            case 187: 
            case 193: 
            case 196: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 16: 
            case 19: 
            case 25: 
            case 27: 
            case 31: 
            case 35: 
            case 38: 
            case 41: 
            case 45: 
            case 49: 
            case 52: 
            case 56: 
            case 60: 
            case 64: 
            case 67: 
            case 71: 
            case 76: 
            case 81: 
            case 83: 
            case 87: 
            case 90: 
            case 95: 
            case 98: 
            case 104: 
            case 107: 
            case 111: 
            case 115: 
            case 117: 
            case 121: 
            case 125: 
            case 129: 
            case 132: 
            case 136: 
            case 140: 
            case 144: 
            case 148: 
            case 153: 
            case 156: 
            case 160: 
            case 161: 
            case 164: 
            case 167: 
            case 170: 
            case 174: 
            case 177: 
            case 178: 
            case 179: 
            case 183: 
            case 187: 
            case 193: 
            case 196: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 10: 
            case 15: 
            case 18: 
            case 181: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: 
            case 24: 
            case 40: 
            case 44: 
            case 48: 
            case 59: 
            case 63: 
            case 75: 
            case 80: 
            case 86: 
            case 94: 
            case 103: 
            case 110: 
            case 114: 
            case 120: 
            case 124: 
            case 159: 
            case 163: 
            case 166: 
            case 169: 
            case 173: 
            case 186: 
            case 198: 
            case 200: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listeners";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 16: 
            case 19: 
            case 25: 
            case 27: 
            case 31: 
            case 35: 
            case 38: 
            case 41: 
            case 45: 
            case 49: 
            case 52: 
            case 56: 
            case 60: 
            case 64: 
            case 67: 
            case 71: 
            case 76: 
            case 81: 
            case 83: 
            case 87: 
            case 90: 
            case 95: 
            case 98: 
            case 104: 
            case 107: 
            case 111: 
            case 115: 
            case 117: 
            case 121: 
            case 125: 
            case 129: 
            case 132: 
            case 136: 
            case 140: 
            case 144: 
            case 148: 
            case 153: 
            case 156: 
            case 160: 
            case 161: 
            case 164: 
            case 167: 
            case 170: 
            case 174: 
            case 177: 
            case 178: 
            case 179: 
            case 183: 
            case 187: 
            case 193: 
            case 196: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/commands/GitImpl";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileStatusPrefix";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDirectory";
                break;
            }
            case 22: 
            case 128: 
            case 143: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clonedDirectoryName";
                break;
            }
            case 26: 
            case 28: 
            case 32: 
            case 36: 
            case 39: 
            case 42: 
            case 46: 
            case 50: 
            case 53: 
            case 57: 
            case 61: 
            case 65: 
            case 68: 
            case 72: 
            case 77: 
            case 82: 
            case 84: 
            case 88: 
            case 91: 
            case 96: 
            case 99: 
            case 105: 
            case 108: 
            case 112: 
            case 116: 
            case 118: 
            case 122: 
            case 126: 
            case 130: 
            case 133: 
            case 137: 
            case 154: 
            case 157: 
            case 162: 
            case 165: 
            case 168: 
            case 171: 
            case 184: 
            case 194: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 29: 
            case 158: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchToMerge";
                break;
            }
            case 47: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 51: 
            case 62: 
            case 69: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchName";
                break;
            }
            case 54: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 66: 
            case 185: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commit";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startPoint";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentName";
                break;
            }
            case 74: 
            case 135: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 92: 
            case 119: 
            case 123: 
            case 131: 
            case 147: 
            case 151: 
            case 155: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remote";
                break;
            }
            case 93: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spec";
                break;
            }
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pushParams";
                break;
            }
            case 100: 
            case 138: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteName";
                break;
            }
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteUrls";
                break;
            }
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 109: 
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 134: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldName";
                break;
            }
            case 139: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newUrl";
                break;
            }
            case 142: 
            case 146: 
            case 150: 
            case 189: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDir";
                break;
            }
            case 152: 
            case 192: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
            case 172: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rebaseMode";
                break;
            }
            case 175: 
            case 182: 
            case 197: 
            case 199: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 176: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorHandler";
                break;
            }
            case 190: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteId";
                break;
            }
            case 191: {
                objectArray2 = objectArray3;
                objectArray3[0] = "authenticationUrls";
                break;
            }
            case 195: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/commands/GitImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "init";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "ignoredFiles";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "ignoredFilesNoChunk";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "parseFiles";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "untrackedFiles";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "untrackedFilesNoChunk";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "clone";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "config";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "diff";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "checkAttr";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "stashSave";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "stashPop";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "merge";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "checkout";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "checkoutNewBranch";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewTag";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "deleteTag";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "branchDelete";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "branchContains";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "branchCreate";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "renameBranch";
                break;
            }
            case 81: 
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "reset";
                break;
            }
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "resetMerge";
                break;
            }
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "tip";
                break;
            }
            case 95: 
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "push";
                break;
            }
            case 104: {
                objectArray = objectArray2;
                objectArray2[1] = "doPush";
                break;
            }
            case 107: {
                objectArray = objectArray2;
                objectArray2[1] = "show";
                break;
            }
            case 111: 
            case 115: {
                objectArray = objectArray2;
                objectArray2[1] = "cherryPick";
                break;
            }
            case 117: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnmergedFiles";
                break;
            }
            case 121: 
            case 125: {
                objectArray = objectArray2;
                objectArray2[1] = "fetch";
                break;
            }
            case 129: {
                objectArray = objectArray2;
                objectArray2[1] = "addRemote";
                break;
            }
            case 132: {
                objectArray = objectArray2;
                objectArray2[1] = "removeRemote";
                break;
            }
            case 136: {
                objectArray = objectArray2;
                objectArray2[1] = "renameRemote";
                break;
            }
            case 140: {
                objectArray = objectArray2;
                objectArray2[1] = "setRemoteUrl";
                break;
            }
            case 144: 
            case 148: {
                objectArray = objectArray2;
                objectArray2[1] = "lsRemote";
                break;
            }
            case 153: {
                objectArray = objectArray2;
                objectArray2[1] = "lsRemoteRefs";
                break;
            }
            case 156: {
                objectArray = objectArray2;
                objectArray2[1] = "remotePrune";
                break;
            }
            case 160: 
            case 161: {
                objectArray = objectArray2;
                objectArray2[1] = "rebase";
                break;
            }
            case 164: {
                objectArray = objectArray2;
                objectArray2[1] = "rebaseAbort";
                break;
            }
            case 167: {
                objectArray = objectArray2;
                objectArray2[1] = "rebaseContinue";
                break;
            }
            case 170: {
                objectArray = objectArray2;
                objectArray2[1] = "rebaseSkip";
                break;
            }
            case 174: {
                objectArray = objectArray2;
                objectArray2[1] = "rebaseResume";
                break;
            }
            case 177: 
            case 178: 
            case 179: {
                objectArray = objectArray2;
                objectArray2[1] = "runWithEditor";
                break;
            }
            case 183: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 187: {
                objectArray = objectArray2;
                objectArray2[1] = "revert";
                break;
            }
            case 193: {
                objectArray = objectArray2;
                objectArray2[1] = "doLsRemote";
                break;
            }
            case 196: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 16: 
            case 19: 
            case 25: 
            case 27: 
            case 31: 
            case 35: 
            case 38: 
            case 41: 
            case 45: 
            case 49: 
            case 52: 
            case 56: 
            case 60: 
            case 64: 
            case 67: 
            case 71: 
            case 76: 
            case 81: 
            case 83: 
            case 87: 
            case 90: 
            case 95: 
            case 98: 
            case 104: 
            case 107: 
            case 111: 
            case 115: 
            case 117: 
            case 121: 
            case 125: 
            case 129: 
            case 132: 
            case 136: 
            case 140: 
            case 144: 
            case 148: 
            case 153: 
            case 156: 
            case 160: 
            case 161: 
            case 164: 
            case 167: 
            case 170: 
            case 174: 
            case 177: 
            case 178: 
            case 179: 
            case 183: 
            case 187: 
            case 193: 
            case 196: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "ignoredFiles";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "ignoredFilesNoChunk";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "parseFiles";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "untrackedFiles";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "untrackedFilesNoChunk";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "clone";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "config";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "diff";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "checkAttr";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "stashSave";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "stashPop";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "checkout";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "checkoutNewBranch";
                break;
            }
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "createNewTag";
                break;
            }
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "deleteTag";
                break;
            }
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "branchDelete";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "branchContains";
                break;
            }
            case 68: 
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "branchCreate";
                break;
            }
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "renameBranch";
                break;
            }
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 84: 
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "resetMerge";
                break;
            }
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "tip";
                break;
            }
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "push";
                break;
            }
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "doPush";
                break;
            }
            case 105: 
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "show";
                break;
            }
            case 108: 
            case 109: 
            case 110: 
            case 112: 
            case 113: 
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "cherryPick";
                break;
            }
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "getUnmergedFiles";
                break;
            }
            case 118: 
            case 119: 
            case 120: 
            case 122: 
            case 123: 
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "fetch";
                break;
            }
            case 126: 
            case 127: 
            case 128: {
                objectArray = objectArray;
                objectArray[2] = "addRemote";
                break;
            }
            case 130: 
            case 131: {
                objectArray = objectArray;
                objectArray[2] = "removeRemote";
                break;
            }
            case 133: 
            case 134: 
            case 135: {
                objectArray = objectArray;
                objectArray[2] = "renameRemote";
                break;
            }
            case 137: 
            case 138: 
            case 139: {
                objectArray = objectArray;
                objectArray[2] = "setRemoteUrl";
                break;
            }
            case 141: 
            case 142: 
            case 143: 
            case 145: 
            case 146: 
            case 147: {
                objectArray = objectArray;
                objectArray[2] = "lsRemote";
                break;
            }
            case 149: 
            case 150: 
            case 151: 
            case 152: {
                objectArray = objectArray;
                objectArray[2] = "lsRemoteRefs";
                break;
            }
            case 154: 
            case 155: {
                objectArray = objectArray;
                objectArray[2] = "remotePrune";
                break;
            }
            case 157: 
            case 158: 
            case 159: {
                objectArray = objectArray;
                objectArray[2] = "rebase";
                break;
            }
            case 162: 
            case 163: {
                objectArray = objectArray;
                objectArray[2] = "rebaseAbort";
                break;
            }
            case 165: 
            case 166: {
                objectArray = objectArray;
                objectArray[2] = "rebaseContinue";
                break;
            }
            case 168: 
            case 169: {
                objectArray = objectArray;
                objectArray[2] = "rebaseSkip";
                break;
            }
            case 171: 
            case 172: 
            case 173: {
                objectArray = objectArray;
                objectArray[2] = "rebaseResume";
                break;
            }
            case 175: 
            case 176: {
                objectArray = objectArray;
                objectArray[2] = "runWithEditor";
                break;
            }
            case 180: 
            case 181: 
            case 182: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 184: 
            case 185: 
            case 186: {
                objectArray = objectArray;
                objectArray[2] = "revert";
                break;
            }
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: {
                objectArray = objectArray;
                objectArray[2] = "doLsRemote";
                break;
            }
            case 194: 
            case 195: {
                objectArray = objectArray;
                objectArray[2] = "getObjectType";
                break;
            }
            case 197: 
            case 198: 
            case 199: 
            case 200: {
                objectArray = objectArray;
                objectArray[2] = "addListeners";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 16: 
            case 19: 
            case 25: 
            case 27: 
            case 31: 
            case 35: 
            case 38: 
            case 41: 
            case 45: 
            case 49: 
            case 52: 
            case 56: 
            case 60: 
            case 64: 
            case 67: 
            case 71: 
            case 76: 
            case 81: 
            case 83: 
            case 87: 
            case 90: 
            case 95: 
            case 98: 
            case 104: 
            case 107: 
            case 111: 
            case 115: 
            case 117: 
            case 121: 
            case 125: 
            case 129: 
            case 132: 
            case 136: 
            case 140: 
            case 144: 
            case 148: 
            case 153: 
            case 156: 
            case 160: 
            case 161: 
            case 164: 
            case 167: 
            case 170: 
            case 174: 
            case 177: 
            case 178: 
            case 179: 
            case 183: 
            case 187: 
            case 193: 
            case 196: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

