/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcsUtil.VcsFileUtil;
import git4idea.GitVcs;
import git4idea.util.GitUIUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class BasicAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent event) {
        if (event == null) {
            BasicAction.$$$reportNull$$$0(0);
        }
        final Project project = (Project)event.getRequiredData(CommonDataKeys.PROJECT);
        ApplicationManager.getApplication().runWriteAction(() -> FileDocumentManager.getInstance().saveAllDocuments());
        VirtualFile[] vFiles = (VirtualFile[])event.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        assert (vFiles != null) : "The action is only available when files are selected";
        GitVcs vcs = GitVcs.getInstance(project);
        if (!ProjectLevelVcsManager.getInstance((Project)project).checkAllFilesAreUnder((AbstractVcs)vcs, vFiles)) {
            return;
        }
        final String actionName = this.getActionName();
        final ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
        final VirtualFile[] affectedFiles = this.collectAffectedFiles(project, vFiles);
        boolean background = this.perform(project, vcs, exceptions, affectedFiles);
        if (!background) {
            GitVcs.runInBackground(new Task.Backgroundable(project, this.getActionName()){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)false, (VirtualFile[])affectedFiles);
                    VcsFileUtil.markFilesDirty((Project)project, Arrays.asList(affectedFiles));
                    UIUtil.invokeLaterIfNeeded(() -> GitUIUtil.showOperationErrors(project, exceptions, actionName));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/actions/BasicAction$1", "run"));
                }
            });
        }
    }

    protected abstract boolean perform(@NotNull Project var1, GitVcs var2, @NotNull List<VcsException> var3, @NotNull VirtualFile[] var4);

    @NotNull
    protected VirtualFile[] collectAffectedFiles(@NotNull Project project, @NotNull VirtualFile[] files) {
        if (project == null) {
            BasicAction.$$$reportNull$$$0(1);
        }
        if (files == null) {
            BasicAction.$$$reportNull$$$0(2);
        }
        ArrayList<VirtualFile> affectedFiles = new ArrayList<VirtualFile>(files.length);
        ProjectLevelVcsManager projectLevelVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        for (VirtualFile file : files) {
            if (!file.isDirectory() && projectLevelVcsManager.getVcsFor(file) instanceof GitVcs) {
                affectedFiles.add(file);
                continue;
            }
            if (!file.isDirectory()) continue;
            this.addChildren(project, affectedFiles, file);
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(affectedFiles);
        if (virtualFileArray == null) {
            BasicAction.$$$reportNull$$$0(3);
        }
        return virtualFileArray;
    }

    private void addChildren(final @NotNull Project project, final @NotNull List<VirtualFile> files, @NotNull VirtualFile file) {
        if (project == null) {
            BasicAction.$$$reportNull$$$0(4);
        }
        if (files == null) {
            BasicAction.$$$reportNull$$$0(5);
        }
        if (file == null) {
            BasicAction.$$$reportNull$$$0(6);
        }
        VfsUtilCore.visitChildrenRecursively((VirtualFile)file, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[]{VirtualFileVisitor.SKIP_ROOT, null}){

            public boolean visitFile(@NotNull VirtualFile file) {
                if (file == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (!file.isDirectory() && BasicAction.this.appliesTo(project, file)) {
                    files.add(file);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "git4idea/actions/BasicAction$2", "visitFile"));
            }
        });
    }

    @NotNull
    protected abstract String getActionName();

    protected boolean appliesTo(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            BasicAction.$$$reportNull$$$0(7);
        }
        if (file == null) {
            BasicAction.$$$reportNull$$$0(8);
        }
        return !file.isDirectory();
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            BasicAction.$$$reportNull$$$0(9);
        }
        super.update(e);
        Presentation presentation = e.getPresentation();
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            presentation.setEnabled(false);
            presentation.setVisible(false);
            return;
        }
        VirtualFile[] vFiles = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (vFiles == null || vFiles.length == 0) {
            presentation.setEnabled(false);
            presentation.setVisible(true);
            return;
        }
        GitVcs vcs = GitVcs.getInstance(project);
        boolean enabled = ProjectLevelVcsManager.getInstance((Project)project).checkAllFilesAreUnder((AbstractVcs)vcs, vFiles) && this.isEnabled(project, vcs, vFiles);
        presentation.setEnabled(enabled);
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            presentation.setVisible(enabled);
        } else {
            presentation.setVisible(true);
        }
    }

    protected abstract boolean isEnabled(@NotNull Project var1, @NotNull GitVcs var2, VirtualFile ... var3);

    public static void saveAll() {
        ApplicationManager.getApplication().runWriteAction(() -> FileDocumentManager.getInstance().saveAllDocuments());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/actions/BasicAction";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/actions/BasicAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "collectAffectedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collectAffectedFiles";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addChildren";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "appliesTo";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

