/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.wizards;

import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleNameLocationSettings;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.ide.util.projectWizard.SourcePathsBuilder;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import icons.MavenIcons;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenArchetype;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenEnvironmentForm;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.idea.maven.wizards.MavenArchetypesStep;
import org.jetbrains.idea.maven.wizards.MavenModuleBuilderHelper;
import org.jetbrains.idea.maven.wizards.MavenModuleWizardStep;
import org.jetbrains.idea.maven.wizards.SelectPropertiesStep;

public class MavenModuleBuilder
extends ModuleBuilder
implements SourcePathsBuilder {
    private MavenProject myAggregatorProject;
    private MavenProject myParentProject;
    private boolean myInheritGroupId;
    private boolean myInheritVersion;
    private MavenId myProjectId;
    private MavenArchetype myArchetype;
    private MavenEnvironmentForm myEnvironmentForm;
    private Map<String, String> myPropertiesToCreateByArtifact;

    public void setupRootModel(@NotNull ModifiableRootModel rootModel) {
        if (rootModel == null) {
            MavenModuleBuilder.$$$reportNull$$$0(0);
        }
        Project project = rootModel.getProject();
        VirtualFile root = this.createAndGetContentEntry();
        rootModel.addContentEntry(root);
        if (this.myJdk != null) {
            rootModel.setSdk(this.myJdk);
        } else {
            rootModel.inheritSdk();
        }
        MavenUtil.runWhenInitialized(project, (Runnable)((DumbAwareRunnable)() -> {
            if (this.myEnvironmentForm != null) {
                this.myEnvironmentForm.setData(MavenProjectsManager.getInstance(project).getGeneralSettings());
            }
            new MavenModuleBuilderHelper(this.myProjectId, this.myAggregatorProject, this.myParentProject, this.myInheritGroupId, this.myInheritVersion, this.myArchetype, this.myPropertiesToCreateByArtifact, "Create new Maven module").configure(project, root, false);
        }));
    }

    public String getBuilderId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getPresentableName() {
        return "Maven";
    }

    public String getParentGroup() {
        return "Build Tools";
    }

    public int getWeight() {
        return 80;
    }

    public String getDescription() {
        return "Maven modules are used for developing <b>JVM-based</b> applications with dependencies managed by <b>Maven</b>. You can create either a blank Maven module or a module based on a <b>Maven archetype</b>.";
    }

    public Icon getNodeIcon() {
        return MavenIcons.MavenLogo;
    }

    public ModuleType getModuleType() {
        return StdModuleTypes.JAVA;
    }

    public boolean isSuitableSdkType(SdkTypeId sdk) {
        return sdk == JavaSdk.getInstance();
    }

    public ModuleWizardStep[] createWizardSteps(@NotNull WizardContext wizardContext, @NotNull ModulesProvider modulesProvider) {
        if (wizardContext == null) {
            MavenModuleBuilder.$$$reportNull$$$0(1);
        }
        if (modulesProvider == null) {
            MavenModuleBuilder.$$$reportNull$$$0(2);
        }
        return new ModuleWizardStep[]{new MavenModuleWizardStep(this, wizardContext, !wizardContext.isNewWizard()), new SelectPropertiesStep(wizardContext.getProject(), this)};
    }

    private VirtualFile createAndGetContentEntry() {
        String path = FileUtil.toSystemIndependentName((String)this.getContentEntryPath());
        new File(path).mkdirs();
        return LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
    }

    public List<Pair<String, String>> getSourcePaths() {
        return Collections.emptyList();
    }

    public void setSourcePaths(List<Pair<String, String>> sourcePaths) {
    }

    public void addSourcePath(Pair<String, String> sourcePathInfo) {
    }

    public void setAggregatorProject(MavenProject project) {
        this.myAggregatorProject = project;
    }

    public MavenProject getAggregatorProject() {
        return this.myAggregatorProject;
    }

    public void setParentProject(MavenProject project) {
        this.myParentProject = project;
    }

    public MavenProject getParentProject() {
        return this.myParentProject;
    }

    public void setInheritedOptions(boolean groupId, boolean version) {
        this.myInheritGroupId = groupId;
        this.myInheritVersion = version;
    }

    public boolean isInheritGroupId() {
        return this.myInheritGroupId;
    }

    public boolean isInheritVersion() {
        return this.myInheritVersion;
    }

    public void setProjectId(MavenId id) {
        this.myProjectId = id;
    }

    public MavenId getProjectId() {
        return this.myProjectId;
    }

    public void setArchetype(MavenArchetype archetype) {
        this.myArchetype = archetype;
    }

    public MavenArchetype getArchetype() {
        return this.myArchetype;
    }

    public MavenEnvironmentForm getEnvironmentForm() {
        return this.myEnvironmentForm;
    }

    public void setEnvironmentForm(MavenEnvironmentForm environmentForm) {
        this.myEnvironmentForm = environmentForm;
    }

    public Map<String, String> getPropertiesToCreateByArtifact() {
        return this.myPropertiesToCreateByArtifact;
    }

    public void setPropertiesToCreateByArtifact(Map<String, String> propertiesToCreateByArtifact) {
        this.myPropertiesToCreateByArtifact = propertiesToCreateByArtifact;
    }

    public String getGroupName() {
        return "Maven";
    }

    @Nullable
    public ModuleWizardStep getCustomOptionsStep(WizardContext context, Disposable parentDisposable) {
        MavenArchetypesStep step = new MavenArchetypesStep(this, null);
        Disposer.register((Disposable)parentDisposable, (Disposable)step);
        return step;
    }

    @Nullable
    public ModuleWizardStep modifySettingsStep(@NotNull SettingsStep settingsStep) {
        ModuleNameLocationSettings nameLocationSettings;
        if (settingsStep == null) {
            MavenModuleBuilder.$$$reportNull$$$0(3);
        }
        if ((nameLocationSettings = settingsStep.getModuleNameLocationSettings()) != null && this.myProjectId != null && this.myProjectId.getArtifactId() != null) {
            nameLocationSettings.setModuleName(StringUtil.sanitizeJavaIdentifier((String)this.myProjectId.getArtifactId()));
            if (this.myAggregatorProject != null) {
                nameLocationSettings.setModuleContentRoot(this.myAggregatorProject.getDirectory() + "/" + this.myProjectId.getArtifactId());
            }
        }
        return super.modifySettingsStep(settingsStep);
    }

    @Nullable
    public Project createProject(String name, String path) {
        return ExternalProjectsManagerImpl.setupCreatedProject((Project)super.createProject(name, path));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wizardContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulesProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsStep";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/wizards/MavenModuleBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setupRootModel";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createWizardSteps";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "modifySettingsStep";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

