/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils;

import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Condition;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;

public class MavenProgressIndicator {
    private ProgressIndicator myIndicator;
    private final List<Condition<MavenProgressIndicator>> myCancelConditions = new ArrayList<Condition<MavenProgressIndicator>>();

    public MavenProgressIndicator() {
        this((ProgressIndicator)new MyEmptyProgressIndicator());
    }

    public MavenProgressIndicator(ProgressIndicator i) {
        this.myIndicator = i;
    }

    public synchronized void setIndicator(ProgressIndicator i) {
        i.setText(this.myIndicator.getText());
        i.setText2(this.myIndicator.getText2());
        if (!i.isIndeterminate()) {
            i.setFraction(this.myIndicator.getFraction());
        }
        if (i.isCanceled()) {
            i.cancel();
        }
        this.myIndicator = i;
    }

    public synchronized ProgressIndicator getIndicator() {
        return this.myIndicator;
    }

    public synchronized void setText(String text) {
        this.myIndicator.setText(text);
    }

    public synchronized void setText2(String text) {
        this.myIndicator.setText2(text);
    }

    public synchronized void setFraction(double fraction) {
        this.myIndicator.setIndeterminate(false);
        this.myIndicator.setFraction(fraction);
    }

    public synchronized void setIndeterminate(boolean indeterminate) {
        this.myIndicator.setIndeterminate(indeterminate);
    }

    public synchronized void pushState() {
        this.myIndicator.pushState();
    }

    public synchronized void popState() {
        this.myIndicator.popState();
    }

    public synchronized void cancel() {
        this.myIndicator.cancel();
    }

    public synchronized void addCancelCondition(Condition<MavenProgressIndicator> condition) {
        this.myCancelConditions.add(condition);
    }

    public synchronized void removeCancelCondition(Condition<MavenProgressIndicator> condition) {
        this.myCancelConditions.remove(condition);
    }

    public synchronized boolean isCanceled() {
        if (this.myIndicator.isCanceled()) {
            return true;
        }
        for (Condition<MavenProgressIndicator> each : this.myCancelConditions) {
            if (!each.value((Object)this)) continue;
            return true;
        }
        return false;
    }

    public void checkCanceled() throws MavenProcessCanceledException {
        if (this.isCanceled()) {
            throw new MavenProcessCanceledException();
        }
    }

    public void checkCanceledNative() {
        if (this.isCanceled()) {
            throw new ProcessCanceledException();
        }
    }

    private static class MyEmptyProgressIndicator
    extends EmptyProgressIndicator {
        private String myText;
        private String myText2;
        private double myFraction;

        private MyEmptyProgressIndicator() {
        }

        public void setText(String text) {
            this.myText = text;
        }

        public String getText() {
            return this.myText;
        }

        public void setText2(String text) {
            this.myText2 = text;
        }

        public String getText2() {
            return this.myText2;
        }

        public void setFraction(double fraction) {
            this.myFraction = fraction;
        }

        public double getFraction() {
            return this.myFraction;
        }
    }
}

