/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenParentDesc;
import org.jetbrains.idea.maven.utils.MavenArtifactUtil;

public abstract class MavenParentProjectFileProcessor<RESULT_TYPE> {
    @Nullable
    public RESULT_TYPE process(@NotNull MavenGeneralSettings generalSettings, @NotNull VirtualFile projectFile, @Nullable MavenParentDesc parentDesc) {
        VirtualFile superPom;
        if (generalSettings == null) {
            MavenParentProjectFileProcessor.$$$reportNull$$$0(0);
        }
        if (projectFile == null) {
            MavenParentProjectFileProcessor.$$$reportNull$$$0(1);
        }
        if ((superPom = generalSettings.getEffectiveSuperPom()) == null || projectFile.equals(superPom)) {
            return null;
        }
        RESULT_TYPE result = null;
        if (parentDesc == null) {
            return this.processSuperParent(superPom);
        }
        VirtualFile parentFile = this.findManagedFile(parentDesc.getParentId());
        if (parentFile != null) {
            result = this.processManagedParent(parentFile);
        }
        if (result == null && projectFile.getParent() != null) {
            parentFile = projectFile.getParent().findFileByRelativePath(parentDesc.getParentRelativePath());
            if (parentFile != null && parentFile.isDirectory()) {
                parentFile = parentFile.findFileByRelativePath("pom.xml");
            }
            if (parentFile != null) {
                result = this.processRelativeParent(parentFile);
            }
        }
        if (result == null) {
            File parentIoFile = MavenArtifactUtil.getArtifactFile(generalSettings.getEffectiveLocalRepository(), parentDesc.getParentId(), "pom");
            parentFile = LocalFileSystem.getInstance().findFileByIoFile(parentIoFile);
            if (parentFile != null) {
                result = this.processRepositoryParent(parentFile);
            }
        }
        return result;
    }

    @Nullable
    protected abstract VirtualFile findManagedFile(@NotNull MavenId var1);

    @Nullable
    protected RESULT_TYPE processManagedParent(VirtualFile parentFile) {
        return this.doProcessParent(parentFile);
    }

    @Nullable
    protected RESULT_TYPE processRelativeParent(VirtualFile parentFile) {
        return this.doProcessParent(parentFile);
    }

    @Nullable
    protected RESULT_TYPE processRepositoryParent(VirtualFile parentFile) {
        return this.doProcessParent(parentFile);
    }

    @Nullable
    protected RESULT_TYPE processSuperParent(VirtualFile parentFile) {
        return this.doProcessParent(parentFile);
    }

    @Nullable
    protected abstract RESULT_TYPE doProcessParent(VirtualFile var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "generalSettings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "projectFile";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/idea/maven/project/MavenParentProjectFileProcessor";
        objectArray[2] = "process";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

