/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.externalSystem.service.ui.ExternalSystemJdkComboBox;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.ExternalStorageConfigurationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.updateSettings.impl.LabelTextReplacingUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.projectImport.ProjectFormatPanel;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.ProjectBundle;

public class MavenImportingSettingsForm {
    private JPanel myPanel;
    private JCheckBox mySearchRecursivelyCheckBox;
    private JLabel myProjectFormatLabel;
    private JComboBox myProjectFormatComboBox;
    private ProjectFormatPanel myProjectFormatPanel;
    private JCheckBox mySeparateModulesDirCheckBox;
    private TextFieldWithBrowseButton mySeparateModulesDirChooser;
    private JCheckBox myImportAutomaticallyBox;
    private JCheckBox myCreateModulesForAggregators;
    private JCheckBox myCreateGroupsCheckBox;
    private JComboBox myUpdateFoldersOnImportPhaseComboBox;
    private JCheckBox myKeepSourceFoldersCheckBox;
    private JCheckBox myUseMavenOutputCheckBox;
    private JCheckBox myDownloadSourcesCheckBox;
    private JCheckBox myDownloadDocsCheckBox;
    private JCheckBox myDownloadAnnotationsCheckBox;
    private JPanel myAdditionalSettingsPanel;
    private JComboBox myGeneratedSourcesComboBox;
    private JCheckBox myExcludeTargetFolderCheckBox;
    private JTextField myDependencyTypes;
    private JCheckBox myStoreProjectFilesExternally;
    private JBTextField myVMOptionsForImporter;
    private ExternalSystemJdkComboBox myJdkForImporterComboBox;
    private JCheckBox myAutoDetectCompilerCheckBox;
    private JBCheckBox myJBCheckBox1;

    public MavenImportingSettingsForm(boolean isImportStep, boolean isCreatingNewProject) {
        this.$$$setupUI$$$();
        this.mySearchRecursivelyCheckBox.setVisible(isImportStep);
        this.myProjectFormatLabel.setVisible(isImportStep && isCreatingNewProject);
        this.myProjectFormatComboBox.setVisible(isImportStep && isCreatingNewProject);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MavenImportingSettingsForm.this.updateControls();
            }
        };
        this.mySeparateModulesDirCheckBox.addActionListener(listener);
        this.mySeparateModulesDirChooser.addBrowseFolderListener(ProjectBundle.message("maven.import.title.module.dir", new Object[0]), "", null, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        this.myUpdateFoldersOnImportPhaseComboBox.setModel(new DefaultComboBoxModel<String>(MavenImportingSettings.UPDATE_FOLDERS_PHASES));
        this.myGeneratedSourcesComboBox.setModel(new EnumComboBoxModel(MavenImportingSettings.GeneratedSourcesFolder.class));
        this.myGeneratedSourcesComboBox.setRenderer(new ListCellRendererWrapper(){

            public void customize(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (value instanceof MavenImportingSettings.GeneratedSourcesFolder) {
                    this.setText(((MavenImportingSettings.GeneratedSourcesFolder)((Object)value)).title);
                }
            }
        });
        LabelTextReplacingUtil.replaceText((JComponent)this.myPanel);
        this.myDownloadAnnotationsCheckBox.setVisible(Registry.is((String)"external.system.import.resolve.annotations"));
        this.myAutoDetectCompilerCheckBox.setVisible(Registry.is((String)"maven.import.compiler.arguments", (boolean)true));
    }

    private void createUIComponents() {
        this.myProjectFormatPanel = new ProjectFormatPanel();
        this.myProjectFormatComboBox = this.myProjectFormatPanel.getStorageFormatComboBox();
    }

    private void updateControls() {
        boolean useSeparateDir = this.mySeparateModulesDirCheckBox.isSelected();
        this.mySeparateModulesDirChooser.setEnabled(useSeparateDir);
        if (useSeparateDir && StringUtil.isEmptyOrSpaces((String)this.mySeparateModulesDirChooser.getText())) {
            this.mySeparateModulesDirChooser.setText(FileUtil.toSystemDependentName((String)this.getDefaultModuleDir()));
        }
    }

    public String getDefaultModuleDir() {
        return "";
    }

    public JComponent createComponent() {
        return this.myPanel;
    }

    public void getData(@NotNull MavenImportingSettings data) {
        if (data == null) {
            MavenImportingSettingsForm.$$$reportNull$$$0(0);
        }
        data.setLookForNested(this.mySearchRecursivelyCheckBox.isSelected());
        data.setDedicatedModuleDir(this.mySeparateModulesDirCheckBox.isSelected() ? this.mySeparateModulesDirChooser.getText() : "");
        data.setImportAutomatically(this.myImportAutomaticallyBox.isSelected());
        data.setCreateModulesForAggregators(this.myCreateModulesForAggregators.isSelected());
        data.setCreateModuleGroups(this.myCreateGroupsCheckBox.isSelected());
        data.setKeepSourceFolders(this.myKeepSourceFoldersCheckBox.isSelected());
        data.setExcludeTargetFolder(this.myExcludeTargetFolderCheckBox.isSelected());
        data.setUseMavenOutput(this.myUseMavenOutputCheckBox.isSelected());
        data.setUpdateFoldersOnImportPhase((String)this.myUpdateFoldersOnImportPhaseComboBox.getSelectedItem());
        data.setGeneratedSourcesFolder((MavenImportingSettings.GeneratedSourcesFolder)((Object)this.myGeneratedSourcesComboBox.getSelectedItem()));
        data.setDownloadSourcesAutomatically(this.myDownloadSourcesCheckBox.isSelected());
        data.setDownloadDocsAutomatically(this.myDownloadDocsCheckBox.isSelected());
        data.setDownloadAnnotationsAutomatically(this.myDownloadAnnotationsCheckBox.isSelected());
        data.setAutoDetectCompiler(this.myAutoDetectCompilerCheckBox.isSelected());
        data.setVmOptionsForImporter(this.myVMOptionsForImporter.getText());
        data.setJdkForImporter(this.myJdkForImporterComboBox.getSelectedValue());
        data.setDependencyTypes(this.myDependencyTypes.getText());
    }

    public void setData(MavenImportingSettings data, @Nullable Project project) {
        this.mySearchRecursivelyCheckBox.setSelected(data.isLookForNested());
        this.mySeparateModulesDirCheckBox.setSelected(!StringUtil.isEmptyOrSpaces((String)data.getDedicatedModuleDir()));
        this.mySeparateModulesDirChooser.setText(data.getDedicatedModuleDir());
        this.myImportAutomaticallyBox.setSelected(data.isImportAutomatically());
        this.myCreateModulesForAggregators.setSelected(data.isCreateModulesForAggregators());
        this.myCreateGroupsCheckBox.setSelected(data.isCreateModuleGroups());
        this.myKeepSourceFoldersCheckBox.setSelected(data.isKeepSourceFolders());
        if (project == null) {
            this.myStoreProjectFilesExternally.setVisible(false);
        } else {
            this.myStoreProjectFilesExternally.setVisible(true);
            this.myStoreProjectFilesExternally.setSelected(MavenImportingSettingsForm.isCurrentlyStoredExternally(project));
        }
        this.myExcludeTargetFolderCheckBox.setSelected(data.isExcludeTargetFolder());
        this.myUseMavenOutputCheckBox.setSelected(data.isUseMavenOutput());
        this.myUpdateFoldersOnImportPhaseComboBox.setSelectedItem(data.getUpdateFoldersOnImportPhase());
        this.myGeneratedSourcesComboBox.setSelectedItem((Object)data.getGeneratedSourcesFolder());
        this.myDownloadSourcesCheckBox.setSelected(data.isDownloadSourcesAutomatically());
        this.myDownloadDocsCheckBox.setSelected(data.isDownloadDocsAutomatically());
        this.myDownloadAnnotationsCheckBox.setSelected(data.isDownloadAnnotationsAutomatically());
        this.myAutoDetectCompilerCheckBox.setSelected(data.isAutoDetectCompiler());
        this.myDependencyTypes.setText(data.getDependencyTypes());
        this.myVMOptionsForImporter.setText(data.getVmOptionsForImporter());
        this.myJdkForImporterComboBox.refreshData(data.getJdkForImporter());
        this.updateControls();
    }

    private static boolean isCurrentlyStoredExternally(@Nullable Project project) {
        return project == null || ExternalStorageConfigurationManager.getInstance((Project)project).isEnabled();
    }

    public boolean isModified(@NotNull MavenImportingSettings settings, @Nullable Project project) {
        if (settings == null) {
            MavenImportingSettingsForm.$$$reportNull$$$0(1);
        }
        if (project != null && MavenImportingSettingsForm.isCurrentlyStoredExternally(project) != this.isStoreExternally()) {
            return true;
        }
        MavenImportingSettings formData = new MavenImportingSettings();
        this.getData(formData);
        return !formData.equals(settings);
    }

    boolean isStoreExternally() {
        return !this.myStoreProjectFilesExternally.isVisible() || this.myStoreProjectFilesExternally.isSelected();
    }

    public void updateData(WizardContext wizardContext) {
        this.myProjectFormatPanel.updateData(wizardContext);
    }

    public JPanel getAdditionalSettingsPanel() {
        return this.myAdditionalSettingsPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/project/MavenImportingSettingsForm";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getData";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isModified";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        ExternalSystemJdkComboBox externalSystemJdkComboBox;
        JBTextField jBTextField;
        JTextField jTextField;
        JCheckBox jCheckBox2;
        JComboBox jComboBox;
        JComboBox jComboBox2;
        JCheckBox jCheckBox3;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JCheckBox jCheckBox4;
        JLabel jLabel;
        JPanel jPanel;
        JCheckBox jCheckBox5;
        JCheckBox jCheckBox6;
        JCheckBox jCheckBox7;
        JCheckBox jCheckBox8;
        JCheckBox jCheckBox9;
        JCheckBox jCheckBox10;
        JCheckBox jCheckBox11;
        JCheckBox jCheckBox12;
        JPanel jPanel2;
        this.createUIComponents();
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(24, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myCreateModulesForAggregators = jCheckBox12 = new JCheckBox();
        jCheckBox12.setText("Create $FULLNAME$ modules for aggregator projects (with 'pom' packaging)");
        jCheckBox12.setMnemonic('M');
        jCheckBox12.setDisplayedMnemonicIndex(18);
        jPanel2.add((Component)jCheckBox12, new GridConstraints(6, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.myCreateGroupsCheckBox = jCheckBox11 = new JCheckBox();
        jCheckBox11.setText("Create module groups for multi-module Maven projects");
        jCheckBox11.setMnemonic('G');
        jCheckBox11.setDisplayedMnemonicIndex(14);
        jPanel2.add((Component)jCheckBox11, new GridConstraints(7, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.mySearchRecursivelyCheckBox = jCheckBox10 = new JCheckBox();
        jCheckBox10.setText("Search for projects recursively");
        jCheckBox10.setMnemonic('S');
        jCheckBox10.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jCheckBox10, new GridConstraints(0, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.myUseMavenOutputCheckBox = jCheckBox9 = new JCheckBox();
        jCheckBox9.setText("Use Maven output directories");
        jCheckBox9.setMnemonic('O');
        jCheckBox9.setDisplayedMnemonicIndex(10);
        jCheckBox9.setToolTipText("IDEA compiler will use output directory defined in maven model (target/classes by default) ");
        jPanel2.add((Component)jCheckBox9, new GridConstraints(10, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel.setFontColor(UIUtil.FontColor.BRIGHTER);
        jBLabel.setText("<html>IDEA needs to execute one of the listed phases in order to discover all source folders that are configured via Maven plugins.<br><b>Note</b> that all test-* phases firstly generate and compile production sources.</html>");
        jPanel2.add((Component)jBLabel, new GridConstraints(14, 0, 1, 3, 0, 1, 3, 0, null, null, null, 3));
        this.myImportAutomaticallyBox = jCheckBox8 = new JCheckBox();
        jCheckBox8.setText("Import Maven projects automatically");
        jCheckBox8.setMnemonic('A');
        jCheckBox8.setDisplayedMnemonicIndex(22);
        jCheckBox8.setToolTipText("Synchronize Maven project model and IDEA project model each time when pom.xml is changed  ");
        jPanel2.add((Component)jCheckBox8, new GridConstraints(4, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 5, new Insets(10, 0, 0, 0), -1, -1, false, false));
        jPanel3.setFocusable(true);
        jPanel2.add((Component)jPanel3, new GridConstraints(16, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Automatically download:");
        jPanel3.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDownloadSourcesCheckBox = jCheckBox7 = new JCheckBox();
        jCheckBox7.setText("Sources");
        jCheckBox7.setMnemonic('R');
        jCheckBox7.setDisplayedMnemonicIndex(3);
        jPanel3.add((Component)jCheckBox7, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myDownloadDocsCheckBox = jCheckBox6 = new JCheckBox();
        jCheckBox6.setText("Documentation");
        jCheckBox6.setMnemonic('D');
        jCheckBox6.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jCheckBox6, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 4, 1, 1, 0, 1, 6, 1, null, null, null));
        JBCheckBox jBCheckBox = new JBCheckBox();
        this.myDownloadAnnotationsCheckBox = jBCheckBox;
        jBCheckBox.setText("Annotations");
        jPanel3.add((Component)jBCheckBox, new GridConstraints(0, 3, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myKeepSourceFoldersCheckBox = jCheckBox5 = new JCheckBox();
        jCheckBox5.setText("Keep source and test folders on reimport");
        jCheckBox5.setMnemonic('F');
        jCheckBox5.setDisplayedMnemonicIndex(21);
        jPanel2.add((Component)jCheckBox5, new GridConstraints(8, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.myAdditionalSettingsPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(15, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(22, 0, 1, 3, 8, 2, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(16, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(2, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myProjectFormatLabel = jLabel = new JLabel();
        jLabel.setText("Project format:");
        jLabel.setDisplayedMnemonic('T');
        jLabel.setDisplayedMnemonicIndex(13);
        jPanel4.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox3 = this.myProjectFormatComboBox;
        jPanel4.add((Component)jComboBox3, new GridConstraints(0, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel4.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 10, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel5, new GridConstraints(3, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.mySeparateModulesDirCheckBox = jCheckBox4 = new JCheckBox();
        jCheckBox4.setText("Keep project files in:");
        jCheckBox4.setMnemonic('K');
        jCheckBox4.setDisplayedMnemonicIndex(0);
        jCheckBox4.setToolTipText("Keep IDEA specified files like *.iml / .idea in selected directory. By default *.iml files are stored beside the pom.xml ");
        jPanel5.add((Component)jCheckBox4, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mySeparateModulesDirChooser = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel5.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        this.myStoreProjectFilesExternally = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("Store generated project files externally");
        jPanel5.add((Component)jCheckBox3, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel2.add((Component)spacer4, new GridConstraints(23, 0, 1, 3, 0, 2, 1, 6, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel6, new GridConstraints(13, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myUpdateFoldersOnImportPhaseComboBox = jComboBox2 = new JComboBox();
        jPanel6.add(jComboBox2, new GridConstraints(0, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Phase to be used for folders update:");
        jLabel3.setDisplayedMnemonic('U');
        jLabel3.setDisplayedMnemonicIndex(29);
        jPanel6.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer5 = new Spacer();
        jPanel6.add((Component)spacer5, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer6 = new Spacer();
        jPanel2.add((Component)spacer6, new GridConstraints(12, 0, 1, 3, 0, 2, 1, 0, null, new Dimension(-1, 10), null));
        Spacer spacer7 = new Spacer();
        jPanel2.add((Component)spacer7, new GridConstraints(1, 0, 1, 3, 0, 2, 1, 0, null, new Dimension(-1, 10), null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel7, new GridConstraints(11, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Generated sources folders:");
        jPanel7.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer8 = new Spacer();
        jPanel7.add((Component)spacer8, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myGeneratedSourcesComboBox = jComboBox = new JComboBox();
        jPanel7.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myExcludeTargetFolderCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Exclude build directory (%PROJECT_ROOT%/target)");
        jCheckBox2.setToolTipText("If you select this options folder /target will be excluded from project during reimport. Compiler output (/target/classes and /target/test-classes) will be excluded anyway");
        jPanel2.add((Component)jCheckBox2, new GridConstraints(9, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("Dependency types:");
        jLabel5.setToolTipText(ResourceBundle.getBundle("ProjectBundle").getString("maven.import.dependency.type.description"));
        jPanel2.add((Component)jLabel5, new GridConstraints(17, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDependencyTypes = jTextField = new JTextField();
        jTextField.setColumns(0);
        jTextField.setToolTipText(ResourceBundle.getBundle("ProjectBundle").getString("maven.import.dependency.type.description"));
        jPanel2.add((Component)jTextField, new GridConstraints(17, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(60, -1), null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel2.setFontColor(UIUtil.FontColor.BRIGHTER);
        this.$$$loadLabelText$$$((JLabel)jBLabel2, ResourceBundle.getBundle("ProjectBundle").getString("maven.import.dependency.type.description"));
        jPanel2.add((Component)jBLabel2, new GridConstraints(18, 1, 1, 2, 9, 0, 0, 0, null, null, null));
        Spacer spacer9 = new Spacer();
        jPanel2.add((Component)spacer9, new GridConstraints(19, 0, 1, 3, 0, 2, 1, 0, null, new Dimension(-1, 10), null));
        Spacer spacer10 = new Spacer();
        jPanel2.add((Component)spacer10, new GridConstraints(15, 0, 1, 3, 0, 2, 1, 0, null, new Dimension(-1, 10), null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("VM options for importer:");
        jPanel2.add((Component)jBLabel3, new GridConstraints(20, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myVMOptionsForImporter = jBTextField = new JBTextField();
        jPanel2.add((Component)jBTextField, new GridConstraints(20, 1, 1, 2, 0, 1, 3, 3, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("JDK for importer:");
        jPanel2.add((Component)jBLabel4, new GridConstraints(21, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myJdkForImporterComboBox = externalSystemJdkComboBox = new ExternalSystemJdkComboBox();
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        externalSystemJdkComboBox.setModel(defaultComboBoxModel);
        jPanel2.add((Component)externalSystemJdkComboBox, new GridConstraints(21, 1, 1, 2, 0, 1, 2, 2, null, null, null));
        this.myAutoDetectCompilerCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setSelected(true);
        jCheckBox.setText("Detect compiler automatically");
        jCheckBox.setToolTipText("");
        jPanel2.add((Component)jCheckBox, new GridConstraints(5, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        jLabel.setLabelFor(jComboBox3);
        jLabel3.setLabelFor(jComboBox2);
        jLabel5.setLabelFor(jTextField);
        jBLabel2.setLabelFor(jTextField);
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

