/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.ide.util.projectWizard.importSources.JavaModuleSourceRoot;
import com.intellij.ide.util.projectWizard.importSources.JavaSourceRootDetectionUtil;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProviderImpl;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.ModifiableModelCommitter;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.LinkedMultiMap;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.NotNullList;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.importing.MavenImporter;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapter;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.model.MavenResource;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class MavenFoldersImporter {
    private final MavenProject myMavenProject;
    private final MavenImportingSettings myImportingSettings;
    private final MavenRootModelAdapter myModel;

    public static void updateProjectFolders(Project project, boolean updateTargetFoldersOnly) {
        MavenProjectsManager manager = MavenProjectsManager.getInstance(project);
        MavenImportingSettings settings = manager.getImportingSettings();
        WriteAction.run(() -> {
            ArrayList<ModifiableRootModel> rootModels = new ArrayList<ModifiableRootModel>();
            for (Module each : ModuleManager.getInstance((Project)project).getModules()) {
                MavenProject mavenProject = manager.findProject(each);
                if (mavenProject == null) continue;
                MavenRootModelAdapter a = new MavenRootModelAdapter(mavenProject, each, (IdeModifiableModelsProvider)new IdeModifiableModelsProviderImpl(project));
                new MavenFoldersImporter(mavenProject, settings, a).config(updateTargetFoldersOnly);
                ModifiableRootModel model = a.getRootModel();
                if (model.isChanged()) {
                    rootModels.add(model);
                    continue;
                }
                model.dispose();
            }
            if (!rootModels.isEmpty()) {
                ModifiableModelCommitter.multiCommit(rootModels, (ModifiableModuleModel)ModuleManager.getInstance((Project)((ModifiableRootModel)rootModels.get(0)).getProject()).getModifiableModel());
            }
        });
    }

    public MavenFoldersImporter(@NotNull MavenProject mavenProject, @NotNull MavenImportingSettings settings, MavenRootModelAdapter model) {
        if (mavenProject == null) {
            MavenFoldersImporter.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            MavenFoldersImporter.$$$reportNull$$$0(1);
        }
        this.myMavenProject = mavenProject;
        this.myImportingSettings = settings;
        this.myModel = model;
    }

    public void config() {
        this.config(false);
    }

    private void config(boolean updateTargetFoldersOnly) {
        if (!updateTargetFoldersOnly) {
            if (!this.myImportingSettings.isKeepSourceFolders()) {
                this.myModel.clearSourceFolders();
            }
            this.configSourceFolders();
            this.configOutputFolders();
        }
        this.configGeneratedFolders();
        if (!updateTargetFoldersOnly) {
            if (!FileUtil.namesEqual((String)"pom", (String)this.myMavenProject.getFile().getNameWithoutExtension()) && MavenUtil.streamPomFiles(this.myModel.getModule().getProject(), this.myMavenProject.getDirectoryFile()).skip(1L).findAny().isPresent()) {
                this.generateNewContentRoots(false);
            } else {
                this.generateNewContentRoots(true);
            }
        }
        this.configExcludedFolders();
    }

    private void configSourceFolders() {
        LinkedMultiMap roots = new LinkedMultiMap();
        roots.putValues((Object)JavaSourceRootType.SOURCE, this.myMavenProject.getSources());
        roots.putValues((Object)JavaSourceRootType.TEST_SOURCE, this.myMavenProject.getTestSources());
        for (MavenImporter mavenImporter : MavenImporter.getSuitableImporters(this.myMavenProject)) {
            mavenImporter.collectSourceRoots(this.myMavenProject, (arg_0, arg_1) -> MavenFoldersImporter.lambda$configSourceFolders$1((MultiMap)roots, arg_0, arg_1));
        }
        for (MavenResource mavenResource : this.myMavenProject.getResources()) {
            roots.putValue((Object)JavaResourceRootType.RESOURCE, (Object)mavenResource.getDirectory());
        }
        for (MavenResource mavenResource : this.myMavenProject.getTestResources()) {
            roots.putValue((Object)JavaResourceRootType.TEST_RESOURCE, (Object)mavenResource.getDirectory());
        }
        this.addBuilderHelperPaths("add-source", roots.getModifiable((Object)JavaSourceRootType.SOURCE));
        this.addBuilderHelperPaths("add-test-source", roots.getModifiable((Object)JavaSourceRootType.TEST_SOURCE));
        this.addBuilderHelperResourcesPaths("add-resource", roots.getModifiable((Object)JavaResourceRootType.RESOURCE));
        this.addBuilderHelperResourcesPaths("add-test-resource", roots.getModifiable((Object)JavaResourceRootType.TEST_RESOURCE));
        ArrayList<String> addedPaths = new ArrayList<String>();
        for (JpsModuleSourceRootType type : roots.keySet()) {
            for (String path : roots.get((Object)type)) {
                if (path == null) continue;
                this.addSourceFolderIfNotOverlap(path, type, addedPaths);
            }
        }
    }

    private void addBuilderHelperPaths(String goal, Collection<String> folders) {
        MavenPlugin plugin = this.myMavenProject.findPlugin("org.codehaus.mojo", "build-helper-maven-plugin");
        if (plugin != null) {
            for (MavenPlugin.Execution execution : plugin.getExecutions()) {
                Element sourcesElement;
                Element configurationElement;
                if (!execution.getGoals().contains(goal) || (configurationElement = execution.getConfigurationElement()) == null || (sourcesElement = configurationElement.getChild("sources")) == null) continue;
                for (Element element : sourcesElement.getChildren()) {
                    folders.add(element.getTextTrim());
                }
            }
        }
    }

    private void addBuilderHelperResourcesPaths(String goal, Collection<String> folders) {
        MavenPlugin plugin = this.myMavenProject.findPlugin("org.codehaus.mojo", "build-helper-maven-plugin");
        if (plugin != null) {
            for (MavenPlugin.Execution execution : plugin.getExecutions()) {
                Element sourcesElement;
                Element configurationElement;
                if (!execution.getGoals().contains(goal) || (configurationElement = execution.getConfigurationElement()) == null || (sourcesElement = configurationElement.getChild("resources")) == null) continue;
                for (Element element : sourcesElement.getChildren()) {
                    Element directory = element.getChild("directory");
                    if (directory == null) continue;
                    folders.add(directory.getTextTrim());
                }
            }
        }
    }

    private void addSourceFolderIfNotOverlap(String path, JpsModuleSourceRootType<?> type, List<String> addedPaths) {
        String canonicalPath = this.myModel.toPath(path).getPath();
        for (String existing : addedPaths) {
            if (!VfsUtilCore.isEqualOrAncestor((String)existing, (String)canonicalPath) && !VfsUtilCore.isEqualOrAncestor((String)canonicalPath, (String)existing)) continue;
            return;
        }
        addedPaths.add(canonicalPath);
        this.myModel.addSourceFolder(canonicalPath, type);
    }

    private void configOutputFolders() {
        String testOutputDirPath;
        String outputDirPath;
        String buildDirPath;
        if (this.myImportingSettings.isUseMavenOutput()) {
            this.myModel.useModuleOutput(this.myMavenProject.getOutputDirectory(), this.myMavenProject.getTestOutputDirectory());
        }
        if (!VfsUtilCore.isEqualOrAncestor((String)(buildDirPath = this.myModel.toPath(this.myMavenProject.getBuildDirectory()).getPath()), (String)(outputDirPath = this.myModel.toPath(this.myMavenProject.getOutputDirectory()).getPath()))) {
            this.myModel.addExcludedFolder(this.myMavenProject.getOutputDirectory());
        }
        if (!VfsUtilCore.isEqualOrAncestor((String)buildDirPath, (String)(testOutputDirPath = this.myModel.toPath(this.myMavenProject.getTestOutputDirectory()).getPath()))) {
            this.myModel.addExcludedFolder(this.myMavenProject.getTestOutputDirectory());
        }
    }

    private void configGeneratedFolders() {
        File[] targetChildren;
        File targetDir = new File(this.myMavenProject.getBuildDirectory());
        String generatedDir = this.myMavenProject.getGeneratedSourcesDirectory(false);
        String generatedDirTest = this.myMavenProject.getGeneratedSourcesDirectory(true);
        this.myModel.unregisterAll(targetDir.getPath(), false, false);
        if (this.myImportingSettings.getGeneratedSourcesFolder() != MavenImportingSettings.GeneratedSourcesFolder.IGNORE) {
            this.myModel.addGeneratedJavaSourceFolder(this.myMavenProject.getAnnotationProcessorDirectory(true), JavaSourceRootType.TEST_SOURCE);
            this.myModel.addGeneratedJavaSourceFolder(this.myMavenProject.getAnnotationProcessorDirectory(false), JavaSourceRootType.SOURCE);
        }
        if ((targetChildren = targetDir.listFiles()) != null) {
            for (File f : targetChildren) {
                if (!f.isDirectory()) continue;
                if (FileUtil.pathsEqual((String)generatedDir, (String)f.getPath())) {
                    this.configGeneratedSourceFolder(f, JavaSourceRootType.SOURCE);
                    continue;
                }
                if (!FileUtil.pathsEqual((String)generatedDirTest, (String)f.getPath())) continue;
                this.configGeneratedSourceFolder(f, JavaSourceRootType.TEST_SOURCE);
            }
        }
    }

    private void generateNewContentRoots(boolean orphansOnly) {
        TreeMap<String, SourceFolder> sourceFoldersMap = new TreeMap<String, SourceFolder>(FileUtil::comparePaths);
        for (String sourceRootUrl : this.myModel.getSourceRootUrls(true)) {
            String sourceRootPath = FileUtil.toSystemDependentName((String)VfsUtil.urlToPath((String)sourceRootUrl));
            SourceFolder sourceFolder = this.myModel.getSourceFolder(new File(sourceRootPath));
            if (sourceFolder == null) continue;
            sourceFoldersMap.put(sourceRootUrl, sourceFolder);
        }
        ModifiableRootModel rootModel = this.myModel.getRootModel();
        if (orphansOnly) {
            for (ContentEntry contentEntry : rootModel.getContentEntries()) {
                sourceFoldersMap.keySet().removeIf(root -> FileUtil.isAncestor((String)contentEntry.getUrl(), (String)root, (boolean)false));
            }
        } else {
            for (ContentEntry contentEntry : rootModel.getContentEntries()) {
                rootModel.removeContentEntry(contentEntry);
            }
        }
        HashSet topLevelSourceFolderUrls = ContainerUtil.newHashSet();
        for (String sourceRoot : sourceFoldersMap.keySet()) {
            if (!topLevelSourceFolderUrls.stream().noneMatch(root -> FileUtil.isAncestor((String)root, (String)sourceRoot, (boolean)false))) continue;
            topLevelSourceFolderUrls.add(sourceRoot);
        }
        for (String sourceFolderUrl : topLevelSourceFolderUrls) {
            ContentEntry contentEntry;
            if (MavenFoldersImporter.isAlreadyContentRoot(sourceFolderUrl, rootModel.getProject())) continue;
            contentEntry = rootModel.addContentEntry(sourceFolderUrl);
            for (Map.Entry entry : sourceFoldersMap.entrySet()) {
                if (!FileUtil.isAncestor((String)sourceFolderUrl, (String)((String)entry.getKey()), (boolean)false)) continue;
                SourceFolder oldSourceFolder = (SourceFolder)entry.getValue();
                SourceFolder newSourceFolder = contentEntry.addSourceFolder(oldSourceFolder.getUrl(), oldSourceFolder.getRootType());
                newSourceFolder.setPackagePrefix(oldSourceFolder.getPackagePrefix());
            }
        }
    }

    private static boolean isAlreadyContentRoot(String sourceFolderUrl, Project project) {
        URL url = VfsUtilCore.convertToURL((String)sourceFolderUrl);
        if (url == null) {
            return false;
        }
        VirtualFile sourceFolder = VfsUtil.findFileByURL((URL)url);
        if (sourceFolder == null) {
            return false;
        }
        MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance(project);
        MavenProject containingProject = mavenProjectsManager.findContainingProject(sourceFolder);
        if (containingProject != null) {
            Module module = mavenProjectsManager.findModule(containingProject);
            if (module == null) {
                return false;
            }
            for (ContentEntry contentEntry : ModuleRootManager.getInstance((Module)module).getContentEntries()) {
                if (!contentEntry.getUrl().equals(sourceFolderUrl)) continue;
                return true;
            }
        }
        return false;
    }

    private void configExcludedFolders() {
        File targetDir = new File(this.myMavenProject.getBuildDirectory());
        String generatedDir = this.myMavenProject.getGeneratedSourcesDirectory(false);
        String generatedDirTest = this.myMavenProject.getGeneratedSourcesDirectory(true);
        File[] targetChildren = targetDir.listFiles();
        if (targetChildren != null) {
            for (File f : targetChildren) {
                if (!f.isDirectory() || FileUtil.pathsEqual((String)generatedDir, (String)f.getPath()) || FileUtil.pathsEqual((String)generatedDirTest, (String)f.getPath()) || !this.myImportingSettings.isExcludeTargetFolder() || this.myModel.hasRegisteredSourceSubfolder(f) || this.myModel.isAlreadyExcluded(f)) continue;
                this.myModel.addExcludedFolder(f.getPath());
            }
        }
        NotNullList facetExcludes = new NotNullList();
        for (MavenImporter each : MavenImporter.getSuitableImporters(this.myMavenProject)) {
            each.collectExcludedFolders(this.myMavenProject, (List<String>)facetExcludes);
        }
        for (String eachFolder : facetExcludes) {
            this.myModel.unregisterAll(eachFolder, true, true);
            this.myModel.addExcludedFolder(eachFolder);
        }
        if (this.myImportingSettings.isExcludeTargetFolder()) {
            this.myModel.addExcludedFolder(targetDir.getPath());
        }
    }

    private void configGeneratedSourceFolder(@NotNull File targetDir, JavaSourceRootType rootType) {
        if (targetDir == null) {
            MavenFoldersImporter.$$$reportNull$$$0(2);
        }
        switch (this.myImportingSettings.getGeneratedSourcesFolder()) {
            case GENERATED_SOURCE_FOLDER: {
                this.myModel.addGeneratedJavaSourceFolder(targetDir.getPath(), rootType);
                break;
            }
            case SUBFOLDER: {
                this.addAllSubDirsAsGeneratedSources(targetDir, rootType);
                break;
            }
            case AUTODETECT: {
                Collection sourceRoots = JavaSourceRootDetectionUtil.suggestRoots((File)targetDir);
                for (JavaModuleSourceRoot root : sourceRoots) {
                    if (FileUtil.filesEqual((File)targetDir, (File)root.getDirectory())) {
                        this.myModel.addGeneratedJavaSourceFolder(targetDir.getPath(), rootType);
                        return;
                    }
                    this.addAsGeneratedSourceFolder(root.getDirectory(), rootType);
                }
                this.addAllSubDirsAsGeneratedSources(targetDir, rootType);
                break;
            }
        }
    }

    private void addAsGeneratedSourceFolder(@NotNull File dir, JavaSourceRootType rootType) {
        if (dir == null) {
            MavenFoldersImporter.$$$reportNull$$$0(3);
        }
        SourceFolder folder = this.myModel.getSourceFolder(dir);
        if (!this.myModel.hasRegisteredSourceSubfolder(dir) || folder != null && !MavenFoldersImporter.isGenerated(folder)) {
            this.myModel.addGeneratedJavaSourceFolder(dir.getPath(), rootType);
        }
    }

    private static boolean isGenerated(@NotNull SourceFolder folder) {
        JavaSourceRootProperties properties;
        if (folder == null) {
            MavenFoldersImporter.$$$reportNull$$$0(4);
        }
        return (properties = (JavaSourceRootProperties)folder.getJpsElement().getProperties(JavaModuleSourceRootTypes.SOURCES)) != null && properties.isForGeneratedSources();
    }

    private void addAllSubDirsAsGeneratedSources(@NotNull File dir, JavaSourceRootType rootType) {
        if (dir == null) {
            MavenFoldersImporter.$$$reportNull$$$0(5);
        }
        for (File f : MavenFoldersImporter.getChildren(dir)) {
            if (!f.isDirectory()) continue;
            this.addAsGeneratedSourceFolder(f, rootType);
        }
    }

    private static File[] getChildren(File dir) {
        File[] result = dir.listFiles();
        return result == null ? ArrayUtil.EMPTY_FILE_ARRAY : result;
    }

    private static /* synthetic */ void lambda$configSourceFolders$1(MultiMap roots, String s, JpsModuleSourceRootType type) {
        roots.putValue((Object)type, (Object)s);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenProject";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDir";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folder";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/importing/MavenFoldersImporter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "configGeneratedSourceFolder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addAsGeneratedSourceFolder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isGenerated";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addAllSubDirsAsGeneratedSources";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

