/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl.dependencies;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.AttributeDisambiguationRule;
import org.gradle.api.attributes.AttributeMatchingStrategy;
import org.gradle.api.attributes.AttributesSchema;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.HasConfigurableAttributes;
import org.gradle.api.attributes.MultipleCandidatesDetails;
import org.gradle.api.internal.ReusableAction;
import org.gradle.api.internal.artifacts.repositories.metadata.MavenImmutableAttributesFactory;
import org.gradle.api.internal.model.NamedObjectInstantiator;
import org.gradle.internal.component.external.model.ComponentVariant;

public class PlatformSupport {
    private final Category regularPlatform;
    private final Category enforcedPlatform;
    private final Set<Category> platformTypes;

    public PlatformSupport(NamedObjectInstantiator instantiator) {
        this.regularPlatform = (Category)instantiator.named(Category.class, "platform");
        this.enforcedPlatform = (Category)instantiator.named(Category.class, "enforced-platform");
        this.platformTypes = ImmutableSet.of((Object)this.regularPlatform, (Object)this.enforcedPlatform);
    }

    public boolean isTargettingPlatform(HasConfigurableAttributes<?> target) {
        Category category = (Category)target.getAttributes().getAttribute(Category.CATEGORY_ATTRIBUTE);
        return this.regularPlatform.equals(category) || this.enforcedPlatform.equals(category);
    }

    public void configureSchema(AttributesSchema attributesSchema) {
        AttributeMatchingStrategy componentTypeMatchingStrategy = attributesSchema.attribute(Category.CATEGORY_ATTRIBUTE);
        componentTypeMatchingStrategy.getDisambiguationRules().add(ComponentCategoryDisambiguationRule.class);
    }

    public void addDisambiguationRule(AttributesSchema attributesSchema) {
        attributesSchema.getMatchingStrategy(Category.CATEGORY_ATTRIBUTE).getDisambiguationRules().add(PreferRegularPlatform.class, c -> c.params(new Object[]{this.platformTypes, this.regularPlatform}));
    }

    public <T> void addPlatformAttribute(HasConfigurableAttributes<T> dependency, final Category category) {
        dependency.attributes((Action)new Action<AttributeContainer>(){

            public void execute(AttributeContainer attributeContainer) {
                attributeContainer.attribute(Category.CATEGORY_ATTRIBUTE, (Object)category);
            }
        });
    }

    public static boolean hasForcedDependencies(ComponentVariant variant) {
        return Objects.equal((Object)variant.getAttributes().getAttribute(MavenImmutableAttributesFactory.CATEGORY_ATTRIBUTE), (Object)"enforced-platform");
    }

    public static class PreferRegularPlatform
    implements AttributeDisambiguationRule<Category> {
        private final Set<Category> platformTypes;
        private final Category regularPlatform;

        @Inject
        public PreferRegularPlatform(Set<Category> platformTypes, Category regularPlatform) {
            this.platformTypes = platformTypes;
            this.regularPlatform = regularPlatform;
        }

        public void execute(MultipleCandidatesDetails<Category> details) {
            if (details.getCandidateValues().equals(this.platformTypes)) {
                details.closestMatch((Object)this.regularPlatform);
            }
        }
    }

    public static class ComponentCategoryDisambiguationRule
    implements AttributeDisambiguationRule<Category>,
    ReusableAction {
        public void execute(MultipleCandidatesDetails<Category> details) {
            Category consumerValue = (Category)details.getConsumerValue();
            Set candidateValues = details.getCandidateValues();
            if (consumerValue == null) {
                candidateValues.stream().filter(it -> it.getName().equals("library")).findFirst().ifPresent(it -> details.closestMatch(it));
            }
        }
    }
}

