(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/xml/ssax#read-xml__%
    (lambda (_g169272_ _ns169023169026_ _source169028_)
      (let* ((_ns169030_
              (if (eq? _ns169023169026_ absent-value) '() _ns169023169026_))
             (_ns169032_
              (if (table? _ns169030_) (table->list _ns169030_) _ns169030_))
             (_ns169066_
              (map (lambda (_e169033169035_)
                     (let* ((_g169037169044_ _e169033169035_)
                            (_E169039169048_
                             (lambda ()
                               (error '"No clause matching" _g169037169044_)))
                            (_K169040169054_
                             (lambda (_id169051_ _uri169052_)
                               (cons (string->symbol _id169051_)
                                     _uri169052_))))
                       (if (##pair? _g169037169044_)
                           (let ((_hd169041169057_ (##car _g169037169044_))
                                 (_tl169042169059_ (##cdr _g169037169044_)))
                             (let* ((_uri169062_ _hd169041169057_)
                                    (_id169064_ _tl169042169059_))
                               (_K169040169054_ _id169064_ _uri169062_)))
                           (_E169039169048_))))
                   _ns169032_)))
        (if (input-port? _source169028_)
            (std/xml/ssax#ssax:xml->sxml _source169028_ _ns169066_)
            (if (string? _source169028_)
                (call-with-input-string
                 _source169028_
                 (lambda (_g169068169070_)
                   (std/xml/ssax#ssax:xml->sxml _g169068169070_ _ns169066_)))
                (if (u8vector? _source169028_)
                    (call-with-input-u8vector
                     _source169028_
                     (lambda (_g169072169074_)
                       (std/xml/ssax#ssax:xml->sxml
                        _g169072169074_
                        _ns169066_)))
                    (error '"Bad input source; expected port, string, or u8vector"
                           _source169028_)))))))
  (define std/xml/ssax#read-xml__@
    (lambda (_keys169022169080_ . _args169082_)
      (apply std/xml/ssax#read-xml__%
             _keys169022169080_
             (table-ref _keys169022169080_ 'namespaces: absent-value)
             _args169082_)))
  (define std/xml/ssax#read-xml
    (lambda _args169024169088_
      (apply keyword-dispatch
             '#(namespaces:)
             std/xml/ssax#read-xml__@
             _args169024169088_)))
  (define std/xml/ssax#ssax:warn void)
  (define std/xml/ssax#string-null? string-empty?)
  (define std/xml/ssax#nl (string '#\newline))
  (define std/xml/ssax#cout
    (lambda _args169017_
      (for-each
       (lambda (_x169019_)
         (if (procedure? _x169019_) (_x169019_) (display _x169019_)))
       _args169017_)))
  (define std/xml/ssax#cerr
    (lambda _args169013_
      (for-each
       (lambda (_x169015_)
         (if (procedure? _x169015_)
             (_x169015_ (current-error-port))
             (display _x169015_ (current-error-port))))
       _args169013_)))
  (define std/xml/ssax#ascii->char integer->char)
  (define std/xml/ssax#ucscode->char
    (lambda (_code169011_) (integer->char _code169011_)))
  (define std/xml/ssax#char-return (std/xml/ssax#ascii->char '13))
  (define std/xml/ssax#char-tab (std/xml/ssax#ascii->char '9))
  (define std/xml/ssax#char-newline (std/xml/ssax#ascii->char '10))
  (define std/xml/ssax#parser-error
    (lambda (_port169007_ _message169008_ . _rest169009_)
      (apply error _message169008_ _rest169009_)))
  (define std/xml/ssax#peek-next-char__%
    (lambda (_port168997_) (read-char _port168997_) (peek-char _port168997_)))
  (define std/xml/ssax#peek-next-char__0
    (lambda ()
      (let ((_port169003_ (current-input-port)))
        (std/xml/ssax#peek-next-char__% _port169003_))))
  (define std/xml/ssax#peek-next-char
    (lambda _g169274_
      (let ((_g169273_ (length _g169274_)))
        (cond ((##fx= _g169273_ 0)
               (apply std/xml/ssax#peek-next-char__0 _g169274_))
              ((##fx= _g169273_ 1)
               (apply std/xml/ssax#peek-next-char__% _g169274_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/xml/ssax#peek-next-char
                _g169274_))))))
  (define std/xml/ssax#assert-curr-char__%
    (lambda (_expected-chars168978_ _comment168979_ _port168980_)
      (let ((_c168982_ (read-char _port168980_)))
        (if (memv _c168982_ _expected-chars168978_)
            _c168982_
            (std/xml/ssax#parser-error
             _port168980_
             '"Wrong character "
             _c168982_
             '" (0x"
             (if (eof-object? _c168982_)
                 '"*eof*"
                 (number->string (char->integer _c168982_) '16))
             '") "
             _comment168979_
             '". "
             _expected-chars168978_
             '" expected")))))
  (define std/xml/ssax#assert-curr-char__0
    (lambda (_expected-chars168987_ _comment168988_)
      (let ((_port168990_ (current-input-port)))
        (std/xml/ssax#assert-curr-char__%
         _expected-chars168987_
         _comment168988_
         _port168990_))))
  (define std/xml/ssax#assert-curr-char
    (lambda _g169276_
      (let ((_g169275_ (length _g169276_)))
        (cond ((##fx= _g169275_ 2)
               (apply std/xml/ssax#assert-curr-char__0 _g169276_))
              ((##fx= _g169275_ 3)
               (apply std/xml/ssax#assert-curr-char__% _g169276_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/xml/ssax#assert-curr-char
                _g169276_))))))
  (define std/xml/ssax#skip-until__%
    (lambda (_arg168955_ _port168956_)
      (if (number? _arg168955_)
          (let _$loop168958_ ((_i168961_ _arg168955_))
            (if (not (positive? _i168961_))
                '#f
                (begin
                  (if (eof-object? (read-char _port168956_))
                      (std/xml/ssax#parser-error
                       _port168956_
                       '"Unexpected EOF while skipping "
                       _arg168955_
                       '" characters")
                      '#!void)
                  (_$loop168958_ (- _i168961_ '1)))))
          (let _loop168963_ ((_c168965_ (read-char _port168956_)))
            (if (memv _c168965_ _arg168955_)
                _c168965_
                (if (eof-object? _c168965_)
                    (if (memq '*eof* _arg168955_)
                        _c168965_
                        (std/xml/ssax#parser-error
                         _port168956_
                         '"Unexpected EOF while skipping until "
                         _arg168955_))
                    (_loop168963_ (read-char _port168956_))))))))
  (define std/xml/ssax#skip-until__0
    (lambda (_arg168970_)
      (let ((_port168972_ (current-input-port)))
        (std/xml/ssax#skip-until__% _arg168970_ _port168972_))))
  (define std/xml/ssax#skip-until
    (lambda _g169278_
      (let ((_g169277_ (length _g169278_)))
        (cond ((##fx= _g169277_ 1)
               (apply std/xml/ssax#skip-until__0 _g169278_))
              ((##fx= _g169277_ 2)
               (apply std/xml/ssax#skip-until__% _g169278_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/xml/ssax#skip-until
                _g169278_))))))
  (define std/xml/ssax#skip-while__%
    (lambda (_skip-chars168936_ _port168937_)
      (let _$loop168939_ ((_c168942_ (peek-char _port168937_)))
        (if (not (memv _c168942_ _skip-chars168936_))
            _c168942_
            (begin
              (read-char _port168937_)
              (_$loop168939_ (peek-char _port168937_)))))))
  (define std/xml/ssax#skip-while__0
    (lambda (_skip-chars168947_)
      (let ((_port168949_ (current-input-port)))
        (std/xml/ssax#skip-while__% _skip-chars168947_ _port168949_))))
  (define std/xml/ssax#skip-while
    (lambda _g169280_
      (let ((_g169279_ (length _g169280_)))
        (cond ((##fx= _g169279_ 1)
               (apply std/xml/ssax#skip-while__0 _g169280_))
              ((##fx= _g169279_ 2)
               (apply std/xml/ssax#skip-while__% _g169280_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/xml/ssax#skip-while
                _g169280_))))))
  (define std/xml/ssax#input-parse:init-buffer
    (let ((_buffer168932_ (make-string '512))) (lambda () _buffer168932_)))
  (define std/xml/ssax#next-token-old__%
    (lambda (_prefix-skipped-chars168894_
             _break-chars168895_
             _comment168896_
             _port168897_)
      (let* ((_buffer168899_ (std/xml/ssax#input-parse:init-buffer))
             (_curr-buf-len168901_ (string-length _buffer168899_))
             (_quantum168903_ _curr-buf-len168901_))
        (let _loop168906_ ((_i168908_ '0)
                           (_c168909_
                            (std/xml/ssax#skip-while__%
                             _prefix-skipped-chars168894_
                             _port168897_)))
          (if (memv _c168909_ _break-chars168895_)
              (substring _buffer168899_ '0 _i168908_)
              (if (eof-object? _c168909_)
                  (if (memq '*eof* _break-chars168895_)
                      (substring _buffer168899_ '0 _i168908_)
                      (std/xml/ssax#parser-error
                       _port168897_
                       '"EOF while reading a token "
                       _comment168896_))
                  (begin
                    (if (>= _i168908_ _curr-buf-len168901_)
                        (begin
                          (set! _buffer168899_
                                (string-append
                                 _buffer168899_
                                 (make-string _quantum168903_)))
                          (set! _quantum168903_ _curr-buf-len168901_)
                          (set! _curr-buf-len168901_
                                (string-length _buffer168899_)))
                        '#!void)
                    (string-set! _buffer168899_ _i168908_ _c168909_)
                    (read-char _port168897_)
                    (_loop168906_
                     (+ '1 _i168908_)
                     (peek-char _port168897_)))))))))
  (define std/xml/ssax#next-token-old__0
    (lambda (_prefix-skipped-chars168914_ _break-chars168915_)
      (let* ((_comment168917_ '"") (_port168919_ (current-input-port)))
        (std/xml/ssax#next-token-old__%
         _prefix-skipped-chars168914_
         _break-chars168915_
         _comment168917_
         _port168919_))))
  (define std/xml/ssax#next-token-old__1
    (lambda (_prefix-skipped-chars168921_ _break-chars168922_ _comment168923_)
      (let ((_port168925_ (current-input-port)))
        (std/xml/ssax#next-token-old__%
         _prefix-skipped-chars168921_
         _break-chars168922_
         _comment168923_
         _port168925_))))
  (define std/xml/ssax#next-token-old
    (lambda _g169282_
      (let ((_g169281_ (length _g169282_)))
        (cond ((##fx= _g169281_ 2)
               (apply std/xml/ssax#next-token-old__0 _g169282_))
              ((##fx= _g169281_ 3)
               (apply std/xml/ssax#next-token-old__1 _g169282_))
              ((##fx= _g169281_ 4)
               (apply std/xml/ssax#next-token-old__% _g169282_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/xml/ssax#next-token-old
                _g169282_))))))
  (define std/xml/ssax#next-token__%
    (lambda (_prefix-skipped-chars168854_
             _break-chars168855_
             _comment168856_
             _port168857_)
      (let _outer168859_ ((_buffer168861_
                           (std/xml/ssax#input-parse:init-buffer))
                          (_filled-buffer-l168862_ '())
                          (_c168863_
                           (std/xml/ssax#skip-while__%
                            _prefix-skipped-chars168854_
                            _port168857_)))
        (let ((_curr-buf-len168865_ (string-length _buffer168861_)))
          (let _loop168867_ ((_i168869_ '0) (_c168870_ _c168863_))
            (if (memv _c168870_ _break-chars168855_)
                (if (null? _filled-buffer-l168862_)
                    (substring _buffer168861_ '0 _i168869_)
                    (std/srfi/13#string-concatenate-reverse__%
                     _filled-buffer-l168862_
                     _buffer168861_
                     _i168869_))
                (if (eof-object? _c168870_)
                    (if (memq '*eof* _break-chars168855_)
                        (if (null? _filled-buffer-l168862_)
                            (substring _buffer168861_ '0 _i168869_)
                            (std/srfi/13#string-concatenate-reverse__%
                             _filled-buffer-l168862_
                             _buffer168861_
                             _i168869_))
                        (std/xml/ssax#parser-error
                         _port168857_
                         '"EOF while reading a token "
                         _comment168856_))
                    (if (>= _i168869_ _curr-buf-len168865_)
                        (_outer168859_
                         (make-string _curr-buf-len168865_)
                         (cons _buffer168861_ _filled-buffer-l168862_)
                         _c168870_)
                        (begin
                          (string-set! _buffer168861_ _i168869_ _c168870_)
                          (read-char _port168857_)
                          (_loop168867_
                           (+ '1 _i168869_)
                           (peek-char _port168857_)))))))))))
  (define std/xml/ssax#next-token__0
    (lambda (_prefix-skipped-chars168875_ _break-chars168876_)
      (let* ((_comment168878_ '"") (_port168880_ (current-input-port)))
        (std/xml/ssax#next-token__%
         _prefix-skipped-chars168875_
         _break-chars168876_
         _comment168878_
         _port168880_))))
  (define std/xml/ssax#next-token__1
    (lambda (_prefix-skipped-chars168882_ _break-chars168883_ _comment168884_)
      (let ((_port168886_ (current-input-port)))
        (std/xml/ssax#next-token__%
         _prefix-skipped-chars168882_
         _break-chars168883_
         _comment168884_
         _port168886_))))
  (define std/xml/ssax#next-token
    (lambda _g169284_
      (let ((_g169283_ (length _g169284_)))
        (cond ((##fx= _g169283_ 2)
               (apply std/xml/ssax#next-token__0 _g169284_))
              ((##fx= _g169283_ 3)
               (apply std/xml/ssax#next-token__1 _g169284_))
              ((##fx= _g169283_ 4)
               (apply std/xml/ssax#next-token__% _g169284_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/xml/ssax#next-token
                _g169284_))))))
  (define std/xml/ssax#next-token-of__%
    (lambda (_incl-list/pred168813_ _port168814_)
      (let* ((_buffer168816_ (std/xml/ssax#input-parse:init-buffer))
             (_curr-buf-len168818_ (string-length _buffer168816_)))
        (if (procedure? _incl-list/pred168813_)
            (let _outer168821_ ((_buffer168823_ _buffer168816_)
                                (_filled-buffer-l168824_ '()))
              (let _loop168826_ ((_i168828_ '0))
                (if (>= _i168828_ _curr-buf-len168818_)
                    (_outer168821_
                     (make-string _curr-buf-len168818_)
                     (cons _buffer168823_ _filled-buffer-l168824_))
                    (let ((_c168830_
                           (_incl-list/pred168813_ (peek-char _port168814_))))
                      (if _c168830_
                          (begin
                            (string-set! _buffer168823_ _i168828_ _c168830_)
                            (read-char _port168814_)
                            (_loop168826_ (+ '1 _i168828_)))
                          (if (null? _filled-buffer-l168824_)
                              (substring _buffer168823_ '0 _i168828_)
                              (std/srfi/13#string-concatenate-reverse__%
                               _filled-buffer-l168824_
                               _buffer168823_
                               _i168828_)))))))
            (let _outer168832_ ((_buffer168834_ _buffer168816_)
                                (_filled-buffer-l168835_ '()))
              (let _loop168837_ ((_i168839_ '0))
                (if (>= _i168839_ _curr-buf-len168818_)
                    (_outer168832_
                     (make-string _curr-buf-len168818_)
                     (cons _buffer168834_ _filled-buffer-l168835_))
                    (let ((_c168841_ (peek-char _port168814_)))
                      (if (not (memv _c168841_ _incl-list/pred168813_))
                          (if (null? _filled-buffer-l168835_)
                              (substring _buffer168834_ '0 _i168839_)
                              (std/srfi/13#string-concatenate-reverse__%
                               _filled-buffer-l168835_
                               _buffer168834_
                               _i168839_))
                          (begin
                            (string-set! _buffer168834_ _i168839_ _c168841_)
                            (read-char _port168814_)
                            (_loop168837_ (+ '1 _i168839_))))))))))))
  (define std/xml/ssax#next-token-of__0
    (lambda (_incl-list/pred168846_)
      (let ((_port168848_ (current-input-port)))
        (std/xml/ssax#next-token-of__% _incl-list/pred168846_ _port168848_))))
  (define std/xml/ssax#next-token-of
    (lambda _g169286_
      (let ((_g169285_ (length _g169286_)))
        (cond ((##fx= _g169285_ 1)
               (apply std/xml/ssax#next-token-of__0 _g169286_))
              ((##fx= _g169285_ 2)
               (apply std/xml/ssax#next-token-of__% _g169286_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/xml/ssax#next-token-of
                _g169286_))))))
  (define std/xml/ssax#*read-line-breaks*
    (list std/xml/ssax#char-newline std/xml/ssax#char-return '*eof*))
  (define std/xml/ssax#read-text-line__%
    (lambda (_port168797_)
      (if (eof-object? (peek-char _port168797_))
          (peek-char _port168797_)
          (let* ((_line168799_
                  (std/xml/ssax#next-token__%
                   '()
                   std/xml/ssax#*read-line-breaks*
                   '"reading a line"
                   _port168797_))
                 (_c168801_ (read-char _port168797_)))
            (if (eqv? _c168801_ std/xml/ssax#char-return)
                (if (eqv? (peek-char _port168797_) '#\newline)
                    (read-char _port168797_)
                    '#f)
                '#f)
            _line168799_))))
  (define std/xml/ssax#read-text-line__0
    (lambda ()
      (let ((_port168808_ (current-input-port)))
        (std/xml/ssax#read-text-line__% _port168808_))))
  (define std/xml/ssax#read-text-line
    (lambda _g169288_
      (let ((_g169287_ (length _g169288_)))
        (cond ((##fx= _g169287_ 0)
               (apply std/xml/ssax#read-text-line__0 _g169288_))
              ((##fx= _g169287_ 1)
               (apply std/xml/ssax#read-text-line__% _g169288_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/xml/ssax#read-text-line
                _g169288_))))))
  (define std/xml/ssax#read-string__%
    (lambda (_n168774_ _port168775_)
      (if (not (positive? _n168774_))
          '""
          (let ((_buffer168777_ (make-string _n168774_)))
            (let _loop168779_ ((_i168781_ '0)
                               (_c168782_ (read-char _port168775_)))
              (if (eof-object? _c168782_)
                  (substring _buffer168777_ '0 _i168781_)
                  (let ((_i1168784_ (+ '1 _i168781_)))
                    (string-set! _buffer168777_ _i168781_ _c168782_)
                    (if (= _i1168784_ _n168774_)
                        _buffer168777_
                        (_loop168779_
                         _i1168784_
                         (read-char _port168775_))))))))))
  (define std/xml/ssax#read-string__0
    (lambda (_n168789_)
      (let ((_port168791_ (current-input-port)))
        (std/xml/ssax#read-string__% _n168789_ _port168791_))))
  (define std/xml/ssax#read-string
    (lambda _g169290_
      (let ((_g169289_ (length _g169290_)))
        (cond ((##fx= _g169289_ 1)
               (apply std/xml/ssax#read-string__0 _g169290_))
              ((##fx= _g169289_ 2)
               (apply std/xml/ssax#read-string__% _g169290_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/xml/ssax#read-string
                _g169290_))))))
  (define std/xml/ssax#MISCIO:find-string-from-port?
    (lambda (_str168739_ _<input-port>168740_ . _max-no-char168741_)
      (set! _max-no-char168741_
            (if (null? _max-no-char168741_) '#f (car _max-no-char168741_)))
      (letrec ((_no-chars-read168743_ '0)
               (_my-peek-char168744_
                (lambda ()
                  (if (or (not _max-no-char168741_)
                          (< _no-chars-read168743_ _max-no-char168741_))
                      (let ((_c168754_ (peek-char _<input-port>168740_)))
                        (if (eof-object? _c168754_) '#f _c168754_))
                      '#f)))
               (_next-char168745_
                (lambda ()
                  (read-char _<input-port>168740_)
                  (set! _no-chars-read168743_ (+ '1 _no-chars-read168743_))))
               (_match-1st-char168746_
                (lambda ()
                  (let ((_c168758_ (_my-peek-char168744_)))
                    (if (not _c168758_)
                        '#f
                        (begin
                          (_next-char168745_)
                          (if (char=? _c168758_ (string-ref _str168739_ '0))
                              (_match-other-chars168747_ '1)
                              (_match-1st-char168746_)))))))
               (_match-other-chars168747_
                (lambda (_pos-to-match168760_)
                  (if (>= _pos-to-match168760_ (string-length _str168739_))
                      _no-chars-read168743_
                      (let ((_c168762_ (_my-peek-char168744_)))
                        (if _c168762_
                            (if (not (char=? _c168762_
                                             (string-ref
                                              _str168739_
                                              _pos-to-match168760_)))
                                (_backtrack168748_ '1 _pos-to-match168760_)
                                (begin
                                  (_next-char168745_)
                                  (_match-other-chars168747_
                                   (+ '1 _pos-to-match168760_))))
                            '#f)))))
               (_backtrack168748_
                (lambda (_i168764_ _matched-substr-len168765_)
                  (let ((_j168767_ (- _matched-substr-len168765_ _i168764_)))
                    (if (<= _j168767_ '0)
                        (_match-1st-char168746_)
                        (let _loop168769_ ((_k168771_ '0))
                          (if (>= _k168771_ _j168767_)
                              (_match-other-chars168747_ _j168767_)
                              (if (char=? (string-ref _str168739_ _k168771_)
                                          (string-ref
                                           _str168739_
                                           (+ _i168764_ _k168771_)))
                                  (_loop168769_ (+ '1 _k168771_))
                                  (_backtrack168748_
                                   (+ '1 _i168764_)
                                   _matched-substr-len168765_)))))))))
        (_match-1st-char168746_))))
  (define std/xml/ssax#find-string-from-port?
    std/xml/ssax#MISCIO:find-string-from-port?)
  (define std/xml/ssax#make-xml-token
    (lambda (_kind168736_ _head168737_) (cons _kind168736_ _head168737_)))
  (define std/xml/ssax#xml-token? pair?)
  (define std/xml/ssax#string-whitespace?
    (lambda (_str168725_)
      (let ((_len168727_ (string-length _str168725_)))
        (if (zero? _len168727_)
            '#t
            (if (= '1 _len168727_)
                (char-whitespace? (string-ref _str168725_ '0))
                (if (= '2 _len168727_)
                    (if (char-whitespace? (string-ref _str168725_ '0))
                        (char-whitespace? (string-ref _str168725_ '1))
                        '#f)
                    (let _loop168729_ ((_i168731_ '0))
                      (let ((_$e168733_ (>= _i168731_ _len168727_)))
                        (if _$e168733_
                            _$e168733_
                            (if (char-whitespace?
                                 (string-ref _str168725_ _i168731_))
                                (_loop168729_ (+ '1 _i168731_))
                                '#f))))))))))
  (define std/xml/ssax#assq-values
    (lambda (_val168717_ _alist168718_)
      (let _loop168720_ ((_alist168722_ _alist168718_) (_scanned168723_ '()))
        (if (null? _alist168722_)
            (values '#f _scanned168723_)
            (if (equal? _val168717_ (caar _alist168722_))
                (values (car _alist168722_)
                        (append _scanned168723_ (cdr _alist168722_)))
                (_loop168720_
                 (cdr _alist168722_)
                 (cons (car _alist168722_) _scanned168723_)))))))
  (define std/xml/ssax#fold-right
    (lambda (_kons168707_ _knil168708_ _lis1168709_)
      (let _recur168711_ ((_lis168713_ _lis1168709_))
        (if (null? _lis168713_)
            _knil168708_
            (let ((_head168715_ (car _lis168713_)))
              (_kons168707_
               _head168715_
               (_recur168711_ (cdr _lis168713_))))))))
  (define std/xml/ssax#fold
    (lambda (_kons168698_ _knil168699_ _lis1168700_)
      (let _lp168702_ ((_lis168704_ _lis1168700_) (_ans168705_ _knil168699_))
        (if (null? _lis168704_)
            _ans168705_
            (_lp168702_
             (cdr _lis168704_)
             (_kons168698_ (car _lis168704_) _ans168705_))))))
  (define std/xml/ssax#ssax:S-chars
    (map std/xml/ssax#ascii->char '(32 10 9 13)))
  (define std/xml/ssax#ssax:skip-S
    (lambda (_port168696_)
      (std/xml/ssax#skip-while__% std/xml/ssax#ssax:S-chars _port168696_)))
  (define std/xml/ssax#ssax:ncname-starting-char?
    (lambda (_a-char168691_)
      (if (char? _a-char168691_)
          (let ((_$e168693_ (char-alphabetic? _a-char168691_)))
            (if _$e168693_ _$e168693_ (char=? '#\_ _a-char168691_)))
          '#f)))
  (define std/xml/ssax#ssax:read-NCName
    (lambda (_port168682_)
      (let* ((_first-char168684_ (peek-char _port168682_))
             (_$e168686_
              (std/xml/ssax#ssax:ncname-starting-char? _first-char168684_)))
        (if _$e168686_
            _$e168686_
            (std/xml/ssax#parser-error
             _port168682_
             '"XMLNS [4] for '"
             _first-char168684_
             '"'")))
      (string->symbol
       (std/xml/ssax#next-token-of__%
        (lambda (_c168689_)
          (if (eof-object? _c168689_)
              '#f
              (if (char-alphabetic? _c168689_)
                  _c168689_
                  (if (std/srfi/13#string-index__0 '"0123456789.-_" _c168689_)
                      _c168689_
                      '#f))))
        _port168682_))))
  (define std/xml/ssax#ssax:read-QName
    (lambda (_port168675_)
      (let* ((_prefix-or-localpart168677_
              (std/xml/ssax#ssax:read-NCName _port168675_))
             (_$e168679_ (peek-char _port168675_)))
        (if (eq? '#\: _$e168679_)
            (begin
              (read-char _port168675_)
              (cons _prefix-or-localpart168677_
                    (std/xml/ssax#ssax:read-NCName _port168675_)))
            _prefix-or-localpart168677_))))
  (define std/xml/ssax#ssax:Prefix-XML (string->symbol '"xml"))
  (define std/xml/ssax#name-compare
    (letrec ((_symbol-compare168667_
              (lambda (_symb1168669_ _symb2168670_)
                (if (eq? _symb1168669_ _symb2168670_)
                    '=
                    (if (string<?
                         (symbol->string _symb1168669_)
                         (symbol->string _symb2168670_))
                        '<
                        '>)))))
      (lambda (_name1168672_ _name2168673_)
        (if (symbol? _name1168672_)
            (if (symbol? _name2168673_)
                (_symbol-compare168667_ _name1168672_ _name2168673_)
                '<)
            (if (symbol? _name2168673_)
                '>
                (if (eq? _name2168673_ std/xml/ssax#ssax:largest-unres-name)
                    '<
                    (if (eq? _name1168672_
                             std/xml/ssax#ssax:largest-unres-name)
                        '>
                        (if (eq? (car _name1168672_) (car _name2168673_))
                            (_symbol-compare168667_
                             (cdr _name1168672_)
                             (cdr _name2168673_))
                            (_symbol-compare168667_
                             (car _name1168672_)
                             (car _name2168673_))))))))))
  (define std/xml/ssax#ssax:largest-unres-name
    (cons (string->symbol '"#LARGEST-SYMBOL")
          (string->symbol '"#LARGEST-SYMBOL")))
  (define std/xml/ssax#ssax:read-markup-token
    (let ()
      (letrec ((_skip-comment164138_
                (lambda (_port168665_)
                  (std/xml/ssax#assert-curr-char__%
                   '(#\-)
                   '"XML [15], second dash"
                   _port168665_)
                  (if (not (std/xml/ssax#find-string-from-port?
                            '"-->"
                            _port168665_))
                      (std/xml/ssax#parser-error
                       _port168665_
                       '"XML [15], no -->")
                      '#!void)
                  (cons 'COMMENT '#f)))
               (_read-cdata164139_
                (lambda (_port164152_)
                  (let ((_$e165522_
                         (string=?
                          '"CDATA["
                          (std/xml/ssax#read-string__% '6 _port164152_))))
                    (if _$e165522_
                        _$e165522_
                        (begin
                          (std/xml/ssax#cerr
                           '"failed assertion: "
                           '(string=? "CDATA[" (read-string 6 port))
                           std/xml/ssax#nl
                           '"bindings"
                           '#\newline
                           'port
                           '": "
                           _port164152_
                           std/xml/ssax#nl)
                          (error '"assertion failure"))))
                  (cons 'CDSECT '#f))))
        (lambda (_port164141_)
          (std/xml/ssax#assert-curr-char__%
           '(#\<)
           '"start of the token"
           _port164141_)
          (let ((_$e164143_ (peek-char _port164141_)))
            (if (eq? '#\/ _$e164143_)
                (begin
                  (read-char _port164141_)
                  (let ((_$r164146_
                         (cons 'END
                               (std/xml/ssax#ssax:read-QName _port164141_))))
                    (std/xml/ssax#ssax:skip-S _port164141_)
                    (std/xml/ssax#assert-curr-char__%
                     '(#\>)
                     '"XML [42]"
                     _port164141_)
                    _$r164146_))
                (if (eq? '#\? _$e164143_)
                    (begin
                      (read-char _port164141_)
                      (cons 'PI (std/xml/ssax#ssax:read-NCName _port164141_)))
                    (if (eq? '#\! _$e164143_)
                        (let ((_$e164149_
                               (std/xml/ssax#peek-next-char__% _port164141_)))
                          (if (eq? '#\- _$e164149_)
                              (begin
                                (read-char _port164141_)
                                (_skip-comment164138_ _port164141_))
                              (if (eq? '#\[ _$e164149_)
                                  (begin
                                    (read-char _port164141_)
                                    (_read-cdata164139_ _port164141_))
                                  (cons 'DECL
                                        (std/xml/ssax#ssax:read-NCName
                                         _port164141_)))))
                        (cons 'START
                              (std/xml/ssax#ssax:read-QName
                               _port164141_))))))))))
  (define std/xml/ssax#ssax:skip-pi
    (lambda (_port164135_)
      (if (not (std/xml/ssax#find-string-from-port? '"?>" _port164135_))
          (std/xml/ssax#parser-error
           _port164135_
           '"Failed to find ?> terminating the PI")
          '#!void)))
  (define std/xml/ssax#ssax:read-pi-body-as-string
    (lambda (_port164128_)
      (std/xml/ssax#ssax:skip-S _port164128_)
      (std/srfi/13#string-concatenate/shared
       (let _loop164130_ ()
         (let ((_pi-fragment164133_
                (std/xml/ssax#next-token__%
                 '()
                 '(#\?)
                 '"reading PI content"
                 _port164128_)))
           (if (eqv? '#\> (std/xml/ssax#peek-next-char__% _port164128_))
               (begin (read-char _port164128_) (cons _pi-fragment164133_ '()))
               (cons _pi-fragment164133_ (cons '"?" (_loop164130_)))))))))
  (define std/xml/ssax#ssax:skip-internal-dtd
    (lambda (_port164126_)
      (if (not (std/xml/ssax#find-string-from-port? '"]>" _port164126_))
          (std/xml/ssax#parser-error
           _port164126_
           '"Failed to find ]> terminating the internal DTD subset")
          '#!void)))
  (define std/xml/ssax#ssax:read-cdata-body
    (let ((_cdata-delimiters164100_
           (list std/xml/ssax#char-return '#\newline '#\] '#\&)))
      (lambda (_port164102_ _str-handler164103_ _seed164104_)
        (let _loop164106_ ((_seed164108_ _seed164104_))
          (let* ((_fragment164110_
                  (std/xml/ssax#next-token__%
                   '()
                   _cdata-delimiters164100_
                   '"reading CDATA"
                   _port164102_))
                 (_$e164112_ (read-char _port164102_)))
            (if (eq? '#\newline _$e164112_)
                (_loop164106_
                 (_str-handler164103_
                  _fragment164110_
                  std/xml/ssax#nl
                  _seed164108_))
                (if (eq? '#\] _$e164112_)
                    (if (not (eqv? (peek-char _port164102_) '#\]))
                        (_loop164106_
                         (_str-handler164103_
                          _fragment164110_
                          '"]"
                          _seed164108_))
                        (let _check-after-second-braket164115_ ((_seed164117_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                         (if (std/xml/ssax#string-null? _fragment164110_)
                             _seed164108_
                             (_str-handler164103_
                              _fragment164110_
                              '""
                              _seed164108_))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                          (let ((_$e164119_
                                 (std/xml/ssax#peek-next-char__%
                                  _port164102_)))
                            (if (eq? '#\> _$e164119_)
                                (begin (read-char _port164102_) _seed164117_)
                                (if (eq? '#\] _$e164119_)
                                    (_check-after-second-braket164115_
                                     (_str-handler164103_
                                      '"]"
                                      '""
                                      _seed164117_))
                                    (_loop164106_
                                     (_str-handler164103_
                                      '"]]"
                                      '""
                                      _seed164117_)))))))
                    (if (eq? '#\& _$e164112_)
                        (let ((_ent-ref164124_
                               (std/xml/ssax#next-token-of__%
                                (lambda (_c164122_)
                                  (if (not (eof-object? _c164122_))
                                      (if (char-alphabetic? _c164122_)
                                          _c164122_
                                          '#f)
                                      '#f))
                                _port164102_)))
                          (if (and (string=? '"gt" _ent-ref164124_)
                                   (eqv? (peek-char _port164102_) '#\;))
                              (begin
                                (read-char _port164102_)
                                (_loop164106_
                                 (_str-handler164103_
                                  _fragment164110_
                                  '">"
                                  _seed164108_)))
                              (_loop164106_
                               (_str-handler164103_
                                _ent-ref164124_
                                '""
                                (_str-handler164103_
                                 _fragment164110_
                                 '"&"
                                 _seed164108_)))))
                        (begin
                          (if (eqv? (peek-char _port164102_) '#\newline)
                              (read-char _port164102_)
                              '#!void)
                          (_loop164106_
                           (_str-handler164103_
                            _fragment164110_
                            std/xml/ssax#nl
                            _seed164108_)))))))))))
  (define std/xml/ssax#ssax:read-char-ref
    (lambda (_port164091_)
      (let* ((_base164093_
              (if (eqv? (peek-char _port164091_) '#\x)
                  (begin (read-char _port164091_) '16)
                  '10))
             (_name164095_
              (std/xml/ssax#next-token__% '() '(#\;) '"XML [66]" _port164091_))
             (_char-code164097_ (string->number _name164095_ _base164093_)))
        (read-char _port164091_)
        (if (integer? _char-code164097_)
            (integer->char _char-code164097_)
            (std/xml/ssax#parser-error
             _port164091_
             '"[wf-Legalchar] broken for '"
             _name164095_
             '"'")))))
  (define std/xml/ssax#ssax:predefined-parsed-entities
    (cons (cons (string->symbol '"amp") '"&")
          (cons (cons (string->symbol '"lt") '"<")
                (cons (cons (string->symbol '"gt") '">")
                      (cons (cons (string->symbol '"apos") '"'")
                            (cons (cons (string->symbol '"quot") '"\"")
                                  '()))))))
  (define std/xml/ssax#ssax:handle-parsed-entity
    (lambda (_port164064_
             _name164065_
             _entities164066_
             _content-handler164067_
             _str-handler164068_
             _seed164069_)
      (let ((_$e164071_ (assq _name164065_ _entities164066_)))
        (if _$e164071_
            ((lambda (_decl-entity164074_)
               (let ((_ent-body164076_ (cdr _decl-entity164074_))
                     (_new-entities164077_
                      (cons (cons _name164065_ '#f) _entities164066_)))
                 (if (string? _ent-body164076_)
                     (call-with-input-string
                      _ent-body164076_
                      (lambda (_port164079_)
                        (_content-handler164067_
                         _port164079_
                         _new-entities164077_
                         _seed164069_)))
                     (if (procedure? _ent-body164076_)
                         (let* ((_port164081_ (_ent-body164076_))
                                (_$r164083_
                                 (_content-handler164067_
                                  _port164081_
                                  _new-entities164077_
                                  _seed164069_)))
                           (close-input-port _port164081_)
                           _$r164083_)
                         (std/xml/ssax#parser-error
                          _port164064_
                          '"[norecursion] broken for "
                          _name164065_)))))
             _$e164071_)
            (let ((_$e164086_
                   (assq _name164065_
                         std/xml/ssax#ssax:predefined-parsed-entities)))
              (if _$e164086_
                  ((lambda (_decl-entity164089_)
                     (_str-handler164068_
                      (cdr _decl-entity164089_)
                      '""
                      _seed164069_))
                   _$e164086_)
                  (std/xml/ssax#parser-error
                   _port164064_
                   '"[wf-entdeclared] broken for "
                   _name164065_)))))))
  (define std/xml/ssax#make-empty-attlist (lambda () '()))
  (define std/xml/ssax#attlist-add
    (lambda (_attlist164057_ _name-value164058_)
      (if (null? _attlist164057_)
          (cons _name-value164058_ _attlist164057_)
          (let ((_$e164060_
                 (std/xml/ssax#name-compare
                  (car _name-value164058_)
                  (caar _attlist164057_))))
            (if (eq? '= _$e164060_)
                '#f
                (if (eq? '< _$e164060_)
                    (cons _name-value164058_ _attlist164057_)
                    (cons (car _attlist164057_)
                          (std/xml/ssax#attlist-add
                           (cdr _attlist164057_)
                           _name-value164058_))))))))
  (define std/xml/ssax#attlist-null? null?)
  (define std/xml/ssax#attlist-remove-top
    (lambda (_attlist164055_)
      (values (car _attlist164055_) (cdr _attlist164055_))))
  (define std/xml/ssax#attlist->alist
    (lambda (_attlist164053_) _attlist164053_))
  (define std/xml/ssax#attlist-fold std/xml/ssax#fold)
  (define std/xml/ssax#ssax:read-attributes
    (let ((_value-delimeters164007_
           (append std/xml/ssax#ssax:S-chars '(#\< #\&))))
      (letrec ((_read-attrib-value164009_
                (lambda (_delimiter164040_
                         _port164041_
                         _entities164042_
                         _prev-fragments164043_)
                  (let* ((_new-fragments164045_
                          (cons (std/xml/ssax#next-token__%
                                 '()
                                 (cons _delimiter164040_
                                       _value-delimeters164007_)
                                 '"XML [10]"
                                 _port164041_)
                                _prev-fragments164043_))
                         (_cterm164047_ (read-char _port164041_)))
                    (if (or (eof-object? _cterm164047_)
                            (eqv? _cterm164047_ _delimiter164040_))
                        _new-fragments164045_
                        (if (eqv? _cterm164047_ std/xml/ssax#char-return)
                            (begin
                              (if (eqv? (peek-char _port164041_) '#\newline)
                                  (read-char _port164041_)
                                  '#!void)
                              (_read-attrib-value164009_
                               _delimiter164040_
                               _port164041_
                               _entities164042_
                               (cons '" " _new-fragments164045_)))
                            (if (memv _cterm164047_ std/xml/ssax#ssax:S-chars)
                                (_read-attrib-value164009_
                                 _delimiter164040_
                                 _port164041_
                                 _entities164042_
                                 (cons '" " _new-fragments164045_))
                                (if (eqv? _cterm164047_ '#\&)
                                    (if (eqv? (peek-char _port164041_) '#\#)
                                        (begin
                                          (read-char _port164041_)
                                          (_read-attrib-value164009_
                                           _delimiter164040_
                                           _port164041_
                                           _entities164042_
                                           (cons (string (std/xml/ssax#ssax:read-char-ref
                                                          _port164041_))
                                                 _new-fragments164045_)))
                                        (_read-attrib-value164009_
                                         _delimiter164040_
                                         _port164041_
                                         _entities164042_
                                         (_read-named-entity164010_
                                          _port164041_
                                          _entities164042_
                                          _new-fragments164045_)))
                                    (std/xml/ssax#parser-error
                                     _port164041_
                                     '"[CleanAttrVals] broken"))))))))
               (_read-named-entity164010_
                (lambda (_port164026_ _entities164027_ _fragments164028_)
                  (let ((_name164030_
                         (std/xml/ssax#ssax:read-NCName _port164026_)))
                    (std/xml/ssax#assert-curr-char__%
                     '(#\;)
                     '"XML [68]"
                     _port164026_)
                    (std/xml/ssax#ssax:handle-parsed-entity
                     _port164026_
                     _name164030_
                     _entities164027_
                     (lambda (_port164032_ _entities164033_ _fragments164034_)
                       (_read-attrib-value164009_
                        '*eof*
                        _port164032_
                        _entities164033_
                        _fragments164034_))
                     (lambda (_str1164036_ _str2164037_ _fragments164038_)
                       (if (equal? '"" _str2164037_)
                           (cons _str1164036_ _fragments164038_)
                           (cons _str2164037_
                                 (cons _str1164036_ _fragments164038_))))
                     _fragments164028_)))))
        (lambda (_port164012_ _entities164013_)
          (let _loop164015_ ((_attr-list164017_
                              (std/xml/ssax#make-empty-attlist)))
            (if (not (std/xml/ssax#ssax:ncname-starting-char?
                      (std/xml/ssax#ssax:skip-S _port164012_)))
                _attr-list164017_
                (let ((_name164019_
                       (std/xml/ssax#ssax:read-QName _port164012_)))
                  (std/xml/ssax#ssax:skip-S _port164012_)
                  (std/xml/ssax#assert-curr-char__%
                   '(#\=)
                   '"XML [25]"
                   _port164012_)
                  (std/xml/ssax#ssax:skip-S _port164012_)
                  (let ((_delimiter164021_
                         (std/xml/ssax#assert-curr-char__%
                          '(#\' #\")
                          '"XML [10]"
                          _port164012_)))
                    (_loop164015_
                     (let ((_$e164023_
                            (std/xml/ssax#attlist-add
                             _attr-list164017_
                             (cons _name164019_
                                   (std/srfi/13#string-concatenate-reverse/shared__0
                                    (_read-attrib-value164009_
                                     _delimiter164021_
                                     _port164012_
                                     _entities164013_
                                     '()))))))
                       (if _$e164023_
                           _$e164023_
                           (std/xml/ssax#parser-error
                            _port164012_
                            '"[uniqattspec] broken for "
                            _name164019_))))))))))))
  (define std/xml/ssax#ssax:resolve-name
    (lambda (_port163997_
             _unres-name163998_
             _namespaces163999_
             _apply-default-ns?164000_)
      (if (pair? _unres-name163998_)
          (cons (let ((_$e164002_
                       (assq (car _unres-name163998_) _namespaces163999_)))
                  (if _$e164002_
                      (cadr _$e164002_)
                      (if (eq? (car _unres-name163998_)
                               std/xml/ssax#ssax:Prefix-XML)
                          std/xml/ssax#ssax:Prefix-XML
                          (std/xml/ssax#parser-error
                           _port163997_
                           '"[nsc-NSDeclared] broken; prefix "
                           (car _unres-name163998_)))))
                (cdr _unres-name163998_))
          (if _apply-default-ns?164000_
              (let ((_default-ns164005_ (assq '*DEFAULT* _namespaces163999_)))
                (if (and _default-ns164005_ (cadr _default-ns164005_))
                    (cons (cadr _default-ns164005_) _unres-name163998_)
                    _unres-name163998_))
              _unres-name163998_))))
  (define std/xml/ssax#ssax:uri-string->symbol
    (lambda (_uri-str163995_) (string->symbol _uri-str163995_)))
  (define std/xml/ssax#ssax:complete-start-tag
    (let ((_xmlns163891_ (string->symbol '"xmlns"))
          (_largest-dummy-decl-attr163892_
           (list std/xml/ssax#ssax:largest-unres-name '#f '#f '#f)))
      (letrec ((_validate-attrs163894_
                (lambda (_port163949_ _attlist163950_ _decl-attrs163951_)
                  (letrec ((_add-default-decl163953_
                            (lambda (_decl-attr163986_ _result163987_)
                              (let ((_g169291_
                                     (apply values _decl-attr163986_)))
                                (begin
                                  (let ((_g169292_
                                         (if (##values? _g169291_)
                                             (##vector-length _g169291_)
                                             1)))
                                    (if (not (##fx= _g169292_ 4))
                                        (error "Context expects 4 values"
                                               _g169292_)))
                                  (let ((_attr-name163989_
                                         (##vector-ref _g169291_ 0))
                                        (_content-type163990_
                                         (##vector-ref _g169291_ 1))
                                        (_use-type163991_
                                         (##vector-ref _g169291_ 2))
                                        (_default-value163992_
                                         (##vector-ref _g169291_ 3)))
                                    (let ()
                                      (if (eq? _use-type163991_ 'REQUIRED)
                                          (std/xml/ssax#parser-error
                                           _port163949_
                                           '"[RequiredAttr] broken for"
                                           _attr-name163989_)
                                          '#f)
                                      (if _default-value163992_
                                          (cons (cons _attr-name163989_
                                                      _default-value163992_)
                                                _result163987_)
                                          _result163987_))))))))
                    (let _loop163955_ ((_attlist163957_ _attlist163950_)
                                       (_decl-attrs163958_ _decl-attrs163951_)
                                       (_result163959_ '()))
                      (if (std/xml/ssax#attlist-null? _attlist163957_)
                          (std/xml/ssax#attlist-fold
                           _add-default-decl163953_
                           _result163959_
                           _decl-attrs163958_)
                          (let ((_g169293_
                                 (std/xml/ssax#attlist-remove-top
                                  _attlist163957_)))
                            (begin
                              (let ((_g169294_
                                     (if (##values? _g169293_)
                                         (##vector-length _g169293_)
                                         1)))
                                (if (not (##fx= _g169294_ 2))
                                    (error "Context expects 2 values"
                                           _g169294_)))
                              (let ((_attr163961_ (##vector-ref _g169293_ 0))
                                    (_attr-others163962_
                                     (##vector-ref _g169293_ 1)))
                                (let ((_g169295_
                                       (if (std/xml/ssax#attlist-null?
                                            _decl-attrs163958_)
                                           (values _largest-dummy-decl-attr163892_
                                                   _decl-attrs163958_)
                                           (std/xml/ssax#attlist-remove-top
                                            _decl-attrs163958_))))
                                  (begin
                                    (let ((_g169296_
                                           (if (##values? _g169295_)
                                               (##vector-length _g169295_)
                                               1)))
                                      (if (not (##fx= _g169296_ 2))
                                          (error "Context expects 2 values"
                                                 _g169296_)))
                                    (let ((_decl-attr163964_
                                           (##vector-ref _g169295_ 0))
                                          (_other-decls163965_
                                           (##vector-ref _g169295_ 1)))
                                      (let ()
                                        (let ((_$e163968_
                                               (std/xml/ssax#name-compare
                                                (car _attr163961_)
                                                (car _decl-attr163964_))))
                                          (if (eq? '< _$e163968_)
                                              (if (or (eq? _xmlns163891_
                                                           (car _attr163961_))
                                                      (and (pair? (car _attr163961_))
                                                           (eq? _xmlns163891_
                                                                (caar _attr163961_))))
                                                  (_loop163955_
                                                   _attr-others163962_
                                                   _decl-attrs163958_
                                                   (cons _attr163961_
                                                         _result163959_))
                                                  (std/xml/ssax#parser-error
                                                   _port163949_
                                                   '"[ValueType] broken for "
                                                   _attr163961_))
                                              (if (eq? '> _$e163968_)
                                                  (_loop163955_
                                                   _attlist163957_
                                                   _other-decls163965_
                                                   (_add-default-decl163953_
                                                    _decl-attr163964_
                                                    _result163959_))
                                                  (let ((_g169297_
                                                         (apply values
                                                                _decl-attr163964_)))
                                                    (begin
                                                      (let ((_g169298_
                                                             (if (##values?
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                          _g169297_)
                         (##vector-length _g169297_)
                         1)))
                (if (not (##fx= _g169298_ 4))
                    (error "Context expects 4 values" _g169298_)))
              (let ((_attr-name163974_ (##vector-ref _g169297_ 0))
                    (_content-type163975_ (##vector-ref _g169297_ 1))
                    (_use-type163976_ (##vector-ref _g169297_ 2))
                    (_default-value163977_ (##vector-ref _g169297_ 3)))
                (let ()
                  (if (eq? _use-type163976_ 'FIXED)
                      (let ((_$e163980_
                             (equal? (cdr _attr163961_)
                                     _default-value163977_)))
                        (if _$e163980_
                            _$e163980_
                            (std/xml/ssax#parser-error
                             _port163949_
                             '"[FixedAttr] broken for "
                             _attr-name163974_)))
                      (if (eq? _content-type163975_ 'CDATA)
                          '#t
                          (if (pair? _content-type163975_)
                              (let ((_$e163983_
                                     (member (cdr _attr163961_)
                                             _content-type163975_)))
                                (if _$e163983_
                                    _$e163983_
                                    (std/xml/ssax#parser-error
                                     _port163949_
                                     '"[enum] broken for "
                                     _attr-name163974_
                                     '"="
                                     (cdr _attr163961_))))
                              '#!void)))
                  (_loop163955_
                   _attr-others163962_
                   _other-decls163965_
                   (cons _attr163961_ _result163959_)))))))))))))))))))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
               (_add-ns163895_
                (lambda (_port163938_
                         _prefix163939_
                         _uri-str163940_
                         _namespaces163941_)
                  (if (equal? '"" _uri-str163940_)
                      (std/xml/ssax#parser-error
                       _port163938_
                       '"[dt-NSName] broken for "
                       _prefix163939_)
                      '#f)
                  (let ((_uri-symbol163943_ (string->symbol _uri-str163940_)))
                    (let _loop163945_ ((_nss163947_ _namespaces163941_))
                      (if (null? _nss163947_)
                          (cons (cons _prefix163939_
                                      (cons _uri-symbol163943_
                                            _uri-symbol163943_))
                                _namespaces163941_)
                          (if (eq? _uri-symbol163943_ (cddar _nss163947_))
                              (cons (cons _prefix163939_
                                          (cons (cadar _nss163947_)
                                                _uri-symbol163943_))
                                    _namespaces163941_)
                              (_loop163945_ (cdr _nss163947_))))))))
               (_adjust-namespace-decl163896_
                (lambda (_port163928_ _attrs163929_ _namespaces163930_)
                  (let _loop163932_ ((_attrs163934_ _attrs163929_)
                                     (_proper-attrs163935_ '())
                                     (_namespaces163936_ _namespaces163930_))
                    (if (null? _attrs163934_)
                        (values _proper-attrs163935_ _namespaces163936_)
                        (if (eq? _xmlns163891_ (caar _attrs163934_))
                            (_loop163932_
                             (cdr _attrs163934_)
                             _proper-attrs163935_
                             (if (equal? '"" (cdar _attrs163934_))
                                 (cons (cons '*DEFAULT* (cons '#f '#f))
                                       _namespaces163936_)
                                 (_add-ns163895_
                                  _port163928_
                                  '*DEFAULT*
                                  (cdar _attrs163934_)
                                  _namespaces163936_)))
                            (if (and (pair? (caar _attrs163934_))
                                     (eq? _xmlns163891_ (caaar _attrs163934_)))
                                (_loop163932_
                                 (cdr _attrs163934_)
                                 _proper-attrs163935_
                                 (_add-ns163895_
                                  _port163928_
                                  (cdaar _attrs163934_)
                                  (cdar _attrs163934_)
                                  _namespaces163936_))
                                (_loop163932_
                                 (cdr _attrs163934_)
                                 (cons (car _attrs163934_)
                                       _proper-attrs163935_)
                                 _namespaces163936_))))))))
        (lambda (_tag-head163898_
                 _port163899_
                 _elems163900_
                 _entities163901_
                 _namespaces163902_)
          (let* ((_attlist163904_
                  (std/xml/ssax#ssax:read-attributes
                   _port163899_
                   _entities163901_))
                 (_empty-el-tag?163906_
                  (begin
                    (std/xml/ssax#ssax:skip-S _port163899_)
                    (if (eqv? '#\/
                              (std/xml/ssax#assert-curr-char__%
                               '(#\> #\/)
                               '"XML [40], XML [44], no '>'"
                               _port163899_))
                        (std/xml/ssax#assert-curr-char__%
                         '(#\>)
                         '"XML [44], no '>'"
                         _port163899_)
                        '#f)))
                 (_g169299_
                  (if _elems163900_
                      (let ((_$e163908_
                             (assoc _tag-head163898_ _elems163900_)))
                        (if _$e163908_
                            ((lambda (_decl-elem163911_)
                               (values (if _empty-el-tag?163906_
                                           'EMPTY-TAG
                                           (cadr _decl-elem163911_))
                                       (caddr _decl-elem163911_)))
                             _$e163908_)
                            (std/xml/ssax#parser-error
                             _port163899_
                             '"[elementvalid] broken, no decl for "
                             _tag-head163898_)))
                      (values (if _empty-el-tag?163906_ 'EMPTY-TAG 'ANY)
                              '#f))))
            (begin
              (let ((_g169300_
                     (if (##values? _g169299_) (##vector-length _g169299_) 1)))
                (if (not (##fx= _g169300_ 2))
                    (error "Context expects 2 values" _g169300_)))
              (let ((_elem-content163913_ (##vector-ref _g169299_ 0))
                    (_decl-attrs163914_ (##vector-ref _g169299_ 1)))
                (let* ((_merged-attrs163916_
                        (if _decl-attrs163914_
                            (_validate-attrs163894_
                             _port163899_
                             _attlist163904_
                             _decl-attrs163914_)
                            (std/xml/ssax#attlist->alist _attlist163904_)))
                       (_g169301_
                        (_adjust-namespace-decl163896_
                         _port163899_
                         _merged-attrs163916_
                         _namespaces163902_)))
                  (begin
                    (let ((_g169302_
                           (if (##values? _g169301_)
                               (##vector-length _g169301_)
                               1)))
                      (if (not (##fx= _g169302_ 2))
                          (error "Context expects 2 values" _g169302_)))
                    (let ((_proper-attrs163918_ (##vector-ref _g169301_ 0))
                          (_namespaces163919_ (##vector-ref _g169301_ 1)))
                      (let ()
                        (values (std/xml/ssax#ssax:resolve-name
                                 _port163899_
                                 _tag-head163898_
                                 _namespaces163919_
                                 '#t)
                                (std/xml/ssax#fold-right
                                 (lambda (_name-value163922_ _attlist163923_)
                                   (let ((_$e163925_
                                          (std/xml/ssax#attlist-add
                                           _attlist163923_
                                           (cons (std/xml/ssax#ssax:resolve-name
                                                  _port163899_
                                                  (car _name-value163922_)
                                                  _namespaces163919_
                                                  '#f)
                                                 (cdr _name-value163922_)))))
                                     (if _$e163925_
                                         _$e163925_
                                         (std/xml/ssax#parser-error
                                          _port163899_
                                          '"[uniqattspec] after NS expansion broken for "
                                          _name-value163922_))))
                                 (std/xml/ssax#make-empty-attlist)
                                 _proper-attrs163918_)
                                _namespaces163919_
                                _elem-content163913_))))))))))))
  (define std/xml/ssax#ssax:read-external-id
    (lambda (_port163877_)
      (let ((_discriminator163879_
             (std/xml/ssax#ssax:read-NCName _port163877_)))
        (std/xml/ssax#assert-curr-char__%
         std/xml/ssax#ssax:S-chars
         '"space after SYSTEM or PUBLIC"
         _port163877_)
        (std/xml/ssax#ssax:skip-S _port163877_)
        (let ((_delimiter163881_
               (std/xml/ssax#assert-curr-char__%
                '(#\' #\")
                '"XML [11], XML [12]"
                _port163877_)))
          (if (eq? _discriminator163879_ (string->symbol '"SYSTEM"))
              (let ((_$r163883_
                     (std/xml/ssax#next-token__%
                      '()
                      (list _delimiter163881_)
                      '"XML [11]"
                      _port163877_)))
                (read-char _port163877_)
                _$r163883_)
              (if (eq? _discriminator163879_ (string->symbol '"PUBLIC"))
                  (begin
                    (std/xml/ssax#skip-until__%
                     (list _delimiter163881_)
                     _port163877_)
                    (std/xml/ssax#assert-curr-char__%
                     std/xml/ssax#ssax:S-chars
                     '"space after PubidLiteral"
                     _port163877_)
                    (std/xml/ssax#ssax:skip-S _port163877_)
                    (let* ((_delimiter163886_
                            (std/xml/ssax#assert-curr-char__%
                             '(#\' #\")
                             '"XML [11]"
                             _port163877_))
                           (_systemid163888_
                            (std/xml/ssax#next-token__%
                             '()
                             (list _delimiter163886_)
                             '"XML [11]"
                             _port163877_)))
                      (read-char _port163877_)
                      _systemid163888_))
                  (std/xml/ssax#parser-error
                   _port163877_
                   '"XML [75], "
                   _discriminator163879_
                   '" rather than SYSTEM or PUBLIC")))))))
  (define std/xml/ssax#ssax:scan-Misc
    (lambda (_port163860_)
      (let _loop163862_ ((_c163864_ (std/xml/ssax#ssax:skip-S _port163860_)))
        (if (eof-object? _c163864_)
            _c163864_
            (if (not (char=? _c163864_ '#\<))
                (std/xml/ssax#parser-error
                 _port163860_
                 '"XML [22], char '"
                 _c163864_
                 '"' unexpected")
                (let* ((_token163866_
                        (std/xml/ssax#ssax:read-markup-token _port163860_))
                       (_$e163868_ (car _token163866_)))
                  (if (eq? 'COMMENT _$e163868_)
                      (_loop163862_ (std/xml/ssax#ssax:skip-S _port163860_))
                      (if (or (eq? 'PI _$e163868_)
                              (eq? 'DECL _$e163868_)
                              (eq? 'START _$e163868_))
                          _token163866_
                          (std/xml/ssax#parser-error
                           _port163860_
                           '"XML [22], unexpected token of kind "
                           (car _token163866_))))))))))
  (define std/xml/ssax#ssax:read-char-data
    (let ((_terminators-usual163817_ (list '#\< '#\& std/xml/ssax#char-return))
          (_terminators-usual-eof163818_
           (list '#\< '*eof* '#\& std/xml/ssax#char-return))
          (_handle-fragment163819_
           (lambda (_fragment163813_ _str-handler163814_ _seed163815_)
             (if (std/xml/ssax#string-null? _fragment163813_)
                 _seed163815_
                 (_str-handler163814_ _fragment163813_ '"" _seed163815_)))))
      (lambda (_port163821_
               _expect-eof?163822_
               _str-handler163823_
               _seed163824_)
        (if (eqv? '#\< (peek-char _port163821_))
            (let* ((_token163826_
                    (std/xml/ssax#ssax:read-markup-token _port163821_))
                   (_$e163828_ (car _token163826_)))
              (if (or (eq? 'START _$e163828_) (eq? 'END _$e163828_))
                  (values _seed163824_ _token163826_)
                  (if (eq? 'CDSECT _$e163828_)
                      (let ((_seed163834_
                             (std/xml/ssax#ssax:read-cdata-body
                              _port163821_
                              _str-handler163823_
                              _seed163824_)))
                        (std/xml/ssax#ssax:read-char-data
                         _port163821_
                         _expect-eof?163822_
                         _str-handler163823_
                         _seed163834_))
                      (if (eq? 'COMMENT _$e163828_)
                          (std/xml/ssax#ssax:read-char-data
                           _port163821_
                           _expect-eof?163822_
                           _str-handler163823_
                           _seed163824_)
                          (values _seed163824_ _token163826_)))))
            (let ((_char-data-terminators163836_
                   (if _expect-eof?163822_
                       _terminators-usual-eof163818_
                       _terminators-usual163817_)))
              (let _loop163838_ ((_seed163840_ _seed163824_))
                (let* ((_fragment163842_
                        (std/xml/ssax#next-token__%
                         '()
                         _char-data-terminators163836_
                         '"reading char data"
                         _port163821_))
                       (_term-char163844_ (peek-char _port163821_)))
                  (if (eof-object? _term-char163844_)
                      (values (_handle-fragment163819_
                               _fragment163842_
                               _str-handler163823_
                               _seed163840_)
                              _term-char163844_)
                      (let ((_$e163847_ _term-char163844_))
                        (if (eq? '#\< _$e163847_)
                            (let* ((_token163850_
                                    (std/xml/ssax#ssax:read-markup-token
                                     _port163821_))
                                   (_$e163852_ (car _token163850_)))
                              (if (eq? 'CDSECT _$e163852_)
                                  (_loop163838_
                                   (std/xml/ssax#ssax:read-cdata-body
                                    _port163821_
                                    _str-handler163823_
                                    (_handle-fragment163819_
                                     _fragment163842_
                                     _str-handler163823_
                                     _seed163840_)))
                                  (if (eq? 'COMMENT _$e163852_)
                                      (_loop163838_
                                       (_handle-fragment163819_
                                        _fragment163842_
                                        _str-handler163823_
                                        _seed163840_))
                                      (values (_handle-fragment163819_
                                               _fragment163842_
                                               _str-handler163823_
                                               _seed163840_)
                                              _token163850_))))
                            (if (eq? '#\& _$e163847_)
                                (let ((_$e163855_
                                       (std/xml/ssax#peek-next-char__%
                                        _port163821_)))
                                  (if (eq? '#\# _$e163855_)
                                      (begin
                                        (read-char _port163821_)
                                        (_loop163838_
                                         (_str-handler163823_
                                          _fragment163842_
                                          (string (std/xml/ssax#ssax:read-char-ref
                                                   _port163821_))
                                          _seed163840_)))
                                      (let ((_name163858_
                                             (std/xml/ssax#ssax:read-NCName
                                              _port163821_)))
                                        (std/xml/ssax#assert-curr-char__%
                                         '(#\;)
                                         '"XML [68]"
                                         _port163821_)
                                        (values (_handle-fragment163819_
                                                 _fragment163842_
                                                 _str-handler163823_
                                                 _seed163840_)
                                                (cons 'ENTITY-REF
                                                      _name163858_)))))
                                (begin
                                  (if (eqv? (std/xml/ssax#peek-next-char__%
                                             _port163821_)
                                            '#\newline)
                                      (read-char _port163821_)
                                      '#!void)
                                  (_loop163838_
                                   (_str-handler163823_
                                    _fragment163842_
                                    (string '#\newline)
                                    _seed163840_))))))))))))))
  (define std/xml/ssax#ssax:assert-token
    (lambda (_token163805_ _kind163806_ _gi163807_ _error-cont163808_)
      (let ((_$e163810_
             (if (std/xml/ssax#xml-token? _token163805_)
                 (if (eq? _kind163806_ (car _token163805_))
                     (equal? _gi163807_ (cdr _token163805_))
                     '#f)
                 '#f)))
        (if _$e163810_
            _$e163810_
            (_error-cont163808_ _token163805_ _kind163806_ _gi163807_)))))
  (define std/xml/ssax#ssax:reverse-collect-str
    (lambda (_fragments163797_)
      (if (null? _fragments163797_)
          '()
          (if (null? (cdr _fragments163797_))
              _fragments163797_
              (let _loop163799_ ((_fragments163801_ _fragments163797_)
                                 (_result163802_ '())
                                 (_strs163803_ '()))
                (if (null? _fragments163801_)
                    (if (null? _strs163803_)
                        _result163802_
                        (cons (std/srfi/13#string-concatenate/shared
                               _strs163803_)
                              _result163802_))
                    (if (string? (car _fragments163801_))
                        (_loop163799_
                         (cdr _fragments163801_)
                         _result163802_
                         (cons (car _fragments163801_) _strs163803_))
                        (_loop163799_
                         (cdr _fragments163801_)
                         (cons (car _fragments163801_)
                               (if (null? _strs163803_)
                                   _result163802_
                                   (cons (std/srfi/13#string-concatenate/shared
                                          _strs163803_)
                                         _result163802_)))
                         '()))))))))
  (define std/xml/ssax#ssax:reverse-collect-str-drop-ws
    (lambda (_fragments163788_)
      (if (null? _fragments163788_)
          '()
          (if (null? (cdr _fragments163788_))
              (if (and (string? (car _fragments163788_))
                       (std/xml/ssax#string-whitespace?
                        (car _fragments163788_)))
                  '()
                  _fragments163788_)
              (let _loop163790_ ((_fragments163792_ _fragments163788_)
                                 (_result163793_ '())
                                 (_strs163794_ '())
                                 (_all-whitespace?163795_ '#t))
                (if (null? _fragments163792_)
                    (if _all-whitespace?163795_
                        _result163793_
                        (cons (std/srfi/13#string-concatenate/shared
                               _strs163794_)
                              _result163793_))
                    (if (string? (car _fragments163792_))
                        (_loop163790_
                         (cdr _fragments163792_)
                         _result163793_
                         (cons (car _fragments163792_) _strs163794_)
                         (if _all-whitespace?163795_
                             (std/xml/ssax#string-whitespace?
                              (car _fragments163792_))
                             '#f))
                        (_loop163790_
                         (cdr _fragments163792_)
                         (cons (car _fragments163792_)
                               (if _all-whitespace?163795_
                                   _result163793_
                                   (cons (std/srfi/13#string-concatenate/shared
                                          _strs163794_)
                                         _result163793_)))
                         '()
                         '#t))))))))
  (define std/xml/ssax#ssax:xml->sxml
    (lambda (_port158816_ _namespace-prefix-assig158817_)
      (letrec ((_namespaces158819_
                (map (lambda (_el158822_)
                       (cons '#f
                             (cons (car _el158822_)
                                   (string->symbol (cdr _el158822_)))))
                     _namespace-prefix-assig158817_))
               (_RES-NAME->SXML158820_
                (lambda (_res-name158824_)
                  (string->symbol
                   (string-append
                    (symbol->string (car _res-name158824_))
                    '":"
                    (symbol->string (cdr _res-name158824_)))))))
        (let ((_result163784_
               (reverse ((lambda (_port160851_ _seed160853_)
                           (letrec ((_handle-decl160856_
                                     (lambda (_port163750_
                                              _token-head163751_
                                              _seed163753_)
                                       (let ((_$e163755_
                                              (eq? (string->symbol '"DOCTYPE")
                                                   _token-head163751_)))
                                         (if _$e163755_
                                             _$e163755_
                                             (std/xml/ssax#parser-error
                                              _port163750_
                                              '"XML [22], expected DOCTYPE declaration, found "
                                              _token-head163751_)))
                                       (std/xml/ssax#assert-curr-char__%
                                        std/xml/ssax#ssax:S-chars
                                        '"XML [28], space after DOCTYPE"
                                        _port163750_)
                                       (std/xml/ssax#ssax:skip-S _port163750_)
                                       (let* ((_docname163758_
                                               (std/xml/ssax#ssax:read-QName
                                                _port163750_))
                                              (_systemid163761_
                                               (if (std/xml/ssax#ssax:ncname-starting-char?
                                                    (std/xml/ssax#ssax:skip-S
                                                     _port163750_))
                                                   (std/xml/ssax#ssax:read-external-id
                                                    _port163750_)
                                                   '#f))
                                              (_internal-subset?163764_
                                               (begin
                                                 (std/xml/ssax#ssax:skip-S
                                                  _port163750_)
                                                 (eqv? '#\[
                                                       (std/xml/ssax#assert-curr-char__%
                                                        '(#\> #\[)
                                                        '"XML [28], end-of-DOCTYPE"
                                                        _port163750_))))
                                              (_g169303_
                                               ((lambda (_port163767_
                                                         _docname163769_
                                                         _systemid163771_
                                                         _internal-subset?163773_
                                                         _seed163775_)
                                                  (if _internal-subset?163773_
                                                      (std/xml/ssax#ssax:skip-internal-dtd
                                                       _port163767_)
                                                      '#!void)
                                                  (values '#f
                                                          '()
                                                          _namespaces158819_
                                                          _seed163775_))
                                                _port163750_
                                                _docname163758_
                                                _systemid163761_
                                                _internal-subset?163764_
                                                _seed163753_)))
                                         (begin
                                           (let ((_g169304_
                                                  (if (##values? _g169303_)
                                                      (##vector-length
                                                       _g169303_)
                                                      1)))
                                             (if (not (##fx= _g169304_ 4))
                                                 (error "Context expects 4 values"
                                                        _g169304_)))
                                           (let ((_elems163778_
                                                  (##vector-ref _g169303_ 0))
                                                 (_entities163779_
                                                  (##vector-ref _g169303_ 1))
                                                 (_namespaces163780_
                                                  (##vector-ref _g169303_ 2))
                                                 (_seed163781_
                                                  (##vector-ref _g169303_ 3)))
                                             (let ()
                                               (_scan-for-significant-prolog-token-2160860_
                                                _port163750_
                                                _elems163778_
                                                _entities163779_
                                                _namespaces163780_
                                                _seed163781_)))))))
                                    (_scan-for-significant-prolog-token-1160858_
                                     (lambda (_port162843_ _seed162844_)
                                       (let ((_token162846_
                                              (std/xml/ssax#ssax:scan-Misc
                                               _port162843_)))
                                         (if (eof-object? _token162846_)
                                             (std/xml/ssax#parser-error
                                              _port162843_
                                              '"XML [22], unexpected EOF")
                                             (let ((_$e162848_
                                                    (car _token162846_)))
                                               (if (eq? 'PI _$e162848_)
                                                   (let ((_seed163737_
                                                          ((lambda (_port163726_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                            _target163727_
                            _seed163728_)
                     (let ((_$e163730_ _target163727_))
                       ((lambda (_port163733_ _pi-tag163734_ _seed163735_)
                          (cons (list '*PI*
                                      _pi-tag163734_
                                      (std/xml/ssax#ssax:read-pi-body-as-string
                                       _port163733_))
                                _seed163735_))
                        _port163726_
                        _target163727_
                        _seed163728_)))
                   _port162843_
                   (cdr _token162846_)
                   _seed162844_)))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                     (_scan-for-significant-prolog-token-1160858_
                                                      _port162843_
                                                      _seed163737_))
                                                   (if (eq? 'DECL _$e162848_)
                                                       (_handle-decl160856_
                                                        _port162843_
                                                        (cdr _token162846_)
                                                        _seed162844_)
                                                       (if (eq? 'START
                                                                _$e162848_)
                                                           (let ((_g169305_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                          ((lambda (_elem-gi163739_ _seed163741_)
                             (values '#f '() _namespaces158819_ _seed163741_))
                           (cdr _token162846_)
                           _seed162844_)))
                     (begin
                       (let ((_g169306_
                              (if (##values? _g169305_)
                                  (##vector-length _g169305_)
                                  1)))
                         (if (not (##fx= _g169306_ 4))
                             (error "Context expects 4 values" _g169306_)))
                       (let ((_elems163744_ (##vector-ref _g169305_ 0))
                             (_entities163745_ (##vector-ref _g169305_ 1))
                             (_namespaces163746_ (##vector-ref _g169305_ 2))
                             (_seed163747_ (##vector-ref _g169305_ 3)))
                         (let ()
                           (_element-parser160862_
                            (cdr _token162846_)
                            _port162843_
                            _elems163744_
                            _entities163745_
                            _namespaces163746_
                            '#f
                            _seed163747_)))))
                   (std/xml/ssax#parser-error
                    _port162843_
                    '"XML [22], unexpected markup "
                    _token162846_)))))))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                    (_scan-for-significant-prolog-token-2160860_
                                     (lambda (_port161935_
                                              _elems161936_
                                              _entities161938_
                                              _namespaces161940_
                                              _seed161942_)
                                       (let ((_token161944_
                                              (std/xml/ssax#ssax:scan-Misc
                                               _port161935_)))
                                         (if (eof-object? _token161944_)
                                             (std/xml/ssax#parser-error
                                              _port161935_
                                              '"XML [22], unexpected EOF")
                                             (let ((_$e161947_
                                                    (car _token161944_)))
                                               (if (eq? 'PI _$e161947_)
                                                   (let ((_seed162836_
                                                          ((lambda (_port162825_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                            _target162826_
                            _seed162827_)
                     (let ((_$e162829_ _target162826_))
                       ((lambda (_port162832_ _pi-tag162833_ _seed162834_)
                          (cons (list '*PI*
                                      _pi-tag162833_
                                      (std/xml/ssax#ssax:read-pi-body-as-string
                                       _port162832_))
                                _seed162834_))
                        _port162825_
                        _target162826_
                        _seed162827_)))
                   _port161935_
                   (cdr _token161944_)
                   _seed161942_)))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                     (_scan-for-significant-prolog-token-2160860_
                                                      _port161935_
                                                      _elems161936_
                                                      _entities161938_
                                                      _namespaces161940_
                                                      _seed162836_))
                                                   (if (eq? 'START _$e161947_)
                                                       (_element-parser160862_
                                                        (cdr _token161944_)
                                                        _port161935_
                                                        _elems161936_
                                                        _entities161938_
                                                        _namespaces161940_
                                                        '#f
                                                        ((lambda (_elem-gi162838_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                          _seed162840_)
                   _seed162840_)
                 (cdr _token161944_)
                 _seed161942_))
               (std/xml/ssax#parser-error
                _port161935_
                '"XML [22], unexpected markup "
                _token161944_))))))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                    (_element-parser160862_
                                     (lambda (_start-tag-head160865_
                                              _port160867_
                                              _elems160869_
                                              _entities160871_
                                              _namespaces160873_
                                              _preserve-ws?160875_
                                              _seed160877_)
                                       (letrec* ((_xml-space-gi160880_
                                                  (cons std/xml/ssax#ssax:Prefix-XML
                                                        (string->symbol
                                                         '"space"))))
                                         (let _handle-start-tag160883_ ((_start-tag-head160886_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                                 _start-tag-head160865_)
                                (_port160887_ _port160867_)
                                (_entities160888_ _entities160871_)
                                (_namespaces160889_ _namespaces160873_)
                                (_preserve-ws?160890_ _preserve-ws?160875_)
                                (_parent-seed160891_ _seed160877_))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                           (let ((_g169307_
                                                  (std/xml/ssax#ssax:complete-start-tag
                                                   _start-tag-head160886_
                                                   _port160887_
                                                   _elems160869_
                                                   _entities160888_
                                                   _namespaces160889_)))
                                             (begin
                                               (let ((_g169308_
                                                      (if (##values? _g169307_)
                                                          (##vector-length
                                                           _g169307_)
                                                          1)))
                                                 (if (not (##fx= _g169308_ 4))
                                                     (error "Context expects 4 values"
                                                            _g169308_)))
                                               (let ((_elem-gi160894_
                                                      (##vector-ref
                                                       _g169307_
                                                       0))
                                                     (_attributes160896_
                                                      (##vector-ref
                                                       _g169307_
                                                       1))
                                                     (_namespaces160898_
                                                      (##vector-ref
                                                       _g169307_
                                                       2))
                                                     (_expected-content160899_
                                                      (##vector-ref
                                                       _g169307_
                                                       3)))
                                                 (let ((_seed160913_
                                                        ((lambda (_elem-gi160902_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                          _attributes160904_
                          _namespaces160906_
                          _expected-content160908_
                          _seed160910_)
                   '())
                 _elem-gi160894_
                 _attributes160896_
                 _namespaces160898_
                 _expected-content160899_
                 _parent-seed160891_)))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                   (let ((_$e160916_
                                                          _expected-content160899_))
                                                     (if (eq? 'EMPTY-TAG
                                                              _$e160916_)
                                                         ((lambda (_elem-gi160919_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                           _attributes160921_
                           _namespaces160923_
                           _parent-seed160925_
                           _seed160927_)
                    (let ((_seed160935_
                           (std/xml/ssax#ssax:reverse-collect-str-drop-ws
                            _seed160927_))
                          (_attrs160936_
                           (std/xml/ssax#attlist-fold
                            (lambda (_attr160930_ _accum160932_)
                              (cons (list (if (symbol? (car _attr160930_))
                                              (car _attr160930_)
                                              (_RES-NAME->SXML158820_
                                               (car _attr160930_)))
                                          (cdr _attr160930_))
                                    _accum160932_))
                            '()
                            _attributes160921_)))
                      (cons (cons (if (symbol? _elem-gi160919_)
                                      _elem-gi160919_
                                      (_RES-NAME->SXML158820_ _elem-gi160919_))
                                  (if (null? _attrs160936_)
                                      _seed160935_
                                      (cons (cons '@ _attrs160936_)
                                            _seed160935_)))
                            _parent-seed160925_)))
                  _elem-gi160894_
                  _attributes160896_
                  _namespaces160898_
                  _parent-seed160891_
                  _seed160913_)
                 (if (eq? 'EMPTY _$e160916_)
                     (begin
                       (std/xml/ssax#ssax:assert-token
                        (if (eqv? '#\< (std/xml/ssax#ssax:skip-S _port160887_))
                            (std/xml/ssax#ssax:read-markup-token _port160887_)
                            '#f)
                        'END
                        _start-tag-head160886_
                        (lambda (_token160939_
                                 _exp-kind160941_
                                 _exp-head160943_)
                          (std/xml/ssax#parser-error
                           _port160887_
                           '"[elementvalid] broken for "
                           _token160939_
                           '" while expecting "
                           _exp-kind160941_
                           _exp-head160943_)))
                       ((lambda (_elem-gi160946_
                                 _attributes160947_
                                 _namespaces160948_
                                 _parent-seed160949_
                                 _seed160950_)
                          (let ((_seed160955_
                                 (std/xml/ssax#ssax:reverse-collect-str-drop-ws
                                  _seed160950_))
                                (_attrs160956_
                                 (std/xml/ssax#attlist-fold
                                  (lambda (_attr160952_ _accum160953_)
                                    (cons (list (if (symbol? (car _attr160952_))
                                                    (car _attr160952_)
                                                    (_RES-NAME->SXML158820_
                                                     (car _attr160952_)))
                                                (cdr _attr160952_))
                                          _accum160953_))
                                  '()
                                  _attributes160947_)))
                            (cons (cons (if (symbol? _elem-gi160946_)
                                            _elem-gi160946_
                                            (_RES-NAME->SXML158820_
                                             _elem-gi160946_))
                                        (if (null? _attrs160956_)
                                            _seed160955_
                                            (cons (cons '@ _attrs160956_)
                                                  _seed160955_)))
                                  _parent-seed160949_)))
                        _elem-gi160894_
                        _attributes160896_
                        _namespaces160898_
                        _parent-seed160891_
                        _seed160913_))
                     (let ((_preserve-ws?160964_
                            (let ((_$e160958_
                                   (assoc _xml-space-gi160880_
                                          _attributes160896_)))
                              (if _$e160958_
                                  ((lambda (_name-value160961_)
                                     (equal? '"preserve"
                                             (cdr _name-value160961_)))
                                   _$e160958_)
                                  _preserve-ws?160890_))))
                       (let _loop160966_ ((_port160969_ _port160887_)
                                          (_entities160970_ _entities160888_)
                                          (_expect-eof?160971_ '#f)
                                          (_seed160973_ _seed160913_))
                         (let ((_g169309_
                                (std/xml/ssax#ssax:read-char-data
                                 _port160969_
                                 _expect-eof?160971_
                                 (lambda (_string1160975_
                                          _string2160977_
                                          _seed160979_)
                                   (if (std/xml/ssax#string-null?
                                        _string2160977_)
                                       (cons _string1160975_ _seed160979_)
                                       (cons _string2160977_
                                             (cons _string1160975_
                                                   _seed160979_))))
                                 _seed160973_)))
                           (begin
                             (let ((_g169310_
                                    (if (##values? _g169309_)
                                        (##vector-length _g169309_)
                                        1)))
                               (if (not (##fx= _g169310_ 2))
                                   (error "Context expects 2 values"
                                          _g169310_)))
                             (let ((_seed160982_ (##vector-ref _g169309_ 0))
                                   (_term-token160983_
                                    (##vector-ref _g169309_ 1)))
                               (let ()
                                 (if (eof-object? _term-token160983_)
                                     _seed160982_
                                     (let ((_$e160987_
                                            (car _term-token160983_)))
                                       (if (eq? 'END _$e160987_)
                                           (begin
                                             (std/xml/ssax#ssax:assert-token
                                              _term-token160983_
                                              'END
                                              _start-tag-head160886_
                                              (lambda (_token160990_
                                                       _exp-kind160991_
                                                       _exp-head160992_)
                                                (std/xml/ssax#parser-error
                                                 _port160969_
                                                 '"[GIMatch] broken for "
                                                 _term-token160983_
                                                 '" while expecting "
                                                 _exp-kind160991_
                                                 _exp-head160992_)))
                                             ((lambda (_elem-gi160994_
                                                       _attributes160995_
                                                       _namespaces160996_
                                                       _parent-seed160997_
                                                       _seed160998_)
                                                (let ((_seed161003_
                                                       (std/xml/ssax#ssax:reverse-collect-str-drop-ws
                                                        _seed160998_))
                                                      (_attrs161004_
                                                       (std/xml/ssax#attlist-fold
                                                        (lambda (_attr161000_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                         _accum161001_)
                  (cons (list (if (symbol? (car _attr161000_))
                                  (car _attr161000_)
                                  (_RES-NAME->SXML158820_ (car _attr161000_)))
                              (cdr _attr161000_))
                        _accum161001_))
                '()
                _attributes160995_)))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                  (cons (cons (if (symbol? _elem-gi160994_)
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                          _elem-gi160994_
                          (_RES-NAME->SXML158820_ _elem-gi160994_))
                      (if (null? _attrs161004_)
                          _seed161003_
                          (cons (cons '@ _attrs161004_) _seed161003_)))
                _parent-seed160997_)))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                              _elem-gi160894_
                                              _attributes160896_
                                              _namespaces160898_
                                              _parent-seed160891_
                                              _seed160982_))
                                           (if (eq? 'PI _$e160987_)
                                               (let ((_seed161921_
                                                      ((lambda (_port161907_
                                                                _target161908_
                                                                _seed161909_)
                                                         (let ((_$e161911_
                                                                _target161908_))
                                                           ((lambda (_port161914_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                             _pi-tag161916_
                             _seed161918_)
                      (cons (list '*PI*
                                  _pi-tag161916_
                                  (std/xml/ssax#ssax:read-pi-body-as-string
                                   _port161914_))
                            _seed161918_))
                    _port161907_
                    _target161908_
                    _seed161909_)))
               _port160969_
               (cdr _term-token160983_)
               _seed160982_)))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                 (_loop160966_
                                                  _port160969_
                                                  _entities160970_
                                                  _expect-eof?160971_
                                                  _seed161921_))
                                               (if (eq? 'ENTITY-REF _$e160987_)
                                                   (let ((_seed161931_
                                                          (std/xml/ssax#ssax:handle-parsed-entity
                                                           _port160969_
                                                           (cdr _term-token160983_)
                                                           _entities160970_
                                                           (lambda (_port161923_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                            _entities161924_
                            _seed161925_)
                     (_loop160966_
                      _port161923_
                      _entities161924_
                      '#t
                      _seed161925_))
                   (lambda (_string1161927_ _string2161928_ _seed161929_)
                     (if (std/xml/ssax#string-null? _string2161928_)
                         (cons _string1161927_ _seed161929_)
                         (cons _string2161928_
                               (cons _string1161927_ _seed161929_))))
                   _seed160982_)))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                     (_loop160966_
                                                      _port160969_
                                                      _entities160970_
                                                      _expect-eof?160971_
                                                      _seed161931_))
                                                   (if (eq? 'START _$e160987_)
                                                       (begin
                                                         (if (eq? _expected-content160899_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                          'PCDATA)
                     (std/xml/ssax#parser-error
                      _port160969_
                      '"[elementvalid] broken for "
                      _elem-gi160894_
                      '" with char content only; unexpected token "
                      _term-token160983_)
                     '#!void)
                 (let ((_seed161933_
                        (_handle-start-tag160883_
                         (cdr _term-token160983_)
                         _port160969_
                         _entities160970_
                         _namespaces160898_
                         _preserve-ws?160964_
                         _seed160982_)))
                   (_loop160966_
                    _port160969_
                    _entities160970_
                    _expect-eof?160971_
                    _seed161933_)))
               (std/xml/ssax#parser-error
                _port160969_
                '"XML [43] broken for "
                _term-token160983_)))))))))))))))))))))))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                             (_scan-for-significant-prolog-token-1160858_
                              _port160851_
                              _seed160853_)))
                         _port158816_
                         '()))))
          (cons '*TOP*
                (if (null? _namespace-prefix-assig158817_)
                    _result163784_
                    (cons (list '@
                                (cons '*NAMESPACES*
                                      (map (lambda (_ns163786_)
                                             (list (car _ns163786_)
                                                   (cdr _ns163786_)))
                                           _namespace-prefix-assig158817_)))
                          _result163784_)))))))
  (define std/xml/ssax#SSAX:XML->SXML std/xml/ssax#ssax:xml->sxml))
