/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.encoding;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CoderResult;
import nu.validator.encoding.Big5Data;
import nu.validator.encoding.Decoder;

public class Big5Decoder
extends Decoder {
    private int big5Lead = 0;
    private char pendingTrail = '\u0000';

    protected Big5Decoder(Charset cs) {
        super(cs, 0.5f, 1.0f);
    }

    @Override
    protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
        assert (!this.report || this.big5Lead == 0) : "When reporting, this method should never return with big5Lead set.";
        if (this.pendingTrail != '\u0000') {
            if (!out.hasRemaining()) {
                return CoderResult.OVERFLOW;
            }
            out.put(this.pendingTrail);
            this.pendingTrail = '\u0000';
        }
        block6: while (in.hasRemaining()) {
            int offset;
            if (!out.hasRemaining()) {
                return CoderResult.OVERFLOW;
            }
            int b = in.get() & 0xFF;
            if (this.big5Lead == 0) {
                if (b <= 127) {
                    out.put((char)b);
                    continue;
                }
                if (b >= 129 && b <= 254) {
                    if (this.report && !in.hasRemaining()) {
                        in.position(in.position() - 1);
                        return CoderResult.UNDERFLOW;
                    }
                    this.big5Lead = b;
                    continue;
                }
                if (this.report) {
                    in.position(in.position() - 1);
                    return CoderResult.malformedForLength(1);
                }
                out.put('\ufffd');
                continue;
            }
            int lead = this.big5Lead;
            this.big5Lead = 0;
            int n = offset = b < 127 ? 64 : 98;
            if (b >= 64 && b <= 126 || b >= 161 && b <= 254) {
                char outTrail;
                int pointer = (lead - 129) * 157 + (b - offset);
                switch (pointer) {
                    case 1133: {
                        out.put('\u00ca');
                        outTrail = '\u0304';
                        break;
                    }
                    case 1135: {
                        out.put('\u00ca');
                        outTrail = '\u030c';
                        break;
                    }
                    case 1164: {
                        out.put('\u00ea');
                        outTrail = '\u0304';
                        break;
                    }
                    case 1166: {
                        out.put('\u00ea');
                        outTrail = '\u030c';
                        break;
                    }
                    default: {
                        char lowBits = Big5Data.lowBits(pointer);
                        if (lowBits == '\u0000') {
                            if (b <= 127) {
                                in.position(in.position() - 1);
                            }
                            if (this.report) {
                                in.position(in.position() - 1);
                                return CoderResult.malformedForLength(b <= 127 ? 1 : 2);
                            }
                            out.put('\ufffd');
                            continue block6;
                        }
                        if (Big5Data.isAstral(pointer)) {
                            int codePoint = lowBits | 0x20000;
                            out.put((char)(55232 + (codePoint >> 10)));
                            outTrail = (char)(56320 + (codePoint & 0x3FF));
                            break;
                        }
                        out.put(lowBits);
                        continue block6;
                    }
                }
                if (!out.hasRemaining()) {
                    this.pendingTrail = outTrail;
                    return CoderResult.OVERFLOW;
                }
                out.put(outTrail);
                continue;
            }
            if (b <= 127) {
                in.position(in.position() - 1);
            }
            if (this.report) {
                in.position(in.position() - 1);
                return CoderResult.malformedForLength(b <= 127 ? 1 : 2);
            }
            out.put('\ufffd');
        }
        return CoderResult.UNDERFLOW;
    }

    @Override
    protected CoderResult implFlush(CharBuffer out) {
        if (this.pendingTrail != '\u0000') {
            if (!out.hasRemaining()) {
                return CoderResult.OVERFLOW;
            }
            out.put(this.pendingTrail);
            this.pendingTrail = '\u0000';
        }
        if (this.big5Lead != 0) {
            assert (!this.report) : "How come big5Lead got to be non-zero when decodeLoop() returned in the reporting mode?";
            if (!out.hasRemaining()) {
                return CoderResult.OVERFLOW;
            }
            out.put('\ufffd');
            this.big5Lead = 0;
        }
        return CoderResult.UNDERFLOW;
    }

    @Override
    protected void implReset() {
        this.big5Lead = 0;
        this.pendingTrail = '\u0000';
    }
}

