/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.datatype;

import java.io.IOException;
import java.util.HashSet;
import nu.validator.datatype.AbstractRel;
import nu.validator.datatype.tools.RegisteredRelValuesBuilder;
import org.relaxng.datatype.DatatypeException;
import org.xml.sax.SAXException;

public final class LinkRel
extends AbstractRel {
    private static final HashSet<String> registeredValues;
    public static final LinkRel THE_INSTANCE;
    private static final boolean WARN;

    private LinkRel() {
    }

    @Override
    protected boolean isRegistered(CharSequence literal, String token) throws DatatypeException {
        if ("shortcut".equals(LinkRel.toAsciiLowerCase(token))) {
            if ("shortcut icon".equals(LinkRel.toAsciiLowerCase(literal))) {
                return true;
            }
            throw new DatatypeException("If the \u201cshortcut\u201d keyword is present, the \u201crel\u201d attribute's entire value must be \u201cshortcut icon\u201d.");
        }
        return registeredValues.contains(token.toLowerCase());
    }

    @Override
    public String getName() {
        return "list of link-type keywords";
    }

    static {
        try {
            RegisteredRelValuesBuilder.parseRegistry();
            registeredValues = RegisteredRelValuesBuilder.getLinkRelValues();
            registeredValues.add("alternate");
            registeredValues.add("author");
            registeredValues.add("dns-prefetch");
            registeredValues.add("help");
            registeredValues.add("icon");
            registeredValues.add("license");
            registeredValues.add("mask-icon");
            registeredValues.add("next");
            registeredValues.add("pingback");
            registeredValues.add("preconnect");
            registeredValues.add("prefetch");
            registeredValues.add("preload");
            registeredValues.add("prerender");
            registeredValues.add("prev");
            registeredValues.add("search");
            registeredValues.add("serviceworker");
            registeredValues.add("stylesheet");
        }
        catch (IOException | SAXException e) {
            throw new RuntimeException(e);
        }
        THE_INSTANCE = new LinkRel();
        WARN = System.getProperty("nu.validator.datatype.warn", "").equals("true");
    }
}

