/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.Protocol;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;

public class VisiontekProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().text("$1,").expression("([^,]+),").number("(d+),").optional().number("(dd),(dd),(dd),").number("(dd),(dd),(dd),").groupBegin().number("(dd)(dd).?(d+)([NS]),").number("(ddd)(dd).?(d+)([EW]),").or().number("(dd.d+)([NS]),").number("(ddd.d+)([EW]),").groupEnd().number("(d+.?d+),").number("(d+),").groupBegin().number("(d+),").number("(d+),").number("(d+),").number("([01]),").number("([01]),").number("([01]),").number("([01]),").number("([01]),").number("(d+),").or().number("(d+.d),").number("(d+),").number("(d+),").number("([01],[01],[01],[01]),").number("([01],[01],[01],[01]),").number("(d+.?d*),").number("(d+.?d*),").groupEnd("?").any().expression("([AV])").number(",(d{10})").optional().any().compile();

    public VisiontekProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        Parser parser = new Parser(PATTERN, (String)msg);
        if (!parser.matches()) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next(), parser.next());
        if (deviceSession == null) {
            return null;
        }
        position.setDeviceId(deviceSession.getDeviceId());
        position.setTime(parser.nextDateTime(Parser.DateTimeFormat.DMY_HMS));
        if (parser.hasNext(8)) {
            position.setLatitude(parser.nextCoordinate(Parser.CoordinateFormat.DEG_MIN_MIN_HEM));
            position.setLongitude(parser.nextCoordinate(Parser.CoordinateFormat.DEG_MIN_MIN_HEM));
        }
        if (parser.hasNext(4)) {
            position.setLatitude(parser.nextCoordinate(Parser.CoordinateFormat.DEG_HEM));
            position.setLongitude(parser.nextCoordinate(Parser.CoordinateFormat.DEG_HEM));
        }
        position.setSpeed(UnitsConverter.knotsFromKph(Double.parseDouble(parser.next().replace(".", "")) / 10.0));
        position.setCourse(parser.nextDouble(0.0));
        if (parser.hasNext(9)) {
            position.setAltitude(parser.nextDouble(0.0));
            position.set("sat", parser.nextInt());
            position.set("odometer", parser.nextInt(0) * 1000);
            position.set("ignition", parser.next().equals("1"));
            position.set("io1", parser.next());
            position.set("io2", parser.next());
            position.set("immobilizer", parser.next());
            position.set("charge", parser.next().equals("1"));
            position.set("rssi", parser.nextDouble());
        }
        if (parser.hasNext(7)) {
            position.set("hdop", parser.nextDouble());
            position.setAltitude(parser.nextDouble(0.0));
            position.set("odometer", parser.nextInt(0) * 1000);
            position.set("input", parser.next());
            position.set("output", parser.next());
            position.set("adc1", parser.next());
            position.set("adc2", parser.next());
        }
        position.setValid(parser.next().equals("A"));
        position.set("driverUniqueId", parser.next());
        return position;
    }
}

