/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.Date;
import java.util.LinkedList;
import org.traccar.BaseProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.Checksum;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;

public class SatsolProtocolDecoder
extends BaseProtocolDecoder {
    public SatsolProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        buf.readUnsignedShortLE();
        buf.readUnsignedShortLE();
        long id = buf.readUnsignedIntLE();
        buf.readUnsignedShortLE();
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, String.valueOf(id));
        if (deviceSession == null) {
            return null;
        }
        LinkedList<Position> positions = new LinkedList<Position>();
        while (buf.isReadable()) {
            buf.readUnsignedShortLE();
            buf.readUnsignedShortLE();
            buf.readUnsignedShortLE();
            int length = buf.readUnsignedShortLE();
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            position.setTime(new Date(buf.readUnsignedIntLE() * 1000L));
            position.setLatitude((double)buf.readUnsignedIntLE() * 1.0E-6);
            position.setLongitude((double)buf.readUnsignedIntLE() * 1.0E-6);
            position.setSpeed(UnitsConverter.knotsFromKph((double)buf.readUnsignedShortLE() * 0.01));
            position.setAltitude(buf.readShortLE());
            position.setCourse(buf.readUnsignedShortLE());
            position.setValid(buf.readUnsignedByte() > 0);
            position.set("sat", buf.readUnsignedByte());
            position.set("event", buf.readUnsignedByte());
            if (BitUtil.check(buf.readUnsignedByte(), 0)) {
                position.set("archive", true);
            }
            positions.add(position);
            buf.skipBytes(length);
        }
        if (channel != null) {
            ByteBuf response = Unpooled.buffer();
            response.writeShortLE(0);
            response.writeShortLE(19647);
            response.writeIntLE((int)id);
            response.writeShortLE(0);
            response.setShortLE(0, Checksum.crc16(Checksum.CRC16_CCITT_FALSE, response.nioBuffer(2, response.readableBytes() - 2)));
            channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
        }
        return positions;
    }
}

