/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import com.fasterxml.jackson.databind.util.ByteBufferBackedInputStream;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.InputStream;
import java.net.SocketAddress;
import java.util.Date;
import java.util.LinkedList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.traccar.BaseHttpProtocolDecoder;
import org.traccar.DeviceSession;
import org.traccar.Protocol;
import org.traccar.helper.DataConverter;
import org.traccar.model.Position;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GlobalstarProtocolDecoder
extends BaseHttpProtocolDecoder {
    private DocumentBuilder documentBuilder;
    private XPath xPath;
    private XPathExpression messageExpression;

    public GlobalstarProtocolDecoder(Protocol protocol) {
        super(protocol);
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            builderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            builderFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            builderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            builderFactory.setXIncludeAware(false);
            builderFactory.setExpandEntityReferences(false);
            this.documentBuilder = builderFactory.newDocumentBuilder();
            this.xPath = XPathFactory.newInstance().newXPath();
            this.messageExpression = this.xPath.compile("//stuMessages/stuMessage");
        }
        catch (ParserConfigurationException | XPathExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        FullHttpRequest request = (FullHttpRequest)msg;
        Document document = this.documentBuilder.parse((InputStream)new ByteBufferBackedInputStream(request.content().nioBuffer()));
        NodeList nodes = (NodeList)this.messageExpression.evaluate(document, XPathConstants.NODESET);
        LinkedList<Position> positions = new LinkedList<Position>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, this.xPath.evaluate("esn", node));
            if (deviceSession == null) continue;
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            position.setValid(true);
            position.setTime(new Date(Long.parseLong(this.xPath.evaluate("unixTime", node)) * 1000L));
            ByteBuf buf = Unpooled.wrappedBuffer((byte[])DataConverter.parseHex(this.xPath.evaluate("payload", node).substring(2)));
            buf.readUnsignedByte();
            position.setLatitude((double)buf.readUnsignedMedium() * 90.0 / 8388608.0);
            if (position.getLatitude() > 90.0) {
                position.setLatitude(position.getLatitude() - 180.0);
            }
            position.setLongitude((double)buf.readUnsignedMedium() * 180.0 / 8388608.0);
            if (position.getLongitude() > 180.0) {
                position.setLongitude(position.getLongitude() - 360.0);
            }
            buf.readUnsignedByte();
            buf.readUnsignedByte();
            positions.add(position);
        }
        this.sendResponse(channel, HttpResponseStatus.OK);
        return positions;
    }
}

