/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Context;
import org.traccar.DeviceSession;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;
import org.traccar.model.WifiAccessPoint;

public class Gl200TextProtocolDecoder
extends BaseProtocolDecoder {
    private boolean ignoreFixTime = Context.getConfig().getBoolean(this.getProtocolName() + ".ignoreFixTime");
    private static final Pattern PATTERN_ACK = new PatternBuilder().text("+ACK:GT").expression("...,").number("([0-9A-Z]{2}xxxx),").number("(d{15}|x{14}),").any().text(",").number("(dddd)(dd)(dd)").number("(dd)(dd)(dd),").number("(xxxx)").text("$").optional().compile();
    private static final Pattern PATTERN_INF = new PatternBuilder().text("+").expression("(?:RESP|BUFF):GTINF,").number("[0-9A-Z]{2}xxxx,").number("(d{15}|x{14}),").expression("(?:[0-9A-Z]{17},)?").expression("(?:[^,]+)?,").number("(xx),").expression("(?:[0-9Ff]{20})?,").number("(d{1,2}),").number("d{1,2},").expression("[01],").number("([d.]+)?,").number("d*,").number("(d+.d+),").expression("([01]),").number("(?:d),").number("(?:d)?,").number("(?:d)?,").number("(?:d)?,").optional().number("d{14},").groupBegin().number("(d+),").number("[d.]*,").number("(-?[d.]+)?,,,").or().expression("(?:[01])?,").optional().number("(d+)?,").number("(d+)?,").optional().number("(xx)?,").number("(xx)?,").number("[-+]dddd,").expression("[01],").groupEnd().number("(dddd)(dd)(dd)").number("(dd)(dd)(dd),").number("(xxxx)").text("$").optional().compile();
    private static final Pattern PATTERN_VER = new PatternBuilder().text("+").expression("(?:RESP|BUFF):GTVER,").number("[0-9A-Z]{2}xxxx,").number("(d{15}|x{14}),").expression("[^,]*,").expression("([^,]*),").number("(xxxx),").number("(xxxx),").number("(dddd)(dd)(dd)").number("(dd)(dd)(dd),").number("(xxxx)").text("$").optional().compile();
    private static final Pattern PATTERN_LOCATION = new PatternBuilder().number("(d{1,2})?,").number("(d{1,3}.d)?,").number("(d{1,3})?,").number("(-?d{1,5}.d)?,").number("(-?d{1,3}.d{6})?,").number("(-?d{1,2}.d{6})?,").number("(dddd)(dd)(dd)").number("(dd)(dd)(dd)").optional(2).text(",").number("(d+)?,").number("(d+)?,").groupBegin().number("(d+),").number("(d+),").or().number("(x+)?,").number("(x+)?,").groupEnd().number("(?:d+|(d+.d))?,").compile();
    private static final Pattern PATTERN_OBD = new PatternBuilder().text("+RESP:GTOBD,").number("[0-9A-Z]{2}xxxx,").number("(d{15}|x{14}),").expression("(?:[0-9A-Z]{17})?,").expression("[^,]{0,20},").expression("[01],").number("x{1,8},").expression("(?:[0-9A-Z]{17})?,").number("[01],").number("(?:d{1,5})?,").number("(?:x{8})?,").number("(d{1,5})?,").number("(d{1,3})?,").number("(-?d{1,3})?,").number("(d+.?d*|Inf|NaN)?,").number("(d{1,5})?,").number("(?:d{1,5})?,").expression("([01])?,").number("(d{1,3})?,").number("(x*),").number("(d{1,3})?,").number("(?:d{1,3})?,").number("(d{1,3})?,").expression("(?:[0-9A],)?").number("(d+),").expression(PATTERN_LOCATION.pattern()).number("(d{1,7}.d)?,").number("(dddd)(dd)(dd)").number("(dd)(dd)(dd)").optional(2).text(",").number("(xxxx)").text("$").optional().compile();
    private static final Pattern PATTERN_FRI = new PatternBuilder().text("+").expression("(?:RESP|BUFF):GT...,").number("(?:[0-9A-Z]{2}xxxx)?,").number("(d{15}|x{14}),").expression("(?:([0-9A-Z]{17}),)?").expression("[^,]*,").number("(d+)?,").number("d{1,2},").optional().number("d{1,2},").optional().number(",").optional().number("(d+),").optional().expression("((?:").expression(PATTERN_LOCATION.pattern()).expression(")+)").groupBegin().number("(d{1,7}.d)?,").number("(d{5}:dd:dd)?,").number("(x+)?,").number("(x+)?,").number("(d{1,3})?,").number("(?:(xx)(xx)(xx))?,").number("(d+)?,").number("(?:d+.?d*|Inf|NaN)?,").number("(d+)?,").or().number("(d{1,7}.d)?,").optional().number("(d{1,3})?,").groupEnd().any().number("(dddd)(dd)(dd)").number("(dd)(dd)(dd)").optional(2).text(",").number("(xxxx)").text("$").optional().compile();
    private static final Pattern PATTERN_ERI = new PatternBuilder().text("+").expression("(?:RESP|BUFF):GTERI,").number("(?:[0-9A-Z]{2}xxxx)?,").number("(d{15}|x{14}),").expression("[^,]*,").number("(x{8}),").number("(d+)?,").number("d{1,2},").number("d{1,2},").expression("((?:").expression(PATTERN_LOCATION.pattern()).expression(")+)").number("(d{1,7}.d)?,").number("(d{5}:dd:dd)?,").number("(x+)?,").number("(x+)?,").optional().number("(d{1,3})?,").number("(?:(xx)(xx)(xx))?,").expression("(.*)").number("(dddd)(dd)(dd)").number("(dd)(dd)(dd)").optional(2).text(",").number("(xxxx)").text("$").optional().compile();
    private static final Pattern PATTERN_IGN = new PatternBuilder().text("+").expression("(?:RESP|BUFF):GTIG[NF],").number("(?:[0-9A-Z]{2}xxxx)?,").number("(d{15}|x{14}),").expression("[^,]*,").number("d+,").expression(PATTERN_LOCATION.pattern()).number("(d{5}:dd:dd)?,").number("(d{1,7}.d)?,").number("(dddd)(dd)(dd)").number("(dd)(dd)(dd)").optional(2).text(",").number("(xxxx)").text("$").optional().compile();
    private static final Pattern PATTERN_LSW = new PatternBuilder().text("+RESP:").expression("GT[LT]SW,").number("(?:[0-9A-Z]{2}xxxx)?,").number("(d{15}|x{14}),").expression("[^,]*,").number("[01],").number("([01]),").expression(PATTERN_LOCATION.pattern()).number("(dddd)(dd)(dd)").number("(dd)(dd)(dd)").optional(2).text(",").number("(xxxx)").text("$").optional().compile();
    private static final Pattern PATTERN_IDA = new PatternBuilder().text("+RESP:GTIDA,").number("(?:[0-9A-Z]{2}xxxx)?,").number("(d{15}|x{14}),").expression("[^,]*,,").number("([^,]+),").expression("[01],").number("1,").expression(PATTERN_LOCATION.pattern()).number("(d+.d),").text(",,,,").number("(dddd)(dd)(dd)").number("(dd)(dd)(dd)").optional(2).text(",").number("(xxxx)").text("$").optional().compile();
    private static final Pattern PATTERN_WIF = new PatternBuilder().text("+RESP:GTWIF,").number("(?:[0-9A-Z]{2}xxxx)?,").number("(d{15}|x{14}),").expression("[^,]*,").number("(d+),").number("((?:x{12},-?d+,,,,)+),,,,").number("(d{1,3}),").number("(dddd)(dd)(dd)").number("(dd)(dd)(dd)").optional(2).text(",").number("(xxxx)").text("$").optional().compile();
    private static final Pattern PATTERN_GSM = new PatternBuilder().text("+RESP:GTGSM,").number("(?:[0-9A-Z]{2}xxxx)?,").number("(d{15}|x{14}),").expression("(?:STR|CTN|NMR|RTL),").expression("(.*)").number("(dddd)(dd)(dd)").number("(dd)(dd)(dd)").optional(2).text(",").number("(xxxx)").text("$").optional().compile();
    private static final Pattern PATTERN_PNA = new PatternBuilder().text("+RESP:GT").expression("P[NF]A,").number("(?:[0-9A-Z]{2}xxxx)?,").number("(d{15}|x{14}),").expression("[^,]*,").number("(dddd)(dd)(dd)").number("(dd)(dd)(dd)").optional(2).text(",").number("(xxxx)").text("$").optional().compile();
    private static final Pattern PATTERN = new PatternBuilder().text("+").expression("(?:RESP|BUFF):GT...,").number("(?:[0-9A-Z]{2}xxxx)?,").number("(d{15}|x{14}),").expression("[^,]*,").number("d*,").number("(x{1,2}),").number("d{1,2},").expression(PATTERN_LOCATION.pattern()).groupBegin().number("(d{1,7}.d)?,").optional().number("(d{1,3})?,").or().number("(d{1,7}.d)?,").groupEnd().number("(dddd)(dd)(dd)").number("(dd)(dd)(dd)").text(",").number("(xxxx)").text("$").optional().compile();
    private static final Pattern PATTERN_BASIC = new PatternBuilder().text("+").expression("(?:RESP|BUFF)").text(":").expression("GT...,").number("(?:[0-9A-Z]{2}xxxx)?,").optional().number("(d{15}|x{14}),").any().number("(d{1,2})?,").number("(d{1,3}.d)?,").number("(d{1,3})?,").number("(-?d{1,5}.d)?,").number("(-?d{1,3}.d{6})?,").number("(-?d{1,2}.d{6})?,").number("(dddd)(dd)(dd)").number("(dd)(dd)(dd)").optional(2).text(",").number("(d+),").number("(d+),").number("(x+),").number("(x+),").optional(4).any().number("(dddd)(dd)(dd)").number("(dd)(dd)(dd)").optional(2).text(",").number("(xxxx)").text("$").optional().compile();

    public Gl200TextProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private Object decodeAck(Channel channel, SocketAddress remoteAddress, String sentence, String type) {
        Parser parser = new Parser(PATTERN_ACK, sentence);
        if (parser.matches()) {
            String protocolVersion = parser.next();
            DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
            if (deviceSession == null) {
                return null;
            }
            if (type.equals("HBD")) {
                if (channel != null) {
                    parser.skip(6);
                    channel.writeAndFlush((Object)new NetworkMessage("+SACK:GTHBD," + protocolVersion + "," + parser.next() + "$", remoteAddress));
                }
            } else {
                Position position = new Position(this.getProtocolName());
                position.setDeviceId(deviceSession.getDeviceId());
                this.getLastLocation(position, parser.nextDateTime());
                position.setValid(false);
                position.set("result", "Command " + type + " accepted");
                return position;
            }
        }
        return null;
    }

    private Position initPosition(Parser parser, Channel channel, SocketAddress remoteAddress) {
        DeviceSession deviceSession;
        if (parser.matches() && (deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next())) != null) {
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            return position;
        }
        return null;
    }

    private void decodeDeviceTime(Position position, Parser parser) {
        if (parser.hasNext(6)) {
            if (this.ignoreFixTime) {
                position.setTime(parser.nextDateTime());
            } else {
                position.setDeviceTime(parser.nextDateTime());
            }
        }
    }

    private Long parseHours(String hoursString) {
        if (hoursString != null) {
            String[] hours = hoursString.split(":");
            return (long)(Integer.parseInt(hours[0]) * 3600 + (hours.length > 1 ? Integer.parseInt(hours[1]) * 60 : 0) + (hours.length > 2 ? Integer.parseInt(hours[2]) : 0)) * 1000L;
        }
        return null;
    }

    private Object decodeInf(Channel channel, SocketAddress remoteAddress, String sentence) {
        Parser parser = new Parser(PATTERN_INF, sentence);
        Position position = this.initPosition(parser, channel, remoteAddress);
        if (position == null) {
            return null;
        }
        switch (parser.nextHexInt()) {
            case 18: 
            case 22: 
            case 26: {
                position.set("ignition", false);
                position.set("motion", true);
                break;
            }
            case 17: {
                position.set("ignition", false);
                position.set("motion", false);
                break;
            }
            case 33: {
                position.set("ignition", true);
                position.set("motion", false);
                break;
            }
            case 34: {
                position.set("ignition", true);
                position.set("motion", true);
                break;
            }
            case 65: {
                position.set("motion", false);
                break;
            }
            case 66: {
                position.set("motion", true);
                break;
            }
        }
        position.set("rssi", parser.nextInt());
        parser.next();
        position.set("battery", parser.nextDouble());
        position.set("charge", parser.nextInt() == 1);
        position.set("batteryLevel", parser.nextInt());
        position.set("temp1", parser.next());
        position.set("adc1", parser.next());
        position.set("adc2", parser.next());
        position.set("input", parser.next());
        position.set("output", parser.next());
        this.getLastLocation(position, parser.nextDateTime());
        position.set("index", parser.nextHexInt());
        return position;
    }

    private Object decodeVer(Channel channel, SocketAddress remoteAddress, String sentence) {
        Parser parser = new Parser(PATTERN_VER, sentence);
        Position position = this.initPosition(parser, channel, remoteAddress);
        if (position == null) {
            return null;
        }
        position.set("deviceType", parser.next());
        position.set("versionFw", parser.nextHexInt());
        position.set("versionHw", parser.nextHexInt());
        this.getLastLocation(position, parser.nextDateTime());
        return position;
    }

    private void skipLocation(Parser parser) {
        parser.skip(19);
    }

    private void decodeLocation(Position position, Parser parser) {
        Integer hdop = parser.nextInt();
        position.setValid(hdop == null || hdop > 0);
        position.set("hdop", hdop);
        position.setSpeed(UnitsConverter.knotsFromKph(parser.nextDouble(0.0)));
        position.setCourse(parser.nextDouble(0.0));
        position.setAltitude(parser.nextDouble(0.0));
        if (parser.hasNext(8)) {
            position.setValid(true);
            position.setLongitude(parser.nextDouble());
            position.setLatitude(parser.nextDouble());
            position.setTime(parser.nextDateTime());
        } else {
            this.getLastLocation(position, null);
        }
        if (parser.hasNext(6)) {
            int mcc = parser.nextInt();
            int mnc = parser.nextInt();
            if (parser.hasNext(2)) {
                position.setNetwork(new Network(CellTower.from(mcc, mnc, parser.nextInt(), parser.nextInt().intValue())));
            }
            if (parser.hasNext(2)) {
                position.setNetwork(new Network(CellTower.from(mcc, mnc, parser.nextHexInt(), parser.nextHexInt().intValue())));
            }
        }
        if (parser.hasNext()) {
            position.set("odometer", parser.nextDouble() * 1000.0);
        }
    }

    private Object decodeObd(Channel channel, SocketAddress remoteAddress, String sentence) {
        Parser parser = new Parser(PATTERN_OBD, sentence);
        Position position = this.initPosition(parser, channel, remoteAddress);
        if (position == null) {
            return null;
        }
        position.set("rpm", parser.nextInt());
        position.set("obdSpeed", parser.nextInt());
        position.set("temp1", parser.nextInt());
        position.set("fuelConsumption", parser.next());
        position.set("dtcsClearedDistance", parser.nextInt());
        if (parser.hasNext()) {
            position.set("odbConnect", parser.nextInt() == 1);
        }
        position.set("dtcsNumber", parser.nextInt());
        position.set("dtcsCodes", parser.next());
        position.set("throttle", parser.nextInt());
        position.set("fuel", parser.nextInt());
        if (parser.hasNext()) {
            position.set("obdOdometer", parser.nextInt() * 1000);
        }
        this.decodeLocation(position, parser);
        if (parser.hasNext()) {
            position.set("obdOdometer", (int)(parser.nextDouble() * 1000.0));
        }
        this.decodeDeviceTime(position, parser);
        return position;
    }

    private Object decodeCan(Channel channel, SocketAddress remoteAddress, String sentence) throws ParseException {
        Position position = new Position(this.getProtocolName());
        int index = 0;
        String[] values = sentence.split(",");
        ++index;
        String[] stringArray = new String[1];
        int n = ++index;
        ++index;
        stringArray[0] = values[n];
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, stringArray);
        position.setDeviceId(deviceSession.getDeviceId());
        ++index;
        ++index;
        int n2 = ++index;
        ++index;
        long reportMask = Long.parseLong(values[n2], 16);
        long reportMaskExt = 0L;
        if (BitUtil.check(reportMask, 0)) {
            position.set("vin", values[index++]);
        }
        if (BitUtil.check(reportMask, 1)) {
            position.set("ignition", Integer.parseInt(values[index++]) > 0);
        }
        if (BitUtil.check(reportMask, 2)) {
            position.set("obdOdometer", values[index++]);
        }
        if (BitUtil.check(reportMask, 3) && !values[index++].isEmpty()) {
            position.set("fuelUsed", Double.parseDouble(values[index - 1]));
        }
        if (BitUtil.check(reportMask, 5) && !values[index++].isEmpty()) {
            position.set("rpm", Integer.parseInt(values[index - 1]));
        }
        if (BitUtil.check(reportMask, 4) && !values[index++].isEmpty()) {
            position.set("obdSpeed", UnitsConverter.knotsFromKph(Integer.parseInt(values[index - 1])));
        }
        if (BitUtil.check(reportMask, 6) && !values[index++].isEmpty()) {
            position.set("coolantTemp", Integer.parseInt(values[index - 1]));
        }
        if (BitUtil.check(reportMask, 7) && !values[index++].isEmpty()) {
            position.set("fuelConsumption", Double.parseDouble(values[index - 1].substring(1)));
        }
        if (BitUtil.check(reportMask, 8) && !values[index++].isEmpty()) {
            position.set("fuel", Double.parseDouble(values[index - 1].substring(1)));
        }
        if (BitUtil.check(reportMask, 9) && !values[index++].isEmpty()) {
            position.set("range", Long.parseLong(values[index - 1]) * 100L);
        }
        if (BitUtil.check(reportMask, 10) && !values[index++].isEmpty()) {
            position.set("throttle", Integer.parseInt(values[index - 1]));
        }
        if (BitUtil.check(reportMask, 11) && !values[index++].isEmpty()) {
            position.set("hours", UnitsConverter.msFromHours(Double.parseDouble(values[index - 1])));
        }
        if (BitUtil.check(reportMask, 12)) {
            position.set("drivingHours", Double.parseDouble(values[index++]));
        }
        if (BitUtil.check(reportMask, 13)) {
            position.set("idleHours", Double.parseDouble(values[index++]));
        }
        if (BitUtil.check(reportMask, 14) && !values[index++].isEmpty()) {
            position.set("idleFuelConsumption", Double.parseDouble(values[index - 1]));
        }
        if (BitUtil.check(reportMask, 15) && !values[index++].isEmpty()) {
            position.set("axleWeight", Integer.parseInt(values[index - 1]));
        }
        if (BitUtil.check(reportMask, 16) && !values[index++].isEmpty()) {
            position.set("tachographInfo", Integer.parseInt(values[index - 1], 16));
        }
        if (BitUtil.check(reportMask, 17) && !values[index++].isEmpty()) {
            position.set("indicators", Integer.parseInt(values[index - 1], 16));
        }
        if (BitUtil.check(reportMask, 18) && !values[index++].isEmpty()) {
            position.set("lights", Integer.parseInt(values[index - 1], 16));
        }
        if (BitUtil.check(reportMask, 19) && !values[index++].isEmpty()) {
            position.set("doors", Integer.parseInt(values[index - 1], 16));
        }
        if (BitUtil.check(reportMask, 20) && !values[index++].isEmpty()) {
            position.set("vehicleOverspeed", Double.parseDouble(values[index - 1]));
        }
        if (BitUtil.check(reportMask, 21) && !values[index++].isEmpty()) {
            position.set("engineOverspeed", Double.parseDouble(values[index - 1]));
        }
        if (BitUtil.check(reportMask, 29)) {
            reportMaskExt = Long.parseLong(values[index++], 16);
        }
        if (BitUtil.check(reportMaskExt, 0) && !values[index++].isEmpty()) {
            position.set("adBlueLevel", Integer.parseInt(values[index - 1]));
        }
        if (BitUtil.check(reportMaskExt, 1) && !values[index++].isEmpty()) {
            position.set("axleWeight1", Integer.parseInt(values[index - 1]));
        }
        if (BitUtil.check(reportMaskExt, 2) && !values[index++].isEmpty()) {
            position.set("axleWeight3", Integer.parseInt(values[index - 1]));
        }
        if (BitUtil.check(reportMaskExt, 3) && !values[index++].isEmpty()) {
            position.set("axleWeight4", Integer.parseInt(values[index - 1]));
        }
        if (BitUtil.check(reportMaskExt, 4)) {
            ++index;
        }
        if (BitUtil.check(reportMaskExt, 5)) {
            ++index;
        }
        if (BitUtil.check(reportMaskExt, 6)) {
            ++index;
        }
        if (BitUtil.check(reportMaskExt, 7) && !values[index++].isEmpty()) {
            position.set("adc1", (double)Integer.parseInt(values[index - 1]) * 0.001);
        }
        if (BitUtil.check(reportMaskExt, 8)) {
            ++index;
        }
        if (BitUtil.check(reportMaskExt, 9)) {
            ++index;
        }
        if (BitUtil.check(reportMaskExt, 10)) {
            ++index;
        }
        if (BitUtil.check(reportMaskExt, 11)) {
            ++index;
        }
        if (BitUtil.check(reportMaskExt, 12)) {
            ++index;
        }
        if (BitUtil.check(reportMaskExt, 13)) {
            ++index;
        }
        if (BitUtil.check(reportMaskExt, 14)) {
            ++index;
        }
        if (BitUtil.check(reportMaskExt, 15) && !values[index++].isEmpty()) {
            position.set("driver1Card", values[index - 1]);
        }
        if (BitUtil.check(reportMaskExt, 16) && !values[index++].isEmpty()) {
            position.set("driver2Card", values[index - 1]);
        }
        if (BitUtil.check(reportMaskExt, 17) && !values[index++].isEmpty()) {
            position.set("driver1Name", values[index - 1]);
        }
        if (BitUtil.check(reportMaskExt, 18) && !values[index++].isEmpty()) {
            position.set("driver2Name", values[index - 1]);
        }
        if (BitUtil.check(reportMaskExt, 19) && !values[index++].isEmpty()) {
            position.set("registration", values[index - 1]);
        }
        if (BitUtil.check(reportMaskExt, 20)) {
            ++index;
        }
        if (BitUtil.check(reportMaskExt, 21)) {
            ++index;
        }
        if (BitUtil.check(reportMaskExt, 22)) {
            ++index;
        }
        if (BitUtil.check(reportMaskExt, 23)) {
            ++index;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        if (BitUtil.check(reportMask, 30)) {
            while (values[index].isEmpty()) {
                ++index;
            }
            position.setValid(Integer.parseInt(values[index++]) > 0);
            if (!values[index].isEmpty()) {
                position.setSpeed(UnitsConverter.knotsFromKph(Double.parseDouble(values[index++])));
                position.setCourse(Integer.parseInt(values[index++]));
                position.setAltitude(Double.parseDouble(values[index++]));
                position.setLongitude(Double.parseDouble(values[index++]));
                position.setLatitude(Double.parseDouble(values[index++]));
                position.setTime(dateFormat.parse(values[index++]));
            } else {
                index += 6;
                this.getLastLocation(position, null);
            }
        } else {
            this.getLastLocation(position, null);
        }
        if (BitUtil.check(reportMask, 31)) {
            index += 4;
            ++index;
        }
        if (this.ignoreFixTime) {
            position.setTime(dateFormat.parse(values[index]));
        } else {
            position.setDeviceTime(dateFormat.parse(values[index]));
        }
        return position;
    }

    private void decodeStatus(Position position, Parser parser) {
        if (parser.hasNext(3)) {
            int ignition = parser.nextHexInt();
            if (BitUtil.check(ignition, 4)) {
                position.set("ignition", false);
            } else if (BitUtil.check(ignition, 5)) {
                position.set("ignition", true);
            }
            position.set("input", parser.nextHexInt());
            position.set("output", parser.nextHexInt());
        }
    }

    private Object decodeFri(Channel channel, SocketAddress remoteAddress, String sentence) {
        Position position;
        Parser parser = new Parser(PATTERN_FRI, sentence);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        LinkedList<Position> positions = new LinkedList<Position>();
        String vin = parser.next();
        Integer power = parser.nextInt();
        Integer battery = parser.nextInt();
        Parser itemParser = new Parser(PATTERN_LOCATION, parser.next());
        while (itemParser.find()) {
            position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            position.set("vin", vin);
            this.decodeLocation(position, itemParser);
            positions.add(position);
        }
        position = (Position)positions.getLast();
        this.skipLocation(parser);
        if (power != null && power > 10) {
            position.set("power", (double)power.intValue() * 0.001);
        }
        if (battery != null) {
            position.set("batteryLevel", battery);
        }
        if (parser.hasNext()) {
            position.set("odometer", parser.nextDouble() * 1000.0);
        }
        position.set("hours", this.parseHours(parser.next()));
        position.set("adc1", parser.next());
        position.set("adc2", parser.next());
        position.set("batteryLevel", parser.nextInt());
        this.decodeStatus(position, parser);
        position.set("rpm", parser.nextInt());
        position.set("fuel", parser.nextInt());
        if (parser.hasNext()) {
            position.set("odometer", parser.nextDouble() * 1000.0);
        }
        position.set("batteryLevel", parser.nextInt());
        this.decodeDeviceTime(position, parser);
        if (this.ignoreFixTime) {
            positions.clear();
            positions.add(position);
        }
        return positions;
    }

    private Object decodeEri(Channel channel, SocketAddress remoteAddress, String sentence) {
        int i;
        int deviceCount;
        Position position;
        Parser parser = new Parser(PATTERN_ERI, sentence);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        long mask = parser.nextHexLong();
        LinkedList<Position> positions = new LinkedList<Position>();
        Integer power = parser.nextInt();
        Parser itemParser = new Parser(PATTERN_LOCATION, parser.next());
        while (itemParser.find()) {
            position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            this.decodeLocation(position, itemParser);
            positions.add(position);
        }
        position = (Position)positions.getLast();
        this.skipLocation(parser);
        if (power != null) {
            position.set("power", (double)power.intValue() * 0.001);
        }
        position.set("odometer", parser.nextDouble() * 1000.0);
        position.set("hours", this.parseHours(parser.next()));
        position.set("adc1", parser.next());
        position.set("adc2", parser.next());
        position.set("batteryLevel", parser.nextInt());
        this.decodeStatus(position, parser);
        int index = 0;
        String[] data = parser.next().split(",");
        ++index;
        if (BitUtil.check(mask, 0)) {
            ++index;
        }
        if (BitUtil.check(mask, 1)) {
            deviceCount = Integer.parseInt(data[index++]);
            for (i = 1; i <= deviceCount; ++i) {
                ++index;
                int n = ++index;
                ++index;
                if (data[n].isEmpty()) continue;
                position.set("temp" + i, (double)((short)Integer.parseInt(data[index - 1], 16)) * 0.0625);
            }
        }
        if (BitUtil.check(mask, 2)) {
            ++index;
        }
        if (BitUtil.check(mask, 3) || BitUtil.check(mask, 4)) {
            deviceCount = Integer.parseInt(data[index++]);
            for (i = 1; i <= deviceCount; ++i) {
                ++index;
                if (BitUtil.check(mask, 3)) {
                    position.set("fuel", Double.parseDouble(data[index++]));
                }
                if (!BitUtil.check(mask, 4)) continue;
                ++index;
            }
        }
        this.decodeDeviceTime(position, parser);
        if (this.ignoreFixTime) {
            positions.clear();
            positions.add(position);
        }
        return positions;
    }

    private Object decodeIgn(Channel channel, SocketAddress remoteAddress, String sentence) {
        Parser parser = new Parser(PATTERN_IGN, sentence);
        Position position = this.initPosition(parser, channel, remoteAddress);
        if (position == null) {
            return null;
        }
        this.decodeLocation(position, parser);
        position.set("ignition", sentence.contains("IGN"));
        position.set("hours", this.parseHours(parser.next()));
        position.set("odometer", parser.nextDouble() * 1000.0);
        this.decodeDeviceTime(position, parser);
        return position;
    }

    private Object decodeLsw(Channel channel, SocketAddress remoteAddress, String sentence) {
        Parser parser = new Parser(PATTERN_LSW, sentence);
        Position position = this.initPosition(parser, channel, remoteAddress);
        if (position == null) {
            return null;
        }
        position.set("in" + (sentence.contains("LSW") ? 1 : 2), parser.nextInt() == 1);
        this.decodeLocation(position, parser);
        this.decodeDeviceTime(position, parser);
        return position;
    }

    private Object decodeIda(Channel channel, SocketAddress remoteAddress, String sentence) {
        Parser parser = new Parser(PATTERN_IDA, sentence);
        Position position = this.initPosition(parser, channel, remoteAddress);
        if (position == null) {
            return null;
        }
        position.set("driverUniqueId", parser.next());
        this.decodeLocation(position, parser);
        position.set("odometer", parser.nextDouble() * 1000.0);
        this.decodeDeviceTime(position, parser);
        return position;
    }

    private Object decodeWif(Channel channel, SocketAddress remoteAddress, String sentence) {
        Parser parser = new Parser(PATTERN_WIF, sentence);
        Position position = this.initPosition(parser, channel, remoteAddress);
        if (position == null) {
            return null;
        }
        this.getLastLocation(position, null);
        Network network = new Network();
        parser.nextInt();
        Matcher matcher = Pattern.compile("([0-9a-fA-F]{12}),(-?\\d+),,,,").matcher(parser.next());
        while (matcher.find()) {
            String mac = matcher.group(1).replaceAll("(..)", "$1:");
            network.addWifiAccessPoint(WifiAccessPoint.from(mac.substring(0, mac.length() - 1), Integer.parseInt(matcher.group(2))));
        }
        position.setNetwork(network);
        position.set("batteryLevel", parser.nextInt());
        return position;
    }

    private Object decodeGsm(Channel channel, SocketAddress remoteAddress, String sentence) {
        Parser parser = new Parser(PATTERN_GSM, sentence);
        Position position = this.initPosition(parser, channel, remoteAddress);
        if (position == null) {
            return null;
        }
        this.getLastLocation(position, null);
        Network network = new Network();
        String[] data = parser.next().split(",");
        for (int i = 0; i < 6; ++i) {
            if (data[i * 6].isEmpty()) continue;
            network.addCellTower(CellTower.from(Integer.parseInt(data[i * 6]), Integer.parseInt(data[i * 6 + 1]), Integer.parseInt(data[i * 6 + 2], 16), Integer.parseInt(data[i * 6 + 3], 16), Integer.parseInt(data[i * 6 + 4])));
        }
        position.setNetwork(network);
        return position;
    }

    private Object decodePna(Channel channel, SocketAddress remoteAddress, String sentence) {
        Parser parser = new Parser(PATTERN_PNA, sentence);
        Position position = this.initPosition(parser, channel, remoteAddress);
        if (position == null) {
            return null;
        }
        this.getLastLocation(position, null);
        position.set("alarm", sentence.contains("PNA") ? "powerOn" : "powerOff");
        return position;
    }

    private Object decodeOther(Channel channel, SocketAddress remoteAddress, String sentence, String type) {
        Parser parser = new Parser(PATTERN, sentence);
        Position position = this.initPosition(parser, channel, remoteAddress);
        if (position == null) {
            return null;
        }
        int reportType = parser.nextHexInt();
        if (type.equals("NMR")) {
            position.set("motion", reportType == 1);
        } else if (type.equals("SOS")) {
            position.set("alarm", "sos");
        } else if (type.equals("DIS")) {
            position.set("in" + reportType / 16, reportType % 16 == 1);
        } else if (type.equals("IGL")) {
            position.set("ignition", reportType % 16 == 1);
        }
        this.decodeLocation(position, parser);
        if (parser.hasNext()) {
            position.set("odometer", parser.nextDouble() * 1000.0);
        }
        position.set("batteryLevel", parser.nextInt());
        if (parser.hasNext()) {
            position.set("odometer", parser.nextDouble() * 1000.0);
        }
        this.decodeDeviceTime(position, parser);
        if (Context.getConfig().getBoolean(this.getProtocolName() + ".ack") && channel != null) {
            channel.writeAndFlush((Object)new NetworkMessage("+SACK:" + parser.next() + "$", remoteAddress));
        }
        return position;
    }

    private Object decodeBasic(Channel channel, SocketAddress remoteAddress, String sentence, String type) {
        Parser parser = new Parser(PATTERN_BASIC, sentence);
        Position position = this.initPosition(parser, channel, remoteAddress);
        if (position == null) {
            return null;
        }
        if (parser.hasNext()) {
            int hdop = parser.nextInt();
            position.setValid(hdop > 0);
            position.set("hdop", hdop);
        }
        position.setSpeed(UnitsConverter.knotsFromKph(parser.nextDouble(0.0)));
        position.setCourse(parser.nextDouble(0.0));
        position.setAltitude(parser.nextDouble(0.0));
        if (parser.hasNext(2)) {
            position.setLongitude(parser.nextDouble());
            position.setLatitude(parser.nextDouble());
        } else {
            this.getLastLocation(position, null);
        }
        if (parser.hasNext(6)) {
            position.setTime(parser.nextDateTime());
        }
        if (parser.hasNext(4)) {
            position.setNetwork(new Network(CellTower.from(parser.nextInt(), parser.nextInt(), parser.nextHexInt(), parser.nextHexInt().intValue())));
        }
        this.decodeDeviceTime(position, parser);
        switch (type) {
            case "TOW": {
                position.set("alarm", "tow");
                break;
            }
            case "IDL": {
                position.set("alarm", "idle");
                break;
            }
            case "PNA": {
                position.set("alarm", "powerOn");
                break;
            }
            case "PFA": {
                position.set("alarm", "powerOff");
                break;
            }
            case "EPN": 
            case "MPN": {
                position.set("alarm", "powerRestored");
                break;
            }
            case "EPF": 
            case "MPF": {
                position.set("alarm", "powerCut");
                break;
            }
            case "BPL": {
                position.set("alarm", "lowBattery");
                break;
            }
            case "STT": {
                position.set("alarm", "movement");
                break;
            }
            case "SWG": {
                position.set("alarm", "geofence");
                break;
            }
            case "TMP": 
            case "TEM": {
                position.set("alarm", "temperature");
                break;
            }
            case "JDR": 
            case "JDS": {
                position.set("alarm", "jamming");
                break;
            }
        }
        return position;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        Object result;
        String sentence = ((ByteBuf)msg).toString(StandardCharsets.US_ASCII);
        int typeIndex = sentence.indexOf(":GT");
        if (typeIndex < 0) {
            return null;
        }
        String type = sentence.substring(typeIndex + 3, typeIndex + 6);
        if (sentence.startsWith("+ACK")) {
            result = this.decodeAck(channel, remoteAddress, sentence, type);
        } else {
            switch (type) {
                case "INF": {
                    result = this.decodeInf(channel, remoteAddress, sentence);
                    break;
                }
                case "OBD": {
                    result = this.decodeObd(channel, remoteAddress, sentence);
                    break;
                }
                case "CAN": {
                    result = this.decodeCan(channel, remoteAddress, sentence);
                    break;
                }
                case "FRI": 
                case "GEO": 
                case "STR": {
                    result = this.decodeFri(channel, remoteAddress, sentence);
                    break;
                }
                case "ERI": {
                    result = this.decodeEri(channel, remoteAddress, sentence);
                    break;
                }
                case "IGN": 
                case "IGF": {
                    result = this.decodeIgn(channel, remoteAddress, sentence);
                    break;
                }
                case "LSW": 
                case "TSW": {
                    result = this.decodeLsw(channel, remoteAddress, sentence);
                    break;
                }
                case "IDA": {
                    result = this.decodeIda(channel, remoteAddress, sentence);
                    break;
                }
                case "WIF": {
                    result = this.decodeWif(channel, remoteAddress, sentence);
                    break;
                }
                case "GSM": {
                    result = this.decodeGsm(channel, remoteAddress, sentence);
                    break;
                }
                case "VER": {
                    result = this.decodeVer(channel, remoteAddress, sentence);
                    break;
                }
                case "PNA": 
                case "PFA": {
                    result = this.decodePna(channel, remoteAddress, sentence);
                    break;
                }
                default: {
                    result = this.decodeOther(channel, remoteAddress, sentence, type);
                }
            }
            if (result == null) {
                result = this.decodeBasic(channel, remoteAddress, sentence, type);
            }
            if (result != null) {
                if (result instanceof Position) {
                    ((Position)result).set("type", type);
                } else {
                    for (Position p : (List)result) {
                        p.set("type", type);
                    }
                }
            }
        }
        return result;
    }
}

