/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.compat;

import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import java.util.concurrent.Executor;
import java.util.zip.GZIPOutputStream;
import org.apache.tomcat.util.compat.JreCompat;

class Jre7Compat
extends JreCompat {
    private static final int RUNTIME_MAJOR_VERSION = 7;
    private static final Method forLanguageTagMethod;
    private static final Constructor<GZIPOutputStream> gzipOutputStreamConstructor;
    private static final Method callableStatementGetObjectIndex;
    private static final Method callableStatementGetObjectName;
    private static final Method connectionSetSchema;
    private static final Method connectionGetSchema;
    private static final Method connectionAbort;
    private static final Method connectionSetNetworkTimeout;
    private static final Method connectionGetNetworkTimeout;
    private static final Method databaseMetaDataGetPseudoColumns;
    private static final Method databaseMetaDataGeneratedKeyAlwaysReturned;
    private static final Method resultSetGetObjectIndex;
    private static final Method resultSetGetObjectName;
    private static final Method statementCloseOnCompletion;
    private static final Method statementIsCloseOnCompletion;

    Jre7Compat() {
    }

    static boolean isSupported() {
        return forLanguageTagMethod != null;
    }

    @Override
    public Locale forLanguageTag(String languageTag) {
        try {
            return (Locale)forLanguageTagMethod.invoke(null, languageTag);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
    }

    @Override
    public GZIPOutputStream getFlushableGZipOutputStream(OutputStream os) {
        try {
            return gzipOutputStreamConstructor.newInstance(os, Boolean.TRUE);
        }
        catch (InstantiationException e) {
            throw new UnsupportedOperationException(e);
        }
        catch (IllegalAccessException e) {
            throw new UnsupportedOperationException(e);
        }
        catch (IllegalArgumentException e) {
            throw new UnsupportedOperationException(e);
        }
        catch (InvocationTargetException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public <T> T getObject(CallableStatement callableStatement, int parameterIndex, Class<T> type) throws SQLException {
        try {
            return (T)callableStatementGetObjectIndex.invoke((Object)callableStatement, parameterIndex, type);
        }
        catch (IllegalArgumentException e) {
            throw new SQLException(e);
        }
        catch (IllegalAccessException e) {
            throw new SQLException(e);
        }
        catch (InvocationTargetException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public <T> T getObject(CallableStatement callableStatement, String parameterName, Class<T> type) throws SQLException {
        try {
            return (T)callableStatementGetObjectName.invoke((Object)callableStatement, parameterName, type);
        }
        catch (IllegalArgumentException e) {
            throw new SQLException(e);
        }
        catch (IllegalAccessException e) {
            throw new SQLException(e);
        }
        catch (InvocationTargetException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void setSchema(Connection connection, String schema) throws SQLException {
        try {
            connectionSetSchema.invoke((Object)connection, schema);
        }
        catch (IllegalArgumentException e) {
            throw new SQLException(e);
        }
        catch (IllegalAccessException e) {
            throw new SQLException(e);
        }
        catch (InvocationTargetException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public String getSchema(Connection connection) throws SQLException {
        try {
            return (String)connectionGetSchema.invoke((Object)connection, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new SQLException(e);
        }
        catch (IllegalAccessException e) {
            throw new SQLException(e);
        }
        catch (InvocationTargetException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void abort(Connection connection, Executor executor) throws SQLException {
        try {
            connectionAbort.invoke((Object)connection, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new SQLException(e);
        }
        catch (IllegalAccessException e) {
            throw new SQLException(e);
        }
        catch (InvocationTargetException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void setNetworkTimeout(Connection connection, Executor executor, int milliseconds) throws SQLException {
        try {
            connectionSetNetworkTimeout.invoke((Object)connection, executor, milliseconds);
        }
        catch (IllegalArgumentException e) {
            throw new SQLException(e);
        }
        catch (IllegalAccessException e) {
            throw new SQLException(e);
        }
        catch (InvocationTargetException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public int getNetworkTimeout(Connection connection) throws SQLException {
        try {
            return (Integer)connectionGetNetworkTimeout.invoke((Object)connection, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new SQLException(e);
        }
        catch (IllegalAccessException e) {
            throw new SQLException(e);
        }
        catch (InvocationTargetException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public ResultSet getPseudoColumns(DatabaseMetaData databaseMetaData, String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        try {
            return (ResultSet)databaseMetaDataGetPseudoColumns.invoke((Object)databaseMetaData, catalog, schemaPattern, tableNamePattern, columnNamePattern);
        }
        catch (IllegalArgumentException e) {
            throw new SQLException(e);
        }
        catch (IllegalAccessException e) {
            throw new SQLException(e);
        }
        catch (InvocationTargetException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public boolean generatedKeyAlwaysReturned(DatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return (Boolean)databaseMetaDataGeneratedKeyAlwaysReturned.invoke((Object)databaseMetaData, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new SQLException(e);
        }
        catch (IllegalAccessException e) {
            throw new SQLException(e);
        }
        catch (InvocationTargetException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public <T> T getObject(ResultSet resultSet, int parameterIndex, Class<T> type) throws SQLException {
        try {
            return (T)resultSetGetObjectIndex.invoke((Object)resultSet, parameterIndex, type);
        }
        catch (IllegalArgumentException e) {
            throw new SQLException(e);
        }
        catch (IllegalAccessException e) {
            throw new SQLException(e);
        }
        catch (InvocationTargetException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public <T> T getObject(ResultSet resultSet, String parameterName, Class<T> type) throws SQLException {
        try {
            return (T)resultSetGetObjectName.invoke((Object)resultSet, parameterName, type);
        }
        catch (IllegalArgumentException e) {
            throw new SQLException(e);
        }
        catch (IllegalAccessException e) {
            throw new SQLException(e);
        }
        catch (InvocationTargetException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void closeOnCompletion(Statement statement) throws SQLException {
        try {
            statementCloseOnCompletion.invoke((Object)statement, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new SQLException(e);
        }
        catch (IllegalAccessException e) {
            throw new SQLException(e);
        }
        catch (InvocationTargetException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public boolean isCloseOnCompletion(Statement statement) throws SQLException {
        try {
            return (Boolean)statementIsCloseOnCompletion.invoke((Object)statement, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new SQLException(e);
        }
        catch (IllegalAccessException e) {
            throw new SQLException(e);
        }
        catch (InvocationTargetException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public int jarFileRuntimeMajorVersion() {
        return 7;
    }

    @Override
    public boolean isCommonsAnnotations1_1Available() {
        return true;
    }

    static {
        Method m1 = null;
        Method m2 = null;
        Method m3 = null;
        Method m4 = null;
        Method m5 = null;
        Method m6 = null;
        Method m7 = null;
        Method m8 = null;
        Method m9 = null;
        Method m10 = null;
        Method m11 = null;
        Method m12 = null;
        Method m13 = null;
        Method m14 = null;
        Constructor c = null;
        try {
            m1 = Locale.class.getMethod("forLanguageTag", String.class);
            c = GZIPOutputStream.class.getConstructor(OutputStream.class, Boolean.TYPE);
            m2 = CallableStatement.class.getMethod("getObject", Integer.TYPE, Class.class);
            m3 = CallableStatement.class.getMethod("getObject", String.class, Class.class);
            m4 = Connection.class.getMethod("setSchema", String.class);
            m5 = Connection.class.getMethod("getSchema", new Class[0]);
            m6 = Connection.class.getMethod("abort", Executor.class);
            m7 = Connection.class.getMethod("setNetworkTimeout", Executor.class, Integer.TYPE);
            m8 = Connection.class.getMethod("getNetworkTimeout", new Class[0]);
            m9 = DatabaseMetaData.class.getMethod("getPseudoColumns", new Class[0]);
            m10 = DatabaseMetaData.class.getMethod("generatedKeyAlwaysReturned", new Class[0]);
            m11 = ResultSet.class.getMethod("getObject", Integer.TYPE, Class.class);
            m12 = ResultSet.class.getMethod("getObject", String.class, Class.class);
            m13 = Statement.class.getMethod("closeOnCompletion", new Class[0]);
            m14 = Statement.class.getMethod("isCloseOnCompletion", new Class[0]);
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        forLanguageTagMethod = m1;
        gzipOutputStreamConstructor = c;
        callableStatementGetObjectIndex = m2;
        callableStatementGetObjectName = m3;
        connectionSetSchema = m4;
        connectionGetSchema = m5;
        connectionAbort = m6;
        connectionSetNetworkTimeout = m7;
        connectionGetNetworkTimeout = m8;
        databaseMetaDataGetPseudoColumns = m9;
        databaseMetaDataGeneratedKeyAlwaysReturned = m10;
        resultSetGetObjectIndex = m11;
        resultSetGetObjectName = m12;
        statementCloseOnCompletion = m13;
        statementIsCloseOnCompletion = m14;
    }
}

