/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.cloud.autoscaling;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.util.Base64;
import org.apache.solr.common.util.Utils;
import org.apache.zookeeper.CreateMode;

public class VersionedData
implements MapWriter {
    private final int version;
    private final byte[] data;
    private final String owner;
    private final CreateMode mode;

    public VersionedData(int version, byte[] data, CreateMode mode, String owner) {
        this.version = version;
        this.data = data;
        this.mode = mode;
        this.owner = owner;
    }

    public int getVersion() {
        return this.version;
    }

    public byte[] getData() {
        return this.data;
    }

    public CreateMode getMode() {
        return this.mode;
    }

    public String getOwner() {
        return this.owner;
    }

    @Override
    public void writeMap(MapWriter.EntryWriter ew) throws IOException {
        ew.put((CharSequence)"version", this.version);
        if (this.owner != null) {
            ew.put((CharSequence)"owner", this.owner);
        }
        ew.put((CharSequence)"mode", this.mode.toString());
        if (this.data != null) {
            ew.put((CharSequence)"data", Base64.byteArrayToBase64(this.data));
        }
    }

    public String toString() {
        return Utils.toJSONString(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionedData that = (VersionedData)o;
        return this.version == that.version && Arrays.equals(this.data, that.data) && Objects.equals(this.owner, that.owner) && this.mode == that.mode;
    }
}

