/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import com.google.common.annotations.VisibleForTesting;
import java.awt.Color;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.imageio.ImageIO;
import org.apache.solr.api.Api;
import org.apache.solr.api.ApiBag;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.cloud.NodeStateProvider;
import org.apache.solr.client.solrj.cloud.SolrCloudManager;
import org.apache.solr.client.solrj.cloud.autoscaling.Variable;
import org.apache.solr.client.solrj.cloud.autoscaling.VersionedData;
import org.apache.solr.cloud.LeaderElector;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.Base64;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.JavaBinCodec;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.Pair;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.TimeSource;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.admin.MetricsHandler;
import org.apache.solr.metrics.SolrMetricManager;
import org.apache.solr.metrics.rrd.SolrRrdBackendFactory;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.solr.util.DefaultSolrThreadFactory;
import org.apache.zookeeper.KeeperException;
import org.rrd4j.ConsolFun;
import org.rrd4j.DsType;
import org.rrd4j.core.ArcDef;
import org.rrd4j.core.Archive;
import org.rrd4j.core.Datasource;
import org.rrd4j.core.DsDef;
import org.rrd4j.core.FetchData;
import org.rrd4j.core.FetchRequest;
import org.rrd4j.core.RrdBackendFactory;
import org.rrd4j.core.RrdDb;
import org.rrd4j.core.RrdDef;
import org.rrd4j.core.Sample;
import org.rrd4j.graph.RrdGraph;
import org.rrd4j.graph.RrdGraphDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsHistoryHandler
extends RequestHandlerBase
implements PermissionNameProvider,
Closeable {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final List<String> DEFAULT_CORE_COUNTERS = new ArrayList<String>();
    public static final List<String> DEFAULT_CORE_GAUGES = new ArrayList<String>();
    public static final List<String> DEFAULT_NODE_GAUGES = new ArrayList<String>();
    public static final List<String> DEFAULT_JVM_GAUGES = new ArrayList<String>();
    public static final String NUM_SHARDS_KEY = "numShards";
    public static final String NUM_REPLICAS_KEY = "numReplicas";
    public static final String NUM_NODES_KEY = "numNodes";
    public static final List<String> DEFAULT_COLLECTION_GAUGES = new ArrayList<String>();
    public static final String COLLECT_PERIOD_PROP = "collectPeriod";
    public static final String SYNC_PERIOD_PROP = "syncPeriod";
    public static final String ENABLE_PROP = "enable";
    public static final String ENABLE_REPLICAS_PROP = "enableReplicas";
    public static final String ENABLE_NODES_PROP = "enableNodes";
    public static final int DEFAULT_COLLECT_PERIOD = 60;
    public static final String URI_PREFIX = "solr:";
    private final SolrRrdBackendFactory factory;
    private final String nodeName;
    private final SolrClient solrClient;
    private final MetricsHandler metricsHandler;
    private final SolrCloudManager cloudManager;
    private final TimeSource timeSource;
    private final int collectPeriod;
    private final Map<String, List<String>> counters = new HashMap<String, List<String>>();
    private final Map<String, List<String>> gauges = new HashMap<String, List<String>>();
    private final String overseerUrlScheme;
    private final Map<String, RrdDb> knownDbs = new ConcurrentHashMap<String, RrdDb>();
    private ScheduledThreadPoolExecutor collectService;
    private boolean logMissingCollection = true;
    private boolean enable;
    private boolean enableReplicas;
    private boolean enableNodes;
    private String versionString;

    public MetricsHistoryHandler(String nodeName, MetricsHandler metricsHandler, SolrClient solrClient, SolrCloudManager cloudManager, Map<String, Object> pluginArgs) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        if (pluginArgs != null) {
            args.putAll(pluginArgs);
        }
        if (cloudManager != null) {
            Map props = ((Map)cloudManager.getClusterStateProvider().getClusterProperty("metrics", Collections.emptyMap())).getOrDefault("history", Collections.emptyMap());
            args.putAll(props);
            this.overseerUrlScheme = (String)cloudManager.getClusterStateProvider().getClusterProperty("urlScheme", (Object)"http");
        } else {
            this.overseerUrlScheme = "http";
        }
        this.nodeName = nodeName;
        this.enable = Boolean.parseBoolean(String.valueOf(args.getOrDefault(ENABLE_PROP, "true")));
        this.enableReplicas = Boolean.parseBoolean(String.valueOf(args.getOrDefault(ENABLE_REPLICAS_PROP, "false")));
        this.enableNodes = Boolean.parseBoolean(String.valueOf(args.getOrDefault(ENABLE_NODES_PROP, "false")));
        this.collectPeriod = Integer.parseInt(String.valueOf(args.getOrDefault(COLLECT_PERIOD_PROP, 60)));
        int syncPeriod = Integer.parseInt(String.valueOf(args.getOrDefault(SYNC_PERIOD_PROP, 60)));
        this.solrClient = solrClient;
        this.metricsHandler = metricsHandler;
        this.cloudManager = cloudManager;
        this.timeSource = cloudManager != null ? cloudManager.getTimeSource() : TimeSource.NANO_TIME;
        this.factory = new SolrRrdBackendFactory(solrClient, ".system", syncPeriod, this.timeSource);
        this.counters.put(SolrInfoBean.Group.core.toString(), DEFAULT_CORE_COUNTERS);
        this.counters.put(SolrInfoBean.Group.node.toString(), Collections.emptyList());
        this.counters.put(SolrInfoBean.Group.jvm.toString(), Collections.emptyList());
        this.counters.put(SolrInfoBean.Group.collection.toString(), Collections.emptyList());
        this.gauges.put(SolrInfoBean.Group.core.toString(), DEFAULT_CORE_GAUGES);
        this.gauges.put(SolrInfoBean.Group.node.toString(), DEFAULT_NODE_GAUGES);
        this.gauges.put(SolrInfoBean.Group.jvm.toString(), DEFAULT_JVM_GAUGES);
        this.gauges.put(SolrInfoBean.Group.collection.toString(), DEFAULT_COLLECTION_GAUGES);
        this.versionString = this.getClass().getPackage().getImplementationVersion();
        if (this.versionString == null) {
            this.versionString = "?.?.?";
        }
        if (this.versionString.length() > 24) {
            this.versionString = this.versionString.substring(0, 24) + "...";
        }
        if (this.enable) {
            this.collectService = (ScheduledThreadPoolExecutor)Executors.newScheduledThreadPool(1, new DefaultSolrThreadFactory("MetricsHistoryHandler"));
            this.collectService.setRemoveOnCancelPolicy(true);
            this.collectService.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
            this.collectService.scheduleWithFixedDelay(() -> this.collectMetrics(), this.timeSource.convertDelay(TimeUnit.SECONDS, (long)this.collectPeriod, TimeUnit.MILLISECONDS), this.timeSource.convertDelay(TimeUnit.SECONDS, (long)this.collectPeriod, TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
            this.checkSystemCollection();
        }
    }

    public void checkSystemCollection() {
        if (this.cloudManager != null) {
            try {
                if (this.cloudManager.isClosed() || Thread.interrupted()) {
                    this.factory.setPersistent(false);
                    return;
                }
                ClusterState clusterState = this.cloudManager.getClusterStateProvider().getClusterState();
                DocCollection systemColl = clusterState.getCollectionOrNull(".system");
                if (systemColl == null) {
                    if (this.logMissingCollection) {
                        log.info("No .system collection, keeping metrics history in memory.");
                        this.logMissingCollection = false;
                    }
                    this.factory.setPersistent(false);
                    return;
                }
                boolean ready = false;
                for (Replica r : systemColl.getReplicas()) {
                    if (!r.isActive(clusterState.getLiveNodes())) continue;
                    ready = true;
                    break;
                }
                if (!ready) {
                    log.debug(".systemcollection not ready yet, keeping metrics history in memory");
                    this.factory.setPersistent(false);
                    return;
                }
            }
            catch (Exception e) {
                if (this.logMissingCollection) {
                    log.warn("Error getting cluster state, keeping metrics history in memory", (Throwable)e);
                }
                this.logMissingCollection = false;
                this.factory.setPersistent(false);
                return;
            }
            this.logMissingCollection = true;
            this.factory.setPersistent(true);
        } else {
            try {
                this.solrClient.query(".system", (SolrParams)new SolrQuery("q", "*:*", new String[]{"rows", "0"}));
                this.factory.setPersistent(true);
                this.logMissingCollection = true;
            }
            catch (Exception e) {
                if (this.logMissingCollection) {
                    log.info("No .system collection, keeping metrics history in memory.");
                }
                this.logMissingCollection = false;
                this.factory.setPersistent(false);
            }
        }
    }

    public SolrClient getSolrClient() {
        return this.solrClient;
    }

    public void removeHistory(String registry) throws IOException {
        registry = SolrMetricManager.enforcePrefix(registry);
        this.knownDbs.remove(registry);
        this.factory.remove(registry);
    }

    @VisibleForTesting
    public SolrRrdBackendFactory getFactory() {
        return this.factory;
    }

    private String getOverseerLeader() {
        if (this.cloudManager == null) {
            return null;
        }
        ZkNodeProps props = null;
        try {
            VersionedData data = this.cloudManager.getDistribStateManager().getData("/overseer_elect/leader");
            if (data != null && data.getData() != null) {
                props = ZkNodeProps.load((byte[])data.getData());
            }
        }
        catch (IOException | NoSuchElementException | KeeperException e) {
            log.warn("Could not obtain overseer's address, skipping.", e);
            return null;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
        if (props == null) {
            return null;
        }
        String oid = props.getStr("id");
        if (oid == null) {
            return null;
        }
        String nodeName = null;
        try {
            nodeName = LeaderElector.getNodeName(oid);
        }
        catch (Exception e) {
            log.warn("Unknown format of leader id, skipping: " + oid, (Throwable)e);
            return null;
        }
        return nodeName;
    }

    private boolean amIOverseerLeader() {
        return this.amIOverseerLeader(null);
    }

    private boolean amIOverseerLeader(String leader) {
        if (leader == null) {
            leader = this.getOverseerLeader();
        }
        if (leader == null) {
            return false;
        }
        return this.nodeName.equals(leader);
    }

    private void collectMetrics() {
        log.debug("-- collectMetrics");
        ExecutorUtil.setServerThreadFlag((Boolean)true);
        try {
            this.checkSystemCollection();
        }
        catch (Exception e) {
            log.warn("Error checking for .system collection, keeping metrics history in memory", (Throwable)e);
            this.factory.setPersistent(false);
        }
        this.collectLocalReplicaMetrics();
        this.collectGlobalMetrics();
        ExecutorUtil.setServerThreadFlag((Boolean)false);
    }

    private void collectLocalReplicaMetrics() {
        ArrayList<SolrInfoBean.Group> groups = new ArrayList<SolrInfoBean.Group>();
        if (this.enableNodes) {
            groups.add(SolrInfoBean.Group.jvm);
            groups.add(SolrInfoBean.Group.node);
        }
        if (this.enableReplicas) {
            groups.add(SolrInfoBean.Group.core);
        }
        for (SolrInfoBean.Group group : groups) {
            if (Thread.interrupted()) {
                return;
            }
            log.debug("--  collecting local " + (Object)((Object)group) + "...");
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.add("group", new String[]{group.toString()});
            params.add("compact", new String[]{"true"});
            this.counters.get(group.toString()).forEach(c -> params.add("prefix", new String[]{c}));
            this.gauges.get(group.toString()).forEach(c -> params.add("prefix", new String[]{c}));
            AtomicReference result = new AtomicReference();
            try {
                this.metricsHandler.handleRequest((SolrParams)params, (String k, Object v) -> {
                    if (k.equals("metrics")) {
                        result.set(v);
                    }
                });
                NamedList nl = (NamedList)result.get();
                if (nl == null) continue;
                for (Map.Entry entry : nl) {
                    RrdDb db;
                    String registry = (String)entry.getKey();
                    if (group != SolrInfoBean.Group.core) {
                        registry = registry + "." + this.nodeName;
                    }
                    if ((db = this.getOrCreateDb(registry, group)) == null) continue;
                    Sample s = db.createSample(TimeUnit.SECONDS.convert(this.timeSource.getEpochTimeNs(), TimeUnit.NANOSECONDS));
                    NamedList values = (NamedList)entry.getValue();
                    AtomicBoolean dirty = new AtomicBoolean(false);
                    this.counters.get(group.toString()).forEach(c -> {
                        Number val = (Number)values.get(c);
                        if (val != null) {
                            dirty.set(true);
                            s.setValue(c, val.doubleValue());
                        }
                    });
                    this.gauges.get(group.toString()).forEach(c -> {
                        Number val = (Number)values.get(c);
                        if (val != null) {
                            dirty.set(true);
                            s.setValue(c, val.doubleValue());
                        }
                    });
                    if (!dirty.get()) continue;
                    s.update();
                }
            }
            catch (Exception e) {
                log.warn("Exception retrieving local metrics for group {}: {}", (Object)group, (Object)e);
            }
        }
    }

    private void collectGlobalMetrics() {
        if (!this.amIOverseerLeader()) {
            return;
        }
        HashSet nodes = new HashSet(this.cloudManager.getClusterStateProvider().getLiveNodes());
        NodeStateProvider nodeStateProvider = this.cloudManager.getNodeStateProvider();
        HashSet collTags = new HashSet();
        collTags.addAll(this.counters.get(SolrInfoBean.Group.core.toString()));
        collTags.addAll(this.gauges.get(SolrInfoBean.Group.core.toString()));
        HashSet nodeTags = new HashSet();
        String nodePrefix = "metrics:" + SolrMetricManager.getRegistryName(SolrInfoBean.Group.node, new String[0]) + ":";
        this.counters.get(SolrInfoBean.Group.node.toString()).forEach(name -> nodeTags.add(nodePrefix + name));
        this.gauges.get(SolrInfoBean.Group.node.toString()).forEach(name -> nodeTags.add(nodePrefix + name));
        String jvmPrefix = "metrics:" + SolrMetricManager.getRegistryName(SolrInfoBean.Group.jvm, new String[0]) + ":";
        this.counters.get(SolrInfoBean.Group.jvm.toString()).forEach(name -> nodeTags.add(jvmPrefix + name));
        this.gauges.get(SolrInfoBean.Group.jvm.toString()).forEach(name -> nodeTags.add(jvmPrefix + name));
        HashMap<SolrInfoBean.Group, Map> totals = new HashMap<SolrInfoBean.Group, Map>();
        for (String node : nodes) {
            if (this.cloudManager.isClosed() || Thread.interrupted()) {
                return;
            }
            Map infos = nodeStateProvider.getReplicaInfo(node, collTags);
            infos.forEach((coll, shards) -> shards.forEach((sh, replicas) -> {
                String registry = SolrMetricManager.getRegistryName(SolrInfoBean.Group.collection, coll);
                Map perReg = totals.computeIfAbsent(SolrInfoBean.Group.collection, g -> new HashMap()).computeIfAbsent(registry, r -> new HashMap());
                replicas.forEach(ri -> collTags.forEach(tag -> {
                    double value = ((Number)ri.getVariable(tag, (Object)0.0)).doubleValue();
                    DoubleAdder adder = (DoubleAdder)perReg.computeIfAbsent(tag, t -> new DoubleAdder());
                    adder.add(value);
                }));
            }));
            Map nodeValues = nodeStateProvider.getNodeValues(node, nodeTags);
            for (SolrInfoBean.Group g : Arrays.asList(SolrInfoBean.Group.node, SolrInfoBean.Group.jvm)) {
                String registry = SolrMetricManager.getRegistryName(g, new String[0]);
                Map perReg = totals.computeIfAbsent(g, gr -> new HashMap()).computeIfAbsent(registry, r -> new HashMap());
                HashSet names = new HashSet();
                names.addAll(this.counters.get(g.toString()));
                names.addAll(this.gauges.get(g.toString()));
                names.forEach(name -> {
                    String tag = "metrics:" + registry + ":" + name;
                    double value = ((Number)nodeValues.getOrDefault(tag, 0.0)).doubleValue();
                    DoubleAdder adder = (DoubleAdder)perReg.computeIfAbsent(name, t -> new DoubleAdder());
                    adder.add(value);
                });
            }
        }
        String nodeReg = SolrMetricManager.getRegistryName(SolrInfoBean.Group.node, new String[0]);
        Map perNodeReg = totals.computeIfAbsent(SolrInfoBean.Group.node, gr -> new HashMap()).computeIfAbsent(nodeReg, r -> new HashMap());
        perNodeReg.put(NUM_NODES_KEY, nodes.size());
        try {
            ClusterState state = this.cloudManager.getClusterStateProvider().getClusterState();
            state.forEachCollection(coll -> {
                String registry = SolrMetricManager.getRegistryName(SolrInfoBean.Group.collection, coll.getName());
                Map perReg = totals.computeIfAbsent(SolrInfoBean.Group.collection, g -> new HashMap()).computeIfAbsent(registry, r -> new HashMap());
                Slice[] slices = coll.getActiveSlicesArr();
                perReg.put(NUM_SHARDS_KEY, slices.length);
                DoubleAdder numActiveReplicas = new DoubleAdder();
                for (Slice s : slices) {
                    s.forEach(r -> {
                        if (r.isActive(state.getLiveNodes())) {
                            numActiveReplicas.add(1.0);
                        }
                    });
                }
                perReg.put(NUM_REPLICAS_KEY, numActiveReplicas);
            });
        }
        catch (IOException e) {
            log.warn("Exception getting cluster state", (Throwable)e);
        }
        totals.forEach((group, perGroup) -> perGroup.forEach((reg, perReg) -> {
            RrdDb db = this.getOrCreateDb((String)reg, (SolrInfoBean.Group)((Object)group));
            if (db == null) {
                return;
            }
            try {
                Sample s = db.createSample(TimeUnit.SECONDS.convert(this.timeSource.getEpochTimeNs(), TimeUnit.NANOSECONDS));
                AtomicBoolean dirty = new AtomicBoolean(false);
                ArrayList<SolrInfoBean.Group> groups = new ArrayList<SolrInfoBean.Group>();
                groups.add((SolrInfoBean.Group)((Object)group));
                if (group == SolrInfoBean.Group.collection) {
                    groups.add(SolrInfoBean.Group.core);
                }
                for (SolrInfoBean.Group g : groups) {
                    this.counters.get(g.toString()).forEach(c -> {
                        Number val = (Number)perReg.get(c);
                        if (val != null) {
                            dirty.set(true);
                            s.setValue(c, val.doubleValue());
                        }
                    });
                    this.gauges.get(g.toString()).forEach(c -> {
                        Number val = (Number)perReg.get(c);
                        if (val != null) {
                            dirty.set(true);
                            s.setValue(c, val.doubleValue());
                        }
                    });
                }
                if (dirty.get()) {
                    s.update();
                }
            }
            catch (Exception e) {
                log.warn("Exception storing sample in RrdDb for group {}: {}", (Object)group, (Object)e);
            }
        }));
    }

    private RrdDef createDef(String registry, SolrInfoBean.Group group) {
        registry = SolrMetricManager.enforcePrefix(registry);
        RrdDef def = new RrdDef(URI_PREFIX + registry, (long)this.collectPeriod);
        def.setStartTime(TimeUnit.SECONDS.convert(this.timeSource.getEpochTimeNs(), TimeUnit.NANOSECONDS) - def.getStep());
        ArrayList<SolrInfoBean.Group> groups = new ArrayList<SolrInfoBean.Group>();
        groups.add(group);
        if (group == SolrInfoBean.Group.collection) {
            groups.add(SolrInfoBean.Group.core);
        }
        for (SolrInfoBean.Group g : groups) {
            this.counters.get(g.toString()).forEach(name -> def.addDatasource(name, DsType.COUNTER, (long)(this.collectPeriod * 2), Double.NaN, Double.NaN));
            this.gauges.get(g.toString()).forEach(name -> def.addDatasource(name, DsType.GAUGE, (long)(this.collectPeriod * 2), Double.NaN, Double.NaN));
        }
        if (groups.contains((Object)SolrInfoBean.Group.node)) {
            def.addDatasource(NUM_NODES_KEY, DsType.GAUGE, (long)(this.collectPeriod * 2), Double.NaN, Double.NaN);
        }
        def.addArchive(ConsolFun.AVERAGE, 0.5, 1, 240);
        def.addArchive(ConsolFun.AVERAGE, 0.5, 10, 288);
        def.addArchive(ConsolFun.AVERAGE, 0.5, 60, 336);
        def.addArchive(ConsolFun.AVERAGE, 0.5, 240, 180);
        def.addArchive(ConsolFun.AVERAGE, 0.5, 1440, 365);
        return def;
    }

    private RrdDb getOrCreateDb(String registry, SolrInfoBean.Group group) {
        RrdDb db = this.knownDbs.computeIfAbsent(registry, r -> {
            RrdDef def = this.createDef((String)r, group);
            try {
                RrdDb newDb = new RrdDb(def, (RrdBackendFactory)this.factory);
                return newDb;
            }
            catch (IOException e) {
                log.warn("Can't create RrdDb for registry {}, group {}: {}", new Object[]{registry, group, e});
                return null;
            }
        });
        return db;
    }

    @Override
    public void close() {
        log.debug("Closing " + this.hashCode());
        if (this.collectService != null) {
            boolean shutdown = false;
            while (!shutdown) {
                try {
                    this.collectService.shutdownNow();
                    shutdown = this.collectService.awaitTermination(5L, TimeUnit.SECONDS);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        if (this.factory != null) {
            this.factory.close();
        }
        this.knownDbs.clear();
    }

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        String leader;
        String actionStr = req.getParams().get("action");
        if (actionStr == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "'action' is a required param");
        }
        Cmd cmd = Cmd.get(actionStr);
        if (cmd == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "unknown 'action' param '" + actionStr + "', supported actions: " + Cmd.actions);
        }
        SimpleOrderedMap res = new SimpleOrderedMap();
        rsp.add("metrics", res);
        switch (cmd) {
            case LIST: {
                int rows = req.getParams().getInt("rows", 500);
                List<Pair<String, Long>> lst = this.factory.list(rows);
                lst.forEach(p -> {
                    SimpleOrderedMap data = new SimpleOrderedMap();
                    data.add("lastModified", (Object)TimeUnit.SECONDS.convert((Long)p.second(), TimeUnit.MILLISECONDS));
                    data.add("node", (Object)this.nodeName);
                    res.add((String)p.first(), (Object)data);
                });
                break;
            }
            case GET: {
                String name = req.getParams().get("name");
                if (name == null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "'name' is a required param");
                }
                String[] dsNames = req.getParams().getParams("ds");
                String formatStr = req.getParams().get("format", Format.LIST.toString());
                Format format = Format.get(formatStr);
                if (format == null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "unknown 'format' param '" + formatStr + "', supported formats: " + Format.formats);
                }
                if (!this.factory.exists(name)) break;
                RrdDb db = new RrdDb(URI_PREFIX + name, true, (RrdBackendFactory)this.factory);
                SimpleOrderedMap data = new SimpleOrderedMap();
                data.add("data", this.getDbData(db, dsNames, format, req.getParams()));
                data.add("lastModified", (Object)db.getLastUpdateTime());
                data.add("node", (Object)this.nodeName);
                res.add(name, (Object)data);
                db.close();
                break;
            }
            case STATUS: {
                String name = req.getParams().get("name");
                if (name == null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "'name' is a required param");
                }
                if (!this.factory.exists(name)) break;
                RrdDb db = RrdDb.getBuilder().setBackendFactory((RrdBackendFactory)this.factory).setReadOnly(true).setPath(new URI(URI_PREFIX + name)).build();
                SimpleOrderedMap status = new SimpleOrderedMap();
                status.add("status", this.getDbStatus(db));
                status.add("node", (Object)this.nodeName);
                res.add(name, (Object)status);
                db.close();
                break;
            }
            case DELETE: {
                String name = req.getParams().get("name");
                if (name == null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "'name' is a required param");
                }
                if (name.equalsIgnoreCase("all") || name.equals("*")) {
                    this.factory.removeAll();
                } else {
                    this.factory.remove(name);
                }
                rsp.add("success", "ok");
            }
        }
        if (!this.factory.isPersistent() && (leader = this.getOverseerLeader()) != null && !this.amIOverseerLeader(leader)) {
            NamedList<Object> remoteRes = this.handleRemoteRequest(leader, req);
            this.mergeRemoteRes(rsp, remoteRes);
        }
        SimpleOrderedMap apiState = new SimpleOrderedMap();
        apiState.add(ENABLE_REPLICAS_PROP, (Object)this.enableReplicas);
        apiState.add(ENABLE_NODES_PROP, (Object)this.enableNodes);
        apiState.add("mode", (Object)(this.enable ? (this.factory.isPersistent() ? "index" : "memory") : "inactive"));
        if (!this.factory.isPersistent()) {
            apiState.add("message", (Object)"WARNING: metrics history is not being persisted. Create .system collection to start persisting history.");
        }
        rsp.add("state", apiState);
        rsp.getResponseHeader().add("zkConnected", (Object)(this.cloudManager != null ? 1 : 0));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private NamedList<Object> handleRemoteRequest(String nodeName, SolrQueryRequest req) {
        String url;
        String baseUrl = Utils.getBaseUrlForNodeName((String)nodeName, (String)this.overseerUrlScheme);
        try {
            URL u = new URL(baseUrl);
            u = new URL(u.getProtocol(), u.getHost(), u.getPort(), "/api/cluster/metrics/history");
            url = u.toString();
        }
        catch (MalformedURLException e) {
            log.warn("Invalid Overseer url '" + baseUrl + "', unable to fetch remote metrics history", (Throwable)e);
            return null;
        }
        ModifiableSolrParams params = new ModifiableSolrParams(req.getParams());
        params.set("wt", new String[]{"javabin"});
        url = url + "?" + params.toString();
        try {
            byte[] data = this.cloudManager.httpRequest(url, SolrRequest.METHOD.GET, null, null, 60000, true);
            try (JavaBinCodec codec = new JavaBinCodec();){
                NamedList namedList = (NamedList)codec.unmarshal((InputStream)new ByteArrayInputStream(data));
                return namedList;
            }
        }
        catch (IOException e) {
            log.warn("Exception forwarding request to Overseer at " + url, (Throwable)e);
            return null;
        }
    }

    private void mergeRemoteRes(SolrQueryResponse rsp, NamedList<Object> remoteRes) {
        if (remoteRes == null || remoteRes.get("metrics") == null) {
            return;
        }
        NamedList remoteMetrics = (NamedList)remoteRes.get("metrics");
        SimpleOrderedMap localMetrics = (SimpleOrderedMap)rsp.getValues().get("metrics");
        remoteMetrics.forEach((k, v) -> localMetrics.add(k, v));
    }

    private NamedList<Object> getDbStatus(RrdDb db) throws IOException {
        LinkedHashMap<String, Object> map;
        SimpleOrderedMap res = new SimpleOrderedMap();
        res.add("lastModified", (Object)db.getLastUpdateTime());
        RrdDef def = db.getRrdDef();
        res.add("step", (Object)def.getStep());
        res.add("datasourceCount", (Object)db.getDsCount());
        res.add("archiveCount", (Object)db.getArcCount());
        res.add("datasourceNames", Arrays.asList(db.getDsNames()));
        ArrayList dss = new ArrayList(db.getDsCount());
        res.add("datasources", dss);
        for (DsDef dsDef : def.getDsDefs()) {
            map = new LinkedHashMap<String, Object>();
            map.put("datasource", dsDef.dump());
            Datasource ds = db.getDatasource(dsDef.getDsName());
            map.put("lastValue", ds.getLastValue());
            dss.add(map);
        }
        ArrayList archives = new ArrayList(db.getArcCount());
        res.add("archives", archives);
        ArcDef[] arcDefs = def.getArcDefs();
        for (int i = 0; i < db.getArcCount(); ++i) {
            Archive a = db.getArchive(i);
            map = new LinkedHashMap();
            map.put("archive", arcDefs[i].dump());
            map.put("steps", a.getSteps());
            map.put("consolFun", a.getConsolFun().name());
            map.put("xff", a.getXff());
            map.put("startTime", a.getStartTime());
            map.put("endTime", a.getEndTime());
            map.put("rows", a.getRows());
            archives.add(map);
        }
        return res;
    }

    private NamedList<Object> getDbData(RrdDb db, String[] dsNames, Format format, SolrParams params) throws IOException {
        ArcDef[] arcDefs;
        SimpleOrderedMap res = new SimpleOrderedMap();
        if (dsNames == null || dsNames.length == 0) {
            dsNames = db.getDsNames();
        }
        StringBuilder str = new StringBuilder();
        RrdDef def = db.getRrdDef();
        for (ArcDef arcDef : arcDefs = def.getArcDefs()) {
            SimpleOrderedMap map = new SimpleOrderedMap();
            res.add(arcDef.dump(), (Object)map);
            Archive a = db.getArchive(arcDef.getConsolFun(), arcDef.getSteps());
            FetchRequest fr = db.createFetchRequest(arcDef.getConsolFun(), a.getStartTime() - a.getArcStep(), a.getEndTime() + a.getArcStep());
            FetchData fd = fr.fetchData();
            if (format != Format.GRAPH) {
                long[] timestamps = fd.getTimestamps();
                if (format == Format.LIST) {
                    map.add("timestamps", Arrays.stream(timestamps).boxed().collect(Collectors.toList()));
                } else {
                    str.setLength(0);
                    for (int i = 0; i < timestamps.length; ++i) {
                        if (i > 0) {
                            str.append('\n');
                        }
                        str.append(String.valueOf(timestamps[i]));
                    }
                    map.add("timestamps", (Object)str.toString());
                }
            }
            SimpleOrderedMap values = new SimpleOrderedMap();
            map.add("values", (Object)values);
            block7: for (String name : dsNames) {
                double[] vals = fd.getValues(name);
                switch (format) {
                    case GRAPH: {
                        RrdGraphDef graphDef = new RrdGraphDef();
                        graphDef.setTitle(name);
                        graphDef.datasource(name, fd);
                        graphDef.setStartTime(a.getStartTime() - a.getArcStep());
                        graphDef.setEndTime(a.getEndTime() + a.getArcStep());
                        graphDef.setPoolUsed(false);
                        graphDef.setAltAutoscale(true);
                        graphDef.setAltYGrid(true);
                        graphDef.setAltYMrtg(true);
                        graphDef.setSignature("Apache Solr " + this.versionString);
                        graphDef.setNoLegend(true);
                        graphDef.setAntiAliasing(true);
                        graphDef.setTextAntiAliasing(true);
                        graphDef.setWidth(500);
                        graphDef.setHeight(175);
                        graphDef.setTimeZone(TimeZone.getDefault());
                        graphDef.setLocale(Locale.ROOT);
                        graphDef.setLazy(false);
                        graphDef.area(name, (Paint)new Color(16758880), null);
                        graphDef.line(name, (Paint)Color.RED, null, 1.0f);
                        RrdGraph graph = new RrdGraph(graphDef);
                        BufferedImage bi = new BufferedImage(graph.getRrdGraphInfo().getWidth(), graph.getRrdGraphInfo().getHeight(), 1);
                        graph.render(bi.getGraphics());
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        ImageIO.write((RenderedImage)bi, "png", baos);
                        values.add(name, (Object)Base64.byteArrayToBase64((byte[])baos.toByteArray()));
                        continue block7;
                    }
                    case STRING: {
                        str.setLength(0);
                        for (int i = 0; i < vals.length; ++i) {
                            if (i > 0) {
                                str.append('\n');
                            }
                            str.append(String.valueOf(vals[i]));
                        }
                        values.add(name, (Object)str.toString());
                        continue block7;
                    }
                    case LIST: {
                        values.add(name, Arrays.stream(vals).boxed().collect(Collectors.toList()));
                    }
                }
            }
        }
        return res;
    }

    @Override
    public String getDescription() {
        return "A handler for metrics history";
    }

    @Override
    public PermissionNameProvider.Name getPermissionName(AuthorizationContext request) {
        return PermissionNameProvider.Name.METRICS_HISTORY_READ_PERM;
    }

    @Override
    public Boolean registerV2() {
        return Boolean.TRUE;
    }

    @Override
    public Collection<Api> getApis() {
        return ApiBag.wrapRequestHandlers(this, "metrics.history");
    }

    static {
        DEFAULT_JVM_GAUGES.add("memory.heap.used");
        DEFAULT_JVM_GAUGES.add("os.processCpuLoad");
        DEFAULT_JVM_GAUGES.add("os.systemLoadAverage");
        DEFAULT_NODE_GAUGES.add("CONTAINER.fs.coreRoot.usableSpace");
        DEFAULT_CORE_GAUGES.add(Variable.Type.CORE_IDX.metricsAttribute);
        DEFAULT_CORE_COUNTERS.add("QUERY./select.requests");
        DEFAULT_CORE_COUNTERS.add("UPDATE./update.requests");
        DEFAULT_COLLECTION_GAUGES.add(NUM_SHARDS_KEY);
        DEFAULT_COLLECTION_GAUGES.add(NUM_REPLICAS_KEY);
    }

    public static enum Format {
        LIST,
        STRING,
        GRAPH;

        static final Map<String, Format> formats;

        public static Format get(String p) {
            return p == null ? null : formats.get(p.toLowerCase(Locale.ROOT));
        }

        public String toLower() {
            return this.toString().toLowerCase(Locale.ROOT);
        }

        static {
            formats = Collections.unmodifiableMap(Stream.of(Format.values()).collect(Collectors.toMap(Format::toLower, Function.identity())));
        }
    }

    public static enum Cmd {
        LIST,
        STATUS,
        GET,
        DELETE;

        static final Map<String, Cmd> actions;

        public static Cmd get(String p) {
            return p == null ? null : actions.get(p.toLowerCase(Locale.ROOT));
        }

        public String toLower() {
            return this.toString().toLowerCase(Locale.ROOT);
        }

        static {
            actions = Collections.unmodifiableMap(Stream.of(Cmd.values()).collect(Collectors.toMap(Cmd::toLower, Function.identity())));
        }
    }
}

