/*
 * Decompiled with CFR 0.152.
 */
package onl.netfishers.netshot.diagnostic;

import javax.persistence.Entity;
import javax.persistence.Transient;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import onl.netfishers.netshot.device.Device;
import onl.netfishers.netshot.device.DeviceDriver;
import onl.netfishers.netshot.device.DeviceGroup;
import onl.netfishers.netshot.device.attribute.AttributeDefinition;
import onl.netfishers.netshot.diagnostic.Diagnostic;

@Entity
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class SimpleDiagnostic
extends Diagnostic {
    private String deviceDriver;
    private String cliMode;
    private String command;
    private String modifierPattern;
    private String modifierReplacement;

    protected SimpleDiagnostic() {
    }

    public SimpleDiagnostic(String name, boolean enabled, DeviceGroup targetGroup, AttributeDefinition.AttributeType resultType, String deviceDriver, String cliMode, String command, String modifierPattern, String modifierReplacement) {
        super(name, enabled, targetGroup, resultType);
        this.deviceDriver = deviceDriver;
        this.cliMode = cliMode;
        this.command = command;
        this.modifierPattern = modifierPattern;
        this.modifierReplacement = modifierReplacement;
    }

    @XmlElement
    public String getDeviceDriver() {
        return this.deviceDriver;
    }

    public void setDeviceDriver(String deviceDriver) {
        this.deviceDriver = deviceDriver;
    }

    @XmlElement
    public String getCliMode() {
        return this.cliMode;
    }

    public void setCliMode(String cliMode) {
        this.cliMode = cliMode;
    }

    @XmlElement
    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    @XmlElement
    public String getModifierPattern() {
        return this.modifierPattern;
    }

    public void setModifierPattern(String modifierPattern) {
        this.modifierPattern = modifierPattern;
    }

    @XmlElement
    public String getModifierReplacement() {
        return this.modifierReplacement;
    }

    public void setModifierReplacement(String modifierReplacement) {
        this.modifierReplacement = modifierReplacement;
    }

    @Transient
    @XmlElement
    public String getDeviceDriverDescription() {
        if ("".equals(this.deviceDriver)) {
            return "";
        }
        try {
            DeviceDriver d = DeviceDriver.getDriverByName(this.deviceDriver);
            return d.getDescription();
        }
        catch (Exception e) {
            return "Unknown driver";
        }
    }

    @Override
    @Transient
    public void addResultToDevice(Device device, String value) {
        String newValue = value;
        if (this.getModifierPattern() != null) {
            newValue = value.replaceAll(this.getModifierPattern(), this.getModifierReplacement());
        }
        super.addResultToDevice(device, newValue);
    }

    @Override
    public Object getJsObject(Device device, ScriptEngine engine, ScriptContext scriptContext) throws ScriptException {
        if (!device.getDriver().equals(this.getDeviceDriver())) {
            return null;
        }
        return new JsSimpleDiagnostic(this.cliMode, this.command);
    }

    public static class JsSimpleDiagnostic {
        private String mode;
        private String command;

        public JsSimpleDiagnostic(String mode, String command) {
            this.setMode(mode);
            this.setCommand(command);
        }

        public String getCommand() {
            return this.command;
        }

        public void setCommand(String command) {
            this.command = command;
        }

        public String getMode() {
            return this.mode;
        }

        public void setMode(String mode) {
            this.mode = mode;
        }
    }
}

