/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import org.bouncycastle.jsse.provider.PropertyUtils;
import org.bouncycastle.jsse.provider.ProvSSLContextSpi;
import org.bouncycastle.jsse.provider.ProvSSLSessionImpl;
import org.bouncycastle.tls.SessionID;
import org.bouncycastle.tls.TlsSession;
import org.bouncycastle.tls.crypto.TlsCrypto;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProvSSLSessionContext
implements SSLSessionContext {
    private static final int provSessionCacheSize = PropertyUtils.getIntegerSystemProperty("javax.net.ssl.sessionCacheSize", 0, 0, Integer.MAX_VALUE);
    protected final Map<SessionID, ProvSSLSessionImpl> sessionsByID = new LinkedHashMap<SessionID, ProvSSLSessionImpl>(16, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<SessionID, ProvSSLSessionImpl> entry) {
            boolean bl;
            boolean bl2 = bl = ProvSSLSessionContext.this.sessionCacheSize > 0 && this.size() > ProvSSLSessionContext.this.sessionCacheSize;
            if (bl) {
                ProvSSLSessionContext.this.removeSessionByPeer(entry.getValue());
            }
            return bl;
        }
    };
    protected final Map<String, ProvSSLSessionImpl> sessionsByPeer = new HashMap<String, ProvSSLSessionImpl>();
    protected final ProvSSLContextSpi sslContext;
    protected final TlsCrypto crypto;
    protected int sessionCacheSize = provSessionCacheSize;
    protected int sessionTimeoutSeconds = 86400;

    ProvSSLSessionContext(ProvSSLContextSpi provSSLContextSpi, TlsCrypto tlsCrypto) {
        this.sslContext = provSSLContextSpi;
        this.crypto = tlsCrypto;
    }

    ProvSSLContextSpi getSSLContext() {
        return this.sslContext;
    }

    TlsCrypto getCrypto() {
        return this.crypto;
    }

    synchronized ProvSSLSessionImpl getSessionImpl(byte[] byArray) {
        if (byArray == null || byArray.length < 1) {
            return null;
        }
        return this.checkSession(this.sessionsByID.get(new SessionID(byArray)));
    }

    synchronized ProvSSLSessionImpl getSessionImpl(String string, int n) {
        if (string == null || n < 0) {
            return null;
        }
        ProvSSLSessionImpl provSSLSessionImpl = this.checkSession(this.sessionsByPeer.get(ProvSSLSessionContext.makePeerKey(string, n)));
        if (provSSLSessionImpl != null) {
            this.sessionsByID.get(new SessionID(provSSLSessionImpl.getId()));
        }
        return provSSLSessionImpl;
    }

    synchronized ProvSSLSessionImpl reportSession(TlsSession tlsSession, String string, int n) {
        SessionID sessionID = new SessionID(tlsSession.getSessionID());
        ProvSSLSessionImpl provSSLSessionImpl = this.sessionsByID.get(sessionID);
        if (provSSLSessionImpl == null || provSSLSessionImpl.getTlsSession() != tlsSession) {
            provSSLSessionImpl = new ProvSSLSessionImpl(this, tlsSession, string, n);
            this.sessionsByID.put(sessionID, provSSLSessionImpl);
        }
        this.addSessionByPeer(provSSLSessionImpl);
        return provSSLSessionImpl;
    }

    @Override
    public synchronized Enumeration<byte[]> getIds() {
        this.removeAllExpiredSessions();
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(this.sessionsByID.size());
        for (SessionID sessionID : this.sessionsByID.keySet()) {
            arrayList.add(sessionID.getBytes());
        }
        return Collections.enumeration(arrayList);
    }

    @Override
    public SSLSession getSession(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("'sessionID' cannot be null");
        }
        return this.getSessionImpl(byArray);
    }

    @Override
    public synchronized int getSessionCacheSize() {
        return this.sessionCacheSize;
    }

    @Override
    public synchronized int getSessionTimeout() {
        return this.sessionTimeoutSeconds;
    }

    @Override
    public synchronized void setSessionCacheSize(int n) throws IllegalArgumentException {
        int n2;
        if (this.sessionCacheSize == n) {
            return;
        }
        if (n < 0) {
            throw new IllegalArgumentException("'size' cannot be < 0");
        }
        this.sessionCacheSize = n;
        if (this.sessionCacheSize > 0 && (n2 = this.sessionsByID.size()) > this.sessionCacheSize) {
            Iterator<ProvSSLSessionImpl> iterator = this.sessionsByID.values().iterator();
            while (iterator.hasNext() && n2 > this.sessionCacheSize) {
                ProvSSLSessionImpl provSSLSessionImpl = iterator.next();
                iterator.remove();
                this.removeSessionByPeer(provSSLSessionImpl);
                --n2;
            }
        }
    }

    @Override
    public synchronized void setSessionTimeout(int n) throws IllegalArgumentException {
        if (this.sessionTimeoutSeconds == n) {
            return;
        }
        if (n < 0) {
            throw new IllegalArgumentException("'seconds' cannot be < 0");
        }
        this.sessionTimeoutSeconds = n;
        this.removeAllExpiredSessions();
    }

    private void addSessionByPeer(ProvSSLSessionImpl provSSLSessionImpl) {
        if (provSSLSessionImpl != null && provSSLSessionImpl.getPeerHost() != null && provSSLSessionImpl.getPeerPort() >= 0) {
            String string = ProvSSLSessionContext.makePeerKey(provSSLSessionImpl.getPeerHost(), provSSLSessionImpl.getPeerPort());
            this.sessionsByPeer.put(string, provSSLSessionImpl);
        }
    }

    private ProvSSLSessionImpl checkSession(ProvSSLSessionImpl provSSLSessionImpl) {
        if (provSSLSessionImpl != null) {
            long l = System.currentTimeMillis();
            this.invalidateIfExpiredBefore(provSSLSessionImpl, l);
            if (provSSLSessionImpl.isValid()) {
                provSSLSessionImpl.accessedAt(l);
                return provSSLSessionImpl;
            }
            this.removeSessionByID(provSSLSessionImpl);
            this.removeSessionByPeer(provSSLSessionImpl);
        }
        return null;
    }

    private void invalidateIfCreatedBefore(ProvSSLSessionImpl provSSLSessionImpl, long l) {
        if (provSSLSessionImpl.getCreationTime() < l) {
            provSSLSessionImpl.invalidate();
        }
    }

    private void invalidateIfExpiredBefore(ProvSSLSessionImpl provSSLSessionImpl, long l) {
        if (this.sessionTimeoutSeconds > 0) {
            long l2 = l - 1000L * (long)this.sessionTimeoutSeconds;
            this.invalidateIfCreatedBefore(provSSLSessionImpl, l2);
        }
    }

    private void removeAllExpiredSessions() {
        if (this.sessionTimeoutSeconds == 0) {
            return;
        }
        long l = System.currentTimeMillis() - 1000L * (long)this.sessionTimeoutSeconds;
        Iterator<ProvSSLSessionImpl> iterator = this.sessionsByID.values().iterator();
        while (iterator.hasNext()) {
            ProvSSLSessionImpl provSSLSessionImpl = iterator.next();
            this.invalidateIfCreatedBefore(provSSLSessionImpl, l);
            if (provSSLSessionImpl.isValid()) continue;
            iterator.remove();
            this.removeSessionByPeer(provSSLSessionImpl);
        }
    }

    private boolean removeSessionByID(ProvSSLSessionImpl provSSLSessionImpl) {
        byte[] byArray;
        if (provSSLSessionImpl != null && (byArray = provSSLSessionImpl.getId()) != null & byArray.length > 0) {
            return null != this.sessionsByID.remove(new SessionID(byArray));
        }
        return false;
    }

    private boolean removeSessionByPeer(ProvSSLSessionImpl provSSLSessionImpl) {
        if (provSSLSessionImpl != null && provSSLSessionImpl.getPeerHost() != null && provSSLSessionImpl.getPeerPort() >= 0) {
            String string = ProvSSLSessionContext.makePeerKey(provSSLSessionImpl.getPeerHost(), provSSLSessionImpl.getPeerPort());
            return null != this.sessionsByPeer.remove(string);
        }
        return false;
    }

    private static String makePeerKey(String string, int n) {
        return (string + ':' + Integer.toString(n)).toLowerCase(Locale.ENGLISH);
    }
}

