/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.plugins.discovery;

import com.google.common.base.Predicate;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Lists;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Stack;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import org.logstash.plugins.discovery.ClasspathHelper;
import org.logstash.plugins.discovery.ReflectionsException;
import org.logstash.plugins.discovery.Utils;

public abstract class Vfs {
    private static List<UrlType> defaultUrlTypes = Lists.newArrayList((Object[])DefaultUrlTypes.values());

    public static Dir fromURL(URL url) {
        return Vfs.fromURL(url, defaultUrlTypes);
    }

    public static Dir fromURL(URL url, List<UrlType> urlTypes) {
        for (UrlType type : urlTypes) {
            try {
                Dir dir;
                if (!type.matches(url) || (dir = type.createDir(url)) == null) continue;
                return dir;
            }
            catch (Throwable throwable) {
            }
        }
        throw new ReflectionsException("could not create Vfs.Dir from url, no matching UrlType was found [" + url.toExternalForm() + "]\neither use fromURL(final URL url, final List<UrlType> urlTypes) or use the static setDefaultURLTypes(final List<UrlType> urlTypes) or addDefaultURLTypes(UrlType urlType) with your specialized UrlType.");
    }

    public static java.io.File getFile(URL url) {
        java.io.File file;
        String path;
        try {
            path = url.toURI().getSchemeSpecificPart();
            file = new java.io.File(path);
            if (file.exists()) {
                return file;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        try {
            path = URLDecoder.decode(url.getPath(), "UTF-8");
            if (path.contains(".jar!")) {
                path = path.substring(0, path.lastIndexOf(".jar!") + ".jar".length());
            }
            if ((file = new java.io.File(path)).exists()) {
                return file;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        try {
            path = url.toExternalForm();
            if (path.startsWith("jar:")) {
                path = path.substring("jar:".length());
            }
            if (path.startsWith("wsjar:")) {
                path = path.substring("wsjar:".length());
            }
            if (path.startsWith("file:")) {
                path = path.substring("file:".length());
            }
            if (path.contains(".jar!")) {
                path = path.substring(0, path.indexOf(".jar!") + ".jar".length());
            }
            if ((file = new java.io.File(path)).exists()) {
                return file;
            }
            file = new java.io.File(path = path.replace("%20", " "));
            if (file.exists()) {
                return file;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static boolean hasJarFileInPath(URL url) {
        return url.toExternalForm().matches(".*\\.jar(\\!.*|$)");
    }

    private static final class SystemFile
    implements File {
        private final SystemDir root;
        private final java.io.File file;

        public SystemFile(SystemDir root, java.io.File file) {
            this.root = root;
            this.file = file;
        }

        @Override
        public String getName() {
            return this.file.getName();
        }

        @Override
        public String getRelativePath() {
            String filepath = this.file.getPath().replace("\\", "/");
            if (filepath.startsWith(this.root.getPath())) {
                return filepath.substring(this.root.getPath().length() + 1);
            }
            return null;
        }

        @Override
        public InputStream openInputStream() {
            try {
                return new FileInputStream(this.file);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }

        public String toString() {
            return this.file.toString();
        }
    }

    private static final class UrlTypeVFS
    implements UrlType {
        public static final String[] REPLACE_EXTENSION = new String[]{".ear/", ".jar/", ".war/", ".sar/", ".har/", ".par/"};
        final String VFSZIP = "vfszip";
        final String VFSFILE = "vfsfile";
        Predicate<java.io.File> realFile = file -> file.exists() && file.isFile();

        private UrlTypeVFS() {
        }

        @Override
        public boolean matches(URL url) {
            return "vfszip".equals(url.getProtocol()) || "vfsfile".equals(url.getProtocol());
        }

        @Override
        public Dir createDir(URL url) {
            try {
                URL adaptedUrl = this.adaptURL(url);
                return new ZipDir(new JarFile(adaptedUrl.getFile()));
            }
            catch (Exception e) {
                try {
                    return new ZipDir(new JarFile(url.getFile()));
                }
                catch (IOException iOException) {
                    return null;
                }
            }
        }

        public URL adaptURL(URL url) throws MalformedURLException {
            if ("vfszip".equals(url.getProtocol())) {
                return this.replaceZipSeparators(url.getPath(), this.realFile);
            }
            if ("vfsfile".equals(url.getProtocol())) {
                return new URL(url.toString().replace("vfsfile", "file"));
            }
            return url;
        }

        URL replaceZipSeparators(String path, Predicate<java.io.File> acceptFile) throws MalformedURLException {
            int pos = 0;
            while (pos != -1) {
                java.io.File file;
                if ((pos = this.findFirstMatchOfDeployableExtention(path, pos)) <= 0 || !acceptFile.apply((Object)(file = new java.io.File(path.substring(0, pos - 1))))) continue;
                return this.replaceZipSeparatorStartingFrom(path, pos);
            }
            throw new ReflectionsException("Unable to identify the real zip file in path '" + path + "'.");
        }

        int findFirstMatchOfDeployableExtention(String path, int pos) {
            Pattern p = Pattern.compile("\\.[ejprw]ar/");
            Matcher m = p.matcher(path);
            if (m.find(pos)) {
                return m.end();
            }
            return -1;
        }

        URL replaceZipSeparatorStartingFrom(String path, int pos) throws MalformedURLException {
            String zipFile = path.substring(0, pos - 1);
            String zipPath = path.substring(pos);
            int numSubs = 1;
            for (String ext : REPLACE_EXTENSION) {
                while (zipPath.contains(ext)) {
                    zipPath = zipPath.replace(ext, ext.substring(0, 4) + "!");
                    ++numSubs;
                }
            }
            String prefix = "";
            for (int i = 0; i < numSubs; ++i) {
                prefix = prefix + "zip:";
            }
            if (zipPath.trim().length() == 0) {
                return new URL(prefix + "/" + zipFile);
            }
            return new URL(prefix + "/" + zipFile + "!" + zipPath);
        }
    }

    public static final class SystemDir
    implements Dir {
        private final java.io.File file;

        public SystemDir(java.io.File file) {
            if (!(file == null || file.isDirectory() && file.canRead())) {
                throw new RuntimeException("cannot use dir " + file);
            }
            this.file = file;
        }

        @Override
        public String getPath() {
            if (this.file == null) {
                return "/NO-SUCH-DIRECTORY/";
            }
            return this.file.getPath().replace("\\", "/");
        }

        @Override
        public Iterable<File> getFiles() {
            if (this.file == null || !this.file.exists()) {
                return Collections.emptyList();
            }
            return () -> new AbstractIterator<File>(){
                final Stack stack = new Stack();
                {
                    this.stack.addAll(SystemDir.listFiles(file));
                }

                protected File computeNext() {
                    while (!this.stack.isEmpty()) {
                        java.io.File file = (java.io.File)this.stack.pop();
                        if (file.isDirectory()) {
                            this.stack.addAll(SystemDir.listFiles(file));
                            continue;
                        }
                        return new SystemFile(this, file);
                    }
                    return (File)this.endOfData();
                }
            };
        }

        private static List<java.io.File> listFiles(java.io.File file) {
            Object[] files = file.listFiles();
            if (files != null) {
                return Lists.newArrayList((Object[])files);
            }
            return Lists.newArrayList();
        }

        @Override
        public void close() {
        }

        public String toString() {
            return this.getPath();
        }
    }

    public static final class ZipFile
    implements File {
        private final ZipDir root;
        private final ZipEntry entry;

        public ZipFile(ZipDir root, ZipEntry entry) {
            this.root = root;
            this.entry = entry;
        }

        @Override
        public String getName() {
            String name = this.entry.getName();
            return name.substring(name.lastIndexOf("/") + 1);
        }

        @Override
        public String getRelativePath() {
            return this.entry.getName();
        }

        @Override
        public InputStream openInputStream() throws IOException {
            return this.root.jarFile.getInputStream(this.entry);
        }

        public String toString() {
            return this.root.getPath() + "!" + java.io.File.separatorChar + this.entry.toString();
        }
    }

    public static final class ZipDir
    implements Dir {
        final java.util.zip.ZipFile jarFile;

        public ZipDir(JarFile jarFile) {
            this.jarFile = jarFile;
        }

        @Override
        public String getPath() {
            return this.jarFile.getName();
        }

        @Override
        public Iterable<File> getFiles() {
            return () -> new AbstractIterator<File>(){
                final Enumeration entries;
                {
                    this.entries = jarFile.entries();
                }

                protected File computeNext() {
                    while (this.entries.hasMoreElements()) {
                        ZipEntry entry = (ZipEntry)this.entries.nextElement();
                        if (entry.isDirectory()) continue;
                        return new ZipFile(this, entry);
                    }
                    return (File)this.endOfData();
                }
            };
        }

        @Override
        public void close() {
            try {
                this.jarFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public String toString() {
            return this.jarFile.getName();
        }
    }

    public static class JarInputFile
    implements File {
        private final ZipEntry entry;
        private final JarInputDir jarInputDir;
        private final long fromIndex;
        private final long endIndex;

        public JarInputFile(ZipEntry entry, JarInputDir jarInputDir, long cursor, long nextCursor) {
            this.entry = entry;
            this.jarInputDir = jarInputDir;
            this.fromIndex = cursor;
            this.endIndex = nextCursor;
        }

        @Override
        public String getName() {
            String name = this.entry.getName();
            return name.substring(name.lastIndexOf("/") + 1);
        }

        @Override
        public String getRelativePath() {
            return this.entry.getName();
        }

        @Override
        public InputStream openInputStream() {
            return new InputStream(){

                @Override
                public int read() throws IOException {
                    if (((JarInputFile)this).jarInputDir.cursor >= fromIndex && ((JarInputFile)this).jarInputDir.cursor <= endIndex) {
                        int read = ((JarInputFile)this).jarInputDir.jarInputStream.read();
                        ++((JarInputFile)this).jarInputDir.cursor;
                        return read;
                    }
                    return -1;
                }
            };
        }
    }

    private static final class JarInputDir
    implements Dir {
        private final URL url;
        JarInputStream jarInputStream;
        long cursor;
        long nextCursor;

        public JarInputDir(URL url) {
            this.url = url;
        }

        @Override
        public String getPath() {
            return this.url.getPath();
        }

        @Override
        public Iterable<File> getFiles() {
            return () -> new AbstractIterator<File>(){
                {
                    try {
                        jarInputStream = new JarInputStream(url.openConnection().getInputStream());
                    }
                    catch (Exception e) {
                        throw new ReflectionsException("Could not open url connection", e);
                    }
                }

                protected File computeNext() {
                    try {
                        JarEntry entry;
                        do {
                            if ((entry = jarInputStream.getNextJarEntry()) == null) {
                                return (File)this.endOfData();
                            }
                            long size = entry.getSize();
                            if (size < 0L) {
                                size = 0xFFFFFFFFL + size;
                            }
                            nextCursor += size;
                        } while (entry.isDirectory());
                        return new JarInputFile(entry, this, cursor, nextCursor);
                    }
                    catch (IOException e) {
                        throw new ReflectionsException("could not get next zip entry", e);
                    }
                }
            };
        }

        @Override
        public void close() {
            Utils.close(this.jarInputStream);
        }
    }

    public static enum DefaultUrlTypes implements UrlType
    {
        jarFile{

            @Override
            public boolean matches(URL url) {
                return url.getProtocol().equals("file") && Vfs.hasJarFileInPath(url);
            }

            @Override
            public Dir createDir(URL url) throws Exception {
                return new ZipDir(new JarFile(Vfs.getFile(url)));
            }
        }
        ,
        jarUrl{

            @Override
            public boolean matches(URL url) {
                return "jar".equals(url.getProtocol()) || "zip".equals(url.getProtocol()) || "wsjar".equals(url.getProtocol());
            }

            @Override
            public Dir createDir(URL url) throws Exception {
                try {
                    URLConnection urlConnection = url.openConnection();
                    if (urlConnection instanceof JarURLConnection) {
                        return new ZipDir(((JarURLConnection)urlConnection).getJarFile());
                    }
                }
                catch (Throwable urlConnection) {
                    // empty catch block
                }
                java.io.File file = Vfs.getFile(url);
                if (file != null) {
                    return new ZipDir(new JarFile(file));
                }
                return null;
            }
        }
        ,
        directory{

            @Override
            public boolean matches(URL url) {
                if (url.getProtocol().equals("file") && !Vfs.hasJarFileInPath(url)) {
                    java.io.File file = Vfs.getFile(url);
                    return file != null && file.isDirectory();
                }
                return false;
            }

            @Override
            public Dir createDir(URL url) {
                return new SystemDir(Vfs.getFile(url));
            }
        }
        ,
        jboss_vfs{

            @Override
            public boolean matches(URL url) {
                return url.getProtocol().equals("vfs");
            }

            @Override
            public Dir createDir(URL url) throws Exception {
                Object content = url.openConnection().getContent();
                Class<?> virtualFile = ClasspathHelper.contextClassLoader().loadClass("org.jboss.vfs.VirtualFile");
                java.io.File physicalFile = (java.io.File)virtualFile.getMethod("getPhysicalFile", new Class[0]).invoke(content, new Object[0]);
                String name = (String)virtualFile.getMethod("getName", new Class[0]).invoke(content, new Object[0]);
                java.io.File file = new java.io.File(physicalFile.getParentFile(), name);
                if (!file.exists() || !file.canRead()) {
                    file = physicalFile;
                }
                return file.isDirectory() ? new SystemDir(file) : new ZipDir(new JarFile(file));
            }
        }
        ,
        jboss_vfsfile{

            @Override
            public boolean matches(URL url) {
                return "vfszip".equals(url.getProtocol()) || "vfsfile".equals(url.getProtocol());
            }

            @Override
            public Dir createDir(URL url) {
                return new UrlTypeVFS().createDir(url);
            }
        }
        ,
        bundle{

            @Override
            public boolean matches(URL url) {
                return url.getProtocol().startsWith("bundle");
            }

            @Override
            public Dir createDir(URL url) throws Exception {
                return Vfs.fromURL((URL)ClasspathHelper.contextClassLoader().loadClass("org.eclipse.core.runtime.FileLocator").getMethod("resolve", URL.class).invoke(null, url));
            }
        }
        ,
        jarInputStream{

            @Override
            public boolean matches(URL url) {
                return url.toExternalForm().contains(".jar");
            }

            @Override
            public Dir createDir(URL url) {
                return new JarInputDir(url);
            }
        };

    }

    public static interface UrlType {
        public boolean matches(URL var1) throws Exception;

        public Dir createDir(URL var1) throws Exception;
    }

    public static interface File {
        public String getName();

        public String getRelativePath();

        public InputStream openInputStream() throws IOException;
    }

    public static interface Dir {
        public String getPath();

        public Iterable<File> getFiles();

        public void close();
    }
}

