#########################################################################
#
# LibKdeEdu Configuration File
#
# This file sets various CMake Variables
#
# LIBKDEEDU_INCLUDE_DIR                - The Include Directory for all LIBKDEEDU libraries
# LIBKDEEDU_KEDUVOCDOCUMENT_LIBRARIES  - the keduvocdocument library
# LIBKDEEDU_KDEEDUUI_LIBRARIES         - the kdeeduui library
#
# Copyright 2008  Andreas Pakulat <apaku@gmx.de>
# Copyright 2010  Niko Sams <niko.sams@gmail.com>
# Redistribution and use is allowed according to the terms of the BSD license.
######################################################################

get_filename_component(_LIBKDEEDU_CURRENT_DIR  "${CMAKE_CURRENT_LIST_FILE}" PATH)

set( LIBKDEEDU_INCLUDE_DIR "/usr/local/include/kde4/libkdeedu" )

if( NOT TARGET LibKdeEduImport__keduvocdocument )
    include("${_LIBKDEEDU_CURRENT_DIR}/LibKdeEduTargets.cmake")
endif( NOT TARGET LibKdeEduImport__keduvocdocument )

macro( _libkdeedu_set_lib_vars _prefix _lib )
  set( LIBKDEEDU_${_prefix}_LIBRARIES LibKdeEduImport__${_lib} )
endmacro( _libkdeedu_set_lib_vars )

_libkdeedu_set_lib_vars( KEDUVOCDOCUMENT keduvocdocument )
_libkdeedu_set_lib_vars( KDEEDUUI kdeeduui )
_libkdeedu_set_lib_vars( QTMMLWIDGET qtmmlwidget )


mark_as_advanced(
    KEDUVOCDOCUMENT
)
