/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.trycatch;

import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.IContainer;
import jadx.core.dex.trycatch.TryCatchBlock;
import jadx.core.utils.InsnUtils;
import jadx.core.utils.Utils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.Nullable;

public class ExceptionHandler {
    private final Set<ClassInfo> catchTypes = new TreeSet<ClassInfo>();
    private final int handleOffset;
    private BlockNode handlerBlock;
    private final List<BlockNode> blocks = new ArrayList<BlockNode>();
    private IContainer handlerRegion;
    private InsnArg arg;
    private TryCatchBlock tryBlock;
    private boolean isFinally;

    public ExceptionHandler(int addr, @Nullable ClassInfo type) {
        this.handleOffset = addr;
        this.addCatchType(type);
    }

    public void addCatchType(@Nullable ClassInfo type) {
        if (type != null) {
            this.catchTypes.add(type);
        } else if (!this.catchTypes.isEmpty()) {
            throw new JadxRuntimeException("Null type added to not empty exception handler: " + this);
        }
    }

    public void addCatchTypes(Collection<ClassInfo> types) {
        for (ClassInfo type : types) {
            this.addCatchType(type);
        }
    }

    public Set<ClassInfo> getCatchTypes() {
        return this.catchTypes;
    }

    public ArgType getArgType() {
        if (this.isCatchAll()) {
            return ArgType.THROWABLE;
        }
        Set<ClassInfo> types = this.getCatchTypes();
        if (types.size() == 1) {
            return types.iterator().next().getType();
        }
        return ArgType.THROWABLE;
    }

    public boolean isCatchAll() {
        if (this.catchTypes.isEmpty()) {
            return true;
        }
        for (ClassInfo classInfo : this.catchTypes) {
            if (!classInfo.getFullName().equals("java.lang.Throwable")) continue;
            return true;
        }
        return false;
    }

    public int getHandleOffset() {
        return this.handleOffset;
    }

    public BlockNode getHandlerBlock() {
        return this.handlerBlock;
    }

    public void setHandlerBlock(BlockNode handlerBlock) {
        this.handlerBlock = handlerBlock;
    }

    public List<BlockNode> getBlocks() {
        return this.blocks;
    }

    public void addBlock(BlockNode node) {
        this.blocks.add(node);
    }

    public IContainer getHandlerRegion() {
        return this.handlerRegion;
    }

    public void setHandlerRegion(IContainer handlerRegion) {
        this.handlerRegion = handlerRegion;
    }

    public InsnArg getArg() {
        return this.arg;
    }

    public void setArg(InsnArg arg) {
        this.arg = arg;
    }

    public void setTryBlock(TryCatchBlock tryBlock) {
        this.tryBlock = tryBlock;
    }

    public TryCatchBlock getTryBlock() {
        return this.tryBlock;
    }

    public boolean isFinally() {
        return this.isFinally;
    }

    public void setFinally(boolean isFinally) {
        this.isFinally = isFinally;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExceptionHandler that = (ExceptionHandler)o;
        return this.handleOffset == that.handleOffset && this.catchTypes.equals(that.catchTypes) && Objects.equals(this.tryBlock, that.tryBlock);
    }

    public int hashCode() {
        return Objects.hash(this.catchTypes, this.handleOffset);
    }

    public String catchTypeStr() {
        return this.catchTypes.isEmpty() ? "all" : Utils.listToString(this.catchTypes, " | ", ClassInfo::getShortName);
    }

    public String toString() {
        return this.catchTypeStr() + " -> " + InsnUtils.formatOffset(this.handleOffset);
    }
}

