/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.codearea;

import jadx.gui.settings.JadxSettings;
import jadx.gui.treemodel.JNode;
import jadx.gui.ui.ContentPanel;
import jadx.gui.ui.MainWindow;
import jadx.gui.utils.JumpPosition;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCodeArea
extends RSyntaxTextArea {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCodeArea.class);
    protected final ContentPanel contentPanel;
    protected final JNode node;

    public AbstractCodeArea(ContentPanel contentPanel) {
        this.contentPanel = contentPanel;
        this.node = contentPanel.getNode();
    }

    public abstract void load();

    public void loadSettings() {
        AbstractCodeArea.loadCommonSettings(this.contentPanel.getTabbedPane().getMainWindow(), this);
    }

    public void scrollToLine(int line) {
        int lineNum = line - 1;
        if (lineNum < 0) {
            lineNum = 0;
        }
        this.setCaretAtLine(lineNum);
        this.centerCurrentLine();
        this.forceCurrentLineHighlightRepaint();
    }

    private void setCaretAtLine(int line) {
        try {
            this.setCaretPosition(this.getLineStartOffset(line));
        }
        catch (BadLocationException e) {
            LOG.debug("Can't scroll to {}", (Object)line, (Object)e);
        }
    }

    public void centerCurrentLine() {
        JViewport viewport = (JViewport)SwingUtilities.getAncestorOfClass(JViewport.class, (Component)((Object)this));
        if (viewport == null) {
            return;
        }
        try {
            Rectangle r = this.modelToView(this.getCaretPosition());
            if (r == null) {
                return;
            }
            int extentHeight = viewport.getExtentSize().height;
            Dimension viewSize = viewport.getViewSize();
            if (viewSize == null) {
                return;
            }
            int viewHeight = viewSize.height;
            int y = Math.max(0, r.y - extentHeight / 2);
            y = Math.min(y, viewHeight - extentHeight);
            viewport.setViewPosition(new Point(0, y));
        }
        catch (BadLocationException e) {
            LOG.debug("Can't center current line", (Throwable)e);
        }
    }

    public JumpPosition getCurrentPosition() {
        return new JumpPosition(this.node, this.getCaretLineNumber() + 1);
    }

    @Nullable
    Integer getSourceLine(int line) {
        return this.node.getSourceLine(line);
    }

    public ContentPanel getContentPanel() {
        return this.contentPanel;
    }

    public JNode getNode() {
        return this.node;
    }

    public static void loadCommonSettings(MainWindow mainWindow, RSyntaxTextArea area) {
        area.setAntiAliasingEnabled(true);
        mainWindow.getEditorTheme().apply(area);
        JadxSettings settings = mainWindow.getSettings();
        area.setFont(settings.getFont());
    }
}

