/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.action.ToolBarData;
import ghidra.feature.vt.api.main.VTAssociationType;
import ghidra.feature.vt.api.main.VTMarkupItem;
import ghidra.feature.vt.api.main.VTMarkupItemStatus;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.plugin.VTPlugin;
import ghidra.feature.vt.gui.task.UnapplyMarkupItemTask;
import ghidra.feature.vt.gui.util.MatchInfo;
import ghidra.program.util.AddressCorrelation;
import ghidra.util.HelpLocation;
import ghidra.util.task.Task;
import ghidra.util.task.TaskListener;
import java.util.List;
import javax.swing.Icon;
import resources.ResourceManager;

public class ResetMarkupItemAction
extends DockingAction {
    public static final Icon RESET_ICON = ResourceManager.loadImage((String)"images/undo-apply.png");
    private static final String MENU_GROUP = "A_VT_UnEdit";
    final VTController controller;

    public ResetMarkupItemAction(VTController controller, boolean addToToolbar) {
        super("Reset Mark-up", VTPlugin.OWNER);
        this.controller = controller;
        if (addToToolbar) {
            this.setToolBarData(new ToolBarData(RESET_ICON, MENU_GROUP));
        }
        this.setPopupMenuData(new MenuData(new String[]{"Reset Mark-up"}, RESET_ICON, MENU_GROUP));
        this.setEnabled(false);
        this.setHelpLocation(new HelpLocation("VersionTrackingPlugin", "Reset_Markup_Item"));
    }

    public void actionPerformed(ActionContext context) {
        VTSession session = this.controller.getSession();
        List<VTMarkupItem> markupItems = this.controller.getMarkupItems(context);
        AddressCorrelation correlation = this.getCorrelation();
        UnapplyMarkupItemTask task = new UnapplyMarkupItemTask(session, correlation, markupItems);
        task.addTaskListener(new TaskListener(){

            public void taskCompleted(Task t) {
                ResetMarkupItemAction.this.controller.refresh();
            }

            public void taskCancelled(Task t) {
            }
        });
        this.controller.runVTTask(task);
    }

    private AddressCorrelation getCorrelation() {
        MatchInfo matchInfo = this.controller.getMatchInfo();
        if (matchInfo == null) {
            return null;
        }
        VTAssociationType type = matchInfo.getMatch().getAssociation().getType();
        if (type == VTAssociationType.FUNCTION) {
            return this.controller.getCorrelator(matchInfo.getSourceFunction(), matchInfo.getDestinationFunction());
        }
        if (type == VTAssociationType.DATA) {
            return this.controller.getCorrelator(matchInfo.getSourceData(), matchInfo.getDestinationData());
        }
        return null;
    }

    public boolean isEnabledForContext(ActionContext context) {
        List<VTMarkupItem> markupItems = this.controller.getMarkupItems(context);
        if (markupItems.size() == 0) {
            return false;
        }
        for (VTMarkupItem markupItem : markupItems) {
            if (this.canReset(markupItem)) continue;
            return false;
        }
        return true;
    }

    private boolean canReset(VTMarkupItem markupItem) {
        String addressSource = markupItem.getDestinationAddressSource();
        if ("User Defined".equals(addressSource)) {
            return true;
        }
        VTMarkupItemStatus status = markupItem.getStatus();
        return !status.isDefault();
    }

    public boolean isAddToPopup(ActionContext context) {
        return this.isEnabledForContext(context);
    }
}

