/*
 * Decompiled with CFR 0.152.
 */
package ghidra.javaclass.format.attributes;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.StructureDataType;
import java.io.IOException;

public abstract class AbstractAttributeInfo
implements StructConverter {
    private long _offset;
    private short attributeNameIndex;
    private int attributeLength;

    protected AbstractAttributeInfo(BinaryReader reader) throws IOException {
        this._offset = reader.getPointerIndex();
        this.attributeNameIndex = reader.readNextShort();
        this.attributeLength = reader.readNextInt();
    }

    public long getOffset() {
        return this._offset;
    }

    public short getAttributeNameIndex() {
        return this.attributeNameIndex;
    }

    public int getAttributeLength() {
        return this.attributeLength;
    }

    protected StructureDataType getBaseStructure(String name) {
        StructureDataType structure = new StructureDataType(name + "|" + this.attributeLength + "|", 0);
        structure.add(WORD, "attribute_name_index", null);
        structure.add(DWORD, "attribute_length", null);
        return structure;
    }
}

