/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.table.field;

import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.util.EolCommentFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.VariableLocation;
import ghidra.util.table.field.ProgramLocationTableColumnExtensionPoint;

public class EOLCommentTableColumn
extends ProgramLocationTableColumnExtensionPoint<ProgramLocation, String> {
    @Override
    public ProgramLocation getProgramLocation(ProgramLocation rowObject, Settings settings, Program program, ServiceProvider serviceProvider) {
        String comment = this.getEOLComment(rowObject, program);
        if (comment != null) {
            return new EolCommentFieldLocation(program, rowObject.getAddress(), null, null, 0, 0, 0);
        }
        return rowObject;
    }

    public String getColumnName() {
        return "EOL Comment";
    }

    public String getValue(ProgramLocation rowObject, Settings settings, Program program, ServiceProvider serviceProvider) throws IllegalArgumentException {
        return this.getEOLComment(rowObject, program);
    }

    private String getEOLComment(ProgramLocation loc, Program program) throws IllegalArgumentException {
        ProgramLocation location = loc;
        if (loc instanceof VariableLocation) {
            return null;
        }
        Address address = location.getAddress();
        return program.getListing().getComment(0, address);
    }
}

