/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.table;

import docking.widgets.table.DefaultSortedTableModel;
import docking.widgets.table.GTable;
import ghidra.app.nav.Navigatable;
import ghidra.app.services.GoToService;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.table.GhidraTableCellRenderer;
import ghidra.util.table.PreviewDataTableCellRenderer;
import ghidra.util.table.PreviewTableCellData;
import ghidra.util.table.ProgramTableModel;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class GhidraTable
extends GTable {
    private Navigatable navigatable;
    private GoToService gotoService;
    private boolean navigateOnSelection;
    private KeyListener navigationKeyListener;
    private MouseListener navigationMouseListener;
    private ListSelectionListener navigationSelectionListener;

    public GhidraTable() {
    }

    public GhidraTable(TableModel model) {
        super(model);
    }

    public GhidraTable(TableModel dm, boolean allowAutoEdit) {
        super(dm, allowAutoEdit);
    }

    public GhidraTable(Object[][] rowData, Object[] columnNames) {
        super(rowData, columnNames);
    }

    public GhidraTable(Object[][] rowData, Object[] columnNames, boolean allowAutoEdit) {
        super(rowData, columnNames, allowAutoEdit);
    }

    protected void initDefaultRenderers() {
        super.initDefaultRenderers();
        GhidraTableCellRenderer ghidraTableCellRenderer = new GhidraTableCellRenderer();
        this.setDefaultRenderer(String.class, (TableCellRenderer)((Object)ghidraTableCellRenderer));
        this.setDefaultRenderer(Enum.class, (TableCellRenderer)((Object)ghidraTableCellRenderer));
        this.defaultGTableRendererList.add(ghidraTableCellRenderer);
        PreviewDataTableCellRenderer previewRenderer = new PreviewDataTableCellRenderer();
        this.setDefaultRenderer(PreviewTableCellData.class, (TableCellRenderer)((Object)previewRenderer));
        this.defaultGTableRendererList.add(previewRenderer);
    }

    public void installNavigation(GoToService goToService, Navigatable nav) {
        if (nav == null) {
            return;
        }
        if (this.navigatable == null) {
            this.navigationKeyListener = new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        int selectedRow = GhidraTable.this.getSelectedRow();
                        int selectedColumn = GhidraTable.this.getSelectedColumn();
                        if (selectedRow < 0 || selectedColumn < 0) {
                            return;
                        }
                        GhidraTable.this.navigate(selectedRow, selectedColumn);
                        e.consume();
                    }
                }
            };
            this.addKeyListener(this.navigationKeyListener);
            this.navigationMouseListener = new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (e.getClickCount() == 2 && !GhidraTable.this.isEditing()) {
                        Point point = e.getPoint();
                        GhidraTable.this.navigate(GhidraTable.this.rowAtPoint(point), GhidraTable.this.columnAtPoint(point));
                    }
                }
            };
            this.addMouseListener(this.navigationMouseListener);
            this.navigationSelectionListener = new SelectionListener();
            this.selectionModel.addListSelectionListener(this.navigationSelectionListener);
        }
        this.gotoService = goToService;
        this.navigatable = nav;
    }

    public void removeNavigation() {
        this.removeKeyListener(this.navigationKeyListener);
        this.removeMouseListener(this.navigationMouseListener);
        this.selectionModel.removeListSelectionListener(this.navigationSelectionListener);
        this.gotoService = null;
        this.navigatable = null;
    }

    public ProgramSelection getProgramSelection() {
        ProgramTableModel programTableModel = this.getProgramTableModel(this.dataModel);
        if (programTableModel == null) {
            return null;
        }
        return programTableModel.getProgramSelection(this.getSelectedRows());
    }

    private ProgramTableModel getProgramTableModel(TableModel model) {
        if (model instanceof ProgramTableModel) {
            return (ProgramTableModel)((Object)model);
        }
        if (model instanceof DefaultSortedTableModel) {
            DefaultSortedTableModel defaultSortedTableModel = (DefaultSortedTableModel)model;
            return this.getProgramTableModel(defaultSortedTableModel.getModel());
        }
        return null;
    }

    public void navigate(int row, int column) {
        if (this.navigatable == null) {
            return;
        }
        column = this.convertColumnIndexToModel(column);
        if (row < 0 || column < 0) {
            return;
        }
        if (!(this.dataModel instanceof ProgramTableModel)) {
            return;
        }
        ProgramTableModel ptm = (ProgramTableModel)((Object)this.dataModel);
        ProgramLocation loc = ptm.getProgramLocation(row, column);
        if (loc != null && loc.getAddress().isExternalAddress()) {
            this.gotoService.goTo(loc.getAddress(), ptm.getProgram());
            return;
        }
        Program program = ptm.getProgram();
        this.gotoService.goTo(this.navigatable, loc, program);
    }

    private void navigateOnCurrentSelection(int row, int column) {
        if (!this.navigateOnSelection) {
            return;
        }
        if (!this.isFocusOwner()) {
            return;
        }
        this.navigate(row, column);
    }

    public void setNavigateOnSelectionEnabled(boolean enabled) {
        this.navigateOnSelection = enabled;
    }

    public void setValueAt(Object aValue, int row, int column) {
        if (this.programIsClosed()) {
            return;
        }
        super.setValueAt(aValue, row, column);
    }

    private boolean programIsClosed() {
        if (!(this.dataModel instanceof ProgramTableModel)) {
            return false;
        }
        ProgramTableModel ptm = (ProgramTableModel)((Object)this.dataModel);
        Program program = ptm.getProgram();
        return program == null;
    }

    public void selectRow(int row) {
        super.selectRow(row);
        this.navigateOnCurrentSelection(row, 0);
    }

    public void dispose() {
        super.dispose();
        this.navigationKeyListener = null;
        this.navigationMouseListener = null;
        this.navigationSelectionListener = null;
    }

    private class SelectionListener
    implements ListSelectionListener {
        private SelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            if (GhidraTable.this.getSelectedRowCount() != 1) {
                return;
            }
            int column = Math.max(0, GhidraTable.this.getSelectedColumn());
            GhidraTable.this.navigateOnCurrentSelection(GhidraTable.this.getSelectedRow(), column);
        }
    }
}

