/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.objectiveC;

import ghidra.app.cmd.function.ApplyFunctionSignatureCmd;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC_MethodType;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.ByteDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.CharDataType;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DoubleDataType;
import ghidra.program.model.data.FloatDataType;
import ghidra.program.model.data.FunctionDefinitionDataType;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.program.model.data.ParameterDefinitionImpl;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.QWordDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.TypedefDataType;
import ghidra.program.model.data.Undefined4DataType;
import ghidra.program.model.data.Union;
import ghidra.program.model.data.UnionDataType;
import ghidra.program.model.data.VoidDataType;
import ghidra.program.model.data.WordDataType;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionSignature;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.exception.DuplicateNameException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ObjectiveC1_TypeEncodings {
    public static final char _C_ID = '@';
    public static final char _C_CLASS = '#';
    public static final char _C_SEL = ':';
    public static final char _C_CHR = 'c';
    public static final char _C_UCHR = 'C';
    public static final char _C_SHT = 's';
    public static final char _C_USHT = 'S';
    public static final char _C_INT = 'i';
    public static final char _C_UINT = 'I';
    public static final char _C_LNG = 'l';
    public static final char _C_ULNG = 'L';
    public static final char _C_LNG_LNG = 'q';
    public static final char _C_ULNG_LNG = 'Q';
    public static final char _C_FLT = 'f';
    public static final char _C_DBL = 'd';
    public static final char _C_BOOL = 'B';
    public static final char _C_VOID = 'v';
    public static final char _C_UNDEF = '?';
    public static final char _C_PTR = '^';
    public static final char _C_CHARPTR = '*';
    public static final char _C_ATOM = '%';
    public static final char _C_ARY_B = '[';
    public static final char _C_ARY_E = ']';
    public static final char _C_UNION_B = '(';
    public static final char _C_UNION_E = ')';
    public static final char _C_STRUCT_B = '{';
    public static final char _C_STRUCT_E = '}';
    public static final char _C_VECTOR = '!';
    public static final char _C_BFLD = 'b';
    public static final char _C_CONST = 'r';
    public static final char _C_IN = 'n';
    public static final char _C_INOUT = 'N';
    public static final char _C_OUT = 'o';
    public static final char _C_BYCOPY = 'O';
    public static final char _C_BYREF = 'R';
    public static final char _C_ONEWAY = 'V';
    private static final String ANONYMOUS_PREFIX = "Anonymous";
    private List<Composite> anonymousCompositeList = new ArrayList<Composite>();
    private Map<AnonymousTypes, Integer> anonymousIndexMap = new HashMap<AnonymousTypes, Integer>();
    private int pointerSize;
    private CategoryPath categoryPath;

    public ObjectiveC1_TypeEncodings(int pointerSize, CategoryPath categoryPath) {
        this.pointerSize = pointerSize;
        this.categoryPath = categoryPath;
        for (AnonymousTypes type : AnonymousTypes.values()) {
            this.anonymousIndexMap.put(type, 0);
        }
    }

    public void processMethodSignature(Program program, Address methodAddress, String mangledSignature, ObjectiveC_MethodType methodType) {
        Function method = program.getListing().getFunctionAt(methodAddress);
        if (method == null) {
            return;
        }
        StringBuffer buffer = new StringBuffer(mangledSignature);
        DataType returnType = this.parseDataType(buffer);
        FunctionDefinitionDataType sig = new FunctionDefinitionDataType(method, true);
        if (returnType != null) {
            sig.setReturnType(returnType);
        }
        int totalSize = this.parseNumber(buffer);
        ArrayList<ParameterDefinitionImpl> args = new ArrayList<ParameterDefinitionImpl>();
        while (buffer.length() > 0) {
            DataType paramDT = this.parseDataType(buffer);
            if (Character.isDigit(buffer.charAt(0))) {
                this.parseNumber(buffer);
            }
            ArrayList matchingDataTypes = new ArrayList();
            program.getDataTypeManager().findDataTypes(paramDT.getName(), matchingDataTypes);
            if (matchingDataTypes.size() == 1) {
                paramDT = (DataType)matchingDataTypes.get(0);
            }
            args.add(new ParameterDefinitionImpl(null, paramDT, null));
        }
        sig.setArguments(args.toArray(new ParameterDefinition[args.size()]));
        new ApplyFunctionSignatureCmd(methodAddress, (FunctionSignature)sig, SourceType.ANALYSIS).applyTo((DomainObject)program);
        StringBuffer commentBuffer = new StringBuffer();
        commentBuffer.append("Function Stack Size: 0x" + Integer.toHexString(totalSize) + " bytes");
        if (method.getComment() == null) {
            method.setComment(commentBuffer.toString());
        }
    }

    public FunctionSignature toFunctionSignature(String methodName, String mangledSignature) {
        FunctionDefinitionDataType fSig = new FunctionDefinitionDataType(methodName);
        StringBuffer buffer = new StringBuffer(mangledSignature);
        DataType returnType = this.parseDataType(buffer);
        fSig.setReturnType(returnType);
        int totalStackSize = this.parseNumber(buffer);
        fSig.setComment("Function Stack Size: 0x" + Integer.toHexString(totalStackSize) + " bytes");
        ArrayList<ParameterDefinitionImpl> arguments = new ArrayList<ParameterDefinitionImpl>();
        while (buffer.length() > 0) {
            DataType paramDT = this.parseDataType(buffer);
            this.parseNumber(buffer);
            String name = null;
            ParameterDefinitionImpl parameter = new ParameterDefinitionImpl(name, paramDT, null);
            arguments.add(parameter);
        }
        fSig.setArguments(arguments.toArray(new ParameterDefinition[arguments.size()]));
        return fSig;
    }

    public void processInstanceVariableSignature(Program program, Address instanceVariableAddress, String mangledType, int instanceVariableSize) {
    }

    public String processInstanceVariableSignature(String name, String mangledType) {
        StringBuffer buffer = new StringBuffer(mangledType);
        DataType dt = this.parseDataType(buffer);
        return dt.getDisplayName() + " " + name;
    }

    private DataType parseDataType(StringBuffer buffer) {
        DataType dt = this.createProperDataType(buffer);
        try {
            dt.setCategoryPath(this.categoryPath);
        }
        catch (DuplicateNameException duplicateNameException) {
            // empty catch block
        }
        return dt;
    }

    private DataType createTypeDef(String name) {
        switch (this.pointerSize) {
            case 4: {
                return new TypedefDataType(name, (DataType)new DWordDataType());
            }
            case 8: {
                return new TypedefDataType(name, (DataType)new QWordDataType());
            }
        }
        throw new RuntimeException("Invalid pointer size specified.");
    }

    private DataType createProperDataType(StringBuffer buffer) {
        switch (buffer.charAt(0)) {
            case '@': {
                buffer.deleteCharAt(0);
                String quotedName = this.parseQuotedName(buffer);
                if (quotedName != null) {
                    DataType quoteNameTypeDef = this.createTypeDef(quotedName);
                    return PointerDataType.getPointer((DataType)quoteNameTypeDef, (int)this.pointerSize);
                }
                return this.createTypeDef("ID");
            }
            case '#': {
                buffer.deleteCharAt(0);
                return this.createTypeDef("CLASS");
            }
            case ':': {
                buffer.deleteCharAt(0);
                return this.createTypeDef("SEL");
            }
            case 'c': {
                buffer.deleteCharAt(0);
                return new CharDataType();
            }
            case 'C': {
                buffer.deleteCharAt(0);
                return new TypedefDataType("unsigned char", (DataType)new CharDataType());
            }
            case 's': {
                buffer.deleteCharAt(0);
                return new TypedefDataType("short", (DataType)new WordDataType());
            }
            case 'S': {
                buffer.deleteCharAt(0);
                return new TypedefDataType("unsigned short", (DataType)new WordDataType());
            }
            case 'i': {
                buffer.deleteCharAt(0);
                return new TypedefDataType("int", (DataType)new DWordDataType());
            }
            case 'I': {
                buffer.deleteCharAt(0);
                return new TypedefDataType("unsigned int", (DataType)new DWordDataType());
            }
            case 'l': {
                buffer.deleteCharAt(0);
                return new TypedefDataType("long", (DataType)new QWordDataType());
            }
            case 'L': {
                buffer.deleteCharAt(0);
                return new TypedefDataType("unsigned long", (DataType)new QWordDataType());
            }
            case 'q': {
                buffer.deleteCharAt(0);
                return new TypedefDataType("long long", (DataType)new QWordDataType());
            }
            case 'Q': {
                buffer.deleteCharAt(0);
                return new TypedefDataType("unsigned long long", (DataType)new QWordDataType());
            }
            case 'f': {
                buffer.deleteCharAt(0);
                return new FloatDataType();
            }
            case 'd': {
                buffer.deleteCharAt(0);
                return new DoubleDataType();
            }
            case 'B': {
                buffer.deleteCharAt(0);
                return new TypedefDataType("bool", (DataType)new DWordDataType());
            }
            case 'v': {
                buffer.deleteCharAt(0);
                return new VoidDataType();
            }
            case '?': {
                buffer.deleteCharAt(0);
                return new Undefined4DataType();
            }
            case '^': {
                buffer.deleteCharAt(0);
                DataType dt = this.parseDataType(buffer);
                return PointerDataType.getPointer((DataType)dt, (int)this.pointerSize);
            }
            case '*': {
                buffer.deleteCharAt(0);
                return PointerDataType.getPointer((DataType)new CharDataType(), (int)this.pointerSize);
            }
            case '%': {
                throw new UnsupportedOperationException("atom not supported");
            }
            case '[': {
                buffer.deleteCharAt(0);
                int nElements = this.parseNumber(buffer);
                DataType dt = this.parseDataType(buffer);
                buffer.deleteCharAt(0);
                if (nElements > 0) {
                    return new ArrayDataType(dt, nElements, dt.getLength());
                }
                if (dt instanceof Pointer) {
                    return dt;
                }
                return PointerDataType.getPointer((DataType)dt, (int)this.pointerSize);
            }
            case '(': {
                buffer.deleteCharAt(0);
                String name = this.parseCompositeName(buffer, ')', AnonymousTypes.UNION);
                UnionDataType union = new UnionDataType(name);
                while (buffer.charAt(0) != ')') {
                    DataType dt = this.parseDataType(buffer);
                    union.add(dt);
                }
                buffer.deleteCharAt(0);
                return this.checkForExistingAnonymousEquivalent((Composite)union);
            }
            case '{': {
                buffer.deleteCharAt(0);
                String name = this.parseCompositeName(buffer, '}', AnonymousTypes.STRUCTURE);
                StructureDataType struct = new StructureDataType(name, 0);
                while (buffer.charAt(0) != '}') {
                    String fieldName = this.parseQuotedName(buffer);
                    String comment = null;
                    if (buffer.charAt(0) == 'b') {
                        this.reinsertName(buffer, fieldName);
                        Union bitFieldUnion = this.parseBitFields(buffer);
                        DataType dt = this.checkForExistingAnonymousEquivalent((Composite)bitFieldUnion);
                        struct.add(dt, fieldName, comment);
                        continue;
                    }
                    DataType dt = this.parseDataType(buffer);
                    struct.add(dt, fieldName, comment);
                }
                buffer.deleteCharAt(0);
                if (struct.getLength() == 0) {
                    struct.add(DataType.DEFAULT);
                }
                DataType dt = this.checkForExistingAnonymousEquivalent((Composite)struct);
                return dt;
            }
            case '!': {
                throw new UnsupportedOperationException("vector not supported");
            }
            case 'r': {
                buffer.deleteCharAt(0);
                DataType dt = this.parseDataType(buffer);
                return new TypedefDataType("const " + dt.getDisplayName(), dt);
            }
            case 'n': {
                buffer.deleteCharAt(0);
                DataType dt = this.parseDataType(buffer);
                return new TypedefDataType("IN " + dt.getDisplayName(), dt);
            }
            case 'N': {
                buffer.deleteCharAt(0);
                DataType dt = this.parseDataType(buffer);
                return new TypedefDataType("INOUT " + dt.getDisplayName(), dt);
            }
            case 'o': {
                buffer.deleteCharAt(0);
                DataType dt = this.parseDataType(buffer);
                return new TypedefDataType("OUT " + dt.getDisplayName(), dt);
            }
            case 'O': {
                buffer.deleteCharAt(0);
                return this.parseDataType(buffer);
            }
            case 'R': {
                buffer.deleteCharAt(0);
                return this.parseDataType(buffer);
            }
            case 'V': {
                buffer.deleteCharAt(0);
                DataType dt = this.parseDataType(buffer);
                return new TypedefDataType("ONEWAY " + dt.getDisplayName(), dt);
            }
        }
        throw new UnsupportedOperationException("unrecognized format type: " + buffer.charAt(0));
    }

    private Union parseBitFields(StringBuffer buffer) {
        Object name;
        UnionDataType bitFieldUnion = new UnionDataType(this.getUniqueAnonymousTypeName(AnonymousTypes.BIT_FIELD_UNION));
        try {
            bitFieldUnion.setCategoryPath(this.categoryPath);
        }
        catch (DuplicateNameException duplicateNameException) {
            // empty catch block
        }
        ArrayList<CallSite> names = new ArrayList<CallSite>();
        int defaultFieldNameIndex = 0;
        int totalBits = 0;
        while (true) {
            name = this.parseQuotedName(buffer);
            if (buffer.charAt(0) != 'b') break;
            if (name == null) {
                name = "bitField" + defaultFieldNameIndex++;
            }
            buffer.deleteCharAt(0);
            int nBits = this.parseNumber(buffer);
            names.add((CallSite)((Object)((String)name + "_" + nBits)));
            totalBits += nBits;
        }
        this.reinsertName(buffer, (String)name);
        DataType dt = this.getBitFieldDataType(totalBits);
        try {
            dt.setCategoryPath(this.categoryPath);
        }
        catch (DuplicateNameException duplicateNameException) {
            // empty catch block
        }
        for (String string : names) {
            bitFieldUnion.add(dt, string, null);
        }
        return bitFieldUnion;
    }

    private DataType getBitFieldDataType(int nBits) {
        int nRemainder = nBits % 8 == 0 ? 0 : 8 - nBits % 8;
        int nBytes = (nBits + nRemainder) / 8;
        switch (nBytes) {
            case 1: {
                return new TypedefDataType("OneByteBitField", (DataType)new ByteDataType());
            }
            case 2: {
                return new TypedefDataType("TwoByteBitField", (DataType)new WordDataType());
            }
            case 3: 
            case 4: {
                return new TypedefDataType("FourByteBitField", (DataType)new DWordDataType());
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return new TypedefDataType("EightByteBitField", (DataType)new QWordDataType());
            }
        }
        throw new IllegalArgumentException();
    }

    private DataType checkForExistingAnonymousEquivalent(Composite composite) {
        if (composite.getName().startsWith(ANONYMOUS_PREFIX)) {
            for (Composite anonynousComposite : this.anonymousCompositeList) {
                if (!anonynousComposite.isEquivalent((DataType)composite)) continue;
                return anonynousComposite;
            }
        }
        this.anonymousCompositeList.add(composite);
        return composite;
    }

    private String parseCompositeName(StringBuffer buffer, char endCompositeChar, AnonymousTypes type) {
        if (buffer.charAt(0) == '?') {
            buffer.deleteCharAt(0);
            if (buffer.charAt(0) == '=') {
                buffer.deleteCharAt(0);
            }
            return this.getUniqueAnonymousTypeName(type);
        }
        int endCompositePos = buffer.indexOf("" + endCompositeChar);
        int equalPos = buffer.indexOf("=");
        if (equalPos >= 0 && equalPos < endCompositePos) {
            String name = buffer.substring(0, equalPos);
            buffer.delete(0, equalPos);
            buffer.deleteCharAt(0);
            return name;
        }
        if (endCompositePos >= 0) {
            String name = buffer.substring(0, endCompositePos);
            buffer.delete(0, endCompositePos);
            return name;
        }
        throw new IllegalArgumentException("Name cannot be null.");
    }

    private synchronized String getUniqueAnonymousTypeName(AnonymousTypes type) {
        int index = this.anonymousIndexMap.get((Object)type);
        this.anonymousIndexMap.put(type, index + 1);
        return type.toString() + index;
    }

    private String parseQuotedName(StringBuffer buffer) {
        if (buffer.charAt(0) == '\"') {
            int endquote = buffer.indexOf("\"", 1);
            String name = buffer.substring(1, endquote);
            buffer.delete(0, endquote + 1);
            return name;
        }
        return null;
    }

    private void reinsertName(StringBuffer buffer, String fieldName) {
        if (fieldName != null) {
            buffer.insert(0, "\"" + fieldName + "\"");
        }
    }

    private int parseNumber(StringBuffer buffer) {
        if (buffer.charAt(0) == '?') {
            buffer.deleteCharAt(0);
        }
        StringBuffer numberBuffer = new StringBuffer();
        while (buffer.length() > 0 && Character.isDigit(buffer.charAt(0))) {
            numberBuffer.append(buffer.charAt(0));
            buffer.deleteCharAt(0);
        }
        return Integer.parseInt(numberBuffer.toString());
    }

    private static enum AnonymousTypes {
        STRUCTURE("AnonymousStructure"),
        UNION("AnonymousUnion"),
        BIT_FIELD_UNION("AnonymousBitField");

        private String string;

        private AnonymousTypes(String string2) {
            this.string = string2;
        }

        public String toString() {
            return this.string;
        }
    }
}

