/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.debug;

import db.DBHandle;
import docking.ActionContext;
import docking.ComponentProvider;
import docking.WindowPosition;
import ghidra.app.plugin.debug.DbViewerComponent;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.Plugin;
import ghidra.util.HelpLocation;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import resources.ResourceManager;

public class DbViewerProvider
extends ComponentProviderAdapter {
    private static final String ICON_IMAGE = "images/zoom.png";
    private DBHandle dbh;
    private String dbName;
    private Plugin plugin;
    private ImageIcon icon;
    private DbViewerComponent comp;

    public DbViewerProvider(Plugin plugin) {
        super(plugin.getTool(), "Database Viewer", plugin.getName());
        this.setDefaultWindowPosition(WindowPosition.BOTTOM);
        this.plugin = plugin;
        this.setHelpLocation(new HelpLocation(plugin.getName(), "DbViewer"));
    }

    public void closeDatabase() {
        if (this.comp != null) {
            this.comp.closeDatabase();
        }
        this.dbh = null;
    }

    public void openDatabase(String databaseName, DBHandle handle) {
        if (this.comp != null) {
            this.comp.openDatabase(databaseName, handle);
        }
        this.dbh = handle;
        this.dbName = databaseName;
    }

    void refresh() {
        if (this.comp != null) {
            this.comp.refresh();
        }
    }

    void dispose() {
        if (this.comp != null) {
            this.comp.dispose();
            this.comp = null;
        }
    }

    public ActionContext getActionContext(MouseEvent event) {
        return new ActionContext((ComponentProvider)this, (Object)this);
    }

    public JComponent getComponent() {
        if (this.comp == null) {
            this.comp = new DbViewerComponent();
            if (this.dbh != null) {
                this.comp.openDatabase(this.dbName, this.dbh);
            }
        }
        return this.comp;
    }

    public ImageIcon getIcon() {
        if (this.icon == null) {
            this.icon = ResourceManager.loadImage((String)ICON_IMAGE);
        }
        return this.icon;
    }
}

