/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.gotoquery;

import docking.DialogComponentProvider;
import docking.widgets.OptionDialog;
import ghidra.app.cmd.refs.SetExternalNameCmd;
import ghidra.app.nav.Navigatable;
import ghidra.app.nav.NavigationUtils;
import ghidra.app.plugin.core.navigation.NavigationOptions;
import ghidra.app.services.NavigationHistoryService;
import ghidra.app.services.ProgramManager;
import ghidra.app.util.NamespaceUtils;
import ghidra.app.util.SymbolPath;
import ghidra.app.util.query.TableService;
import ghidra.framework.cmd.Command;
import ghidra.framework.main.DataTreeDialog;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.ProjectData;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Library;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.ExternalManager;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.util.AddressFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.VariableNameFieldLocation;
import ghidra.util.HelpLocation;
import ghidra.util.table.AddressArrayTableModel;
import java.util.Iterator;
import java.util.Stack;

public class GoToHelper {
    private PluginTool tool;
    private NavigationOptions navOptions;

    public GoToHelper(PluginTool tool) {
        this.tool = tool;
        this.navOptions = new NavigationOptions(tool);
    }

    public void dispose() {
        this.navOptions.dispose();
    }

    public NavigationOptions getOptions() {
        return this.navOptions;
    }

    public static ProgramLocation getProgramLocationForAddress(Address goToAddress, Program program) {
        if (program == null) {
            return null;
        }
        SymbolTable symTable = program.getSymbolTable();
        Symbol symbol = symTable.getPrimarySymbol(goToAddress);
        if (symbol != null) {
            return symbol.getProgramLocation();
        }
        if (goToAddress.isMemoryAddress()) {
            return new AddressFieldLocation(program, goToAddress);
        }
        return null;
    }

    public boolean goTo(Navigatable navigatable, ProgramLocation loc, Program program) {
        if (loc == null || loc.getAddress() == null) {
            return false;
        }
        if (program == null) {
            program = this.findGoToProgram(navigatable.getProgram(), loc.getAddress());
        }
        if (program == null) {
            return false;
        }
        Address addr = loc.getAddress();
        if (addr.isExternalAddress()) {
            Symbol externalSym = program.getSymbolTable().getPrimarySymbol(addr);
            if (externalSym == null) {
                return false;
            }
            ExternalLocation externalLoc = program.getExternalManager().getExternalLocation(externalSym);
            return this.goToExternalLinkage(navigatable, externalLoc, false);
        }
        Memory memory = program.getMemory();
        if (!memory.contains(addr)) {
            this.tool.setStatusInfo("Address not found in program memory: " + addr);
            return false;
        }
        this.saveLocation(navigatable);
        if (!navigatable.goTo(program, loc)) {
            return false;
        }
        this.saveLocation(navigatable);
        return true;
    }

    private void saveLocation(Navigatable navigatable) {
        if (navigatable.getProgram() == null) {
            return;
        }
        NavigationHistoryService historyService = (NavigationHistoryService)this.tool.getService(NavigationHistoryService.class);
        if (historyService != null) {
            historyService.addNewLocation(navigatable);
        }
    }

    public ProgramLocation getLocation(Program program, Address currentAddress, Address gotoAddress) {
        ReferenceManager refMgr;
        Reference ref;
        SymbolTable symTable;
        Symbol symbol;
        Function func;
        ProgramLocation loc = GoToHelper.getProgramLocationForAddress(gotoAddress, program);
        if (loc != null) {
            return loc;
        }
        if ((gotoAddress.isStackAddress() || gotoAddress.isRegisterAddress()) && (func = program.getFunctionManager().getFunctionContaining(currentAddress)) != null) {
            for (Variable v : func.getAllVariables()) {
                VariableStorage storage = v.getVariableStorage();
                if (!storage.contains(gotoAddress)) continue;
                return new VariableNameFieldLocation(program, v, 0);
            }
        }
        if ((symbol = (symTable = program.getSymbolTable()).getSymbol(ref = (refMgr = program.getReferenceManager()).getReference(currentAddress, gotoAddress, 0))) != null) {
            return symbol.getProgramLocation();
        }
        return null;
    }

    private boolean goToExternalLinkage(Navigatable nav, ExternalLocation externalLoc, boolean popupAllowed) {
        ProgramLocation location;
        if (externalLoc == null) {
            return false;
        }
        Symbol externalSym = externalLoc.getSymbol();
        Program program = externalSym.getProgram();
        Address[] externalLinkageAddresses = NavigationUtils.getExternalLinkageAddresses(program, externalSym.getAddress());
        if (externalLinkageAddresses.length == 0) {
            this.tool.setStatusInfo("Failed to identify external linkage address for " + externalSym.getName(true) + ". Unable to perform navigation.", true);
            return false;
        }
        if (externalLinkageAddresses.length > 1) {
            if (popupAllowed) {
                AddressArrayTableModel model = new AddressArrayTableModel("Goto: ", (ServiceProvider)this.tool, program, externalLinkageAddresses, null);
                TableService service = (TableService)this.tool.getService(TableService.class);
                service.showTable("Goto " + externalSym.getName(true) + " linkage location", "Goto", model, "Go To", nav);
                return true;
            }
            this.tool.setStatusInfo("Multiple external linkage addresses found for " + externalSym.getName(true), true);
        } else if (popupAllowed && (location = nav.getLocation()) != null && externalLinkageAddresses[0].equals((Object)location.getAddress())) {
            return this.goToExternalLocation(nav, externalLoc, false);
        }
        location = GoToHelper.getProgramLocationForAddress(externalLinkageAddresses[0], program);
        return this.goTo(nav, location, program);
    }

    public boolean goToExternalLocation(Navigatable nav, ExternalLocation externalLoc, boolean checkNavigationOption) {
        Address addr;
        if (checkNavigationOption && !this.navOptions.isGotoExternalProgramEnabled()) {
            return this.goToExternalLinkage(nav, externalLoc, true);
        }
        Symbol externalSym = externalLoc.getSymbol();
        Program program = externalSym.getProgram();
        ExternalManager extMgr = program.getExternalManager();
        String extProgName = externalLoc.getLibraryName();
        if ("<EXTERNAL>".equals(extProgName)) {
            this.tool.setStatusInfo(" External location refers to <EXTERNAL> library. Unable to perform navigation.", true);
            return false;
        }
        String pathName = extMgr.getExternalLibraryPath(extProgName);
        if (pathName == null || pathName.length() == 0) {
            this.createExternalAssociation(program, extProgName);
            pathName = extMgr.getExternalLibraryPath(extProgName);
        }
        if (pathName == null || pathName.length() == 0) {
            this.tool.setStatusInfo(" External location is not resolved. Unable to perform navigation.", true);
            return false;
        }
        ProjectData pd = this.tool.getProject().getProjectData();
        DomainFile domainFile = pd.getFile(pathName);
        ProgramManager service = (ProgramManager)this.tool.getService(ProgramManager.class);
        if (domainFile == null || service == null) {
            this.tool.setStatusInfo("Unable to navigate to external location. Destination program [" + pathName + "] does not exist.");
            return false;
        }
        Program externalProgram = service.openProgram(domainFile, -1, 2);
        if (externalProgram == null) {
            return false;
        }
        String label = externalLoc.getOriginalImportedName();
        if (label == null) {
            label = externalLoc.getLabel();
        }
        if ((addr = externalLoc.getAddress()) != null && externalProgram.getMemory().contains(addr)) {
            this.goTo(nav, (ProgramLocation)new AddressFieldLocation(externalProgram, addr), externalProgram);
            return true;
        }
        Symbol symbol = this.getExternalSymbol(externalProgram, externalLoc);
        if (symbol != null) {
            this.goTo(nav, symbol.getProgramLocation(), externalProgram);
            return true;
        }
        if (addr != null) {
            if (externalLoc.getSymbol().getSource() != SourceType.DEFAULT) {
                this.tool.setStatusInfo("Symbol [" + this.getExternalName(externalLoc) + "] does not exist, and address [" + addr + "] is not in memory.", true);
            } else {
                this.tool.setStatusInfo("Address [" + addr + "] is not in memory.", true);
            }
        } else {
            this.tool.setStatusInfo("Symbol [" + this.getExternalName(externalLoc) + "] does not exist.", true);
        }
        addr = externalProgram.getMinAddress();
        this.goTo(nav, (ProgramLocation)new AddressFieldLocation(externalProgram, addr), externalProgram);
        return false;
    }

    private Stack<String> getExternalNamespaceStack(ExternalLocation externalLoc) {
        Symbol s = externalLoc.getSymbol();
        if (s.getSource() == SourceType.DEFAULT) {
            return null;
        }
        Stack<String> nameStack = new Stack<String>();
        Namespace namespace = s.getParentNamespace();
        while (!(namespace instanceof Library)) {
            nameStack.push(namespace.getName());
            namespace = namespace.getParentNamespace();
        }
        return nameStack;
    }

    private String getExternalName(ExternalLocation externalLoc) {
        String label = externalLoc.getOriginalImportedName();
        if (label != null) {
            return label;
        }
        Stack<String> nameStack = this.getExternalNamespaceStack(externalLoc);
        if (nameStack == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        while (!nameStack.isEmpty()) {
            buf.append(nameStack.pop());
            buf.append("::");
        }
        buf.append(externalLoc.getLabel());
        return buf.toString();
    }

    private Symbol getExternalSymbol(Program externalProgram, ExternalLocation externalLoc) {
        SymbolPath symbolPath;
        String label = externalLoc.getOriginalImportedName();
        if (label == null) {
            Symbol s = externalLoc.getSymbol();
            if (s.getSource() == SourceType.DEFAULT) {
                return null;
            }
            symbolPath = new SymbolPath(s, true);
        } else {
            symbolPath = new SymbolPath(label);
        }
        Symbol symbol = null;
        int count = 0;
        Iterator iterator = NamespaceUtils.getSymbols((SymbolPath)symbolPath, (Program)externalProgram).iterator();
        while (iterator.hasNext()) {
            Symbol s;
            symbol = s = (Symbol)iterator.next();
            ++count;
            if (!s.isExternalEntryPoint()) continue;
            return symbol;
        }
        return count == 1 ? symbol : null;
    }

    private void createExternalAssociation(Program program, String extProgName) {
        ExternalManager externalManager;
        String externalLibraryPath;
        int result = OptionDialog.showOptionDialog(null, (String)"No Program Association", (String)("The external program name \"" + extProgName + "\" is not associated with a Ghidra Program\nWould you like to create an association?"), (String)"Create Association", (int)3);
        if (result == 0) {
            return;
        }
        DataTreeDialog dialog = new DataTreeDialog(null, "Choose External Program (" + extProgName + ")", 0);
        dialog.setSearchText(extProgName);
        dialog.setHelpLocation(new HelpLocation("ReferencesPlugin", "ChooseExternalProgram"));
        this.tool.showDialog((DialogComponentProvider)dialog);
        DomainFile domainFile = dialog.getDomainFile();
        if (dialog.wasCancelled() || domainFile == null) {
            return;
        }
        String pathName = domainFile.toString();
        if (!pathName.equals(externalLibraryPath = (externalManager = program.getExternalManager()).getExternalLibraryPath(extProgName))) {
            SetExternalNameCmd cmd = new SetExternalNameCmd(extProgName, domainFile.getPathname());
            this.tool.execute((Command)cmd, (DomainObject)program);
        }
    }

    private Program findGoToProgram(Program currentProgram, Address address) {
        Program goToProgram = this.findProgramContaining(currentProgram, address);
        if (goToProgram == null) {
            return null;
        }
        return goToProgram;
    }

    private Program findProgramContaining(Program currentProgram, Address addr) {
        if (addr.isExternalAddress()) {
            return currentProgram;
        }
        ProgramManager service = (ProgramManager)this.tool.getService(ProgramManager.class);
        if (service != null) {
            return service.getProgram(addr);
        }
        if (currentProgram != null && currentProgram.getMemory().contains(addr)) {
            return currentProgram;
        }
        return null;
    }
}

